/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionPersistenceKind;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.multibroker.drsclient.DRSRuntimeMode;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.container.DeployedModule;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.WLM;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.component.ComponentUtil;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistry;
import com.ibm.ws.webcontainer.httpsession.httprouting.HttpSessClusterObserver;
import com.ibm.ws.webcontainer.httpsession.httprouting.HttpSessDRSHttpRequestExtensionFactory;
import com.ibm.ws.webcontainer.httpsession.httprouting.HttpSessDRSHttpServletResponseListener;
import com.ibm.ws.webcontainer.httpsession.ws390.HttpSessZOSBaseServerDRSSettings;
import com.ibm.ws.webcontainer.httpsession.ws390.HttpSessionPlatformHelper;
import com.ibm.ws.webcontainer.httpsession.ws390.SessionContextGroupInstanceFactoryImpl;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.wsspi.cluster.ClusterObserver;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class SessionMgrComponentImpl
extends WsComponentImpl
implements SessionRegistry,
HAGroupCallback {
    private static SessionContextParameters params = null;
    private static String _serverId = null;
    private static Properties savedDRSCfg = null;
    private static DRSSettings savedDRSSettings;
    private static String[] savedDRSConList;
    private static Properties savedProps;
    private Repository repository = null;
    private static Properties _webcontainerProps;
    private static TraceComponent tc;
    private static String _uuid;
    private static String _cloneId;
    private static boolean uuidInitialized;
    private static boolean serverIdInitialized;
    private static boolean cloneIdInitialized;
    private static String _clusterName;
    private static boolean clusterServerMode;
    private static boolean _is_zOS;
    private static HAGroup remoteInvalHAMGroup;

    public String getUUID() {
        return _uuid;
    }

    public String getCloneId() {
        return _cloneId;
    }

    public boolean isUUIDInitialized() {
        return uuidInitialized;
    }

    public boolean isServerIdInitialized() {
        return serverIdInitialized;
    }

    public boolean isCloneIdInitialized() {
        return cloneIdInitialized;
    }

    public String getClusterName() {
        return _clusterName;
    }

    public static boolean getClusterServerMode() {
        return clusterServerMode;
    }

    private void configureBaseServerReplication(SessionManager sessionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl.configureBaseServerReplication: Entry.");
        }
        if (sessionManager == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl.configureBaseServerReplication:  Exit - failed, parameter is null.");
            }
            return;
        }
        int n = sessionManager.getSessionPersistenceMode().getValue();
        if (n == 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl.configureBaseServerReplication:  Exit - Using Database Persistence.");
            }
            return;
        }
        sessionManager.setSessionPersistenceMode(SessionPersistenceKind.DATA_REPLICATION_LITERAL);
        Object object = sessionManager.getSessionDRSPersistence();
        if (object == null) {
            HttpSessZOSBaseServerDRSSettings httpSessZOSBaseServerDRSSettings = new HttpSessZOSBaseServerDRSSettings();
            object = httpSessZOSBaseServerDRSSettings;
        }
        object.setDataReplicationMode(DRSRuntimeMode.BOTH_LITERAL);
        object.setMessageBrokerDomainName("HTTPSession_Base_Server_Domain");
        sessionManager.setSessionDRSPersistence(object);
        Tr.info((TraceComponent)tc, (String)"HttpSession Unmanaged Server Replication has been enabled.");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl:configureBaseServer - success");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        WLM wLM;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl:initialize");
        }
        SessionManager sessionManager = (SessionManager)object;
        WebContainer webContainer = (WebContainer)sessionManager.getContext();
        HttpSessionPlatformHelper.init();
        EList eList = webContainer.getProperties();
        if (eList != null && eList.size() > 0) {
            SessionMgrComponentImpl.setWebContainerProps((List)eList);
        }
        if (!(_is_zOS = PlatformHelperFactory.getPlatformHelper().isZOS())) {
            wLM = (WLM)ComponentUtil.getService(this, WLM.class);
            if (wLM != null) {
                _serverId = wLM.getMemberUID();
            }
            if (_serverId == null) {
                _serverId = "-1";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Clone id for the server instanace " + _serverId));
            }
        }
        if (HttpSessionPlatformHelper.isZOSBaseServerReplicationEnabled()) {
            this.configureBaseServerReplication(sessionManager);
        }
        if ((params = SessionContextRegistry.initSessionContextParametersFromWCCM(sessionManager)).isUsingMemtoMem()) {
            this.initDRSSettings(sessionManager);
        }
        if (_is_zOS) {
            block25: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SessionMgrComponentImpl : about to call getService");
                }
                _uuid = "-1";
                try {
                    this.repository = (Repository)ComponentUtil.getService(this, Repository.class);
                    if (this.repository != null) {
                        try {
                            wLM = this.repository.getConfigRoot();
                            if (wLM != null) {
                                _uuid = this.getServerUUID((ConfigRoot)wLM);
                                if (_uuid == null) {
                                    _serverId = _uuid = "-1";
                                    _cloneId = _uuid;
                                    Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.initialize: ERROR : UUID not obtained from server.xml; default to -1");
                                    Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.initialize: ERROR : CloneId not obtained; default to -1");
                                } else {
                                    _serverId = _uuid;
                                    _cloneId = _uuid;
                                    serverIdInitialized = true;
                                    cloneIdInitialized = true;
                                    uuidInitialized = true;
                                }
                                _clusterName = this.getClusterName((ConfigRoot)wLM);
                                if (_clusterName == null) {
                                    clusterServerMode = false;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("BaseServerMode in use : ClusterMode flag =  " + clusterServerMode + "  ClusterName = " + _clusterName));
                                    }
                                } else {
                                    clusterServerMode = true;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("ClusterServerMode in use : =  " + clusterServerMode + "  ClusterName = " + _clusterName));
                                    }
                                }
                                break block25;
                            }
                            Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.initialize: ERROR : unable to aquire config root");
                        }
                        catch (Throwable throwable) {
                            Tr.error((TraceComponent)tc, (String)("SessionMgrComponentImpl.initialize caught exception while getting config root object " + throwable));
                            throwable.printStackTrace();
                        }
                        break block25;
                    }
                    Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl: ERROR : Repository object is null");
                }
                catch (Throwable throwable) {
                    Tr.error((TraceComponent)tc, (String)("SessionMgrComponentImpl.initialize caught exception while getting repository object " + throwable));
                    throwable.printStackTrace();
                }
            }
            Tr.info((TraceComponent)tc, (String)("getSessionManagerConfig : uuid = " + _uuid));
            Tr.info((TraceComponent)tc, (String)("Clone id for the server instance = " + _serverId));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl:initialize");
        }
    }

    private String getServerUUID(ConfigRoot configRoot) throws Exception {
        String string = null;
        Server server = null;
        Resource resource = configRoot.getResource(4, "server.xml");
        if (resource != null) {
            server = this.getServer(resource);
        } else {
            Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.getServerUUID: ERROR : Unable to get resource server.xml");
        }
        if (server != null) {
            string = server.getUniqueId();
        } else {
            Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.getServerUUID: ERROR : Server object is null");
        }
        return string;
    }

    private Server getServer(Resource resource) {
        Server server = null;
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            Object e = eList.get(i);
            if (e == null || !(e instanceof Server)) continue;
            server = (Server)e;
        }
        if (server == null) {
            Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.getServer: ERROR : Server Resource object is null");
        }
        return server;
    }

    private String getClusterName(ConfigRoot configRoot) throws Exception {
        String string = null;
        Server server = null;
        Resource resource = configRoot.getResource(4, "server.xml");
        if (resource != null) {
            server = this.getServer(resource);
        } else {
            Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.getClusterName: ERROR : Unable to get resource server.xml");
        }
        if (server != null) {
            string = server.getClusterName();
        } else {
            Tr.error((TraceComponent)tc, (String)"SessionMgrComponentImpl.getClusterName: ERROR : Server object is null");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl:start");
        }
        WebContainerService webContainerService = null;
        webContainerService = (WebContainerService)ComponentUtil.getService(this, WebContainerService.class);
        webContainerService.setSessionRegistry(this);
        SessionContextRegistry.start();
        if (params.isUsingMemtoMem()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.ibm.ws.webcontainer.httpsession.HttpSessDRSVars");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            Class[] classArray = new Class[]{SessionMgrComponentImpl.class, String.class, DRSSettings.class};
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(classArray);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            Object[] objectArray = new Object[]{this, "HttpSessionCache", savedDRSSettings};
            try {
                Object obj = constructor.newInstance(objectArray);
                SessionContextRegistry.registerDRSInstance("HttpSessionCache", obj);
                if (savedDRSSettings.getDataReplicationMode().getValue() == 2) {
                    SessionContextRegistry.setupDRSServerOnlyContext();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            webContainerService.addHttpServletResponseListener(HttpSessDRSHttpServletResponseListener.singleton);
            webContainerService.addVirtualHostExtensionFactory(HttpSessDRSHttpRequestExtensionFactory.singleton);
            HttpSessClusterObserver.singleton.set_ci(this);
        }
        remoteInvalHAMGroup = this.joinRemoteInvalHAMGroup();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl:start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl:stop");
        }
        SessionContextRegistry.stop();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl:stop");
        }
    }

    private void initDRSSettings(SessionManager sessionManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl:initDRSSettings");
        }
        savedDRSSettings = sessionManager.getSessionDRSPersistence();
    }

    public IHttpSessionContext getSessionContext(DeployedModule deployedModule, ServletContext servletContext, String string, ArrayList[] arrayListArray) throws Throwable {
        return SessionContextRegistry.getSessionContext(((com.ibm.ws.wscontainer.DeployedModule)deployedModule).getDeployedModule(), servletContext, string, this, arrayListArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRSDataXfer getDRSDataXfer(String string, String string2, DRSCacheMsgListener dRSCacheMsgListener, DRSBootstrap dRSBootstrap, DRSSettings dRSSettings) {
        DRSDataXfer dRSDataXfer = null;
        MultibrokerDomain multibrokerDomain = null;
        multibrokerDomain = (MultibrokerDomain)ComponentUtil.getService(this, MultibrokerDomain.class);
        dRSDataXfer = multibrokerDomain.getInstance(string, string2);
        if (dRSDataXfer == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("MISC_PARM_WAIT_FOR_HAM", new Boolean(true));
            hashMap.put("Configure DRS Controller Instance", "HttpSession DRS Controller Instance");
            dRSDataXfer = multibrokerDomain.createInstance(string2, dRSCacheMsgListener, dRSBootstrap, dRSSettings, (ClusterObserver)HttpSessClusterObserver.singleton, hashMap);
        }
        return dRSDataXfer;
    }

    public static String getServerId() {
        return _serverId;
    }

    static SessionContextParameters getSessionManagerConfig() {
        return params;
    }

    public static DRSSettings getWebcontainerDRSSettings() {
        return savedDRSSettings;
    }

    static String[] getWebcontainerFailOverList() {
        return savedDRSConList;
    }

    static Properties getWebcontainerBrokerProperties() {
        return savedDRSCfg;
    }

    static Properties getWebcontainerMessageServerProps() {
        return savedProps;
    }

    private static void setWebContainerProps(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            _webcontainerProps.put(property.getName(), property.getValue());
        }
    }

    static Properties getWebContainerProperties() {
        return _webcontainerProps;
    }

    static boolean is_zOS() {
        return _is_zOS;
    }

    protected HAGroup joinRemoteInvalHAMGroup() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl:joinRemoteInvalHAGroup.");
        }
        if ((string = AdminServiceFactory.getAdminService().getProcessType()).equals("NodeAgent") || string.equals("DeploymentManager") || string.equals("UnManagedProcess")) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("WMContextRoot", "SessionRemoteInvalidateAll");
        hashMap.put("RepDomainName", "dummyRepDomain");
        hashMap.put("policy", "DefaultNOOPPolicy");
        HAGroup hAGroup = null;
        hAGroup = _is_zOS ? SessionContextGroupInstanceFactoryImpl.createInstance(this).createSessionContextGroup(hashMap, this) : this.joinHAGroup(hashMap, this);
        try {
            byte[] byArray = "*".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.info((TraceComponent)tc, (String)"SessionContext.exception", (Object)unsupportedEncodingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionMgrComponentImpl:joinRemoteInvalHAGroup - rc is " + hAGroup));
        }
        return hAGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HAGroup joinHAGroup(HashMap hashMap, HAGroupCallback hAGroupCallback) {
        CoreStack coreStack;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionMgrComponentImpl:joinHAGroup.");
        }
        if ((coreStack = (CoreStack)ComponentUtil.getService(this, CoreStack.class)) == null) {
            Tr.error((TraceComponent)tc, (String)("SessionMgrComponentImpl. CoreStack service is null, unable to join HAGroup for " + hashMap.get("WMContextRoot")));
            return null;
        }
        GroupManager groupManager = coreStack.getGroupManager();
        if (groupManager == null) {
            Tr.debug((TraceComponent)tc, (String)("GroupManager is null.WebModule with contextRoot " + hashMap.get("WMContextRoot") + " failed to join the HAGroup "));
            return null;
        }
        HAGroup hAGroup = null;
        try {
            GroupName groupName = groupManager.createGroupName((Map)hashMap);
            hAGroup = groupManager.joinGroup(groupName, new HashMap(), hAGroupCallback);
            if (hAGroup != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebModule  " + hashMap.get("WMContextRoot") + " joined the HAGroup successfully"));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl.joinHAGroup", (String)"467", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionMgrComponentImpl:joinHAGroup");
        }
        return hAGroup;
    }

    public boolean isAlive(GroupName groupName) {
        return true;
    }

    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
    }

    public void memberMayActivate(GroupName groupName) {
    }

    public void memberMayActivateCancelled(GroupName groupName) {
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionMgrComponentImpl.onMessage called to remotely invalidate session " + string));
        }
        SessionContext.invalidateAll(string, "IBMRemoteInvalCall", null, false, true);
    }

    public static HAGroup getRemoteInvalHAMGroup() {
        return remoteInvalHAMGroup;
    }

    static {
        savedDRSConList = null;
        savedProps = null;
        _webcontainerProps = new Properties();
        tc = Tr.register((String)SessionMgrComponentImpl.class.getName(), (String)"IBM HttpSession", (String)"com.ibm.servlet.resources.personalization");
        _uuid = null;
        _cloneId = null;
        uuidInitialized = false;
        serverIdInitialized = false;
        cloneIdInitialized = false;
        _clusterName = null;
        clusterServerMode = false;
        _is_zOS = false;
        remoteInvalHAMGroup = null;
    }
}

