/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.httpsession.SessionHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SessionSimpleLRUHashMap
extends HashMap {
    CacheEntryWrapper mru = null;
    CacheEntryWrapper lru = null;
    int maxSize;
    int currentSize = 0;
    private static TraceComponent tc = Tr.register((String)"com.ibm.ws.webcontainer.httpsession.SessionContext", (String)"IBM HttpSession", (String)"com.ibm.servlet.resources.personalization");
    private static final long serialVersionUID = -1137988339144221054L;

    public SessionSimpleLRUHashMap() {
        this(128);
    }

    public SessionSimpleLRUHashMap(int n) {
        super(n + 20, 1.0f);
        this.maxSize = n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap constructor - capacity is: " + this.maxSize));
        }
    }

    public synchronized Object put(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.put() - key=" + object + " value=" + object2));
        }
        if (this.maxSize == 0) {
            return null;
        }
        CacheEntryWrapper cacheEntryWrapper = null;
        CacheEntryWrapper cacheEntryWrapper2 = (CacheEntryWrapper)super.get(object);
        if (cacheEntryWrapper2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.put() - Doesn't exist in HashMap");
            }
            ++this.currentSize;
            if (this.currentSize > this.maxSize) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.put() - Too Many Entries.. Remove the oldest entry: " + this.lru.key));
                }
                cacheEntryWrapper = (CacheEntryWrapper)this.removeGuts(this.lru.key);
            }
            cacheEntryWrapper2 = new CacheEntryWrapper();
            cacheEntryWrapper2.key = object;
            cacheEntryWrapper2.value = object2;
            cacheEntryWrapper2.next = this.mru;
            if (this.mru != null) {
                this.mru.prev = cacheEntryWrapper2;
            } else {
                this.lru = cacheEntryWrapper2;
            }
            this.mru = cacheEntryWrapper2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.put() - Adding new entry to the map");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.put() - Key already in use .. Reuse the entry");
            }
            this.updateCacheList(object);
            cacheEntryWrapper2.value = object2;
        }
        CacheEntryWrapper cacheEntryWrapper3 = super.put(object, cacheEntryWrapper2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.put() - PUT Returning: " + cacheEntryWrapper3));
        }
        if (cacheEntryWrapper != null) {
            return cacheEntryWrapper.value;
        }
        return null;
    }

    public Object accessObject(Object object) {
        CacheEntryWrapper cacheEntryWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.get() - key=" + object));
        }
        if ((cacheEntryWrapper = this.updateCacheList(object)) == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.get() - returning with " + cacheEntryWrapper.value));
        }
        return cacheEntryWrapper.value;
    }

    public Object get(Object object) {
        CacheEntryWrapper cacheEntryWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.getWithoutCacheUpdate() - key=" + object));
        }
        if ((cacheEntryWrapper = (CacheEntryWrapper)super.get(object)) == null) {
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.getWithoutCacheUpdate() - found object with key=  " + object));
        }
        return cacheEntryWrapper.value;
    }

    public synchronized Object remove(Object object) {
        CacheEntryWrapper cacheEntryWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.remove() - key=" + object));
        }
        if ((cacheEntryWrapper = (CacheEntryWrapper)this.removeGuts(object)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.remove() returning with value: NULL");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.remove() returning with value: " + cacheEntryWrapper.value));
        }
        return cacheEntryWrapper.value;
    }

    private Object removeGuts(Object object) {
        CacheEntryWrapper cacheEntryWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.removeGuts() - key=" + object));
        }
        if ((cacheEntryWrapper = (CacheEntryWrapper)super.remove(object)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.removeGuts() - key not found in hashmap");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.removeGuts() - key found in hashmap");
        }
        --this.currentSize;
        CacheEntryWrapper cacheEntryWrapper2 = cacheEntryWrapper.prev;
        CacheEntryWrapper cacheEntryWrapper3 = cacheEntryWrapper.next;
        if (cacheEntryWrapper2 == null) {
            this.mru = cacheEntryWrapper3;
        } else {
            cacheEntryWrapper2.next = cacheEntryWrapper3;
        }
        if (cacheEntryWrapper3 == null) {
            this.lru = cacheEntryWrapper2;
        } else {
            cacheEntryWrapper3.prev = cacheEntryWrapper2;
        }
        cacheEntryWrapper.prev = null;
        cacheEntryWrapper.next = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.removeGuts() - returning with value: " + cacheEntryWrapper));
        }
        return cacheEntryWrapper;
    }

    public synchronized void clear() {
        super.clear();
        this.currentSize = 0;
        this.mru = null;
        this.lru = null;
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionSimpleLRUHashMap.keySet()");
        }
        Object[] objectArray = null;
        Set set = super.keySet();
        if (set != null) {
            object = this;
            synchronized (object) {
                objectArray = set.toArray();
            }
        }
        object = new SessionHashSet(objectArray);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleLRUHashMap.keySet() returning keySet" + object));
        }
        return object;
    }

    public void showMRUList() {
        System.out.println(" ");
        System.out.println(" Here is the list starting at mru");
        CacheEntryWrapper cacheEntryWrapper = this.mru;
        while (cacheEntryWrapper != null) {
            System.out.println("   Entry is: " + cacheEntryWrapper.key);
            cacheEntryWrapper = cacheEntryWrapper.next;
        }
    }

    private synchronized CacheEntryWrapper updateCacheList(Object object) {
        CacheEntryWrapper cacheEntryWrapper = (CacheEntryWrapper)super.get(object);
        if (cacheEntryWrapper == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"updateCacheList returned null");
            }
            return null;
        }
        CacheEntryWrapper cacheEntryWrapper2 = cacheEntryWrapper.prev;
        CacheEntryWrapper cacheEntryWrapper3 = cacheEntryWrapper.next;
        if (cacheEntryWrapper2 != null) {
            cacheEntryWrapper2.next = cacheEntryWrapper3;
            cacheEntryWrapper.prev = null;
            cacheEntryWrapper.next = this.mru;
            this.mru.prev = cacheEntryWrapper;
            this.mru = cacheEntryWrapper;
            if (cacheEntryWrapper3 != null) {
                cacheEntryWrapper3.prev = cacheEntryWrapper2;
            } else {
                this.lru = cacheEntryWrapper2;
            }
        }
        return cacheEntryWrapper;
    }

    private static class CacheEntryWrapper {
        CacheEntryWrapper prev;
        CacheEntryWrapper next;
        Object key;
        Object value;

        private CacheEntryWrapper() {
        }
    }
}

