/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.websphere.pmi.ServletSessionsPerf;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiAttribute;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiFactory;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextMBeanAdapter;
import com.ibm.ws.webcontainer.httpsession.SessionTrackingPMIException;

public class SessionTrackingPMIApplicationData {
    private ServletSessionsPerf pmiServerData;
    private long createCount;
    private long activeCount;
    private long invalidatedCount;
    private long gcCollectedCount;
    private long noRoomForNewSessions;
    private long cacheDiscards;
    private long affinityBreaks;
    private long accessNonExistent;
    private long readCount;
    private long readSize;
    private long readTime;
    private long writeCount;
    private long writeSize;
    private long writeTime;
    private long invalByTimeOut;
    private long attemptToActivateNonExistent;
    private long sessionAccessCount;
    private long invalidatorExecuted = 0L;
    private long inMemoryCount = 0L;

    SessionTrackingPMIApplicationData(SessionApplicationParameters sessionApplicationParameters, final SessionContextMBeanAdapter sessionContextMBeanAdapter) throws SessionTrackingPMIException {
        if (sessionApplicationParameters == null) {
            throw new SessionTrackingPMIException("Session Application Parameters is null");
        }
        String string = null;
        try {
            string = sessionApplicationParameters.getJ2EEName();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionTrackingPMIApplicationData.SessionTrackingPMIApplicationData", (String)"70", (Object)this);
        }
        PmiCallback pmiCallback = new PmiCallback(){
            SessionContextMBeanAdapter adap;
            {
                this.adap = sessionContextMBeanAdapter;
            }

            public PmiAttribute[] getPmiAttributes() {
                return null;
            }

            public Object getRuntimeInfo() {
                return this.adap.getSessionsInfo();
            }
        };
        this.pmiServerData = PmiFactory.createServletSessionsPerf((String)string, (PmiCallback)pmiCallback);
    }

    void incActiveSessions(long l) {
        if (this.pmiServerData != null) {
            this.pmiServerData.sessionActivated(l);
        }
        ++this.activeCount;
    }

    void decActiveSessions() {
        if (this.pmiServerData != null) {
            this.pmiServerData.sessionInactivated();
        }
        --this.activeCount;
    }

    void incSessionsCreated() {
        if (this.pmiServerData != null) {
            this.pmiServerData.sessionCreated();
        }
        ++this.createCount;
    }

    void incInvalidatedSessions(long l) {
        if (this.pmiServerData != null) {
            this.pmiServerData.sessionInvalidated(l);
        }
        ++this.invalidatedCount;
    }

    void incSessionGarbageCollected(long l) {
        ++this.gcCollectedCount;
    }

    void incNoRoomForNewSession() {
        if (this.pmiServerData != null) {
            this.pmiServerData.noRoomForNewSession();
        }
        ++this.noRoomForNewSessions;
    }

    void incCacheDiscards() {
        if (this.pmiServerData != null) {
            this.pmiServerData.discardCache();
        }
        ++this.cacheDiscards;
    }

    void readTimes(long l, long l2) {
        if (this.pmiServerData != null) {
            this.pmiServerData.readExternal(l2, l);
        }
        ++this.readCount;
        this.readSize += l;
        this.readTime += l2;
    }

    void writeTimes(long l, long l2) {
        if (this.pmiServerData != null) {
            this.pmiServerData.writeExternal(l2, l);
        }
        ++this.writeCount;
        this.writeSize += l;
        this.writeTime += l2;
    }

    void incAffinityBreaks() {
        if (this.pmiServerData != null) {
            this.pmiServerData.affinityBreak();
        }
        ++this.affinityBreaks;
    }

    void incInvalidatedByTimeout() {
        if (this.pmiServerData != null) {
            this.pmiServerData.invalidatedViaTimeout();
        }
        ++this.invalByTimeOut;
    }

    void IncAttemptToActivateNonExistent() {
        if (this.pmiServerData != null) {
            this.pmiServerData.attempToActiveNonExistSession();
        }
        ++this.attemptToActivateNonExistent;
    }

    void incSessionAccessCount() {
        ++this.sessionAccessCount;
    }

    void incInvalidatorExecutedCount() {
        ++this.invalidatorExecuted;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nSessions Created:").append(this.createCount).append("\nActive Count:").append(this.activeCount).append("\nSession Access count").append(this.sessionAccessCount).append("\nGarbage Collected count").append(this.gcCollectedCount).append("\nInvalidated Count:").append(this.invalidatedCount).append("\nInvalidated By SessionManager:").append(this.invalByTimeOut).append("\nSessionAffinity Breaks:").append("\nNumber of times invalidation path has run").append(this.invalidatorExecuted).append(this.affinityBreaks).append("\nRejected Session creation requests(overflow off):").append(this.noRoomForNewSessions).append("\nCache Discards:").append(this.cacheDiscards).append("\nAttempts to access invalidated sessions:").append(this.attemptToActivateNonExistent).append("\nNumber of binary reads from external store:").append(this.readCount).append("\nTotal time spent in reading from external store(ms):").append(this.readTime).append("\nTotal number of bytes read:").append(this.readSize).append("\nNumber of binary writes to external store:").append(this.writeCount).append("\nTotal time spent in writing to external store(ms):").append(this.writeTime).append("\nTotal number of bytes wriiten out:").append(this.writeSize);
        return stringBuffer.toString();
    }

    public String toHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<br><b>Sessions Created:</b>").append(this.createCount).append("<br><b>Active Count:</b>").append(this.activeCount).append("<br><b>Session Access Count:</b>").append(this.sessionAccessCount).append("<br><b>Invalidated Sessions Count:</b>").append(this.invalidatedCount).append("<br><b>Invalidated By SessionManager:</b>").append(this.invalByTimeOut).append("<br><b>Garbage Collected count:</b>").append(this.gcCollectedCount).append("<br><b>SessionAffinity Breaks:</b>").append(this.affinityBreaks).append("<br><b>Number of times invalidation alarm has run:</b>").append(this.invalidatorExecuted).append("<br><b>Rejected Session creation requests(overflow off):</b>").append(this.noRoomForNewSessions).append("<br><b>Cache Discards:</b>").append(this.cacheDiscards).append("<br><b>Attempts to access non-existent sessions:</b>").append(this.attemptToActivateNonExistent).append("<br><b>Number of binary reads from external store:</b>").append(this.readCount).append("<br><b>Total time spent in reading from external store(ms):</b>").append(this.readTime).append("<br><b>Total number of bytes read:</b>").append(this.readSize).append("<br><b>Number of binary writes to external store:</b>").append(this.writeCount).append("<br><b>Total time spent in writing to external store(ms):</b>").append(this.writeTime).append("<br><b>Total number of bytes wriiten out:</b>").append(this.writeSize).append("<br><b>Session count </b>").append(this.inMemoryCount).append("<br>");
        return stringBuffer.toString();
    }

    public long getInMemoryCount() {
        return this.inMemoryCount;
    }

    public void incMemoryCount() {
        ++this.inMemoryCount;
        if (this.pmiServerData != null) {
            this.pmiServerData.sessionAdded();
        }
    }

    public void decMemoryCount() {
        --this.inMemoryCount;
        if (this.pmiServerData != null) {
            this.pmiServerData.sessionRemoved();
        }
    }

    public void unregister() {
        if (this.pmiServerData != null) {
            PmiFactory.removePmiModule((Object)this.pmiServerData);
        }
    }
}

