/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.httpsession.ws390.HttpSessHAGroupControllerCallback;
import com.ibm.ws.webcontainer.httpsession.ws390.SessionContextGroupInstanceTokenImpl;
import com.ibm.ws.webcontainer.httpsession.ws390.SessionContextGroupInstanceTokenTableImpl;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.datastack.MsgQoS;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;

public class HttpSessHAGroupControllerContext {
    private static TraceComponent tc = Tr.register((String)HttpSessHAGroupControllerContext.class.getName(), (String)"IBM HttpSession", (String)"com.ibm.servlet.resources.personalization");
    private static boolean _loggedVersion = false;
    private HashMap properties;
    private HAGroup haGroup;
    private HttpSessHAGroupControllerCallback callback;
    private boolean usingHAManager;
    private Integer lock;
    private SessionContextGroupInstanceTokenTableImpl newTokens;
    private SessionContextGroupInstanceTokenTableImpl oldTokens;
    String appName;
    String domainName;
    SessionContextGroupInstanceTokenImpl invalidatorToken;
    String instanceId;
    long uniqueId;

    public HttpSessHAGroupControllerContext(HashMap hashMap, HAGroup hAGroup, HttpSessHAGroupControllerCallback httpSessHAGroupControllerCallback, boolean bl, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessHAGroupControllerContext:constructor: Entry");
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug((TraceComponent)tc, (String)"HttpSessHAGroupControllerContext:constructor: Version 1.7 1/13/06 09:42:54");
            _loggedVersion = true;
        }
        this.lock = new Integer(7654);
        this.properties = hashMap;
        this.haGroup = hAGroup;
        this.callback = httpSessHAGroupControllerCallback;
        this.uniqueId = l;
        this.callback.setContext(this);
        this.usingHAManager = bl;
        this.invalidatorToken = null;
        this.appName = (String)this.properties.get("WMContextRoot");
        this.domainName = (String)this.properties.get("RepDomainName");
        this.instanceId = this.appName + ":" + this.domainName + ":" + this.uniqueId;
        this.newTokens = new SessionContextGroupInstanceTokenTableImpl("HttpSessHAGroupControllerContext" + this.instanceId, "newTokens");
        this.oldTokens = new SessionContextGroupInstanceTokenTableImpl("HttpSessHAGroupControllerContext" + this.instanceId, "oldTokens");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("HttpSessHAGroupControllerContext:constructor:  appName = " + this.appName + " ,domainName = " + this.domainName + " ,usingHAManager = " + this.usingHAManager + " ,uniqueId = " + this.uniqueId + " ,instanceId = " + this.instanceId + " ,core group name = " + this.haGroup.getGroupName().getCoreGroupName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessHAGroupControllerContext:constructor: Exit");
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public boolean getUsingHAManager() {
        return this.usingHAManager;
    }

    public HAGroup getHAGroup() {
        return this.haGroup;
    }

    public HttpSessHAGroupControllerCallback getHttpSessHAGroupControllerCallback() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registrationComplete(String string) {
        String string2 = "HttpSessHAGroupControllerContext:registrationComplete/" + this.instanceId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Entry - stoken = " + string));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string2 + " stoken = " + string));
        }
        Integer n = this.lock;
        synchronized (n) {
            Iterator iterator = this.newTokens.getIterator();
            while (iterator.hasNext()) {
                SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl = (SessionContextGroupInstanceTokenImpl)iterator.next();
                if (!sessionContextGroupInstanceTokenImpl.getStoken().equals(string)) continue;
                this.newTokens.deleteServant(sessionContextGroupInstanceTokenImpl);
                this.oldTokens.addServant(sessionContextGroupInstanceTokenImpl);
                if (this.invalidatorToken == null) {
                    this.invalidatorToken = sessionContextGroupInstanceTokenImpl;
                    if (this.callback.isPrimaryInvalidator()) {
                        this.callback.sendMemberIsActivatedToServant(this.invalidatorToken, this.haGroup.getGroupName());
                        continue;
                    }
                    this.callback.sendMemberDeactivateToServant(this.invalidatorToken, this.haGroup.getGroupName());
                    continue;
                }
                this.callback.sendMemberDeactivateToServant(sessionContextGroupInstanceTokenImpl, this.haGroup.getGroupName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string2 + "Exit"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServant(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl, boolean bl) {
        String string = "HttpSessHAGroupControllerContext:registrationComplete/" + this.instanceId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry - token = " + sessionContextGroupInstanceTokenImpl + " registered = " + bl));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " token = " + sessionContextGroupInstanceTokenImpl + " registered = " + bl));
        }
        if (sessionContextGroupInstanceTokenImpl != null) {
            Integer n = this.lock;
            synchronized (n) {
                this.newTokens.deleteServant(sessionContextGroupInstanceTokenImpl);
                if (bl) {
                    this.oldTokens.addServant(sessionContextGroupInstanceTokenImpl);
                    if (this.invalidatorToken == null) {
                        this.invalidatorToken = sessionContextGroupInstanceTokenImpl;
                        if (this.callback.isPrimaryInvalidator()) {
                            this.callback.sendMemberIsActivatedToServant(this.invalidatorToken, this.haGroup.getGroupName());
                        } else {
                            this.callback.sendMemberDeactivateToServant(this.invalidatorToken, this.haGroup.getGroupName());
                        }
                    } else {
                        this.callback.sendMemberDeactivateToServant(sessionContextGroupInstanceTokenImpl, this.haGroup.getGroupName());
                    }
                } else {
                    this.newTokens.addServant(sessionContextGroupInstanceTokenImpl);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteServant(String string, boolean bl) {
        String string2 = "HttpSessHAGroupControllerContext:deleteServant/" + this.instanceId + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Entry - stoken = " + string));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string2 + " stoken = " + string));
        }
        if (string != null) {
            Integer n = this.lock;
            synchronized (n) {
                this.newTokens.deleteServant(string);
                if (this.oldTokens.containsStoken(string)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(string2 + " stoken = " + string + " found in oldtokens"));
                    }
                    this.oldTokens.deleteServant(string);
                    if (this.invalidatorToken != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(string2 + " invalidatorToken = " + this.invalidatorToken));
                        }
                        if (this.invalidatorToken.getStoken().equals(string)) {
                            this.invalidatorToken = null;
                            if (bl) {
                                Iterator iterator = this.oldTokens.getIterator();
                                while (iterator.hasNext() && this.invalidatorToken == null) {
                                    this.invalidatorToken = (SessionContextGroupInstanceTokenImpl)iterator.next();
                                }
                                if (this.invalidatorToken != null && this.callback.isPrimaryInvalidator()) {
                                    this.callback.sendMemberIsActivatedToServant(this.invalidatorToken, this.haGroup.getGroupName());
                                }
                            }
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string2 + "Exit"));
        }
    }

    SessionContextGroupInstanceTokenTableImpl getTokens() {
        return this.oldTokens;
    }

    void sendMessage(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl, MsgQoS msgQoS, byte[] byArray) {
        String string;
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("HttpSessHAGroupControllerContext:sendMessage: Entry - msg = " + string));
        }
        if (this.usingHAManager && this.haGroup != null) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"HttpSessHAGroupControllerContext:sendMessage: sending message to HAManager");
                }
                this.haGroup.sendMessage(msgQoS, byArray);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"ControllerSession.CaughtException", (Object)new Object[]{"HttpSessHAGroupControllerContext:sendMessage:", exception});
            }
        }
        if (this.callback != null) {
            this.callback.sendMsgToServants(sessionContextGroupInstanceTokenImpl, null, byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"HttpSessHAGroupControllerContext:sendMessage: Exit");
        }
    }
}

