/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession.ws390;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class HttpSessionPlatformHelper {
    public static final String HTTPSESSION_CONTROLLER_PROXY_ID = "HttpSessionControllerProxy";
    public static final String HTTPSESSION_TRACE_CLASS = "com.ibm.ws.webcontainer.httpsession.SessionContext";
    public static final String HTTPSESSION_TRACE_COMPONENT = "IBM HttpSession";
    public static final String HTTPSESSION_TRACE_PACKAGE = "com.ibm.servlet.resources.personalization";
    public static final String HTTPSESSION_ENABLE_BASE_REPLICATION = "HttpSessionEnableUnmanagedServerReplication";
    private static boolean initialized = false;
    private static Integer lock = new Integer(0);
    private static boolean _is_zOS = false;
    private static boolean _is_zOS_servant = false;
    private static boolean _is_zOS_controller = false;
    private static String processType = null;
    private static boolean isBaseServerReplicationEnabled = false;
    private static boolean isBaseServer = false;
    private static String stoken = null;
    private static boolean _loggedVersion = false;
    private static TraceComponent tc = Tr.register((String)"com.ibm.ws.webcontainer.httpsession.SessionContext", (String)"IBM HttpSession", (String)"com.ibm.servlet.resources.personalization");

    private HttpSessionPlatformHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.init: Entry.");
        }
        Integer n = lock;
        synchronized (n) {
            if (tc.isDebugEnabled() && !_loggedVersion) {
                Tr.debug((TraceComponent)tc, (String)"HttpSessionPlatformHelper.init: Version 1.3 11/30/04 11:43:52");
                _loggedVersion = true;
            }
            if (!initialized) {
                String string;
                processType = AdminServiceFactory.getAdminService().getProcessType();
                if (processType != null) {
                    isBaseServer = processType.equals("UnManagedProcess");
                }
                if ((string = System.getProperty(HTTPSESSION_ENABLE_BASE_REPLICATION)) != null && string.equals("true")) {
                    isBaseServerReplicationEnabled = true;
                }
                if (_is_zOS = PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    _is_zOS_controller = PlatformHelperFactory.getPlatformHelper().isControlJvm();
                    _is_zOS_servant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
                    stoken = PlatformHelperFactory.getPlatformHelper().getServantToken();
                } else {
                    _is_zOS_controller = false;
                    _is_zOS_servant = false;
                    stoken = null;
                }
                initialized = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init: _is_zOS = " + _is_zOS));
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init: _is_zOS_controller = " + _is_zOS_controller));
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init: _is_zOS_servant = " + _is_zOS_servant));
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init:  Process Type = " + processType));
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init:  enableBaseReplication = " + (string == null ? "null" : string)));
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init:  isBaseServerReplicationEnabled = " + isBaseServerReplicationEnabled));
                    Tr.debug((TraceComponent)tc, (String)("HttpSessionPlatformHelper.init:  isBaseServer = " + isBaseServer));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"HttpSessionPlatformHelper.init: Exit.");
        }
    }

    public static boolean isZOS() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isZOS: Entry.");
        }
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        boolean bl = _is_zOS;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isZOS: Exit - " + bl));
        }
        return bl;
    }

    public static boolean isZOS_Controller() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isZOS_Controller: Entry.");
        }
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_controller;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isZOS_Controller: Exit - " + bl));
        }
        return bl;
    }

    public static boolean isZOS_Servant() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isZOS_Servant: Entry.");
        }
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_servant;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isZOS_Servant: Exit - " + bl));
        }
        return bl;
    }

    public static String getZOSUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getZOSUniqueId: Entry.");
        }
        String string = null;
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        if (_is_zOS) {
            string = PlatformHelperFactory.getPlatformHelper().getUniqueId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.getZOSUniqueId: Exit - unique id " + string));
        }
        return string;
    }

    public static String getZOSStoken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getZOSStoken: Entry.");
        }
        String string = null;
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        string = stoken;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.getZOSStoken: Exit - stoken = " + string));
        }
        return string;
    }

    public static String getZOSServantToken() {
        return HttpSessionPlatformHelper.getZOSStoken();
    }

    public static ORB getZOSORB() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getZOSORB: Entry.");
        }
        ORB oRB = null;
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        if (_is_zOS) {
            oRB = PlatformHelperFactory.getPlatformHelper().getGlobalORB();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getZOSORB: Exit.");
        }
        return oRB;
    }

    public static boolean isBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isBaseServer: Entry.");
        }
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isBaseServer: Exit - isBaseServer = " + isBaseServer));
        }
        return isBaseServer;
    }

    public static boolean isZOSBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isZOSBaseServer: Entry.");
        }
        boolean bl = false;
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isZOSBaseServer: Exit - isZOSBaseServer = " + bl));
        }
        return bl;
    }

    public static boolean isBaseServerReplicationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isBaseServerReplicationEnabled: Entry.");
        }
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isBaseServerReplicationEnabled: Exit - isBaseServerReplicationEnabled = " + isBaseServerReplicationEnabled));
        }
        return isBaseServerReplicationEnabled;
    }

    public static boolean isZOSBaseServerReplicationEnabled() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.isZOSBaseServerReplicationEnabled: Entry.");
        }
        if (!initialized) {
            HttpSessionPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer && isBaseServerReplicationEnabled;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("HttpSessionPlatformHelper.isZOSBaseServerReplicationEnabled: Exit - isZOSBaseServerReplicationEnabled = " + bl));
        }
        return bl;
    }

    public static String getHttpSessionControllerProxyId() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getHttpSessionControllerProxyId: Entry - HTTPSESSION_CONTROLLER_PROXY_ID=HttpSessionControllerProxy");
        }
        return HTTPSESSION_CONTROLLER_PROXY_ID;
    }

    public static byte[] getByteArray(Object object) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getByteArray: Entry.");
        }
        byte[] byArray = new byte[]{};
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getByteArray: Exit.");
        }
        return byArray;
    }

    public static Object getObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getObject: Entry.");
        }
        Object object = null;
        if (byArray != null && byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"HttpSessionPlatformHelper.getObject: Exit.");
        }
        return object;
    }
}

