/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession.ws390;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.httpsession.ws390.SessionContextGroupInstanceTokenImpl;
import java.util.Iterator;

public class SessionContextGroupInstanceTokenTableImpl {
    private static final int INITIAL_SIZE = 200;
    private static final int ARRAY_INCREMENT = 100;
    private static long uniqueTableId = 0L;
    private static final Integer uniqueTableIdLock = new Integer(6429);
    private static TraceComponent tc = Tr.register((String)SessionContextGroupInstanceTokenTableImpl.class.getName(), (String)"DRS", (String)"com.ibm.ws.drs.resources.drs");
    private static boolean _loggedVersion = false;
    private Integer lock;
    private int currentArraySize;
    private SessionContextGroupInstanceTokenImpl[] tokenArray;
    private int numberOfTokens;
    private String containerName;
    private String tableName;
    private String instanceOffsetName;
    private long uniqueId;

    public SessionContextGroupInstanceTokenTableImpl(String string, String string2) {
        this(200, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContextGroupInstanceTokenTableImpl(int n, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContextGroupInstanceTokenTableImpl:constructor: Entry -  container name = " + string + " ,table name = " + string2));
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug((TraceComponent)tc, (String)"SessionContextGroupInstanceTokenTableImpl:constructor: Version 1.2 1/9/05 21:55:37");
            _loggedVersion = true;
        }
        this.lock = new Integer(22);
        this.currentArraySize = n > 1 ? n : 200;
        this.tokenArray = new SessionContextGroupInstanceTokenImpl[this.currentArraySize];
        for (int i = 0; i < this.currentArraySize; ++i) {
            this.tokenArray[i] = null;
        }
        this.numberOfTokens = 0;
        this.containerName = string;
        this.tableName = string2;
        Integer n2 = uniqueTableIdLock;
        synchronized (n2) {
            if (++uniqueTableId < 0L) {
                uniqueTableId = 1L;
            }
            this.uniqueId = uniqueTableId;
        }
        this.instanceOffsetName = this.uniqueId + ":" + this.containerName + ":" + this.tableName;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContextGroupInstanceTokenTableImpl:constructor:  container name = " + this.containerName + " ,table name = " + this.tableName + " ,instanceOffsetName = " + this.instanceOffsetName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContextGroupInstanceTokenTableImpl:constructor: Exit -  container name = " + this.containerName + " ,table name = " + this.tableName + " ,instanceOffsetName = " + this.instanceOffsetName));
        }
    }

    public void addServant(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl2;
        String string = "SessionContextGroupInstanceTokenTableImpl:addServant/" + this.instanceOffsetName + "/";
        if (sessionContextGroupInstanceTokenImpl == null) {
            throw new IllegalArgumentException(string + " token = null");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        if ((sessionContextGroupInstanceTokenImpl2 = sessionContextGroupInstanceTokenImpl).getInstanceOffset(this.instanceOffsetName) < 0) {
            this.addTokenToArray(sessionContextGroupInstanceTokenImpl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit"));
        }
    }

    public void deleteServant(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        String string;
        String string2 = "SessionContextGroupInstanceTokenTableImpl:deleteServant(T)/" + this.instanceOffsetName + "/";
        if (sessionContextGroupInstanceTokenImpl == null) {
            throw new IllegalArgumentException(string2 + " token = null");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        if ((string = sessionContextGroupInstanceTokenImpl.getStoken()) == null) {
            throw new IllegalStateException(string2 + " stoken = null");
        }
        this.removeServantFromArray(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string2 + "Exit"));
        }
    }

    public void deleteServant(String string) {
        String string2 = "SessionContextGroupInstanceTokenTableImpl:deleteServant(S)/" + this.instanceOffsetName + "/";
        if (string == null) {
            throw new IllegalArgumentException(string2 + " stoken = null");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Entry - stoken = " + string));
        }
        this.removeServantFromArray(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string2 + "Exit"));
        }
    }

    public void clear() {
        this.removeAllTokensFromArray();
    }

    public boolean containsToken(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        String string = "SessionContextGroupInstanceTokenTableImpl:containsToken/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        boolean bl = false;
        if (sessionContextGroupInstanceTokenImpl != null) {
            bl = this.isTokenInArray(sessionContextGroupInstanceTokenImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - token = " + sessionContextGroupInstanceTokenImpl + " rc = " + bl));
        }
        return bl;
    }

    public boolean containsStoken(String string) {
        String string2 = "SessionContextGroupInstanceTokenTableImpl:containsStoken/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Entry - stoken = " + string));
        }
        boolean bl = false;
        if (string != null) {
            bl = this.isStokenInArray(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Exit - stoken = " + string + " rc = " + bl));
        }
        return bl;
    }

    public Iterator getIterator() {
        return this.createIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTokenToArray(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        String string = "SessionContextGroupInstanceTokenTableImpl:addTokenToArray/" + this.instanceOffsetName + "/";
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        Integer n = this.lock;
        synchronized (n) {
            if (this.numberOfTokens >= this.currentArraySize) {
                this.expandArray();
            }
            for (int i = 0; i < this.currentArraySize && !bl; ++i) {
                if (this.tokenArray[i] != null) continue;
                this.tokenArray[i] = sessionContextGroupInstanceTokenImpl;
                sessionContextGroupInstanceTokenImpl.setInstanceOffset(this.instanceOffsetName, i);
                ++this.numberOfTokens;
                bl = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)(string + " Token(" + sessionContextGroupInstanceTokenImpl + ") inserted at position " + i + " , number of tokens = " + this.numberOfTokens));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Exit - inserted = " + bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceExistingTokenInArray(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContextGroupInstanceTokenTableImpl:replaceExistingTokenInArray: Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        Integer n = this.lock;
        synchronized (n) {
            int n2 = sessionContextGroupInstanceTokenImpl.getInstanceOffset(this.instanceOffsetName);
            if (n2 >= 0) {
                if (this.tokenArray[n2] != null) {
                    this.tokenArray[n2] = sessionContextGroupInstanceTokenImpl;
                } else {
                    Tr.error((TraceComponent)tc, (String)"ControllerSession.tokenNotinArray", (Object)new Object[]{"SessionContextGroupInstanceTokenTableImpl:replaceExistingTokenInArray: ", sessionContextGroupInstanceTokenImpl});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"ControllerSession.tokenInstanceOffset", (Object)new Object[]{"SessionContextGroupInstanceTokenTableImpl:replaceExistingTokenInArray: ", sessionContextGroupInstanceTokenImpl});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTokenFromArray(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        String string = "SessionContextGroupInstanceTokenTableImpl:removeTokenFromArray/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        int n = -1;
        boolean bl = false;
        Integer n2 = this.lock;
        synchronized (n2) {
            n = sessionContextGroupInstanceTokenImpl.getInstanceOffset(this.instanceOffsetName);
            if (n > 0 && n < this.currentArraySize && this.tokenArray[n] != null && this.tokenArray[n].equals(sessionContextGroupInstanceTokenImpl)) {
                this.tokenArray[n] = null;
                sessionContextGroupInstanceTokenImpl.deleteInstanceOffset(this.instanceOffsetName);
                bl = true;
                --this.numberOfTokens;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(string + " Token(" + sessionContextGroupInstanceTokenImpl + ") deleted from position " + n + " , number of tokens = " + this.numberOfTokens));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - removed = " + bl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTokensFromArray() {
        Integer n = this.lock;
        synchronized (n) {
            for (int i = 0; i < this.currentArraySize; ++i) {
                if (this.tokenArray[i] == null) continue;
                this.tokenArray[i].deleteInstanceOffset(this.instanceOffsetName);
                this.tokenArray[i] = null;
                --this.numberOfTokens;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenInArray(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        String string = "SessionContextGroupInstanceTokenTableImpl:isTokenInArray/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry - token = " + sessionContextGroupInstanceTokenImpl));
        }
        boolean bl = false;
        int n = -1;
        Integer n2 = this.lock;
        synchronized (n2) {
            n = sessionContextGroupInstanceTokenImpl.getInstanceOffset(this.instanceOffsetName);
            if (n >= 0 && this.tokenArray[n] != null) {
                bl = this.tokenArray[n].equals(sessionContextGroupInstanceTokenImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Exit - token = " + sessionContextGroupInstanceTokenImpl + " rc = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStokenInArray(String string) {
        String string2 = "SessionContextGroupInstanceTokenTableImpl:isStokenInArray/" + this.instanceOffsetName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Entry - stoken = " + string));
        }
        boolean bl = false;
        Integer n = this.lock;
        synchronized (n) {
            for (int i = 0; i < this.currentArraySize; ++i) {
                if (this.tokenArray[i] == null || !this.tokenArray[i].getStoken().equals(string)) continue;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + "Exit - stoken = " + string + " rc = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchForTokenInArray(SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl) {
        int n = -1;
        Integer n2 = this.lock;
        synchronized (n2) {
            for (int i = 0; i < this.currentArraySize && n == -1; ++i) {
                if (this.tokenArray[i] == null || !this.tokenArray[i].equals(sessionContextGroupInstanceTokenImpl)) continue;
                n = i;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServantFromArray(String string) {
        Integer n = this.lock;
        synchronized (n) {
            for (int i = 0; i < this.currentArraySize; ++i) {
                if (this.tokenArray[i] == null || !this.tokenArray[i].getStoken().equals(string)) continue;
                this.tokenArray[i].deleteInstanceOffset(this.instanceOffsetName);
                this.tokenArray[i] = null;
                --this.numberOfTokens;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandArray() {
        Integer n = this.lock;
        synchronized (n) {
            int n2;
            int n3 = this.currentArraySize + 100;
            SessionContextGroupInstanceTokenImpl[] sessionContextGroupInstanceTokenImplArray = new SessionContextGroupInstanceTokenImpl[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                sessionContextGroupInstanceTokenImplArray[n2] = null;
            }
            for (n2 = 0; n2 < this.currentArraySize; ++n2) {
                if (this.tokenArray[n2] == null) continue;
                sessionContextGroupInstanceTokenImplArray[n2] = this.tokenArray[n2];
                this.tokenArray[n2] = null;
            }
            this.tokenArray = sessionContextGroupInstanceTokenImplArray;
            this.currentArraySize = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator createIterator() {
        Iterator iterator = null;
        Integer n = this.lock;
        synchronized (n) {
            if (this.numberOfTokens == 0) {
                EmptySessionContextGroupInstanceTokenImplIterator emptySessionContextGroupInstanceTokenImplIterator;
                iterator = emptySessionContextGroupInstanceTokenImplIterator = new EmptySessionContextGroupInstanceTokenImplIterator();
            } else {
                SessionContextGroupInstanceTokenImplIterator sessionContextGroupInstanceTokenImplIterator = new SessionContextGroupInstanceTokenImplIterator(this.tokenArray);
                iterator = sessionContextGroupInstanceTokenImplIterator;
            }
        }
        return iterator;
    }

    class EmptySessionContextGroupInstanceTokenImplIterator
    implements Iterator {
        private EmptySessionContextGroupInstanceTokenImplIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    class SessionContextGroupInstanceTokenImplIterator
    implements Iterator {
        private int current = 0;
        private int tokenArraySize = 0;
        private SessionContextGroupInstanceTokenImpl[] tokenArray = null;

        private SessionContextGroupInstanceTokenImplIterator(SessionContextGroupInstanceTokenImpl[] sessionContextGroupInstanceTokenImplArray) {
            int n;
            for (n = 0; n < sessionContextGroupInstanceTokenImplArray.length; ++n) {
                if (sessionContextGroupInstanceTokenImplArray[n] == null) continue;
                ++this.tokenArraySize;
            }
            if (this.tokenArraySize > 0) {
                this.tokenArray = new SessionContextGroupInstanceTokenImpl[this.tokenArraySize];
                n = 0;
                for (int i = 0; i < sessionContextGroupInstanceTokenImplArray.length; ++i) {
                    if (sessionContextGroupInstanceTokenImplArray[i] == null) continue;
                    this.tokenArray[n++] = sessionContextGroupInstanceTokenImplArray[i];
                }
            }
        }

        public boolean hasNext() {
            return this.current < this.tokenArraySize;
        }

        public Object next() {
            if (this.current >= this.tokenArraySize) {
                return null;
            }
            SessionContextGroupInstanceTokenImpl sessionContextGroupInstanceTokenImpl = this.tokenArray[this.current];
            this.tokenArray[this.current] = null;
            ++this.current;
            return sessionContextGroupInstanceTokenImpl;
        }

        public void remove() {
        }
    }
}

