/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EmptyStackException;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultErrorReporter
extends HttpServlet {
    private static final long serialVersionUID = 3763096349528044856L;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PrintWriter printWriter;
        try {
            printWriter = httpServletResponse.getWriter();
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.webcontainer.servlet.DefaultErrorReporter.service", (String)"48", (Object)((Object)this));
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), httpServletResponse.getCharacterEncoding()));
        }
        ServletErrorReport servletErrorReport = (ServletErrorReport)((Object)httpServletRequest.getAttribute("ErrorReport"));
        DefaultErrorReporter.reportErrorAsHTML(printWriter, servletErrorReport, httpServletRequest.getRequestURL().toString());
    }

    public static void reportErrorAsHTML(PrintWriter printWriter, ServletErrorReport servletErrorReport, String string) {
        printWriter.println("<HTML>\n<HEAD><TITLE>" + nls.getString("Error.Report", "Error Report") + "</TITLE></HEAD>\n<BODY>");
        if (servletErrorReport == null) {
            printWriter.println(nls.getString("No.Error.to.Report", "No Error to Report"));
        } else {
            printWriter.println("<H1>Error " + servletErrorReport.getErrorCode() + "</H1>");
            printWriter.println("<H3>" + nls.getString("error.occured.processing.request", "An error has occurred while processing request: ") + DefaultErrorReporter.encodeChars(string) + "</H3>");
            printWriter.println("<H3><B>" + nls.getString("Message", "Message:") + "</B> " + servletErrorReport.getMessage() + "</H3><BR>");
            printWriter.println("<B>" + nls.getString("Target.Servlet", "Target Servlet:") + " </B>" + DefaultErrorReporter.encodeChars(servletErrorReport.getTargetServletName()) + "<BR>");
            printWriter.println("<B>" + nls.getString("StackTrace", "StackTrace:") + " </B>");
            DefaultErrorReporter.printFullStackTrace(printWriter, servletErrorReport);
        }
        printWriter.println("\n</BODY>\n</HTML>");
        printWriter.flush();
    }

    public static void printFullStackTrace(PrintWriter printWriter, ServletException servletException) {
        Throwable throwable = null;
        while (servletException != null) {
            throwable = servletException.getRootCause();
            if (throwable == null) {
                throwable = servletException;
                break;
            }
            servletException = throwable instanceof ServletException ? (ServletException)throwable : null;
        }
        try {
            if (throwable instanceof ServletErrorReport) {
                printWriter.println("<HR width=\"100%\">\n" + throwable.getMessage() + "<BR>");
            } else {
                printWriter.println("<HR width=\"100%\">\n" + DefaultErrorReporter.encodeChars(throwable.getMessage()) + "<BR>");
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter2 = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter2);
            printWriter2.flush();
            String string = throwable instanceof ServletErrorReport ? stringWriter.toString() : DefaultErrorReporter.encodeChars(stringWriter.toString());
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                printWriter.println(stringTokenizer.nextToken());
                printWriter.println("<BR>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            printWriter.println("<BR>");
        }
        catch (EmptyStackException emptyStackException) {
            FFDCFilter.processException((Throwable)emptyStackException, (String)"com.ibm.ws.webcontainer.servlet.DefaultErrorReporter.printFullStackTrace", (String)"158");
        }
    }

    public static void printShortStackTrace(PrintWriter printWriter, ServletException servletException) {
        Throwable throwable = null;
        while (servletException != null) {
            throwable = servletException.getRootCause();
            if (throwable == null) {
                throwable = servletException;
                break;
            }
            servletException = throwable instanceof ServletException ? (ServletException)throwable : null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter2 = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter2);
            printWriter2.flush();
            String string = throwable instanceof ServletErrorReport ? stringWriter.toString() : DefaultErrorReporter.encodeChars(stringWriter.toString());
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                printWriter.println(stringTokenizer.nextToken());
                printWriter.println("<BR>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            printWriter.println("<BR>");
        }
        catch (EmptyStackException emptyStackException) {
            FFDCFilter.processException((Throwable)emptyStackException, (String)"com.ibm.ws.webcontainer.servlet.DefaultErrorReporter.printShortStackTrace", (String)"217");
        }
    }

    public static String encodeChars(String string) {
        if (string == null) {
            return "";
        }
        boolean bl = false;
        int n = string.length();
        if (n < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block12: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block12;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block12;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block12;
                }
                case '+': {
                    stringBuffer.append("&#43;");
                    continue block12;
                }
                case '(': {
                    stringBuffer.append("&#40;");
                    continue block12;
                }
                case ')': {
                    stringBuffer.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block12;
                }
                case '%': {
                    stringBuffer.append("&#37;");
                    continue block12;
                }
                case ';': {
                    stringBuffer.append("&#59;");
                    continue block12;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }
}

