/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.util.FileSystem;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryBrowsingServlet
extends HttpServlet {
    private static final long serialVersionUID = 3258125864872195895L;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    public static boolean exposeWebInfOnDispatch = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("exposewebinfondispatch"));

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "Index of ";
        String string2 = (String)httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path");
        String string3 = (String)httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri");
        File file = new File(string2);
        ServletContext servletContext = this.getServletConfig().getServletContext();
        String string4 = servletContext.getRealPath("");
        int n = string2.lastIndexOf(string4);
        if (n != -1) {
            String string5 = string2.substring(n + string4.length());
            if (!(string5 = string5.replace(File.separatorChar, '/')).startsWith("/")) {
                string5 = "/" + string5;
            }
            if (string5.endsWith("/")) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            boolean bl = !exposeWebInfOnDispatch || httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null;
            try {
                if (!FileSystem.uriCaseCheck(file, string5, bl)) {
                    httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                return;
            }
        }
        if (!string3.endsWith("/")) {
            string3 = string3 + '/';
        }
        string = string + string3;
        if (!file.canRead()) {
            httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<HTML><HEAD><TITLE>");
        printWriter.println(string);
        printWriter.println("</TITLE></HEAD><BODY>");
        printWriter.println("<H1 align=\"left\">" + string + "</H1>");
        printWriter.println("<HR size=\"3\"><TABLE cellpadding=\"2\"><TBODY><TR bgcolor=\"#d7ffff\">");
        printWriter.println("<TH width=\"250\" nowrap><P align=\"left\">Name</P></TH>");
        printWriter.println("<TH width=\"250\" nowrap><P align=\"left\">Last Modified</P></TH>");
        printWriter.println("<TH width=\"150\" nowrap><P align=\"left\">Size</P></TH>");
        printWriter.println("<TH width=\"300\" nowrap><P align=\"left\">Description</P></TH></TR>");
        this.fillTableRows(file, string3, printWriter);
        printWriter.println("</TBODY></TABLE></BODY></HTML>");
        printWriter.close();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private void fillTableRows(File file, String string, PrintWriter printWriter) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            Date date;
            if (fileArray[n].isDirectory()) {
                if (fileArray[n].getName().equalsIgnoreCase("META-INF") || fileArray[n].getName().equalsIgnoreCase("WEB-INF")) {
                    ++n;
                    continue;
                }
                printWriter.println("<TR><TD nowrap>");
                printWriter.println("<A href=\"" + string + fileArray[n].getName() + "\">");
                printWriter.println("<B>" + fileArray[n].getName() + "</B></A></TD>");
                date = new Date(fileArray[n].lastModified());
                printWriter.println("<TD nowrap>" + date.toString() + "</TD>");
                printWriter.println("<TD nowrap>-</TD><TD nowrap>Directory</TD></TR>");
            } else {
                if (fileArray[n].getName().endsWith(".jsp") || fileArray[n].getName().endsWith(".jsv") || fileArray[n].getName().endsWith(".jsw")) {
                    ++n;
                    continue;
                }
                printWriter.println("<TR><TD nowrap>");
                printWriter.println("<A href=\"" + string + fileArray[n].getName() + "\">");
                printWriter.println(fileArray[n].getName() + "</A></TD>");
                date = new Date(fileArray[n].lastModified());
                printWriter.println("<TD nowrap>" + date.toString() + "</TD>");
                printWriter.println("<TD nowrap>" + fileArray[n].length() + "</TD>");
                printWriter.println("<TD nowrap>File</TD></TR>");
            }
            ++n;
        }
    }
}

