/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.event.ServletErrorEvent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.filter.ChainedResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.filter.WebAppFilterManager;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.ws.webcontainer.util.ThreadContextHelper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.ws.webcontainer.webapp.WebAppEventSource;
import com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletReferenceListener;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FileServletWrapper
implements IServletWrapper {
    private boolean notifyInvocationListeners = false;
    private ArrayList listeners;
    private long lasAccessedTime = -1L;
    protected WebApp context;
    protected DefaultExtensionProcessor parentProcessor;
    private int nServicing = 0;
    private static TraceComponent tc = Tr.register((Class)FileServletWrapper.class, (String)"FileServletWrapper", (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected WebAppEventSource evtSource;
    private static boolean fileWrapperEvents = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.filewrapperevents", "false"));
    private ServletEvent event;
    private boolean wrapperInitialized;
    private StringBuffer servletAndFileName = new StringBuffer();
    private static boolean fileWrapperEventsLessDetail = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.filewrappereventslessdetail", "false"));

    public FileServletWrapper(IServletContext iServletContext, DefaultExtensionProcessor defaultExtensionProcessor) {
        this.context = (WebApp)iServletContext;
        this.parentProcessor = defaultExtensionProcessor;
        if (fileWrapperEventsLessDetail) {
            fileWrapperEvents = true;
        }
        this.evtSource = (WebAppEventSource)this.context.getServletContextEventSource();
        boolean bl = this.notifyInvocationListeners = this.evtSource.hasServletInvocationListeners() && fileWrapperEvents;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("FileServletWrapper created : " + this.evtSource.hasServletInvocationListeners() + ", fileWrapperEvents :" + fileWrapperEvents + ", fileWrapperEventsLessDetail : " + fileWrapperEventsLessDetail));
        }
    }

    public void addServletReferenceListener(ServletReferenceListener servletReferenceListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(servletReferenceListener);
    }

    public ServletErrorReport constructErrorReport(Throwable throwable, IServletWrapper iServletWrapper) {
        return new WebAppErrorReport(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Destroy");
        }
        for (int i = 0; this.nServicing > 0 && i < ServletWrapper.destroyWaitTime; ++i) {
            try {
                if (i == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("servlet is still servicing " + this.nServicing + " requests...will wait another " + i + " 60 seconds for servlet to become idle. : {0}"), (Object)this.getServletName());
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Waiting.servlet.to.finish.servicing.requests:.{0}", (Object)this.getServletName());
                    }
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webcontainer.servlet.ServletInstance.destroy", (String)"377", (Object)this);
            }
        }
        if (this.nServicing > 0 && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Servlet.wait.for.destroy.timeout.has.expired,.destroy.will.be.forced:.{0}", (Object)this.getServletName());
        }
        if (this.notifyInvocationListeners) {
            this.evtSource.onServletStartDestroy(this.getServletEvent());
        }
        FileServletWrapper fileServletWrapper = this;
        synchronized (fileServletWrapper) {
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ServletReferenceListener servletReferenceListener = (ServletReferenceListener)this.listeners.get(i);
                    servletReferenceListener.invalidate();
                }
                this.listeners = null;
            }
        }
        if (this.notifyInvocationListeners) {
            this.evtSource.onServletFinishDestroy(this.getServletEvent());
            this.evtSource.onServletUnloaded(this.getServletEvent());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Destroy");
        }
    }

    public long getLastAccessTime() {
        return this.lasAccessedTime;
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletName() {
        return "File wrapper";
    }

    public Servlet getTarget() {
        return null;
    }

    public ClassLoader getTargetClassLoader() {
        return null;
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        Request request = (Request)ServletUtil.unwrapRequest(servletRequest);
        WebAppDispatcherContext webAppDispatcherContext = request.getWebAppDispatcherContext();
        this.handleRequest(servletRequest, servletResponse, webAppDispatcherContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse, WebAppDispatcherContext webAppDispatcherContext) throws Exception {
        Object object;
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleRequest");
        }
        webAppDispatcherContext.pushServletReference(this);
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (this.notifyInvocationListeners && this.servletAndFileName.length() == 0) {
            object2 = null;
            object = null;
            if (servletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                object2 = (String)servletRequest.getAttribute("javax.servlet.include.servlet_path");
                object = (String)servletRequest.getAttribute("javax.servlet.include.path_info");
            } else {
                object2 = httpServletRequest.getServletPath();
                object = httpServletRequest.getPathInfo();
            }
            this.servletAndFileName.append((String)object2);
            if (object != null) {
                int n = ((String)object).indexOf(59);
                if (n != -1) {
                    object = ((String)object).substring(0, n);
                }
                this.servletAndFileName.append((String)object);
            }
            this.initialize((IServletConfig)this.getServletConfig());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            object2 = (String)httpServletRequest.getAttribute("javax.servlet.include.request_uri");
            object = httpServletRequest.getRequestURI();
            Tr.debug((TraceComponent)tc, (String)("handling request for resource [" + (String)(object2 == null ? object : object2) + "]"));
        }
        if (httpServletRequest.isSecure()) {
            object2 = null;
            object = ServletUtil.unwrapRequest((ServletRequest)httpServletRequest);
            object2 = ((SRTServletRequest)object).getCipherSuite();
            if (object2 != null) {
                httpServletRequest.setAttribute("javax.servlet.request.cipher_suite", object2);
                Integer n = WebContainer.getWebContainer().getKeySize((String)object2);
                if (n != null) {
                    httpServletRequest.setAttribute("javax.servlet.request.key_size", (Object)n);
                }
            }
        }
        object2 = null;
        if (this.notifyInvocationListeners) {
            object2 = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletAndFileName(), this.getFileName(), (ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        object = null;
        try {
            block44: {
                try {
                    if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                        this.context.notifyServletRequestCreated((ServletRequest)httpServletRequest);
                    }
                    if (this.context.isMimeFilteringEnabled()) {
                        String string;
                        String string2;
                        object = ThreadContextHelper.getContextClassLoader();
                        ClassLoader classLoader = this.context.getClassLoader();
                        if (classLoader != object) {
                            ThreadContextHelper.setClassLoader(classLoader);
                        }
                        ChainedResponse chainedResponse = new ChainedResponse(httpServletRequest, httpServletResponse);
                        chainedResponse.setContentType("text/html");
                        Enumeration enumeration = httpServletRequest.getHeaderNames();
                        while (enumeration.hasMoreElements()) {
                            string2 = (String)enumeration.nextElement();
                            string = httpServletRequest.getHeader(string2);
                            if (string2.toLowerCase().startsWith("content")) continue;
                            chainedResponse.setAutoTransferringHeader(string2, string);
                        }
                        this.service((ServletRequest)httpServletRequest, (ServletResponse)chainedResponse, (WebAppServletInvocationEvent)object2);
                        string2 = null;
                        if (chainedResponse.isRedirected()) {
                            string2 = chainedResponse.getRedirectURI();
                        }
                        string = chainedResponse.getHeader("content-type");
                        IServletWrapper iServletWrapper = this.getMimeFilterWrapper(string);
                        while (iServletWrapper != null) {
                            httpServletRequest = chainedResponse.getChainedRequest();
                            ChainedResponse chainedResponse2 = chainedResponse;
                            chainedResponse = new ChainedResponse(httpServletRequest, httpServletResponse);
                            chainedResponse.setContentType(string);
                            this.transferHeadersFromPrevChainedResp(chainedResponse, chainedResponse2);
                            if (string2 != null) {
                                chainedResponse.setHeader("location", string2);
                                chainedResponse.setStatus(302);
                            }
                            webAppDispatcherContext.pushServletReference(iServletWrapper);
                            ((ServletWrapper)iServletWrapper).service((ServletRequest)httpServletRequest, (ServletResponse)chainedResponse, (WebAppServletInvocationEvent)object2);
                            webAppDispatcherContext.popServletReference();
                            String string3 = chainedResponse.getHeader("content-type");
                            String string4 = string3.toLowerCase();
                            String string5 = string.toLowerCase();
                            int n = string4.indexOf(";");
                            if (n != -1) {
                                string4 = string4.substring(0, n);
                            }
                            if ((n = string5.indexOf(";")) != -1) {
                                string5 = string5.substring(0, n);
                            }
                            if (string4.equals(string5)) {
                                iServletWrapper = null;
                                continue;
                            }
                            string = string3;
                            iServletWrapper = this.getMimeFilterWrapper(string);
                        }
                        chainedResponse.transferResponse(httpServletResponse);
                        break block44;
                    }
                    if (this.context.isFiltersDefined()) {
                        WebAppFilterManager webAppFilterManager = this.context.getFilterManager();
                        webAppFilterManager.doFilter(httpServletRequest, httpServletResponse, this, webAppDispatcherContext);
                    } else {
                        this.service((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, (WebAppServletInvocationEvent)object2);
                    }
                    if (webAppDispatcherContext.isInclude()) break block44;
                    if (httpServletResponse instanceof IResponseOutput) {
                        ((IResponseOutput)httpServletResponse).flushBuffer(false);
                        break block44;
                    }
                    httpServletResponse.flushBuffer();
                }
                catch (WriteBeyondContentLengthException writeBeyondContentLengthException) {
                    FFDCFilter.processException((Throwable)writeBeyondContentLengthException, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", (String)"293");
                    webAppDispatcherContext.pushException(writeBeyondContentLengthException);
                    try {
                        httpServletResponse.flushBuffer();
                    }
                    catch (IOException iOException) {
                        ServletErrorReport servletErrorReport = this.constructErrorReport(iOException, webAppDispatcherContext.getCurrentServletReference());
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", (String)"298");
                        throw servletErrorReport;
                    }
                    Object var20_35 = null;
                    if (object != null) {
                        ThreadContextHelper.setClassLoader((ClassLoader)object);
                    }
                    if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                        this.context.notifyServletRequestDestroyed((ServletRequest)httpServletRequest);
                    }
                    webAppDispatcherContext.popServletReference();
                    if (!TraceComponent.isAnyTracingEnabled()) return;
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit((TraceComponent)tc, (String)"handleRequest");
                    return;
                }
                catch (IOException iOException) {
                    if (!webAppDispatcherContext.isInclude() && !webAppDispatcherContext.isForward()) {
                        ServletErrorReport servletErrorReport = this.constructErrorReport(iOException, webAppDispatcherContext.getCurrentServletReference());
                        webAppDispatcherContext.pushException(iOException);
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", (String)"298");
                        throw servletErrorReport;
                    }
                    webAppDispatcherContext.pushException(iOException);
                    throw iOException;
                }
                catch (ServletErrorReport servletErrorReport) {
                    FFDCFilter.processException((Throwable)((Object)servletErrorReport), (String)"com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher.dispatch", (String)"428", (Object)this);
                    webAppDispatcherContext.pushException((Throwable)((Object)servletErrorReport));
                    throw servletErrorReport;
                }
                catch (ServletException servletException) {
                    if (!webAppDispatcherContext.isInclude() && !webAppDispatcherContext.isForward()) {
                        servletErrorReport = this.constructErrorReport(servletException, webAppDispatcherContext.getCurrentServletReference());
                        FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", (String)"309");
                        webAppDispatcherContext.pushException(servletException);
                        throw servletErrorReport;
                    }
                    webAppDispatcherContext.pushException(servletException);
                    throw servletException;
                }
                catch (RuntimeException runtimeException) {
                    if (!webAppDispatcherContext.isInclude() && !webAppDispatcherContext.isForward()) {
                        servletErrorReport = this.constructErrorReport(runtimeException, webAppDispatcherContext.getCurrentServletReference());
                        webAppDispatcherContext.pushException(runtimeException);
                        FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher.dispatch", (String)"448", (Object)this);
                        throw servletErrorReport;
                    }
                    webAppDispatcherContext.pushException(runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    servletErrorReport = this.constructErrorReport(throwable, webAppDispatcherContext.getCurrentServletReference());
                    webAppDispatcherContext.pushException(throwable);
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.ServletWrapper.handleRequest()", (String)"313");
                    throw servletErrorReport;
                }
            }
            Object var20_34 = null;
            if (object != null) {
                ThreadContextHelper.setClassLoader((ClassLoader)object);
            }
            if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                this.context.notifyServletRequestDestroyed((ServletRequest)httpServletRequest);
            }
            webAppDispatcherContext.popServletReference();
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"handleRequest");
            return;
        }
        catch (Throwable throwable) {
            Object var20_36 = null;
            if (object != null) {
                ThreadContextHelper.setClassLoader((ClassLoader)object);
            }
            if (!webAppDispatcherContext.getIsInclude() && !webAppDispatcherContext.isForward()) {
                this.context.notifyServletRequestDestroyed((ServletRequest)httpServletRequest);
            }
            webAppDispatcherContext.popServletReference();
            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"handleRequest");
            throw throwable;
        }
    }

    protected String getFileName() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse, WebAppServletInvocationEvent webAppServletInvocationEvent) throws IOException, ServletException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"service");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        Request request = (Request)ServletUtil.unwrapRequest(servletRequest);
        WebAppDispatcherContext webAppDispatcherContext = request.getWebAppDispatcherContext();
        boolean bl = true;
        boolean bl2 = this.notifyInvocationListeners && webAppServletInvocationEvent != null;
        long l = 0L;
        long l2 = 0L;
        if (bl2) {
            this.evtSource.onServletStartService(webAppServletInvocationEvent);
            l = System.currentTimeMillis();
        }
        try {
            block16: {
                try {
                    Object object = this;
                    // MONITORENTER : object
                    ++this.nServicing;
                    // MONITOREXIT : object
                    if (!webAppDispatcherContext.isInclude()) {
                        bl = this.setResponseHeaders(httpServletRequest, httpServletResponse);
                    }
                    if (bl) {
                        object = this.getInputStream();
                        this.writeResponseToClient(httpServletResponse, (InputStream)object);
                    }
                    if (!bl2) break block16;
                    l2 = System.currentTimeMillis();
                    webAppServletInvocationEvent.setResponseTime(l2 - l);
                    this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                }
                catch (Throwable throwable) {
                    if (!bl2) throw new ServletException(throwable);
                    if (l2 == 0L) {
                        l2 = System.currentTimeMillis();
                        webAppServletInvocationEvent.setResponseTime(l2 - l);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Notify onServletFinishService : response time " + (l2 - l) + " milliseconds"));
                        }
                        this.evtSource.onServletFinishService(webAppServletInvocationEvent);
                    }
                    ServletErrorEvent servletErrorEvent = new ServletErrorEvent(this, this.getServletContext(), this.getServletName(), "FileServletWrapper", throwable);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Notify onServletServiceError : " + servletErrorEvent.toString()));
                    }
                    this.evtSource.onServletServiceError(servletErrorEvent);
                    throw new ServletException(throwable);
                }
            }
            Object var17_14 = null;
            FileServletWrapper fileServletWrapper = this;
            // MONITORENTER : fileServletWrapper
            --this.nServicing;
            // MONITOREXIT : fileServletWrapper
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)tc, (String)"service");
            return;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            FileServletWrapper fileServletWrapper = this;
            // MONITORENTER : fileServletWrapper
            --this.nServicing;
            // MONITOREXIT : fileServletWrapper
            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)tc, (String)"service");
            throw throwable;
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected abstract long getLastModified();

    protected abstract int getContentLength();

    private boolean setResponseHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        String string = httpServletRequest.getRequestURI();
        String string2 = this.context.getMimeType(string);
        if (string2 != null) {
            httpServletResponse.setContentType(string2);
        } else if (string.endsWith(".html") || string.endsWith(".htm")) {
            httpServletResponse.setContentType("text/html");
        } else {
            httpServletResponse.setContentType("text/plain");
        }
        String string3 = this.parentProcessor.getEsiControl();
        if (string3 != null && httpServletRequest.getHeader("Surrogate-Capability") != null && httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null && !httpServletResponse.containsHeader("Surrogate-Control") && httpServletRequest.getAuthType() == null) {
            httpServletResponse.addHeader("Surrogate-Control", string3);
        }
        long l = -1L;
        try {
            l = httpServletRequest.getDateHeader("If-Modified-Since");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = -1L;
        }
        long l2 = this.getLastModified();
        if (l2 == 0L && !this.isAvailable()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isAvailable false, setting 404 status");
            }
            httpServletResponse.setStatus(404);
            return false;
        }
        httpServletResponse.setDateHeader("last-modified", l2);
        if (l != -1L && l / 1000L == l2 / 1000L) {
            httpServletResponse.setStatus(304);
            return false;
        }
        httpServletResponse.setContentLength(this.getContentLength());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponseToClient(HttpServletResponse httpServletResponse, InputStream inputStream) throws ServletException, IOException {
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[this.parentProcessor.getDefaultBufferSize()];
            int n = inputStream.read(byArray);
            while (n != -1) {
                servletOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IllegalStateException illegalStateException) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            char[] cArray = new char[this.parentProcessor.getDefaultBufferSize()];
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, httpServletResponse.getCharacterEncoding());
            int n = inputStreamReader.read(cArray);
            try {
                while (n != -1) {
                    printWriter.write(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"298", (Object)this);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"304", (Object)this);
        }
        finally {
            inputStream.close();
        }
    }

    public void initialize(IServletConfig iServletConfig) throws Exception {
        if (!this.wrapperInitialized && this.notifyInvocationListeners) {
            this.wrapperInitialized = true;
            this.evtSource.onServletStartInit(this.getServletEvent());
            this.evtSource.onServletFinishInit(this.getServletEvent());
            this.evtSource.onServletAvailableForService(this.getServletEvent());
        }
    }

    public void prepareForReload() {
    }

    public void setTarget(Servlet servlet) {
    }

    public void setTargetClassLoader(ClassLoader classLoader) {
    }

    private IServletWrapper getMimeFilterWrapper(String string) {
        try {
            if (string.indexOf(";") != -1) {
                string = string.substring(0, string.indexOf(";"));
            }
            return this.context.getMimeFilterWrapper(string);
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.webapp.WebAppRequestDispatcher.getMimeFilterReference", (String)"834", (Object)this);
            this.context.logError("Failed to load filter for mime-type: " + string, servletException);
            return null;
        }
    }

    private void transferHeadersFromPrevChainedResp(ChainedResponse chainedResponse, ChainedResponse chainedResponse2) {
        Object object;
        Enumeration enumeration = chainedResponse2.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = chainedResponse2.getHeader((String)object);
            chainedResponse.setHeader((String)object, string);
        }
        object = chainedResponse2.getCookies();
        for (int i = 0; i < ((Cookie[])object).length; ++i) {
            Cookie cookie = object[i];
            chainedResponse.addCookie(cookie);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        WebAppServletInvocationEvent webAppServletInvocationEvent = null;
        if (this.notifyInvocationListeners) {
            webAppServletInvocationEvent = new WebAppServletInvocationEvent(this, this.getServletContext(), this.getServletAndFileName(), this.getFileName(), (ServletRequest)((HttpServletRequest)servletRequest), (ServletResponse)((HttpServletResponse)servletResponse));
        }
        this.service(servletRequest, servletResponse, webAppServletInvocationEvent);
    }

    public boolean isAvailable() {
        return true;
    }

    public void nameSpacePostInvoke() {
    }

    public void nameSpacePreInvoke() {
    }

    private ServletEvent getServletEvent() {
        if (this.event == null) {
            this.event = new ServletEvent(this, this.getServletContext(), this.getServletAndFileName(), this.getFileName());
        }
        return this.event;
    }

    private String getServletAndFileName() {
        if (!fileWrapperEventsLessDetail && this.servletAndFileName.length() > 0) {
            return this.servletAndFileName.toString();
        }
        return this.getServletName();
    }
}

