/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ExtendedDocumentRootUtils;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.wswebcontainer.servlet.StaticFileServletWrapper;
import com.ibm.wsspi.webcontainer.util.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleFileServlet
extends HttpServlet {
    public static final String PARAM_DEFAULT_PAGE = "default.page";
    public static final String PARAM_BUFFER_SIZE = "bufferSize";
    public static final String WEB_INF_DIR = "WEB-INF";
    public static final String META_INF_DIR = "META-INF";
    private static TraceComponent tc = Tr.register((Class)SimpleFileServlet.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private int defaultBufferSize = 4096;
    private String esiControl = null;
    String extendedDocumentRoot = null;
    private boolean redirectToWelcomeFile = false;

    public void init() throws ServletException {
        String string = this.getInitParameter(PARAM_BUFFER_SIZE);
        if (string != null) {
            try {
                int n;
                this.defaultBufferSize = n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.init", (String)"65", (Object)((Object)this));
            }
        }
        this.extendedDocumentRoot = this.getInitParameter("extendedDocumentRoot");
        String string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.timeOut", "300");
            }
        });
        if (!string2.equals("0")) {
            this.esiControl = "max-age=" + string2 + "," + "cacheid=\"URL\"," + "content=\"ESI/1.0+\"";
        }
        this.esiControl = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperties().getProperty("com.ibm.servlet.file.esi.control", SimpleFileServlet.this.esiControl);
            }
        });
        String string3 = this.getInitParameter("redirectToWelcomeFile");
        if (string3 != null) {
            this.redirectToWelcomeFile = string3.equalsIgnoreCase("true");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doPost");
        }
        this.doGet(httpServletRequest, httpServletResponse);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doPost");
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("doGet : request --->" + httpServletRequest.getRequestURI() + "<---"));
            }
            boolean bl = false;
            ServletContext servletContext = this.getServletContext();
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = null;
            String string4 = null;
            if (httpServletRequest.getAttribute("javax.servlet.include.request_uri") != null) {
                bl = true;
                string3 = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
                string4 = (String)httpServletRequest.getAttribute("javax.servlet.include.path_info");
            } else {
                string3 = httpServletRequest.getServletPath();
                string4 = httpServletRequest.getPathInfo();
            }
            stringBuffer.append(string3);
            if (string4 != null) {
                int n;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("pathInfo:" + string4.toString()));
                }
                if ((n = string4.indexOf(59)) != -1) {
                    string4 = string4.substring(0, n);
                }
                stringBuffer.append(string4);
                if (string4.indexOf(WEB_INF_DIR) != -1 || string4.indexOf(META_INF_DIR) != -1) {
                    httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), stringBuffer.toString()));
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doGet ---> Forbidden-WEB-INF/META-INF");
                    }
                    return;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("path:" + stringBuffer.toString()));
            }
            if (stringBuffer.toString().indexOf(WebApp.DIR_BROWSING_MAPPING) != -1) {
                httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doGet ---> FileNotFound-DirBrowsing disabled");
                }
                return;
            }
            string2 = servletContext.getRealPath(stringBuffer.toString());
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!this.isValidFilePath(string2)) {
                httpServletResponse.sendError(403, nls.getString("File.name.contains.illegal.character", "File path contains illegal character."));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doGet ---> Forbidden-invalid file path");
                }
                return;
            }
            File file = new File(string2);
            List list = (List)servletContext.getAttribute(WebApp.WELCOME_FILE_LIST);
            if (!file.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("file does not exist :" + file.getPath()));
                }
                if (!(string = new ExtendedDocumentRootUtils(this.getServletContext(), this.extendedDocumentRoot)).searchPathExists()) {
                    int n = 0;
                    object4 = httpServletRequest.getAttribute("WelcomeFileListEntry");
                    if (object4 != null) {
                        n = Integer.parseInt((String)object4);
                        int n2 = stringBuffer.lastIndexOf((String)list.get(n));
                        if (n2 != -1) {
                            stringBuffer.delete(n2, stringBuffer.length());
                        }
                        ++n;
                    }
                    if (n != list.size()) {
                        object3 = (String)list.get(n);
                        if (((String)object3).charAt(0) == '/') {
                            object3 = ((String)object3).substring(1);
                        }
                        if (stringBuffer.charAt(stringBuffer.length() - 1) != '/') {
                            stringBuffer.append('/');
                        }
                        object2 = stringBuffer.toString() + (String)object3;
                        httpServletRequest.setAttribute("WelcomeFileListEntry", (Object)("" + n));
                        object = servletContext.getRequestDispatcher((String)object2);
                        if (object != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("forward to WelcomeFile:" + (String)object2));
                            }
                            object.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"doGet");
                            }
                            return;
                        }
                    } else {
                        string2 = servletContext.getRealPath(stringBuffer.toString());
                        if (!string2.endsWith(File.separator)) {
                            string2 = string2 + File.separator;
                        }
                        if ((object3 = servletContext.getRequestDispatcher(WebApp.DIR_BROWSING_MAPPING)) != null) {
                            httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", (Object)string2);
                            httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", (Object)stringBuffer.toString());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Directory Browse :" + string2));
                            }
                            object3.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"doGet");
                            }
                            return;
                        }
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Extended doc root :" + string.toString()));
                    }
                    if (this.isRequestForbidden(stringBuffer)) {
                        httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), httpServletRequest.getPathInfo()));
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"doGet --> Forbidden-Extended doc root endsWith");
                        }
                        return;
                    }
                    string.handleExtendedDocumentRoots(stringBuffer.toString());
                    boolean bl2 = true;
                    if (!bl) {
                        bl2 = this.setResponseHeaders(httpServletRequest, httpServletResponse, string.getMatchedFile(), string.useContentLength());
                    }
                    if (bl2) {
                        this.writeResponseToClient(httpServletResponse, string.getInputStream());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doGet --> Extended doc root");
                    }
                    return;
                }
            }
            if (file.isDirectory()) {
                RequestDispatcher requestDispatcher;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("file is a directory:" + file.getPath()));
                }
                if (!(string = this.getURLWithRequestURIEncoded(httpServletRequest).toString()).endsWith("/") && !bl) {
                    String string5 = string + "/";
                    object4 = httpServletRequest.getQueryString();
                    if (object4 != null) {
                        string5 = string5 + "?" + (String)object4;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("sendRedirect :" + string5));
                    }
                    httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string5));
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doGet");
                    }
                    return;
                }
                if (list != null && list.size() != 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Welcome File list found : " + list.toString()));
                    }
                    Iterator iterator = list.iterator();
                    object4 = null;
                    object3 = null;
                    while (iterator.hasNext()) {
                        String string6;
                        object4 = (String)iterator.next();
                        if (((String)object4).charAt(0) == '/') {
                            object4 = ((String)object4).substring(1);
                        }
                        if (((File)(object3 = new File(string2 + (String)object4))).exists()) {
                            if (this.redirectToWelcomeFile) {
                                object2 = "";
                                if (httpServletRequest.getQueryString() != null) {
                                    object2 = "?" + httpServletRequest.getQueryString();
                                }
                                if ((object = this.removeLeadingSlashes(stringBuffer.toString())) == null) {
                                    object = "";
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("sendRedirect to Welcome File:" + (String)object + (String)object4 + (String)object2));
                                }
                                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL((String)object + (String)object4 + (String)object2));
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("sendRedirect to Welcome File:" + stringBuffer.toString() + (String)object4));
                                }
                                servletContext.getRequestDispatcher(stringBuffer.toString() + (String)object4).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"doGet : Welcome File");
                            }
                            return;
                        }
                        int n = 0;
                        object = httpServletRequest.getAttribute("WelcomeFileListEntry");
                        if (object != null) {
                            n = Integer.parseInt((String)object);
                            int n3 = stringBuffer.indexOf((String)list.get(n));
                            if (n3 != -1) {
                                stringBuffer.delete(n3, stringBuffer.length());
                            }
                            ++n;
                        }
                        if (n == list.size()) {
                            throw new FileNotFoundException(file.getAbsolutePath());
                        }
                        if (((String)object4).charAt(0) == '/') {
                            object4 = ((String)object4).substring(1);
                        }
                        httpServletRequest.setAttribute("WelcomeFileListEntry", (Object)("" + n));
                        if (this.redirectToWelcomeFile) {
                            String string7;
                            string6 = "";
                            if (httpServletRequest.getQueryString() != null) {
                                string6 = "?" + httpServletRequest.getQueryString();
                            }
                            if ((string7 = this.removeLeadingSlashes(stringBuffer.toString())) == null) {
                                string7 = "";
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("sendRedirect to Welcome File from list:" + string7 + (String)object4 + string6));
                            }
                            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string7 + (String)object4 + string6));
                            continue;
                        }
                        string6 = servletContext.getRequestDispatcher(stringBuffer.toString() + (String)object4);
                        if (string6 != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Forward :" + stringBuffer.toString() + (String)object4));
                            }
                            string6.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                        }
                        if (!httpServletResponse.isCommitted()) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"doGet ---> resp comitted");
                        }
                        return;
                    }
                }
                if ((requestDispatcher = servletContext.getRequestDispatcher(WebApp.DIR_BROWSING_MAPPING)) != null) {
                    httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.path", (Object)string2);
                    httpServletRequest.setAttribute("com.ibm.servlet.engine.webapp.dir.browsing.uri", (Object)httpServletRequest.getRequestURI());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Directory Browse :" + string2));
                    }
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doGet");
                    }
                    return;
                }
                httpServletResponse.sendError(404, nls.getString("File.not.found", "File not found"));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doGet ---> FileNotFound");
                }
                return;
            }
            string = stringBuffer.toString();
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
                String string8 = string.substring(string.lastIndexOf(46) + 1);
                if ((string8 = string8.substring(0, string8.indexOf(47)).toLowerCase()).equals("jsp") || string8.equals("jsv") || string8.equals("jsw")) {
                    httpServletResponse.sendError(403, nls.getString("Serving.JSP.Not.Allowed", "Serving contents of JSP files is not allowed."));
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doGet --->Forbidden-serving jsp source files");
                    }
                    return;
                }
            }
            if (this.isRequestForbidden(stringBuffer)) {
                httpServletResponse.sendError(403, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), string4));
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doGet --> Forbidden-endsWith");
                }
                return;
            }
            File file2 = new File(string2);
            boolean bl3 = !StaticFileServletWrapper.exposeWebInfOnDispatch || httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null;
            try {
                if (!FileSystem.uriCaseCheck(file2, stringBuffer.toString(), bl3)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doGet --> Case sensitivity check failed - throw FileNotFoundException");
                    }
                    throw new FileNotFoundException(stringBuffer.toString());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"doGet --> Case sensitivity check threw Illegal Argument Exception - throw FileNotFoundException");
                }
                throw new FileNotFoundException(stringBuffer.toString());
            }
            boolean bl4 = true;
            if (!bl) {
                bl4 = this.setResponseHeaders(httpServletRequest, httpServletResponse, file, true);
            }
            if (bl4) {
                object2 = new FileInputStream(file);
                this.writeResponseToClient(httpServletResponse, (InputStream)object2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"FileNotFoundException caught");
            }
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.doGet", (String)"312", (Object)((Object)this));
            httpServletResponse.sendError(404, MessageFormat.format(nls.getString("File.not.found", "File not found: {0}"), fileNotFoundException.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doGet");
        }
    }

    private boolean isValidFilePath(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) >= ' ') continue;
            return false;
        }
        return true;
    }

    private boolean setResponseHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setResponseHeaders");
        }
        httpServletResponse.setDateHeader("Date", System.currentTimeMillis());
        String string = httpServletRequest.getRequestURI();
        String string2 = this.getServletContext().getMimeType(string);
        if (string2 != null) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setContentType :" + string2));
            }
            httpServletResponse.setContentType(string2);
        } else if (string.endsWith(".html") || string.endsWith(".htm")) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setContentType :text/html");
            }
            httpServletResponse.setContentType("text/html");
        } else {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setContentType :text/plain");
            }
            httpServletResponse.setContentType("text/plain");
        }
        if (this.esiControl != null && httpServletRequest.getHeader("Surrogate-Capability") != null && httpServletRequest.getAttribute("com.ibm.servlet.engine.webapp.dispatch_nested") == null && !httpServletResponse.containsHeader("Surrogate-Control") && httpServletRequest.getAuthType() == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addHeader :Surrogate-Control");
            }
            httpServletResponse.addHeader("Surrogate-Control", this.esiControl);
        }
        long l = -1L;
        try {
            l = httpServletRequest.getDateHeader("If-Modified-Since") / 1000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            l = -1L;
        }
        long l2 = file.lastModified();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDateHeader :last-modified :" + l2));
        }
        httpServletResponse.setDateHeader("last-modified", l2);
        if (l == l2 / 1000L) {
            httpServletResponse.setStatus(304);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setResponseHeaders false");
            }
            return false;
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setContentLength :" + file.length()));
            }
            httpServletResponse.setContentLength(new Long(file.length()).intValue());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setResponseHeaders true");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseToClient(HttpServletResponse httpServletResponse, InputStream inputStream) throws ServletException, IOException {
        try {
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"writeResponseToClient");
            }
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[this.defaultBufferSize];
            int n = inputStream.read(byArray);
            while (n != -1) {
                servletOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IllegalStateException caught");
            }
            PrintWriter printWriter = httpServletResponse.getWriter();
            char[] cArray = new char[this.defaultBufferSize];
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, httpServletResponse.getCharacterEncoding());
            int n = inputStreamReader.read(cArray);
            try {
                while (n != -1) {
                    printWriter.write(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"IOException caught");
                }
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"298", (Object)((Object)this));
            }
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IOException caught");
            }
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.servlet.SimpleFileServlet.writeResponseToClient", (String)"304", (Object)((Object)this));
        }
        finally {
            inputStream.close();
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeResponseToClient");
        }
    }

    public String removeLeadingSlashes(String string) {
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        while (!bl && n < n2) {
            if (string.charAt(n) == '/') {
                ++n;
                continue;
            }
            bl = true;
        }
        if (bl) {
            string2 = string.substring(n);
        }
        return string2;
    }

    private StringBuffer getURLWithRequestURIEncoded(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = httpServletRequest.getScheme();
        int n = httpServletRequest.getServerPort();
        String string2 = null;
        try {
            string2 = new String(httpServletRequest.getRequestURI().getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = httpServletRequest.getRequestURI();
        }
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private boolean isRequestForbidden(StringBuffer stringBuffer) {
        boolean bl = false;
        String string = stringBuffer.toString();
        if (string.lastIndexOf("..") != -1 && !string.startsWith("/...") || string.endsWith("\\") || string.endsWith(".") || string.endsWith("/")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isRequestForbidden returning true, matchstring :" + string));
            }
            bl = true;
        }
        return bl;
    }
}

