/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.TimedServletPool;
import com.ibm.ws.webcontainer.servlet.TimedServletPoolElement;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class SingleThreadModelServlet
extends GenericServlet {
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private TimedServletPool _pool;
    private Class _servletClass;
    protected static TraceComponent tc = Tr.register((Class)SingleThreadModelServlet.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public SingleThreadModelServlet() {
    }

    public SingleThreadModelServlet(Class clazz) {
        this.setServletClass(clazz);
    }

    public void init() throws ServletException {
        try {
            int n = 5;
            long l = 60000L;
            String string = this.getServletConfig().getServletContext().getInitParameter("singlethreadmodel.initialpoolsize");
            String string2 = this.getServletConfig().getServletContext().getInitParameter("singlethreadmodel.maxidletime");
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 5;
                    Tr.error((TraceComponent)tc, (String)"setting initialPoolSize to default value of 5", (Object)numberFormatException);
                }
            }
            if (string2 != null) {
                try {
                    l = Long.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    l = 60000L;
                    Tr.error((TraceComponent)tc, (String)"setting maxIdleTime to default value of 60000", (Object)numberFormatException);
                }
            }
            this._pool = this.getTimedServletPool(n, l, this.getServletClass(), this.getServletConfig());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.init", (String)"64", (Object)((Object)this));
            throw new ServletException(throwable);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            TimedServletPoolElement timedServletPoolElement = this._pool.getNextElement();
            timedServletPoolElement.getServlet().service(servletRequest, servletResponse);
            this._pool.returnElement(timedServletPoolElement);
            this._pool.removeExpiredElements();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.service", (String)"84", (Object)((Object)this));
            throw new ServletException(throwable);
        }
    }

    public void destroy() {
        this._pool.removeAllElements();
    }

    public Class getServletClass() {
        return this._servletClass;
    }

    public void setServletClass(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            Object[] objectArray = new Object[]{clazz};
            throw new IllegalArgumentException(nls.getFormattedMessage("Class.{0}.does.not.implement.servlet", objectArray, "Class " + clazz + " does not implement servlet"));
        }
        this._servletClass = clazz;
    }

    public int getInstanceCount() {
        return this._pool.getSize();
    }

    protected TimedServletPool getTimedServletPool(int n, long l, Class clazz, ServletConfig servletConfig) throws ServletException {
        try {
            return new TimedServletPool(n, l, clazz, servletConfig);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.servlet.SingleThreadModelServlet.getTimedServletPool", (String)"65", (Object)((Object)this));
            throw new ServletException(throwable);
        }
    }
}

