/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.servlet.util.EmptyEnumeration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.core.Request;
import com.ibm.ws.webcontainer.core.Response;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.srt.IExtendedRequest;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.http.HttpInputStream;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.IInputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SRTServletRequest
implements Request,
HttpServletRequest,
IExtendedRequest,
IServletRequest,
IPrivateRequestAttributes,
IInputStreamObserver {
    protected static TraceComponent tc = Tr.register((Class)SRTServletRequest.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static String CLIENT_ENCODING_OVERRIDE;
    private static String DEFAULT_CLIENT_ENCODING;
    private static String suppressHeadersInRequest;
    private static ArrayList suppressheadersList;
    private static final String JAVAX_NET_SSL_PEER_CERTS = "javax.net.ssl.peer_certificates";
    private static final String JAVAX_NET_SSL_CIPHER_SUITE = "javax.net.ssl.cipher_suite";
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static final String INPUT_STREAM_CONTENT_TYPE = "ContentType";
    private static final String INPUT_STREAM_CONTENT_DATA = "ContentData";
    private static final String INPUT_STREAM_CONTENT_DATA_LENGTH = "ContentDataLength";
    private UnsynchronizedStack _paramStack = new UnsynchronizedStack();
    private SRTConnectionContext _connContext;
    private SRTRequestContext _requestContext = null;
    private WebAppDispatcherContext _dispatchContext = null;
    private SRTServletRequestHelper _srtRequestHelper;
    protected IRequest _request = null;
    protected WSServletInputStream _in;
    private boolean _runningCollaborators = false;
    private String _setInputStreamContentType;
    private int _setInputStreamContentLength;
    private boolean _setInputDataStreamCalled;

    public SRTServletRequest(SRTConnectionContext sRTConnectionContext) {
        this._connContext = sRTConnectionContext;
        this._requestContext = new SRTRequestContext(this);
        this._in = this.createInputStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("inputStream is of type --> " + (Object)((Object)this._in) + " [" + this + "]"));
        }
    }

    public Object getPrivateAttribute(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPrivateAttribute name --> " + string + " [" + this + "]"));
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            return null;
        }
        return this._srtRequestHelper._privateAttributes.get(string);
    }

    public Enumeration getPrivateAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPrivateAttributeNames [" + this + "]"));
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            return EmptyEnumeration.instance();
        }
        return this._srtRequestHelper._privateAttributes.keys();
    }

    public void setPrivateAttribute(String string, Object object) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setPrivateAttribute name --> " + string + " value --> " + object.toString() + " [" + this + "]"));
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            this._srtRequestHelper._privateAttributes = new Hashtable();
        }
        this._srtRequestHelper._privateAttributes.put(string, object);
    }

    public void initForNextRequest(IRequest iRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initForNextRequest. IRequest = " + iRequest + " [" + this + "]"));
        }
        try {
            if (iRequest == null) {
                this._in.init(null);
                return;
            }
            this._setInputStreamContentType = null;
            this._setInputStreamContentLength = -1;
            this._setInputDataStreamCalled = false;
            this._request = iRequest;
            this._srtRequestHelper = new SRTServletRequestHelper();
            this._in.init(this._request.getInputStream());
            if (this.getContentLength() > 0) {
                this._in.setContentLength(this.getContentLength());
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.initForNextRequest", (String)"828", (Object)this);
        }
    }

    public Object getAttribute(String string) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAttribute name --> " + string + " [" + this + "]"));
        }
        if ((object = this._srtRequestHelper._attributes.get(string)) == null) {
            if (string.equals(JAVAX_NET_SSL_PEER_CERTS) || string.equals(JAVAX_SERVLET_REQUEST_X509CERTIFICATE)) {
                object = this.getPeerCertificates();
            } else if (string.equals(JAVAX_NET_SSL_CIPHER_SUITE)) {
                object = this.getCipherSuite();
            }
        }
        return object;
    }

    public Enumeration getAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAttributeNames [" + this + "]"));
        }
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._attributes.keySet().iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        boolean bl = EncodingUtils.isCharsetSupported(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCharacterEncoding name --> " + string + " isSupported --> " + String.valueOf(bl) + " [" + this + "]"));
        }
        if (!bl) {
            String string2 = nls.getFormattedMessage("unsupported.request.encoding.[{0}]", new Object[]{string}, "Unsupported encoding specified --> " + string);
            throw new UnsupportedEncodingException(string2);
        }
        this._srtRequestHelper._characterEncoding = string;
    }

    private boolean isHeaderinSuppressedHeadersList(String string) {
        boolean bl = false;
        if (string != null) {
            Iterator iterator = suppressheadersList.iterator();
            while (iterator.hasNext() && !bl) {
                String string2 = (String)iterator.next();
                if (!string.startsWith(string2)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" suppressHeadersInRequest is set and headername =" + string + " begins with =" + string2));
                }
                bl = true;
            }
        }
        return bl;
    }

    public long getDateHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getDateHeader [" + this + "]"));
        }
        long l = -1L;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(string)) {
            l = this._request.getDateHeader(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getDateHeader name --> " + string + " header --> " + String.valueOf(l)));
        }
        return l;
    }

    public String getHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHeader [" + this + "]"));
        }
        String string2 = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(string)) {
            string2 = this._request.getHeader(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getHeader name --> " + string + " header --> " + string2));
        }
        return string2;
    }

    public String getHeaderDirect(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHeaderDirect [" + this + "]"));
        }
        String string2 = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(string)) {
            string2 = this._request.getHeader(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getHeaderDirect name --> " + string + " header --> " + string2));
        }
        return string2;
    }

    public Enumeration getHeaderNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaderNames [" + this + "]"));
        }
        if (suppressHeadersInRequest == null) {
            return this._request.getHeaderNames();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this._request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isHeaderinSuppressedHeadersList(string)) continue;
            arrayList.add(string);
        }
        return Collections.enumeration(arrayList);
    }

    public int getIntHeader(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getIntHeader [" + this + "]"));
        }
        int n = -1;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(string)) {
            n = this._request.getIntHeader(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getIntHeader name --> " + string + " header --> " + String.valueOf(n)));
        }
        return n;
    }

    public Enumeration getHeaders(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getHeaders name --> " + string + " [" + this + "]"));
        }
        Enumeration enumeration = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(string)) {
            enumeration = this._request.getHeaders(string);
        }
        return enumeration;
    }

    public String getMethod() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getMethod [" + this + "]"));
        }
        if (this._srtRequestHelper._method == null) {
            this._srtRequestHelper._method = this._request.getMethod();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getMethod method --> " + this._srtRequestHelper._method));
        }
        return this._srtRequestHelper._method;
    }

    public int getContentLength() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getContentLength [" + this + "]"));
        }
        int n = !this._setInputDataStreamCalled ? this._request.getContentLength() : this._setInputStreamContentLength;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getContentLength length --> " + String.valueOf(n)));
        }
        return n;
    }

    public String getContentType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getContentType [" + this + "]"));
        }
        String string = !this._setInputDataStreamCalled ? this._request.getContentType() : this._setInputStreamContentType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getContentType type --> " + string));
        }
        return string;
    }

    public String getProtocol() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getProtocol [" + this + "]"));
        }
        String string = this._request.getProtocol();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProtocol protocol --> " + string));
        }
        return string;
    }

    public String getScheme() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getScheme [" + this + "]"));
        }
        String string = this._request.getScheme();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getScheme scheme --> " + string));
        }
        return string;
    }

    public int getServerPort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getServerPort [" + this + "]"));
        }
        int n = this._request.getServerPort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getServerPort port --> " + String.valueOf(n)));
        }
        return n;
    }

    public String getRemoteAddr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRemoteAddr [" + this + "]"));
        }
        String string = this._request.getRemoteAddr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRemoteAddr address --> " + string));
        }
        return string;
    }

    public String getRemoteHost() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRemoteHost [" + this + "]"));
        }
        String string = this._request.getRemoteHost();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRemoteHost host --> " + string));
        }
        return string;
    }

    public void setAttribute(String string, Object object) {
        Object object2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAttribute name --> " + string + " value --> " + (object != null ? object.toString() : "") + " [" + this + "]"));
        }
        if ((object2 = this._srtRequestHelper._attributes.put(string, object)) != null) {
            this.attributeReplaced(string, object2);
        } else {
            this.attributeAdded(string, object);
        }
    }

    public void removeAttribute(String string) {
        Object v;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeAttribute name --> " + string + " [" + this + "]"));
        }
        if ((v = this._srtRequestHelper._attributes.remove(string)) != null) {
            this.attributeRemoved(string, v);
        }
    }

    public Locale getLocale() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getLocale [" + this + "]"));
        }
        this.processLocales();
        Locale locale = this._srtRequestHelper._locales.size() > 0 ? this._srtRequestHelper._locales.get(0) : null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getLocale locale --> " + (locale != null ? locale.toString() : "")));
        }
        return locale;
    }

    public Enumeration getLocales() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getLocales [" + this + "]"));
        }
        this.processLocales();
        return new Enumeration(){
            Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._locales.iterator();
            }

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public boolean isSecure() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isSecure [" + this + "]"));
        }
        boolean bl = this._request.isSSL();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isSecure value --> " + String.valueOf(bl)));
        }
        return bl;
    }

    public String getCipherSuite() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCipherSuite [" + this + "]"));
        }
        String string = this._request.getCipherSuite();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCipherSuite value --> " + string));
        }
        return string;
    }

    public X509Certificate[] getPeerCertificates() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPeerCertificates [" + this + "]"));
        }
        X509Certificate[] x509CertificateArray = this._request.getPeerCertificates();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerCertificates", (Object)x509CertificateArray);
        }
        return x509CertificateArray;
    }

    public void setRequest(IRequest iRequest) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRequest [" + this + "]"));
        }
        this._request = iRequest;
    }

    public void attributeAdded(String string, Object object) {
        WebApp webApp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("attributeAdded key --> " + string + " value --> " + object + " [" + this + "]"));
        }
        if ((webApp = this._dispatchContext.getWebApp()) != null) {
            webApp.notifyServletRequestAttrAdded(this, string, object);
        }
    }

    public void attributeRemoved(String string, Object object) {
        WebApp webApp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("attributeRemoved key --> " + string + " value --> " + object + " [" + this + "]"));
        }
        if ((webApp = this._dispatchContext.getWebApp()) != null) {
            webApp.notifyServletRequestAttrRemoved(this, string, object);
        }
    }

    public void attributeReplaced(String string, Object object) {
        WebApp webApp;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("attributeReplaced key --> " + string + " value --> " + object + " [" + this + "]"));
        }
        if ((webApp = this._dispatchContext.getWebApp()) != null) {
            webApp.notifyServletRequestAttrReplaced(this, string, object);
        }
    }

    protected void setLocales(Iterator iterator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLocales [" + this + "]"));
        }
        while (iterator.hasNext()) {
            this._srtRequestHelper._locales.add(iterator.next());
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getInputStream [" + this + "]"));
        }
        if (this._srtRequestHelper._gotReader) {
            throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        if (RequestUtils.ENABLE_MULTI_READ_OF_POST_DATA) {
            if (this._srtRequestHelper._InputStreamClosed) {
                this._in.restart();
            } else if (!this._srtRequestHelper._gotInputStream) {
                this._in.setObserver(this);
            }
        }
        this._srtRequestHelper._gotInputStream = true;
        return this._in;
    }

    protected ServletInputStream getInputStreamInternal() throws IOException {
        if (RequestUtils.ENABLE_MULTI_READ_OF_POST_DATA) {
            if (this._srtRequestHelper._InputStreamClosed) {
                this._in.restart();
            } else {
                this._in.setObserver(this);
            }
            this._srtRequestHelper._gotInputStream = true;
            return this._in;
        }
        return this.getInputStream();
    }

    public IRequest getIRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getIRequest [" + this + "]"));
        }
        return this._request;
    }

    public synchronized BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getReader [" + this + "]"));
        }
        if (this._srtRequestHelper._gotInputStream) {
            throw new IllegalStateException(nls.getString("InputStream.already.obtained", "Input Stream already obtained"));
        }
        if (this._srtRequestHelper._reader == null) {
            this._srtRequestHelper._gotReader = true;
            if (RequestUtils.ENABLE_MULTI_READ_OF_POST_DATA) {
                if (this._srtRequestHelper._InputStreamClosed) {
                    this._in.restart();
                } else {
                    this._in.setObserver(this);
                }
            }
            this._srtRequestHelper._reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this._in), this.getReaderEncoding()));
        } else if (RequestUtils.ENABLE_MULTI_READ_OF_POST_DATA && this._srtRequestHelper._InputStreamClosed) {
            this._in.restart();
            this._srtRequestHelper._reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this._in), this.getReaderEncoding()));
        }
        return this._srtRequestHelper._reader;
    }

    protected void releaseInputStream() {
        if (this._srtRequestHelper._gotInputStream) {
            this._srtRequestHelper._gotInputStream = false;
        }
    }

    protected void releaseReader() {
        if (this._srtRequestHelper._gotReader) {
            this._srtRequestHelper._gotReader = false;
        }
    }

    public void alertOpen() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"alertOpen()", (Object)"");
        }
        this._srtRequestHelper._InputStreamClosed = false;
    }

    public void alertClose() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"alertClose()", (Object)"");
        }
        this._srtRequestHelper._InputStreamClosed = true;
    }

    protected SRTConnectionContext getConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getConnectionContext [" + this + "]"));
        }
        return this._connContext;
    }

    public WebAppDispatcherContext getWebAppDispatcherContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getWebAppDispatcherContext [" + this + "]"));
        }
        return this._dispatchContext;
    }

    public void setWebAppDispatcherContext(WebAppDispatcherContext webAppDispatcherContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setWebAppDispatcherContext old context [" + this._dispatchContext + "] new context [" + webAppDispatcherContext + "]" + " [" + this + "]"));
        }
        this._dispatchContext = webAppDispatcherContext;
        this.resetPathElements();
    }

    public void resetPathElements() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("resetPathElements [" + this + "]"));
        }
        if (this._srtRequestHelper != null) {
            this._srtRequestHelper._requestURI = null;
            this._srtRequestHelper._pathInfo = null;
        }
    }

    public String getLocalAddr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getLocalAddr [" + this + "]"));
        }
        String string = this._request.getLocalAddr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getLocalAddr address --> " + string));
        }
        return string;
    }

    public String getLocalName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getLocalName [" + this + "]"));
        }
        String string = this._request.getLocalName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getLocalName name --> " + string));
        }
        return string;
    }

    public int getLocalPort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getLocalPort [" + this + "]"));
        }
        int n = this._request.getLocalPort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getLocalPort port --> " + String.valueOf(n)));
        }
        return n;
    }

    public int getRemotePort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRemotePort [" + this + "]"));
        }
        int n = this._request.getRemotePort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRemotePort port --> " + String.valueOf(n)));
        }
        return n;
    }

    public Response getResponse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResponse [" + this + "]"));
        }
        return this._connContext.getResponse();
    }

    public void start() {
    }

    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("clone [" + this + "]"));
        }
        SRTServletRequest sRTServletRequest = (SRTServletRequest)super.clone();
        SRTRequestContext sRTRequestContext = null;
        if (this._requestContext != null) {
            sRTServletRequest._requestContext = sRTRequestContext = (SRTRequestContext)this._requestContext.clone(sRTServletRequest);
        }
        WebAppDispatcherContext webAppDispatcherContext = null;
        if (this._dispatchContext != null) {
            sRTServletRequest._dispatchContext = webAppDispatcherContext = (WebAppDispatcherContext)this._dispatchContext.clone(sRTServletRequest, sRTRequestContext);
        }
        SRTConnectionContext sRTConnectionContext = null;
        if (this._connContext != null) {
            sRTServletRequest._connContext = sRTConnectionContext = (SRTConnectionContext)this._connContext.clone(sRTServletRequest, webAppDispatcherContext);
        }
        SRTServletRequestHelper sRTServletRequestHelper = null;
        if (this._srtRequestHelper != null) {
            sRTServletRequest._srtRequestHelper = sRTServletRequestHelper = (SRTServletRequestHelper)this._srtRequestHelper.clone();
        }
        if (this._paramStack != null) {
            sRTServletRequest._paramStack = (UnsynchronizedStack)this._paramStack.clone();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("clone exit original -->" + this + " cloned -->" + sRTServletRequest));
        }
        return sRTServletRequest;
    }

    public String getAuthType() {
        String string = null;
        string = this.getWebAppDispatcherContext().isSecurityEnabledForApplication() ? (String)this.getPrivateAttribute("AUTH_TYPE") : this._request.getAuthType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAuthType authType --> " + string));
        }
        if (string != null) {
            if (string.equals("BASIC")) {
                return "BASIC";
            }
            if (string.equals("CLIENT_CERT")) {
                return "CLIENT_CERT";
            }
            if (string.equals("DIGEST")) {
                return "DIGEST";
            }
            if (string.equals("FORM")) {
                return "FORM";
            }
        }
        return string;
    }

    public String getCharacterEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCharacterEncoding [" + this + "]"));
        }
        if (this._srtRequestHelper._characterEncoding != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getCharacterEncoding existing encoding --> " + this._srtRequestHelper._characterEncoding));
            }
            return this._srtRequestHelper._characterEncoding;
        }
        String string = this.getContentType();
        int n = -1;
        if (string != null) {
            n = string.indexOf("charset=");
        }
        if (n > -1) {
            int n2;
            int n3 = string.indexOf(59, (n2 = n + 8) + 1);
            int n4 = n3 == -1 ? string.length() - 1 : n3 - 1;
            if (n2 < n4) {
                boolean bl;
                boolean bl2 = string.charAt(n2) == '\"' || string.charAt(n2) == '\'';
                boolean bl3 = bl = string.charAt(n4) == '\"' || string.charAt(n4) == '\'';
                String string2 = bl2 && bl ? string.substring(n2 + 1, n4) : (n3 == -1 ? string.substring(n2) : string.substring(n2, n3));
                string = string.substring(0, n) + "charset=" + string2;
                try {
                    this.setCharacterEncoding(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Tr.info((TraceComponent)tc, (String)"Unable to set request character encoding based upon request header ", (Object)unsupportedEncodingException);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getCharacterEncoding encoding --> " + string2));
                }
                return string2;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCharacterEncoding encoding --> null");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCharacterEncoding encoding --> null. Index <= -1.");
        }
        return null;
    }

    public String getReaderEncoding() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getReaderEncoding [" + this + "]"));
        }
        if (this._srtRequestHelper._readerEncoding != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getReaderEncoding: existing encoding --> " + this._srtRequestHelper._readerEncoding));
            }
            return this._srtRequestHelper._readerEncoding;
        }
        String string = CLIENT_ENCODING_OVERRIDE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: client encoding override --> " + string));
        }
        if (string == null) {
            string = this.getCharacterEncoding();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: content-type header --> " + string));
            }
        }
        if (string == null && this.getWebAppDispatcherContext().getWebApp().getConfiguration().isAutoRequestEncoding()) {
            String string2 = this.getHeader("Accept-Language");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: accept-language --> " + string2));
            }
            if (string2 != null && !string2.equals("*")) {
                string = EncodingUtils.getEncodingFromLocale(this.getLocale());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: encoding from locale --> " + string));
                }
            }
        }
        if (string == null) {
            string = DEFAULT_CLIENT_ENCODING;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: default client encoding -->" + string));
            }
        }
        if (string == null) {
            string = "ISO-8859-1";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getReaderEncoding: default encoding --> " + string));
            }
        }
        this._srtRequestHelper._readerEncoding = EncodingUtils.getJvmConverter(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getReaderEncoding: encoding  converted --> " + this._srtRequestHelper._readerEncoding));
        }
        return this._srtRequestHelper._readerEncoding;
    }

    public Cookie[] getCookies() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCookies [" + this + "]"));
        }
        if (!this._srtRequestHelper._cookiesParsed) {
            SRTServletRequestHelper.access$1502(this._srtRequestHelper, this._request.getCookies());
            this._srtRequestHelper._cookiesParsed = true;
        }
        return this._srtRequestHelper._cookies;
    }

    public void addParameter(String string, String[] stringArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addParameter name = " + string + " [" + this + "]"));
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>(3);
        hashtable.put(string, stringArray);
        this.mergeQueryParams(hashtable);
    }

    public void setMethod(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMethod method = " + string + " [" + this + "]"));
        }
        this._srtRequestHelper._method = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setInputStreamData(HashMap hashMap) throws IOException {
        if (this._srtRequestHelper._gotReader) {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
            Tr.debug((TraceComponent)tc, (String)"attempt to setInputStreamData after it has been read");
            throw new IllegalStateException(nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._setInputDataStreamCalled = true;
        if (hashMap != null) {
            Integer n = (Integer)hashMap.get(INPUT_STREAM_CONTENT_DATA_LENGTH);
            if (n == null) {
                if (!tc.isDebugEnabled()) throw new IllegalStateException();
                Tr.debug((TraceComponent)tc, (String)"No content length in passed map. Throw IOException");
                throw new IllegalStateException();
            }
            this._setInputStreamContentLength = n;
            this._setInputStreamContentType = (String)hashMap.get(INPUT_STREAM_CONTENT_TYPE);
            byte[] byArray = (byte[])hashMap.get(INPUT_STREAM_CONTENT_DATA);
            if (byArray == null) return;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SetInputStreamData Content Type = " + this._setInputStreamContentType + ", " + "contentLength = " + this._setInputStreamContentLength + ", data length = " + byArray.length + " : this = " + this));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                this._in.init(byteArrayInputStream);
                if (byArray.length <= 0) return;
                this._in.setContentLength(byArray.length);
                return;
            }
            catch (IOException iOException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw iOException;
                Tr.debug((TraceComponent)tc, (String)("SetInputStream exception caught : " + iOException));
                throw iOException;
            }
        } else {
            if (!tc.isDebugEnabled()) throw new IllegalArgumentException();
            Tr.debug((TraceComponent)tc, (String)"No map passed as input");
            throw new IllegalArgumentException();
        }
    }

    public HashMap getInputStreamData() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInputStreamData() [" + this + "]"));
        }
        ServletInputStream servletInputStream = this.getInputStream();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.getContentType() != null) {
            hashMap.put(INPUT_STREAM_CONTENT_TYPE, new String(this.getContentType()));
        } else {
            hashMap.put(INPUT_STREAM_CONTENT_TYPE, null);
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.getContentLength();
        hashMap.put(INPUT_STREAM_CONTENT_DATA_LENGTH, new Integer(n3));
        if (n3 > 0) {
            byte[] byArray = new byte[n3];
            do {
                if ((n2 = servletInputStream.read(byArray, n, n3 - n)) > 0) continue;
                String string = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(string);
            } while (n3 - (n += n2) > 0);
            hashMap.put(INPUT_STREAM_CONTENT_DATA, byArray);
        } else {
            hashMap.put(INPUT_STREAM_CONTENT_DATA, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInputStreamData() ContentType = " + this.getContentType() + ", data length = " + n3));
        }
        return hashMap;
    }

    public void setRawParameters(Hashtable hashtable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRawParameters [" + this + "]"));
        }
        this._srtRequestHelper._parameters = hashtable;
    }

    public Hashtable getRawParameters() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRawParameters [" + this + "]"));
        }
        this.parseParameters();
        return (Hashtable)this._srtRequestHelper._parameters;
    }

    public String getParameter(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getParameter name --> " + string + " [" + this + "]"));
        }
        this.parseParameters();
        String[] stringArray = (String[])this._srtRequestHelper._parameters.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getParameterNames [" + this + "]"));
        }
        this.parseParameters();
        return ((Hashtable)this._srtRequestHelper._parameters).keys();
    }

    public String[] getParameterValues(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getParameterValues [" + this + "]"));
        }
        this.parseParameters();
        String[] stringArray = (String[])this._srtRequestHelper._parameters.get(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getParameterValues name --> " + string));
        }
        return stringArray;
    }

    public String getPathInfo() {
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPathInfo [" + this + "]"));
        }
        if (this._srtRequestHelper._pathInfo == null) {
            string = this.getWebAppDispatcherContext().getPathInfo();
            if (string == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getPathInfo returning null");
                }
                return null;
            }
            this._srtRequestHelper._pathInfo = WebGroup.stripURL(string, false);
        }
        if ((string = this._srtRequestHelper._pathInfo).equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPathInfo path is \"\", returning null");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPathInfo path --> [" + string + "]"));
        }
        return string;
    }

    public String getServletPath() {
        String string = this.getWebAppDispatcherContext().getServletPath();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getServletPath --> path " + string));
        }
        return string;
    }

    public String getPathTranslated() {
        String string = this.getWebAppDispatcherContext().getPathTranslated();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getServletPath --> path " + string));
        }
        return string;
    }

    public String getQueryString() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getQueryString [" + this + "]"));
        }
        if (this._srtRequestHelper._queryString == null && !this._srtRequestHelper._qsSetExplicit) {
            this._srtRequestHelper._queryString = this._request.getQueryString();
        }
        String string = this._srtRequestHelper._queryString;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getQueryString queryString --> " + string));
        }
        return string;
    }

    public void setQueryString(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setQueryString --> queryString " + string + " [" + this + "]"));
        }
        this._srtRequestHelper._qsSetExplicit = true;
        this._srtRequestHelper._queryString = string;
    }

    public String getRealPath(String string) {
        String string2 = this.getWebAppDispatcherContext().getRealPath(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRealPath --> path " + string + " realPath --> " + string2));
        }
        return string2;
    }

    public String getRemoteUser() {
        if (this.getWebAppDispatcherContext().isSecurityEnabledForApplication()) {
            String string = SecurityContext.getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteUser (security enabled)--> user " + string));
            }
            return string;
        }
        String string = this._request.getRemoteUser();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRemoteUser --> user " + string));
        }
        return string;
    }

    public String getRequestedSessionId() {
        String string = this.getWebAppDispatcherContext().getRequestedSessionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRequestedSessionId --> id " + string));
        }
        return string;
    }

    public String getRequestURI() {
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRequestURI [" + this + "]"));
        }
        if (this._srtRequestHelper._requestURI == null) {
            string = this.getEncodedRequestURI();
            if (string == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getRequestURI uri --> null");
                }
                return null;
            }
            this._srtRequestHelper._requestURI = WebGroup.stripURL(string);
        }
        string = this._srtRequestHelper._requestURI;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRequestURI uri --> " + string));
        }
        return string;
    }

    public String getServerName() {
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getServerName [" + this + "]"));
        }
        if ((string = this._request.getServerName()) == null || string.length() == 0) {
            try {
                string = InetAddress.getLocalHost().getHostName();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getServerName: using InetAddress --> " + string));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string.charAt(0) != '[' && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getServerName: serverName --> " + string));
        }
        return string;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getSession --> create " + String.valueOf(bl) + " [" + this + "]"));
        }
        return this._requestContext.getSession(bl, this.getWebAppDispatcherContext().getWebApp());
    }

    public boolean isRequestedSessionIdFromCookie() {
        boolean bl = this.getWebAppDispatcherContext().isRequestedSessionIdFromCookie();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isRequestedSessionIdFromCookie --> " + String.valueOf(bl)));
        }
        return bl;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        boolean bl = this.getWebAppDispatcherContext().isRequestedSessionIdFromURL();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isRequestedSessionIdFromURL --> " + String.valueOf(bl)));
        }
        return bl;
    }

    public boolean isRequestedSessionIdValid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("isRequestedSessionIdValid [" + this + "]"));
        }
        boolean bl = this._requestContext.isRequestedSessionIdValid(this.getWebAppDispatcherContext().getWebApp());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isRequestedSessionIdValid --> " + String.valueOf(bl)));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseParameters() {
        String string;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("parseParameters [" + this + "]"));
        }
        if (this._srtRequestHelper._parameters != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseParameters - no parameters");
            }
            return;
        }
        try {
            this._srtRequestHelper._parameters = new Hashtable();
            string = this.getContentType();
            if (string != null) {
                string = string.toLowerCase();
                Tr.debug((TraceComponent)tc, (String)("Content type:" + string));
                if (string.startsWith("java-internal")) {
                    String[] stringArray = new String[]{string};
                    this._srtRequestHelper._parameters.put(new String("Application specific data. Content-type "), stringArray);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"parseParameters - java-internal");
                    }
                    return;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", (String)"667", (Object)this);
            Tr.info((TraceComponent)tc, (String)"Exception thrown during parsing of parameters", (Object)exception.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseParameters - exception");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Content type is not java-internal");
        }
        if ((string = this.getMethod().toLowerCase()).equals("post")) {
            String string2 = this.getContentType();
            if (string2 != null && string2.startsWith("application/x-www-form-urlencoded")) {
                try {
                    if (this.getContentLength() > 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"parsing post data based upon content length");
                        }
                        this._srtRequestHelper._parameters = RequestUtils.parsePostData(this.getContentLength(), this.getInputStreamInternal(), this.getReaderEncoding());
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"parsing post data based upon input stream (possibly chunked)");
                        }
                        this._srtRequestHelper._parameters = RequestUtils.parsePostData(this.getInputStreamInternal(), this.getReaderEncoding());
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", (String)"765", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"Error.Parsing.Parameters", (Object)iOException);
                }
                finally {
                    this.releaseInputStream();
                }
                if (this._srtRequestHelper._parameters != null) {
                    this.parseQueryStringList();
                }
            }
            if (string2 != null && string2.startsWith("multipart/form-data") && this._srtRequestHelper._parameters != null) {
                this.parseQueryStringList();
            }
            if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                this.parseQueryStringList();
            }
        } else {
            this.parseQueryStringList();
        }
        if (this._srtRequestHelper._parameters == null) {
            this._srtRequestHelper._parameters = new Hashtable();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseParameters");
        }
    }

    private void parseQueryStringList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseQueryStringList");
        }
        Hashtable hashtable = null;
        if (this._srtRequestHelper._queryStringList == null || this._srtRequestHelper._queryStringList.isEmpty()) {
            String string = this.getQueryString();
            if (string != null && string.indexOf("=") != -1) {
                if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                    this._srtRequestHelper._parameters = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding());
                } else {
                    hashtable = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding());
                    this.mergeQueryParams(hashtable);
                }
            }
        } else {
            Iterator iterator = this._srtRequestHelper._queryStringList.iterator();
            QSListItem qSListItem = null;
            while (iterator.hasNext()) {
                qSListItem = (QSListItem)iterator.next();
                String string = qSListItem._qs;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("queryString --> " + string));
                }
                if (qSListItem._qsHashtable != null) {
                    this.mergeQueryParams(qSListItem._qsHashtable);
                    continue;
                }
                if (string == null || string.indexOf(61) == -1) continue;
                if (this._srtRequestHelper._parameters == null || this._srtRequestHelper._parameters.isEmpty()) {
                    qSListItem._qsHashtable = RequestUtils.parseQueryString(string, this.getReaderEncoding());
                    this._srtRequestHelper._parameters = qSListItem._qsHashtable;
                    qSListItem._qs = null;
                    continue;
                }
                qSListItem._qsHashtable = hashtable = RequestUtils.parseQueryString(string, this.getReaderEncoding());
                qSListItem._qs = null;
                this.mergeQueryParams(hashtable);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseQueryStringList");
        }
    }

    private void mergeQueryParams(Hashtable hashtable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mergeQueryParams");
        }
        if (hashtable != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams.size() " + hashtable.size()));
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams " + hashtable));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if (this._srtRequestHelper._parameters != null && this._srtRequestHelper._parameters.containsKey(k)) {
                    int n;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("_paramaters contains key " + k));
                    }
                    String[] stringArray = (String[])this._srtRequestHelper._parameters.get(k);
                    String[] stringArray2 = (String[])hashtable.get(k);
                    String[] stringArray3 = new String[stringArray.length + stringArray2.length];
                    int n2 = 0;
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray3[n2++] = stringArray2[n];
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray3[n2++] = stringArray[n];
                    }
                    this._srtRequestHelper._parameters.put(k, stringArray3);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("put key " + k + " into _parameters."));
                    continue;
                }
                if (this._srtRequestHelper._parameters == null) {
                    this._srtRequestHelper._parameters = new Hashtable();
                }
                this._srtRequestHelper._parameters.put(k, hashtable.get(k));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("put key " + k + " into _parameters. "));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeQueryParams");
        }
    }

    private void removeQueryParams(Hashtable hashtable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeQueryParams");
        }
        if (hashtable != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams.size() " + hashtable.size()));
                Tr.debug((TraceComponent)tc, (String)("tmpQueryParams " + hashtable));
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String[] stringArray;
                String[] stringArray2;
                Object k = enumeration.nextElement();
                if (!this._srtRequestHelper._parameters.containsKey(k)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("_paramaters contains key " + k));
                }
                if ((stringArray2 = (String[])this._srtRequestHelper._parameters.get(k)).length - (stringArray = (String[])hashtable.get(k)).length > 0) {
                    String[] stringArray3 = new String[stringArray2.length - stringArray.length];
                    int n = 0;
                    for (int i = stringArray.length; i < stringArray2.length; ++i) {
                        stringArray3[n++] = stringArray2[i];
                    }
                    this._srtRequestHelper._parameters.put(k, stringArray3);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("put key " + k + " into _parameters."));
                    continue;
                }
                this._srtRequestHelper._parameters.remove(k);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeQueryParams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() {
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("finish [" + this + "]"));
            }
            try {
                try {
                    int n = this.getContentLength();
                    if (n > 0) {
                        this._in.close();
                    } else {
                        this._in.finish();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webcontainer.srt.SRTServletRequest.finish", (String)"875", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Error occurred while finishing request", (Object)iOException);
                    }
                    Object var3_4 = null;
                    this._srtRequestHelper = null;
                    this._request.clearHeaders();
                    this._requestContext.finish();
                    if (!this._paramStack.isEmpty()) {
                        this._paramStack.clear();
                    }
                    break block13;
                }
                Object var3_3 = null;
                this._srtRequestHelper = null;
                this._request.clearHeaders();
                this._requestContext.finish();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this._srtRequestHelper = null;
                this._request.clearHeaders();
                this._requestContext.finish();
                if (!this._paramStack.isEmpty()) {
                    this._paramStack.clear();
                }
                throw throwable;
            }
            if (!this._paramStack.isEmpty()) {
                this._paramStack.clear();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"finish");
        }
    }

    protected void processLocales() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processLocales + [" + this + "]"));
        }
        if (this._srtRequestHelper._localesProcessed) {
            return;
        }
        if (this._srtRequestHelper._locales == null) {
            this._srtRequestHelper._locales = new LinkedList();
        }
        this.setLocales(EncodingUtils.getLocales(this).iterator());
        this._srtRequestHelper._localesProcessed = true;
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRequestDispatcher path --> " + string + " [" + this + "]"));
        }
        return this.getWebAppDispatcherContext().getRequestDispatcher(string);
    }

    public String getContextPath() {
        String string = this.getWebAppDispatcherContext().getContextPath();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getContextPath path --> " + string));
        }
        return string;
    }

    public boolean isUserInRole(String string) {
        boolean bl = this.getWebAppDispatcherContext().isUserInRole(string, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isUserInRole role --> " + string + " result --> " + String.valueOf(bl)));
        }
        return bl;
    }

    public Principal getUserPrincipal() {
        Principal principal = this.getWebAppDispatcherContext().getUserPrincipal();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUserPrincipal principal --> " + (principal != null ? principal.getName() : "")));
        }
        return principal;
    }

    public void pushParameterStack() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pushParameterStack [" + this + "]"));
        }
        if (this._srtRequestHelper._parameters == null) {
            this._paramStack.push((Object)null);
        } else {
            this._paramStack.push(((Hashtable)this._srtRequestHelper._parameters).clone());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this._srtRequestHelper._parameters != null) {
            this.debugParams(this._srtRequestHelper._parameters);
        }
    }

    public void popParameterStack() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("popParameterStack [" + this + "]"));
            }
            try {
                this._srtRequestHelper._parameters = (Hashtable)this._paramStack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Unable to remove item from stack", (Object)emptyStackException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this._srtRequestHelper._parameters != null) {
            this.debugParams(this._srtRequestHelper._parameters);
        }
    }

    private void debugParams(Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"debugParams");
        }
        if (map != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Only displaying value retrieved by request.getParameter(). More parameters may exist for parameter name");
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.isSecure() || string.toUpperCase().indexOf("PASSWORD") > -1) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("param: paramName --> " + string + " paramValue [**********]"));
                    continue;
                }
                String string2 = this.getParameter(string);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("param: paramName --> " + string + " paramValue --> " + string2));
            }
        }
    }

    public void removeQSFromList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeQSFromList [" + this + "]"));
        }
        if (this._srtRequestHelper._queryStringList != null && !this._srtRequestHelper._queryStringList.isEmpty()) {
            Map map = this._srtRequestHelper._parameters;
            this.popParameterStack();
            if (this._srtRequestHelper._parameters == null && map != null) {
                this._srtRequestHelper._parameters = map;
                Hashtable hashtable = ((QSListItem)((SRTServletRequestHelper)this._srtRequestHelper)._queryStringList.getLast())._qsHashtable;
                if (hashtable == null) {
                    hashtable = RequestUtils.parseQueryString(((QSListItem)((SRTServletRequestHelper)this._srtRequestHelper)._queryStringList.getLast())._qs, this.getReaderEncoding());
                }
                this.removeQueryParams(hashtable);
            }
            this._srtRequestHelper._queryStringList.removeLast();
        } else {
            this.popParameterStack();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeQSFromList");
        }
    }

    public void aggregateQueryStringParams(String string, boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("aggregateQueryStringParams qs --> " + string + " set --> " + String.valueOf(bl) + " [" + this + "]"));
        }
        QSListItem qSListItem = null;
        if (this._srtRequestHelper._parameters == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The paramater stack is currently null");
            }
            if (this._srtRequestHelper._queryStringList == null || this._srtRequestHelper._queryStringList.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The queryStringList is empty");
                }
                if (this._srtRequestHelper._queryStringList == null) {
                    this._srtRequestHelper._queryStringList = new LinkedList();
                }
                if (this.getQueryString() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getQueryString will be added first in the QSList wih value->" + this.getQueryString()));
                    }
                    qSListItem = new QSListItem(this.getQueryString(), null);
                    this._srtRequestHelper._queryStringList.add(qSListItem);
                }
            }
            if (string != null) {
                qSListItem = new QSListItem(string, null);
                this._srtRequestHelper._queryStringList.add(qSListItem);
            }
        }
        if (bl) {
            this.setQueryString(string);
        }
        if (this._srtRequestHelper._parameters != null && string != null) {
            Hashtable hashtable = RequestUtils.parseQueryString(string, this.getReaderEncoding());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string2);
                if (this._srtRequestHelper._parameters.containsKey(string2)) {
                    int n;
                    String[] stringArray2 = (String[])this._srtRequestHelper._parameters.get(string2);
                    Vector<String> vector = new Vector<String>();
                    for (n = 0; n < stringArray.length; ++n) {
                        vector.add(stringArray[n]);
                    }
                    for (n = 0; n < stringArray2.length; ++n) {
                        vector.add(stringArray2[n]);
                    }
                    String[] stringArray3 = new String[vector.size()];
                    vector.toArray(stringArray3);
                    this._srtRequestHelper._parameters.put(string2, stringArray3);
                    continue;
                }
                this._srtRequestHelper._parameters.put(string2, stringArray);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"aggregateQueryStringParams");
        }
    }

    public Map getParameterMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getParameterMap [" + this + "]"));
        }
        this.parseParameters();
        return this._srtRequestHelper._parameters;
    }

    public StringBuffer getRequestURL() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getRequestURL [" + this + "]"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getScheme();
        int n = this.getServerPort();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(this.getServerName());
        if (string.equals("http") && n != 80 || string.equals("https") && n != 443) {
            stringBuffer.append(':');
            stringBuffer.append(this.getServerPort());
        }
        stringBuffer.append(this.getEncodedRequestURI());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getRequestURL url --> " + stringBuffer));
        }
        return stringBuffer;
    }

    public byte[] getSSLId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSSLId [" + this + "]"));
        }
        byte[] byArray = this._request.getSSLSessionID();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSSLId id --> " + (byArray != null ? new String(byArray) : "")));
        }
        return byArray;
    }

    public byte[] getCookieValueAsBytes(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCookieValueAsBytes [" + this + "]"));
        }
        byte[] byArray = this._request.getCookieValue(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCookieValueAsBytes name --> " + string + " value --> " + (byArray != null ? new String(byArray) : "")));
        }
        return byArray;
    }

    public List getAllCookieValues(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAllCookieValues [" + this + "]"));
        }
        List list = this._request.getAllCookieValues(string);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAllCookieValues name --> " + string + " values --> " + list));
        }
        return list;
    }

    public String getUpdatedSessionId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getUpdatedSessionId [" + this + "]"));
        }
        String string = this._srtRequestHelper._updatedSessionId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getUpdatedSessionId id --> " + string));
        }
        return string;
    }

    public void setSessionId(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSessionId id --> " + string + " [" + this + "]"));
        }
        this._srtRequestHelper._updatedSessionId = string;
    }

    public String getEncodedRequestURI() {
        String string = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncodedRequestURI [" + this + "]"));
        }
        string = this._dispatchContext == null ? this._request.getRequestURI() : this._dispatchContext.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncodedRequestURI uri --> " + string));
        }
        return string;
    }

    public SRTRequestContext getRequestContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRequestContext [" + this + "]"));
        }
        return this._requestContext;
    }

    public boolean getRunningCollaborators() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRunningCollaborators value --> " + String.valueOf(this._runningCollaborators) + " [" + this + "]"));
        }
        return this._runningCollaborators;
    }

    public void setRunningCollaborators(boolean bl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRunningCollaborators value --> " + String.valueOf(this._runningCollaborators) + " [" + this + "]"));
        }
        this._runningCollaborators = bl;
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroy [" + this + "]"));
        }
        this._requestContext.destroy();
        this._requestContext = null;
        this._connContext = null;
        this._dispatchContext = null;
        this._srtRequestHelper = null;
        this._paramStack = null;
        this._in = null;
        this._setInputStreamContentType = null;
        this._setInputStreamContentLength = -1;
        this._setInputDataStreamCalled = false;
        if (this._request instanceof IPoolable) {
            ((IPoolable)((Object)this._request)).destroy();
        }
        this._request = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    protected WSServletInputStream createInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createInputStream entry  [" + this + "]"));
        }
        return new HttpInputStream();
    }

    static {
        suppressHeadersInRequest = null;
        suppressheadersList = null;
        CLIENT_ENCODING_OVERRIDE = System.getProperty("client.encoding.override");
        DEFAULT_CLIENT_ENCODING = System.getProperty("default.client.encoding");
        suppressHeadersInRequest = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.suppressheadersinrequest");
        if (suppressHeadersInRequest != null) {
            String string = ",";
            suppressheadersList = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(suppressHeadersInRequest, string);
            while (stringTokenizer.hasMoreTokens()) {
                suppressheadersList.add(stringTokenizer.nextToken().trim());
            }
        }
    }

    class QSListItem {
        String _qs = null;
        Hashtable _qsHashtable = null;

        QSListItem(String string, Hashtable hashtable) {
            this._qs = string;
            this._qsHashtable = hashtable;
        }
    }

    private class SRTServletRequestHelper
    implements Cloneable {
        private Hashtable _privateAttributes = null;
        private LinkedList _queryStringList = null;
        private Map _attributes = new HashMap();
        private Map _parameters = null;
        private String _queryString = null;
        private boolean _cookiesParsed = false;
        private String _updatedSessionId;
        private Cookie[] _cookies;
        private boolean _localesProcessed = false;
        private String _readerEncoding = null;
        private String _characterEncoding = null;
        private boolean _qsSetExplicit = false;
        private boolean _gotReader = false;
        private boolean _gotInputStream = false;
        private boolean _InputStreamClosed = false;
        private String _requestURI = null;
        private String _pathInfo = null;
        private String _method = null;
        private BufferedReader _reader = null;
        private LinkedList _locales = null;

        private SRTServletRequestHelper() {
        }

        protected Object clone() throws CloneNotSupportedException {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SRTRequestHelper.clone entry");
            }
            SRTServletRequestHelper sRTServletRequestHelper = null;
            sRTServletRequestHelper = (SRTServletRequestHelper)super.clone();
            if (this._privateAttributes != null) {
                sRTServletRequestHelper._privateAttributes = (Hashtable)this._privateAttributes.clone();
            }
            if (this._queryStringList != null) {
                sRTServletRequestHelper._queryStringList = (LinkedList)this._queryStringList.clone();
            }
            if (this._parameters != null) {
                sRTServletRequestHelper._parameters = (Hashtable)((Hashtable)this._parameters).clone();
            }
            if (this._attributes != null) {
                sRTServletRequestHelper._attributes = (HashMap)((HashMap)this._attributes).clone();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SRTRequestHelper.clone original -->" + this + " cloned -->" + sRTServletRequestHelper));
            }
            return sRTServletRequestHelper;
        }

        static /* synthetic */ Cookie[] access$1502(SRTServletRequestHelper sRTServletRequestHelper, Cookie[] cookieArray) {
            sRTServletRequestHelper._cookies = cookieArray;
            return cookieArray;
        }
    }
}

