/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.http.Ascii;
import java.io.IOException;
import java.io.OutputStream;

public class HttpDate
extends Ascii {
    protected int sec;
    protected int min;
    protected int hour;
    protected int mday;
    protected int mon;
    protected int year;
    protected int wday;
    protected static final byte[][] days = new byte[][]{HttpDate.toBytes("Sunday"), HttpDate.toBytes("Monday"), HttpDate.toBytes("Tuesday"), HttpDate.toBytes("Wednesday"), HttpDate.toBytes("Thursday"), HttpDate.toBytes("Friday"), HttpDate.toBytes("Saturday")};
    protected static final byte[][] months = new byte[][]{HttpDate.toBytes("Jan"), HttpDate.toBytes("Feb"), HttpDate.toBytes("Mar"), HttpDate.toBytes("Apr"), HttpDate.toBytes("May"), HttpDate.toBytes("Jun"), HttpDate.toBytes("Jul"), HttpDate.toBytes("Aug"), HttpDate.toBytes("Sep"), HttpDate.toBytes("Oct"), HttpDate.toBytes("Nov"), HttpDate.toBytes("Dec")};
    protected static byte[] daysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static byte[] daysInMonthLeap = new byte[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static short[] daysBeforeMonth = new short[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    protected static short[] daysBeforeMonthLeap = new short[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final String DATESTR = "Sun, 06 Nov 1994 08:49:37 GMT";
    public static final int DATELEN = "Sun, 06 Nov 1994 08:49:37 GMT".length();
    protected static final int DAYS_PER_YEAR = 365;
    protected static final int DAYS_PER_LEAP = 1461;
    protected static final int SECS_PER_MIN = 60;
    protected static final int SECS_PER_HOUR = 3600;
    protected static final int SECS_PER_DAY = 86400;
    protected static final int BASE_DAY_OF_WEEK = 4;

    public HttpDate() {
    }

    public HttpDate(long l) {
        this.setTime(l);
    }

    protected static int daysBeforeMonth(int n, int n2) {
        return HttpDate.isLeapYear(n2) ? daysBeforeMonthLeap[n] : daysBeforeMonth[n];
    }

    protected static int daysInMonth(int n, int n2) {
        return HttpDate.isLeapYear(n2) ? daysInMonthLeap[n] : daysInMonth[n];
    }

    public int getBytes(byte[] byArray, int n, int n2) {
        if (n2 < DATELEN) {
            throw new IllegalArgumentException("array too small");
        }
        byte[] byArray2 = days[this.wday];
        byArray[n++] = byArray2[0];
        byArray[n++] = byArray2[1];
        byArray[n++] = byArray2[2];
        byArray[n++] = 44;
        byArray[n++] = 32;
        byArray[n++] = (byte)(48 + this.mday / 10);
        byArray[n++] = (byte)(48 + this.mday % 10);
        byArray[n++] = 32;
        byArray2 = months[this.mon];
        byArray[n++] = byArray2[0];
        byArray[n++] = byArray2[1];
        byArray[n++] = byArray2[2];
        byArray[n++] = 32;
        int n3 = this.year + 1900;
        byArray[n++] = (byte)(48 + n3 / 1000);
        byArray[n++] = (byte)(48 + (n3 %= 1000) / 100);
        byArray[n++] = (byte)(48 + (n3 %= 100) / 10);
        byArray[n++] = (byte)(48 + n3 % 10);
        byArray[n++] = 32;
        byArray[n++] = (byte)(48 + this.hour / 10);
        byArray[n++] = (byte)(48 + this.hour % 10);
        byArray[n++] = 58;
        byArray[n++] = (byte)(48 + this.min / 10);
        byArray[n++] = (byte)(48 + this.min % 10);
        byArray[n++] = 58;
        byArray[n++] = (byte)(48 + this.sec / 10);
        byArray[n++] = (byte)(48 + this.sec % 10);
        byArray[n++] = 32;
        byArray[n++] = 71;
        byArray[n++] = 77;
        byArray[n] = 84;
        return DATELEN;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public long getTime() {
        int n = this.year;
        int n2 = (n - 70) * 365;
        n2 += (n - 69) / 4;
        n2 -= (n - 1) / 100;
        n2 += (n + 299) / 400;
        return (long)(this.sec + 60 * (this.min + 60 * (this.hour + 24 * (n2 += HttpDate.daysBeforeMonth(this.mon, n) + this.mday - 1)))) * 1000L;
    }

    protected static boolean isLeapYear(int n) {
        return (n & 3) == 0 && (n % 100 != 0 || (n + 300) % 400 != 0);
    }

    public void parse(byte[] byArray, int n, int n2) {
        try {
            byte by;
            int n3 = n + n2;
            n = this.parseDay(byArray, n);
            while (HttpDate.isWhite(by = byArray[n++])) {
            }
            if (HttpDate.isDigit(by)) {
                int n4 = by - 48;
                while (HttpDate.isDigit(by = byArray[n++])) {
                    n4 = n4 * 10 + by - 48;
                }
                this.mday = n4;
                if (HttpDate.isWhite(by)) {
                    while (HttpDate.isWhite(by = byArray[n++])) {
                    }
                } else if (by == 45) {
                    by = byArray[n++];
                } else {
                    throw new IllegalArgumentException();
                }
                n = this.parseMonth(by, byArray, n);
                if (HttpDate.isWhite(by = byArray[n++])) {
                    while (HttpDate.isWhite(by = byArray[n++])) {
                    }
                } else if (by == 45) {
                    by = byArray[n++];
                } else {
                    throw new IllegalArgumentException();
                }
                if (!HttpDate.isDigit(by)) {
                    throw new IllegalArgumentException();
                }
                n4 = by - 48;
                while (HttpDate.isDigit(by = byArray[n++])) {
                    n4 = n4 * 10 + by - 48;
                }
                if (n4 < 100) {
                    n4 += 1900;
                }
                if (this.mday > HttpDate.daysInMonth(this.mon, n4)) {
                    throw new IllegalArgumentException();
                }
                this.year = n4 - 1900;
                n = this.parseTime(byArray, n);
                while (HttpDate.isWhite(by = byArray[n++])) {
                }
                if (HttpDate.toLower(by) != 103 || HttpDate.toLower(byArray[n++]) != 109 || HttpDate.toLower(byArray[n++]) != 116) {
                    throw new IllegalArgumentException();
                }
            } else {
                n = this.parseMonth(by, byArray, n);
                if (!HttpDate.isWhite(by = byArray[n++])) {
                    throw new IllegalArgumentException();
                }
                while (HttpDate.isWhite(by = byArray[n++])) {
                }
                if (!HttpDate.isDigit(by)) {
                    throw new IllegalArgumentException();
                }
                int n5 = by - 48;
                while (HttpDate.isDigit(by = byArray[n++])) {
                    n5 = n5 * 10 + by - 48;
                }
                this.mday = n5;
                n = this.parseTime(byArray, n);
                while (HttpDate.isWhite(by = byArray[n++])) {
                }
                n5 = by - 48;
                while (n < n3 && HttpDate.isDigit(by = byArray[n++])) {
                    n5 = n5 * 10 + by - 48;
                }
                if (n5 < 1900 || this.mday > HttpDate.daysInMonth(this.mon, n5)) {
                    throw new IllegalArgumentException();
                }
                this.year = n5 - 1900;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            FFDCFilter.processException((Throwable)arrayIndexOutOfBoundsException, (String)"com.ibm.ws.webcontainer.srt.http.HttpDate.parse", (String)"345", (Object)this);
            throw new IllegalArgumentException();
        }
    }

    public void parse(String string) {
        byte[] byArray = HttpDate.toBytes(string);
        this.parse(byArray, 0, byArray.length);
    }

    private int parseDay(byte[] byArray, int n) {
        byte by;
        while (HttpDate.isWhite(by = byArray[n++])) {
        }
        int n2 = HttpDate.toLower(by);
        n2 = n2 << 8 | HttpDate.toLower(byArray[n++]);
        n2 = n2 << 8 | HttpDate.toLower(byArray[n++]);
        switch (n2) {
            case 7566702: {
                this.wday = 0;
                break;
            }
            case 7171950: {
                this.wday = 1;
                break;
            }
            case 7632229: {
                this.wday = 2;
                break;
            }
            case 7824740: {
                this.wday = 3;
                break;
            }
            case 7628917: {
                this.wday = 4;
                break;
            }
            case 6713961: {
                this.wday = 5;
                break;
            }
            case 7561588: {
                this.wday = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        by = byArray[n++];
        if (HttpDate.isAlpha(by)) {
            byte[] byArray2 = days[this.wday];
            int n3 = byArray2.length;
            for (int i = 3; i < n3; ++i) {
                if (HttpDate.toLower(by) != byArray2[i]) {
                    throw new IllegalArgumentException();
                }
                by = byArray[n++];
            }
        }
        if (!HttpDate.isWhite(by) && by != 44) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    private int parseMonth(int n, byte[] byArray, int n2) {
        int n3 = HttpDate.toLower(n);
        n3 = n3 << 8 | HttpDate.toLower(byArray[n2++]);
        n3 = n3 << 8 | HttpDate.toLower(byArray[n2++]);
        switch (n3) {
            case 6971758: {
                this.mon = 0;
                break;
            }
            case 0x666562: {
                this.mon = 1;
                break;
            }
            case 7168370: {
                this.mon = 2;
                break;
            }
            case 6385778: {
                this.mon = 3;
                break;
            }
            case 7168377: {
                this.mon = 4;
                break;
            }
            case 6976878: {
                this.mon = 5;
                break;
            }
            case 6976876: {
                this.mon = 6;
                break;
            }
            case 6387047: {
                this.mon = 7;
                break;
            }
            case 7562608: {
                this.mon = 8;
                break;
            }
            case 7299956: {
                this.mon = 9;
                break;
            }
            case 7237494: {
                this.mon = 10;
                break;
            }
            case 6579555: {
                this.mon = 11;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n2;
    }

    private int parseTime(byte[] byArray, int n) {
        byte by;
        while (HttpDate.isWhite(by = byArray[n++])) {
        }
        if (HttpDate.isDigit(by)) {
            int n2 = by - 48;
            while (HttpDate.isDigit(by = byArray[n++])) {
                n2 = n2 * 10 + by - 48;
            }
            if (n2 < 24 && by == 58 && HttpDate.isDigit(by = byArray[n++])) {
                this.hour = n2;
                n2 = by - 48;
                while (HttpDate.isDigit(by = byArray[n++])) {
                    n2 = n2 * 10 + by - 48;
                }
                if (n2 < 60 && by == 58 && HttpDate.isDigit(by = byArray[n++])) {
                    this.min = n2;
                    n2 = by - 48;
                    while (HttpDate.isDigit(by = byArray[n++])) {
                        n2 = n2 * 10 + by - 48;
                    }
                    if (n2 < 60 && by == 32) {
                        this.sec = n2;
                        return n;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public void setTime() {
        this.setTime(HttpDate.getCurrentTime());
    }

    public void setTime(long l) {
        int n = (int)(l / 1000L);
        int n2 = n / 86400;
        this.hour = (n -= n2 * 86400) / 3600;
        this.min = (n -= this.hour * 3600) / 60;
        this.sec = n - this.min * 60;
        this.wday = (n2 + 4) % 7;
        int n3 = n2 / 1461;
        boolean bl = false;
        int n4 = n3 * 4 + 70;
        if ((n2 -= n3 * 1461) >= 365) {
            ++n4;
            if ((n2 -= 365) >= 365) {
                ++n4;
                if ((n2 -= 365) >= 366) {
                    ++n4;
                    n2 -= 366;
                } else {
                    bl = true;
                }
            }
        }
        this.year = n4;
        short[] sArray = bl ? daysBeforeMonthLeap : daysBeforeMonth;
        int n5 = 1;
        while (sArray[n5] <= n2) {
            ++n5;
        }
        this.mon = --n5;
        this.mday = n2 - sArray[n5] + 1;
    }

    protected static byte[] toBytes(String string) {
        byte[] byArray = string.getBytes();
        return byArray;
    }

    public String toString() {
        byte[] byArray = new byte[DATELEN];
        return new String(byArray, 0, 0, this.getBytes(byArray, 0, byArray.length));
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[DATELEN];
        outputStream.write(byArray, 0, this.getBytes(byArray, 0, byArray.length));
    }

    public void reset() {
        this.sec = 0;
        this.min = 0;
        this.hour = 0;
        this.mday = 0;
        this.mon = 0;
        this.year = 0;
        this.wday = 0;
    }
}

