/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.webcontainer.util.IInputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpInputStream
extends WSServletInputStream {
    protected InputStream in;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected long total;
    protected long limit;
    protected int length;
    private static TraceComponent tc = Tr.register((Class)HttpInputStream.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private IInputStreamObserver obs;

    public HttpInputStream(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Constructor --> " + n));
        }
        this.buf = new byte[n];
    }

    public HttpInputStream() {
        this(512);
    }

    public void init(InputStream inputStream) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init");
        }
        this.in = inputStream;
        this.next();
        this.obs = null;
    }

    public void next() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"next");
        }
        this.length = -1;
        this.limit = Long.MAX_VALUE;
        this.total = 0L;
        this.count = 0;
        this.pos = 0;
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finish");
        }
        if (!SRTServletResponse.isSkipInputStreamRead() && this.length != -1) {
            long l;
            for (long i = this.limit - this.total; i > 0L; i -= l) {
                l = this.skip(i);
                if (l != 0L) continue;
                throw new IOException(nls.getString("Invalid.Content.Length", "Invalid content length"));
            }
        }
    }

    public void resets() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"resets");
        }
        this.in = null;
    }

    public long getTotal() {
        return this.total;
    }

    public void setContentLength(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setContentLength --> " + n));
        }
        if (n < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid Content Length");
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.Content.Length", "Illegal Argument: Invalid Content Length"));
        }
        this.length = n;
        if (Long.MAX_VALUE - this.total > (long)n) {
            this.limit = this.total + (long)n;
        }
    }

    public int getContentLength() {
        return this.length;
    }

    public int read() throws IOException {
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Over the limit: -1");
            }
            return -1;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.pos + " >= " + this.count + " : -1"));
                }
                return -1;
            }
        }
        ++this.total;
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("read length -->" + n2));
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read byte[] over the limit: -1");
            }
            return -1;
        }
        int n3 = this.count - this.pos;
        if (n3 > 0) {
            if (n3 >= n2) {
                System.arraycopy(this.buf, this.pos, byArray, n, n2);
                this.pos += n2;
                this.total += (long)n2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("read returning -->" + n2));
                }
                return n2;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n3);
            this.pos = 0;
            this.count = 0;
            n += n3;
            n2 -= n3;
        }
        int n4 = n3;
        int n5 = 0;
        if (n2 > 0) {
            n5 = this.in.read(byArray, n, n2);
        }
        if (n5 > 0) {
            n4 += n5;
        }
        this.total += (long)n4;
        if (n4 == 0) {
            n4 = -1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("read returning -->" + n4));
        }
        return n4;
    }

    public int readLine(byte[] byArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"readLine");
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readLine Over the limit: -1");
            }
            return -1;
        }
        int n3 = 0;
        n3 = n2;
        int n4 = this.count - this.pos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"readLine avail less than 0: -1");
                }
                return -1;
            }
        }
        int n5 = n4 < n2 ? n4 : n2;
        int n6 = HttpInputStream.copyLine(this.buf, this.pos, byArray, n, n5);
        this.pos += n6;
        this.total += (long)n6;
        n3 -= n6;
        int n7 = n6;
        if (n7 == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readLine totalRead is 0: -1");
            }
            return -1;
        }
        while (n3 > 0 && byArray[n + n7 - 1] != 10) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLine returning --> " + n7));
                }
                return n7;
            }
            n5 = n4 < n3 ? n4 : n3;
            n6 = HttpInputStream.copyLine(this.buf, this.pos, byArray, n + n7, n5);
            this.pos += n6;
            this.total += (long)n6;
            n3 -= n6;
            n7 += n6;
        }
        return n7;
    }

    private static int copyLine(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"copyLine");
        }
        int n4 = n;
        while (n3-- > 0 && byArray[n4++] != 10) {
        }
        System.arraycopy(byArray, n, byArray2, n2, n4 - n);
        return n4 - n;
    }

    public long skip(long l) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"skip");
        }
        if (this.total >= this.limit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Total over limit: 0");
            }
            return 0L;
        }
        long l2 = l;
        while (l2 > 0L) {
            int n = this.count - this.pos;
            if (n <= 0) {
                this.fill();
                n = this.count - this.pos;
                if (n <= 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("skip avail < 0: " + (l - l2)));
                    }
                    return l - l2;
                }
            }
            if (l2 < (long)n) {
                n = (int)l2;
            }
            l2 -= (long)n;
            this.pos += n;
            this.total += (long)n;
        }
        return l;
    }

    public int available() throws IOException {
        long l = this.limit - this.total;
        if (l > Integer.MAX_VALUE) {
            return this.count - this.pos + this.in.available();
        }
        return Math.min(this.count - this.pos + this.in.available(), (int)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            this.finish();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.in.close();
            if (this.obs != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"close", (Object)"Notify observer that input stream has been closed.");
                }
                this.obs.alertClose();
                this.total = this.limit;
            }
            throw throwable;
        }
        this.in.close();
        if (this.obs != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"close", (Object)"Notify observer that input stream has been closed.");
            }
            this.obs.alertClose();
            this.total = this.limit;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close", (Object)("total=" + this.total + ",limit=" + this.limit));
        }
    }

    protected void fill() throws IOException {
        long l;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"fill");
        }
        int n = (l = this.limit - this.total) > Integer.MAX_VALUE ? this.buf.length : Math.min(this.buf.length, (int)l);
        if (n > 0 && (n = this.in.read(this.buf, 0, n)) > 0) {
            this.pos = 0;
            this.count = n;
        }
    }

    public void restart() {
        if (TraceComponent.isAnyTracingEnabled() & tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"restart", (Object)"Start re-read of data");
        }
        this.total = 0L;
        this.count = 0;
        this.pos = 0;
        if (this.obs != null) {
            this.obs.alertOpen();
        }
    }

    public void setObserver(IInputStreamObserver iInputStreamObserver) {
        this.obs = iInputStreamObserver;
    }
}

