/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ws.webcontainer.util.HashtableEntry;
import com.ibm.ws.webcontainer.util.SimpleHashtableEnumerator;
import com.ibm.ws.webcontainer.util.objectpool.IPoolable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class SimpleHashtable
extends Dictionary
implements Cloneable,
IPoolable {
    private transient HashtableEntry[] table;
    private transient int count;
    private float loadFactor = 0.75f;
    private transient int modCount = 0;
    private int threshold;

    public SimpleHashtable(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.table = new HashtableEntry[n];
        this.threshold = (int)((float)n * this.loadFactor);
    }

    public SimpleHashtable() {
        this(127);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new SimpleHashtableEnumerator(this.table, true);
    }

    public synchronized Enumeration elements() {
        return new SimpleHashtableEnumerator(this.table, false);
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = hashtableEntryArray.length;
        while (n-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n];
            while (hashtableEntry != null) {
                if (hashtableEntry.value.equals(object)) {
                    return true;
                }
                hashtableEntry = hashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return true;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return false;
    }

    public synchronized Set keySet() {
        HashSet hashSet = new HashSet(this.size());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public Object get(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                return hashtableEntry.value;
            }
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                Object object3 = hashtableEntry.value;
                hashtableEntry.value = object2;
                return object3;
            }
            hashtableEntry = hashtableEntry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            hashtableEntryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        }
        hashtableEntry = new HashtableEntry();
        hashtableEntry.hash = n;
        hashtableEntry.key = object;
        hashtableEntry.value = object2;
        hashtableEntry.next = hashtableEntryArray[n2];
        hashtableEntryArray[n2] = hashtableEntry;
        ++this.count;
        return null;
    }

    public synchronized Object remove(Object object) {
        HashtableEntry[] hashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % hashtableEntryArray.length;
        HashtableEntry hashtableEntry = hashtableEntryArray[n2];
        HashtableEntry hashtableEntry2 = null;
        while (hashtableEntry != null) {
            if (hashtableEntry.hash == n && hashtableEntry.key.equals(object)) {
                if (hashtableEntry2 != null) {
                    hashtableEntry2.next = hashtableEntry.next;
                } else {
                    hashtableEntryArray[n2] = hashtableEntry.next;
                }
                --this.count;
                return hashtableEntry.value;
            }
            hashtableEntry2 = hashtableEntry;
            hashtableEntry = hashtableEntry.next;
        }
        return null;
    }

    public synchronized void clear() {
        if (this.count > 0) {
            HashtableEntry[] hashtableEntryArray = this.table;
            int n = hashtableEntryArray.length;
            while (--n >= 0) {
                hashtableEntryArray[n] = null;
            }
            this.count = 0;
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void resetObject() {
        this.clear();
    }

    protected void rehash() {
        int n = this.table.length;
        HashtableEntry[] hashtableEntryArray = this.table;
        int n2 = n * 2 + 1;
        HashtableEntry[] hashtableEntryArray2 = new HashtableEntry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = hashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            HashtableEntry hashtableEntry = hashtableEntryArray[n3];
            while (hashtableEntry != null) {
                HashtableEntry hashtableEntry2 = hashtableEntry;
                hashtableEntry = hashtableEntry.next;
                int n4 = (hashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                hashtableEntry2.next = hashtableEntryArray2[n4];
                hashtableEntryArray2[n4] = hashtableEntry2;
            }
        }
    }
}

