/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util.objectpool;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.util.objectpool.IObjectPool;
import com.ibm.ws.webcontainer.util.objectpool.IPoolable;
import com.ibm.ws.webcontainer.util.objectpool.ObjectPoolException;

public class ObjectPool
implements IObjectPool {
    protected Object[] m_objects;
    protected Class m_class;
    protected int m_head;
    protected boolean m_createObj;
    private static TraceComponent tc = Tr.register((String)ObjectPool.class.getName(), (String)"Servlet_Engine");
    private static NLS nls = new NLS("com.ibm.servlet.resources.ServletEngineNLS");

    public ObjectPool(Class clazz, int n, boolean bl) throws IllegalArgumentException {
        this(clazz, n);
        this.m_createObj = bl;
    }

    public ObjectPool(Class clazz, int n) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)clazz);
        }
        if (null == clazz || n <= 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid ObjectPool Instantiated.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Constructor", (Object)clazz);
            }
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.ObjectPool.Instantiated", "Illegal Argument: Invalid ObjectPool Instantiated."));
        }
        if (!IPoolable.class.isAssignableFrom(clazz)) {
            Tr.error((TraceComponent)tc, (String)"Class Cast Exception: Input class does not implement IPoolable.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Constructor", (Object)clazz);
            }
            throw new ClassCastException(nls.getString("Class.Cast.Exception.Input.class.not.IPoolable", "Class Cast Exception: Input class does not implement IPoolable."));
        }
        this.m_head = 0;
        this.m_class = clazz;
        this.m_objects = new Object[n];
        this.m_createObj = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor", (Object)clazz);
        }
    }

    public ObjectPool(Class clazz) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Constructor", (Object)clazz);
        }
        if (null == clazz) {
            Tr.error((TraceComponent)tc, (String)"Illegal Argument: Invalid ObjectPool Instantiated.");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"Constructor", (Object)clazz);
            }
            throw new IllegalArgumentException(nls.getString("Illegal.Argument.Invalid.ObjectPool.Instantiated", "Illegal Argument: Invalid ObjectPool Instantiated."));
        }
        this.m_head = 0;
        this.m_class = clazz;
        this.m_objects = new Object[10];
        this.m_createObj = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectFromPool() throws ObjectPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getObjectFromPool");
        }
        Object object = null;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.m_head > 0) {
                --this.m_head;
                object = this.m_objects[this.m_head];
                this.m_objects[this.m_head] = null;
            } else {
                try {
                    if (this.m_createObj) {
                        object = this.m_class.newInstance();
                    }
                }
                catch (InstantiationException instantiationException) {
                    FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.webcontainer.util.objectpool.ObjectPool.getObjectFromPool", (String)"111", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"Object Pool Exception: Class could not be instantiated.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getObjectFromPool");
                    }
                    throw new ObjectPoolException(nls.getString("Object.Pool.Exception.Class.could.not.be.instantiated", "Object Pool Exception: Class could not be instantiated."));
                }
                catch (IllegalAccessException illegalAccessException) {
                    FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.webcontainer.util.objectpool.ObjectPool.getObjectFromPool", (String)"118", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"Object Pool Exception: Class not accessible to instantiate.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getObjectFromPool");
                    }
                    throw new ObjectPoolException(nls.getString("Object.Pool.Exception.Class.not.accessible.to.instantiate", "Object Pool Exception: Class not accessible to instantiate."));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getObjectFromPool");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObjectToPool(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"returnObjectToPool", (Object)object);
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            ((IPoolable)object).resetObject();
            if (this.m_objects.length > this.m_head) {
                this.m_objects[this.m_head] = object;
                ++this.m_head;
            } else if (this.m_createObj) {
                this.expandObjectPool();
                this.m_objects[this.m_head] = object;
                ++this.m_head;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"returnObjectToPool");
        }
    }

    public synchronized void expandObjectPool() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expandObjectPool");
        }
        Object[] objectArray = this.m_objects;
        Object[] objectArray2 = new Object[this.m_objects.length * 2];
        System.arraycopy(this.m_objects, 0, objectArray2, 0, this.m_objects.length);
        this.m_objects = objectArray2;
        objectArray = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"expandObjectPool");
        }
    }

    public synchronized int size() {
        return this.m_objects.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Object pool for ");
        stringBuffer.append(this.m_class).append(" with a size of ").append(this.m_objects.length).append(" and current head of ").append(this.m_head).append("\n");
        for (int i = 0; i < this.m_objects.length; ++i) {
            stringBuffer.append("pooled object index : ").append(i).append("\n").append(" value : ").append(this.m_objects[i]);
        }
        return stringBuffer.toString();
    }
}

