/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.asynchbeans.pool.ObjectPool;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.servlet.response.ResponseUtils;
import com.ibm.ws.container.Container;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.localhttp.channel.LocalInboundChainFactory;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.runtime.component.ThreadContextHelper;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.web.WebSecurityCollaborator;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.ReaperAlarmListener;
import com.ibm.ws.webcontainer.VirtualHostConfiguration;
import com.ibm.ws.webcontainer.VirtualHostConfigurationHelper;
import com.ibm.ws.webcontainer.WebContainerConfiguration;
import com.ibm.ws.webcontainer.WebContainerWorkloadRegulator;
import com.ibm.ws.webcontainer.cache.CacheManager;
import com.ibm.ws.webcontainer.collaborator.ConnectionHandleCollaborator;
import com.ibm.ws.webcontainer.component.ComponentUtil;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.exception.WebGroupVHostNotFoundException;
import com.ibm.ws.webcontainer.extension.ExtHandshakeVHostExtensionFactory;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.objectpool.ObjectPoolFactory;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.webcontainer.servlet.ServletWrapper;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInitializationCollaborator;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.ws.webcontainer.util.VirtualHostContextRootMapper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.ws.wscontainer.DeployedModule;
import com.ibm.ws.wswebcontainer.ServletContextFacadeRegistryItem;
import com.ibm.ws.wswebcontainer.VirtualHost;
import com.ibm.ws.wswebcontainer.srt.SRTConnectionContext;
import com.ibm.ws.wswebcontainer.webapp.WebAppConfiguration;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollector;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorFactory;
import com.ibm.ws390.sm.smf.SmfWebContainerDataCollectorIntervalManager;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.webcontainer.IRequest;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WebContainerConstants;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;

public final class WebContainer
extends com.ibm.ws.webcontainer.WebContainer
implements Runnable,
WebContainerConstants {
    private Hashtable threadData = new Hashtable();
    protected static TraceComponent tc = Tr.register((Class)WebContainer.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static ArrayList virtualHostExtFactories = new ArrayList();
    public static final boolean isZOS = AdminHelper.getPlatformHelper().isZOS();
    public static final boolean isZOS_CR = AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isControlJvm();
    public static final boolean isZOS_SR = AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm();
    public static String tempDir = null;
    private static boolean isDefaultTempDir = false;
    private com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer webConConfig;
    private WebSecurityCollaborator securityCollaborator;
    private static String THREAD_POOL_NAME = "Migrated.Servlet.Engine.Transports";
    private ObjectPool srtConnectionObjectPool = null;
    private static ConnectionHandleCollaborator connectionHandleCollaborator;
    private IInitializationCollaborator[] webAppInitializationCollaborators;
    private IInvocationCollaborator[] webAppInvocationCollaborators;
    private boolean chainsAvailable = false;
    private HashMap moduleToVHostTable = new HashMap();
    private boolean enableSecurityAtWARBoundary = false;
    private boolean enableSecurityAtEARBoundary = false;
    private Alarm reaperAlarm;
    private long reaperInterval = 0L;
    private long reaperInactiveLimit = 10000L;
    private static SmfWebContainerDataCollector Smf;
    private static SmfWebContainerDataCollectorIntervalManager intervalManager;
    private int numRequests = 0;
    private static Map servletContextFacadeRegistry;
    private Map virtualHostMap;

    private WebContainer(String string, Container container) {
        super(string, container);
        this.requestMapper = new VirtualHostContextRootMapper();
        this.setVHostCompatFlag(false);
        this.virtualHostMap = new HashMap();
    }

    public static com.ibm.ws.webcontainer.WebContainer getWebContainer() {
        if (self == null) {
            self = new WebContainer("Was.webcontainer", null);
        }
        return self;
    }

    public void initialize(com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer webContainer, IInitializationCollaborator[] iInitializationCollaboratorArray, IInvocationCollaborator[] iInvocationCollaboratorArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.webConConfig = webContainer;
        this.wcconfig = new WebContainerConfiguration();
        this.wcconfig.setDefaultVirtualHostName(webContainer.getDefaultVirtualHostName());
        this.wcconfig.setEnableServletCaching(webContainer.isEnableServletCaching());
        if (!this._initialized) {
            Tr.audit((TraceComponent)tc, (String)"web.container.copyright");
            Tr.audit((TraceComponent)tc, (String)"web.container.servlet.spec.level");
            Tr.audit((TraceComponent)tc, (String)"web.container.jsp.spec.level");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Web Container Configuration: {0}", (Object)webContainer);
            }
            Iterator iterator = webContainer.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                webConProperties.put(property.getName().toLowerCase(), property.getValue());
            }
            boolean bl = new Boolean(webConProperties.getProperty("com.ibm.ws.webcontainer.skipinputstreamread"));
            if (bl) {
                SRTServletResponse.setSkipInputStreamRead(true);
            }
            this.getURIEncoding();
            this.webAppInitializationCollaborators = iInitializationCollaboratorArray;
            this.webAppInvocationCollaborators = iInvocationCollaboratorArray;
            if (webContainer.isEnableServletCaching()) {
                this.initializeDynamicCache();
            }
            this.loadCipherToBit();
            connectionHandleCollaborator = new ConnectionHandleCollaborator();
            WebContainerWorkloadRegulator.getRegulator();
            boolean bl2 = this.webConConfig.isDisablePooling();
            int n = -1;
            if (bl2) {
                this.wcconfig.setPoolingDisabled(bl2);
                n = 0;
            }
            if (!isZOS_CR) {
                this.srtConnectionObjectPool = ObjectPoolFactory.getPool(SRTConnectionContext.class, n);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("initialize: connection pool type -->" + this.srtConnectionObjectPool + "poolingDisabled --> " + bl2));
                }
            }
            if (webConProperties.get("com.ibm.ws.webcontainer.decodeurlplussign") != null) {
                boolean bl3 = decodePlusSign = ((String)webConProperties.get("com.ibm.ws.webcontainer.decodeurlplussign")).equalsIgnoreCase("true");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("decodePlusSign -->" + decodePlusSign));
                }
            }
            if (this.reaperInterval > 0L) {
                Tr.audit((TraceComponent)tc, (String)"reaper.with.interval.[{0}].limit.[{1}].started", (Object)new Object[]{new Long(this.reaperInterval), new Long(this.reaperInactiveLimit)});
                this.reaperAlarm = ReaperAlarmListener.startReaperAlarm(this, this.reaperInterval);
            }
            this._initialized = true;
            String string = WSSecurityHelper.isServerSecurityEnabled() || WSSecurityHelper.isGlobalSecurityEnabled() ? "com.ibm.ws.security.web.EJSWebCollaborator" : "com.ibm.ws.security.web.NullWebSecurityCollaborator";
            try {
                this.securityCollaborator = (WebSecurityCollaborator)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"59", (Object)this);
                Object[] objectArray = new Object[]{exception};
                Tr.error((TraceComponent)tc, (String)"instantiate.collaborator.exception", (Object)objectArray);
            }
        }
        WebContainer.addVirtualHostExtensionFactory(new ExtHandshakeVHostExtensionFactory());
        try {
            if (webConProperties.getProperty("enablesecurityatwarboundary") != null) {
                this.enableSecurityAtWARBoundary = "true".equalsIgnoreCase(webConProperties.getProperty("enablesecurityatwarboundary"));
            }
            if (webConProperties.getProperty("enablesecurityatearboundary") != null) {
                this.enableSecurityAtEARBoundary = "true".equalsIgnoreCase(webConProperties.getProperty("enablesecurityatearboundary"));
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)("Error in WebContainer custom property value: " + exception.getMessage()));
        }
        this.processVirtualHostExtensionFactories();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    private void processVirtualHostExtensionFactories() {
        for (int i = 0; i < virtualHostExtFactories.size(); ++i) {
            Object[] objectArray;
            ExtensionFactory extensionFactory = (ExtensionFactory)virtualHostExtFactories.get(i);
            try {
                ExtensionProcessor extensionProcessor = extensionFactory.createExtensionProcessor(null);
                objectArray = extensionFactory.getPatternList().iterator();
                while (objectArray.hasNext()) {
                    String string = (String)objectArray.next();
                    this.requestMapper.addMapping(string, extensionProcessor);
                }
                continue;
            }
            catch (Exception exception) {
                objectArray = new Object[]{exception};
                Tr.error((TraceComponent)tc, (String)"Engine.Exception.[{0}]", (Object)objectArray);
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"1829", (Object)this);
            }
        }
    }

    public static void addVirtualHostExtensionFactory(ExtensionFactory extensionFactory) {
        List list = extensionFactory.getPatternList();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer(32);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("VH:" + string);
            stringBuffer.append(' ');
        }
        Tr.audit((TraceComponent)tc, (String)"ExtensionFactory.[{0}].registered.successfully", (Object)new Object[]{extensionFactory.getClass().toString()});
        Tr.audit((TraceComponent)tc, (String)"ExtensionFactory.[{0}].associated.with.patterns.[{1}]", (Object)new Object[]{extensionFactory.getClass().toString(), stringBuffer.toString()});
        virtualHostExtFactories.add(extensionFactory);
    }

    public void destroy() {
        this.stopChains(0);
        super.destroy();
        this.requestMapper = null;
        if (isZOS && !isDefaultTempDir) {
            File file;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"deleting tempDirectory");
            }
            if (tempDir != null && (file = new File(tempDir)).exists()) {
                try {
                    this.removeDir(file);
                }
                catch (SecurityException securityException) {
                    Tr.error((TraceComponent)tc, (String)"Did not have access to delete Directory");
                }
            }
        }
        if (this.reaperAlarm != null) {
            this.reaperAlarm.cancel();
        }
    }

    private boolean removeDir(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = this.removeDir(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    private void initializeDynamicCache() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeDynamicCache");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Dynamic Caching Initializing");
        }
        CacheManager.initialize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDynamicCache");
        }
    }

    private VirtualHost loadVirtualHost(com.ibm.ws.http.VirtualHost virtualHost) {
        VirtualHostConfiguration virtualHostConfiguration = VirtualHostConfigurationHelper.createConfiguration(virtualHost);
        VirtualHost virtualHost2 = new VirtualHost(virtualHostConfiguration.getName(), this);
        virtualHost2.setName(virtualHost.getName());
        virtualHost2.init(virtualHostConfiguration);
        Alias[] aliasArray = virtualHost.getAliases();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        for (int i = 0; i < aliasArray.length; ++i) {
            Alias alias = aliasArray[i];
            string = alias.getHostname().toLowerCase();
            string2 = alias.getPort();
            if (string2 == null) {
                string2 = "80";
            }
            stringBuffer.setLength(0);
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append(string2);
            try {
                virtualHost2.addVhostEntry(stringBuffer.toString());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer.loadVirtualHosts", (String)"332");
                throw new RuntimeException(exception);
            }
            if (!string.equalsIgnoreCase("localhost")) continue;
            stringBuffer.setLength(0);
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.WebContainer.loadVirtualHosts", (String)"348");
            }
            if (inetAddress == null) continue;
            stringBuffer.append(inetAddress.getHostName().toLowerCase());
            stringBuffer.append(":");
            stringBuffer.append(string2);
            try {
                virtualHost2.addVhostEntry(stringBuffer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.setLength(0);
            stringBuffer.append(inetAddress.getHostAddress().toLowerCase());
            stringBuffer.append(":");
            stringBuffer.append(string2);
            try {
                virtualHost2.addVhostEntry(stringBuffer.toString());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("<MESSAGE> Adding VirtualHost " + stringBuffer.toString()));
        }
        return virtualHost2;
    }

    public void shutdown() {
        this.destroy();
    }

    public void addWebApplication(DeployedModule deployedModule, boolean bl) throws WebAppNotLoadedException {
        block11: {
            try {
                this.production = bl;
                if (isZOS) {
                    Thread thread;
                    block10: {
                        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        thread = new Thread(this);
                        this.threadData.put(thread, deployedModule);
                        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                            public Object run() {
                                thread.setContextClassLoader(classLoader);
                                return null;
                            }
                        });
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Starting autoload thread");
                        }
                        thread.start();
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Entering join() on autoload thread");
                            }
                            thread.join();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Left join() on autoload thread");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                            Tr.debug((TraceComponent)tc, (String)"join() on autoload thread interrupted");
                        }
                    }
                    WebAppNotLoadedException webAppNotLoadedException = (WebAppNotLoadedException)this.threadData.remove(thread);
                    if (webAppNotLoadedException != null) {
                        throw webAppNotLoadedException;
                    }
                    break block11;
                }
                this.addWebApp(deployedModule, bl);
            }
            catch (WebAppNotLoadedException webAppNotLoadedException) {
                throw webAppNotLoadedException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"695", (Object)this);
                throw new WebAppNotLoadedException(throwable.getMessage());
            }
        }
    }

    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Running autoload on daughter thread");
        }
        DeployedModule deployedModule = (DeployedModule)this.threadData.remove(Thread.currentThread());
        try {
            ThreadContextHelper threadContextHelper = (ThreadContextHelper)ImplFactory.loadImplFromKey((Class)ThreadContextHelper.class);
            threadContextHelper.establishCredentials();
            this.addWebApp(deployedModule, this.production);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            this.threadData.put(Thread.currentThread(), webAppNotLoadedException);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Autoload done");
        }
    }

    private void addWebApp(DeployedModule deployedModule, boolean bl) throws WebAppNotLoadedException {
        try {
            VirtualHost virtualHost;
            WebAppBinding webAppBinding = deployedModule.getBinding();
            String string = webAppBinding.getVirtualHostName();
            if (string == null || string.equals("")) {
                string = "default_host";
            }
            if ((virtualHost = (VirtualHost)this.getVirtualHost(string)) == null) {
                throw new WebAppNotLoadedException("Virtual Host " + string + " not found");
            }
            virtualHost.addWebApplication(deployedModule, extensionFactories, this.webAppInitializationCollaborators, this.webAppInvocationCollaborators, bl);
            this.moduleToVHostTable.put(deployedModule.getModuleRef(), virtualHost);
        }
        catch (WebAppHostNotFoundException webAppHostNotFoundException) {
            FFDCFilter.processException((Throwable)webAppHostNotFoundException, (String)"com.ibm.ws.webcontainer.Webcontainer", (String)"732", (Object)this);
            throw new WebAppNotLoadedException(webAppHostNotFoundException.getMessage(), webAppHostNotFoundException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"736", (Object)this);
            throw new WebAppNotLoadedException(throwable.getMessage(), throwable);
        }
    }

    public synchronized com.ibm.ws.webcontainer.VirtualHost getVirtualHost(String string) throws WebAppHostNotFoundException {
        if (this.virtualHostMap.containsKey(string)) {
            return (VirtualHost)this.virtualHostMap.get(string);
        }
        VirtualHostMgr virtualHostMgr = (VirtualHostMgr)ComponentUtil.getService(this, VirtualHostMgr.class);
        com.ibm.ws.http.VirtualHost virtualHost = virtualHostMgr.getVirtualHost(string);
        try {
            VirtualHost virtualHost2 = this.loadVirtualHost(virtualHost);
            this.virtualHostMap.put(string, virtualHost2);
            return virtualHost2;
        }
        catch (Throwable throwable) {
            throw new WebAppHostNotFoundException(throwable, string);
        }
    }

    public void removeWebApplication(DeployedModule deployedModule) throws Exception {
        try {
            VirtualHost virtualHost = (VirtualHost)this.moduleToVHostTable.get(deployedModule.getModuleRef());
            if (virtualHost == null) {
                throw new WebAppHostNotFoundException("VirtualHost for app " + deployedModule.getModuleRef().getUri() + " not found");
            }
            this.moduleToVHostTable.remove(deployedModule.getModuleRef());
            virtualHost.removeWebApplication(deployedModule);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Exception \n{0}", (Object)exception);
            throw exception;
        }
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void startTransports() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startTransports no args");
        }
        this.startChains();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startTransports no args");
        }
    }

    public synchronized void startChains() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startChains");
        }
        if (this.chainsAvailable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"startChains already started");
            }
            return;
        }
        try {
            if (!isZOS_CR) {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = adminService.getServerType();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serverType-->" + string));
                }
                boolean bl = false;
                if (string != null) {
                    bl = string.equals("PROXY_SERVER") || string.equals("ONDEMAND_ROUTER");
                }
                ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)ComponentUtil.getService(this, ChannelFrameworkService.class);
                String string2 = WebContainer.getWebContainerProperties().getProperty("enableinprocessconnections");
                if (string2 != null && string2.equalsIgnoreCase("true") || bl) {
                    LocalInboundChainFactory localInboundChainFactory;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"enableinprocessconnections is true");
                    }
                    if ((localInboundChainFactory = (LocalInboundChainFactory)ComponentUtil.getService(this, LocalInboundChainFactory.class)) != null) {
                        localInboundChainFactory.createLocalChains((ChannelFramework)channelFrameworkService, "com.ibm.ws.runtime.WebContainerImpl");
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"LocalInboundChainFactory was null.  Do not create local chains");
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"start chains by acceptor id");
                }
                channelFrameworkService.startChainsByAcceptorID("com.ibm.ws.runtime.WebContainerImpl", ChainStartMode.RETRY_EACH_ON_FAIL);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"skip starting chains by acceptor id since we are in the ZOS CR");
            }
            this.chainsAvailable = true;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.WebContainerImpl.startChannels", (String)"277", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startChains");
        }
    }

    public synchronized void stopChains(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stopChains, timeout-->" + n));
        }
        if (!this.chainsAvailable) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stopChains already stopped");
            }
            return;
        }
        try {
            if (!isZOS_CR) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"stop chains by acceptor id");
                }
                ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)ComponentUtil.getService(this, ChannelFrameworkService.class);
                channelFrameworkService.stopChainsByAcceptorID("com.ibm.ws.runtime.WebContainerImpl", (long)n);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"skip stopping chains by acceptor id");
            }
            this.chainsAvailable = false;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.WebContainerImpl.startChannels", (String)"277", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopChains");
        }
    }

    public void restartWebApplication(String string) throws WebAppNotLoadedException {
        Tr.warning((TraceComponent)tc, (String)"restartWebApplication no longer does anything. Use the ApplicationManager MBean to start and restart an application.");
    }

    private void transformTransportsToChains(VariableMap variableMap, ThreadPoolMgr threadPoolMgr) {
        com.ibm.websphere.models.config.process.ThreadPool threadPool;
        EList eList = this.webConConfig.getTransports();
        ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)ComponentUtil.getService(this, ChannelFrameworkService.class);
        try {
            threadPool = this.webConConfig.getThreadPool();
        }
        catch (Throwable throwable) {
            threadPool = null;
        }
        if (eList.size() == 0) {
            if (threadPool != null) {
                if (isZOS) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"threadpool not used");
                    }
                } else {
                    Tr.warning((TraceComponent)tc, (String)"threadpool.not.used");
                }
            }
            return;
        }
        Tr.warning((TraceComponent)tc, (String)"transports.detected");
        ThreadPoolMgr threadPoolMgr2 = (ThreadPoolMgr)ComponentUtil.getService(this, ThreadPoolMgr.class);
        ThreadPool threadPool2 = threadPoolMgr2.getThreadPool(THREAD_POOL_NAME, threadPool);
        Tr.debug((TraceComponent)tc, (String)("ThreadPool created for transports -->" + threadPool2));
        Transport transport = null;
        for (int i = 0; i < eList.size(); ++i) {
            try {
                String[] stringArray;
                Object object;
                String string;
                Object object2;
                Object object3;
                Object object4;
                transport = (Transport)eList.get(i);
                EndPoint endPoint = transport.getAddress();
                String string2 = "*";
                String string3 = "";
                String string4 = null;
                if (endPoint != null) {
                    string3 = "" + endPoint.getPort();
                    if (endPoint.getHost() != null && !endPoint.getHost().equals("")) {
                        string2 = endPoint.getHost();
                    }
                }
                HashMap hashMap = this.flattenProps(transport.getProperties());
                if (transport.isSslEnabled() && !isZOS_SR) {
                    object4 = new HashMap<String, Object>();
                    object3 = transport.getSslConfig();
                    ((HashMap)object4).put("alias", object3);
                    string4 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_SSL_" + string2 + ":" + string3;
                    try {
                        object2 = Class.forName("com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory");
                        channelFrameworkService.addChannel(string4, object2, (Map)object4, 100);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Tr.error((TraceComponent)tc, (String)"transport error \n{0}", (Object)classNotFoundException);
                    }
                    catch (ChannelException channelException) {
                        Tr.error((TraceComponent)tc, (String)"transport error \n{0}", (Object)((Object)channelException));
                    }
                }
                object4 = null;
                if (!isZOS_SR) {
                    object3 = new Properties();
                    ((Properties)object3).put("hostname", string2);
                    ((Properties)object3).put("port", string3);
                    ((Properties)object3).put("threadPoolName", THREAD_POOL_NAME);
                    object4 = (String)hashMap.get("maxconnectbacklog");
                    if (object4 != null) {
                        ((Properties)object3).put("listenBacklog", object4);
                    }
                    if ((object4 = (String)hashMap.get("connectioniotimeout")) != null) {
                        ((Properties)object3).put("inactivityTimeout", object4);
                    }
                    string = "MIGRATED_HTTP_TRANSPORT_CHANNEL_TCP_" + string2 + ":" + string3;
                    object2 = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
                    if (isZOS_CR) {
                        object2 = "com.ibm.ws.tcp.channel.impl.ZAioTCPChannelFactory";
                    }
                    try {
                        object = Class.forName((String)object2);
                        channelFrameworkService.addChannel(string, object, (Map)object3, 100);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Tr.error((TraceComponent)tc, (String)("Unable to locate " + (String)object2 + " \n{0}"), (Object)classNotFoundException);
                    }
                    catch (ChannelException channelException) {
                        Tr.error((TraceComponent)tc, (String)"Error adding channel \n{0}", (Object)((Object)channelException));
                    }
                } else {
                    string = "XMEM_IN";
                }
                object3 = new Properties();
                if (isZOS_SR) {
                    ((Properties)object3).put("enableBinaryTransport", "true");
                }
                if ((object4 = (String)hashMap.get("maxkeepaliverequests")) != null) {
                    ((Properties)object3).put("MaxKeepAliveRequests", object4);
                }
                if ((object4 = (String)hashMap.get("keepaliveenabled")) != null) {
                    ((Properties)object3).put("useKeepAlive", object4);
                }
                if ((object4 = (String)hashMap.get("maxkeepaliveconnections")) != null) {
                    int n = -1;
                    try {
                        n = Integer.parseInt((String)object4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n == 0) {
                        ((Properties)object3).put("useKeepAlive", "false");
                    }
                }
                if ((object4 = (String)hashMap.get("errorlog")) != null) {
                    ((Properties)object3).put("errorLogFileName", object4);
                }
                if ((object4 = (String)hashMap.get("accesslog")) != null) {
                    ((Properties)object3).put("accessLogFileName", object4);
                }
                if ((object4 = (String)hashMap.get("loglevel")) != null) {
                    ((Properties)object3).put("loggingLevel", object4);
                }
                object4 = (String)hashMap.get("errorlogdisable");
                boolean bl = true;
                if (object4 != null) {
                    bl = "true".equalsIgnoreCase((String)object4);
                }
                if ((object4 = (String)hashMap.get("accesslogdisable")) != null) {
                    bl = bl && "true".equalsIgnoreCase((String)object4);
                }
                ((Properties)object3).put("loggingDisable", "" + bl);
                object4 = (String)hashMap.get("connectioniotimeout");
                if (object4 != null) {
                    ((Properties)object3).put("readTimeout", object4);
                }
                if ((object4 = (String)hashMap.get("connectionresponsetimeout")) != null) {
                    ((Properties)object3).put("writeTimeout", object4);
                }
                if ((object4 = (String)hashMap.get("connectionkeepalivetimeout")) != null) {
                    ((Properties)object3).put("persistTimeout", object4);
                }
                String string5 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_HTTP_" + string2 + ":" + string3;
                try {
                    object = Class.forName("com.ibm.ws.http.channel.inbound.impl.WSHttpInboundChannelFactory");
                    channelFrameworkService.addChannel(string5, object, (Map)object3, 100);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Tr.error((TraceComponent)tc, (String)"Unable to locate com.ibm.ws.http.channel.inbound.impl.WSHttpInboundChannelFactory \n{0}", (Object)classNotFoundException);
                }
                catch (ChannelException channelException) {
                    Tr.error((TraceComponent)tc, (String)"Error adding channel \n{0}", (Object)((Object)channelException));
                }
                String string6 = "MIGRATED_HTTP_TRANSPORT_CHANNEL_WCC_" + string2 + ":" + string3;
                try {
                    object = new Properties();
                    stringArray = Class.forName("com.ibm.ws.webcontainer.channel.WCChannelFactory");
                    channelFrameworkService.addChannel(string6, stringArray, object, 100);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Tr.error((TraceComponent)tc, (String)"Unable to locate com.ibm.ws.webcontainer.channel.WCChannelFactory \n{0}", (Object)classNotFoundException);
                }
                catch (ChannelException channelException) {
                    Tr.error((TraceComponent)tc, (String)"Error adding channel \n{0}", (Object)((Object)channelException));
                }
                object = "MIGRATED_HTTP_TRANSPORT_CHANNEL_Chain_" + string2 + ":" + string3;
                if (string4 != null) {
                    stringArray = new String[]{string, string4, string5, string6};
                    try {
                        channelFrameworkService.addChain((String)object, FlowType.INBOUND, stringArray, "com.ibm.ws.runtime.WebContainerImpl");
                    }
                    catch (ChannelException channelException) {
                        Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. \n{0}"), (Object)((Object)channelException));
                    }
                    catch (ChainException chainException) {
                        Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. \n{0}"), (Object)((Object)chainException));
                    }
                    continue;
                }
                stringArray = new String[]{string, string5, string6};
                try {
                    channelFrameworkService.addChain((String)object, FlowType.INBOUND, stringArray, "com.ibm.ws.runtime.WebContainerImpl");
                }
                catch (ChannelException channelException) {
                    Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. \n{0}"), (Object)((Object)channelException));
                }
                catch (ChainException chainException) {
                    Tr.error((TraceComponent)tc, (String)("Error occured while migrating transport at port " + string3 + " to the corresponding chain. \n{0}"), (Object)((Object)chainException));
                }
                continue;
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)"Error occured while migrating transport to the corresponding chain. \n{0}", (Object)throwable);
            }
        }
    }

    private HashMap flattenProps(EList eList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Properties properties = WebContainer.getWebContainerProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string;
            Property property = (Property)iterator.next();
            String string2 = property.getName();
            if (string2.equalsIgnoreCase("maxconnectbacklog")) {
                hashMap.put("maxconnectbacklog", property.getValue());
            } else {
                string = properties.getProperty("maxconnectbacklog");
                if (string != null) {
                    hashMap.put("maxconnectbacklog", string);
                }
            }
            if (string2.equalsIgnoreCase("maxkeepaliveconnections")) {
                Tr.warning((TraceComponent)tc, (String)("The semantics for the " + string2 + " property on the transport, have changed. A thread is no longer tied to a single connection. Please refer to the infocenter for more details."));
                hashMap.put("maxkeepaliveconnections", property.getValue());
            } else {
                Tr.warning((TraceComponent)tc, (String)("The semantics for the " + string2 + " property on the transport, have changed. A thread is no longer tied to a single connection. Please refer to the infocenter for more details."));
                string = properties.getProperty("maxkeepaliveconnections");
                if (string != null) {
                    hashMap.put("maxkeepaliveconnections", string);
                }
            }
            if (string2.equalsIgnoreCase("maxkeepaliverequests")) {
                hashMap.put("maxkeepaliverequests", property.getValue());
            } else {
                string = properties.getProperty("maxkeepaliverequests");
                if (string != null) {
                    hashMap.put("maxkeepaliverequests", string);
                }
            }
            if (string2.equalsIgnoreCase("trustedproxy")) {
                Tr.warning((TraceComponent)tc, (String)("The " + string2 + " property is now configurable only at the WebContainer level, and not at the transports. "));
                hashMap.put("trustedproxy", property.getValue());
            } else {
                string = properties.getProperty("trustedproxy");
                if (string != null) {
                    hashMap.put("trustedproxy", string);
                }
            }
            if (string2.equalsIgnoreCase("connectioniotimeout")) {
                hashMap.put("connectioniotimeout", property.getValue());
            } else {
                string = properties.getProperty("connectioniotimeout");
                if (string != null) {
                    hashMap.put("connectioniotimeout", string);
                }
            }
            if (string2.equalsIgnoreCase("connectionkeepalivetimeout")) {
                hashMap.put("connectionkeepalivetimeout", property.getValue());
            } else {
                string = properties.getProperty("connectionkeepalivetimeout");
                if (string != null) {
                    hashMap.put("connectionkeepalivetimeout", string);
                }
            }
            if (!string2.equalsIgnoreCase("ErrorLog") && !string2.equalsIgnoreCase("LogLevel") && !string2.equalsIgnoreCase("AccessLog") && !string2.equalsIgnoreCase("ErrorLogDisable") && !string2.equalsIgnoreCase("AccessLogDisable")) continue;
            Tr.warning((TraceComponent)tc, (String)("The " + string2 + " attribute under the transport no longer applies. Please configure this property under the Logging Service (see infocenter for more details on HTTP Access Logger)."));
        }
        return hashMap;
    }

    public void startTransports(VariableMap variableMap, ThreadPoolMgr threadPoolMgr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startTransports");
        }
        this.transformTransportsToChains(variableMap, threadPoolMgr);
    }

    public void reload(DeployedModule deployedModule) throws WebAppNotLoadedException {
        this.restartWebApplication(deployedModule);
    }

    public void restartWebApplication(DeployedModule deployedModule) throws WebAppNotLoadedException {
        WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getDeployedModule().getMetaData();
        WebAppConfiguration webAppConfiguration = webModuleMetaDataImpl.getWebAppConfig();
        String string = webAppConfiguration.getDisplayName();
        if (string == null) {
            string = deployedModule.getName();
        }
        Tr.audit((TraceComponent)tc, (String)"Restarting Module: {0}", (Object)string);
        try {
            this.removeWebApplication(deployedModule);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)("Failed to remove webmodule " + string + ".\n{0}"), (Object)exception);
            return;
        }
        this.addWebApplication(deployedModule, this.production);
    }

    public void stopTransports() {
        this.stopChains(0);
    }

    public synchronized boolean areRequestsOutstanding() {
        return this.numRequests != 0;
    }

    public static ConnectionHandleCollaborator getConnectionHandleCollaborator() {
        return connectionHandleCollaborator;
    }

    public IHttpSessionContext getSessionContext(DeployedModule deployedModule, WebApp webApp, String string, ArrayList[] arrayListArray) throws Throwable {
        try {
            return this.getSessionRegistry().getSessionContext(deployedModule, webApp, string, arrayListArray);
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"getSessionContext Error \n{0}", (Object)throwable);
            return null;
        }
    }

    private SessionRegistry getSessionRegistry() {
        return (SessionRegistry)this.sessionRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handleRequest(IRequest iRequest, IResponse iResponse) throws IOException {
        boolean bl = true;
        Object object = this;
        synchronized (object) {
            if (this.isStopped) {
                bl = false;
            } else {
                ++this.numRequests;
            }
        }
        if (bl) {
            object = null;
            String string = iRequest.getHeader("Expect");
            if (string != null && !string.equalsIgnoreCase("100-continue")) {
                iResponse.setStatusCode(417);
                iResponse.setReason("Expectation Failed");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Response Code: 417, Invalid Expect Header --> " + string));
                }
                WebContainer webContainer = this;
                synchronized (webContainer) {
                    --this.numRequests;
                }
                return;
            }
            boolean bl2 = false;
            if (isZOS) {
                try {
                    Smf.webContainerDispatchBegins();
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    Tr.error((TraceComponent)tc, (String)"webContainerDispatchBegins() failed \n{0}", (Object)throwable);
                }
            }
            if (this.securityCollaborator == null) {
                throw new WebGroupVHostNotFoundException("Not found.");
            }
            object = this.securityCollaborator.preInvoke();
            super.handleRequest(iRequest, iResponse);
            Object var12_14 = null;
            try {
                this.securityCollaborator.postInvoke(object);
            }
            catch (Exception object2) {
                FFDCFilter.processException((Throwable)object2, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                Object[] objectArray = new Object[]{object2};
                Tr.error((TraceComponent)tc, (String)"postInvoke.Security.Exception.", (Object)objectArray);
            }
            if (isZOS) {
                try {
                    intervalManager.flush();
                }
                catch (Throwable object2) {
                    Tr.error((TraceComponent)tc, (String)"intervalManager.flush() failed \n{0}", (Object)object2);
                }
                if (bl2) {
                    try {
                        Smf.webContainerDispatchEnds();
                    }
                    catch (Throwable object2) {
                        Tr.error((TraceComponent)tc, (String)"Smf.webContainerDispatchEnds() failed \n{0}", (Object)object2);
                    }
                }
            }
            object2 = this;
            synchronized (object2) {
                --this.numRequests;
            }
            {
                catch (WebGroupVHostNotFoundException webGroupVHostNotFoundException) {
                    iResponse.addHeader("Content-Type", "text/html");
                    iResponse.setStatusCode(404);
                    String string2 = "<H1>" + MessageFormat.format(nls.getString("Web.Group.VHost.Not.Found", "WebGroup Not Found"), ResponseUtils.encodeDataString(iRequest.getRequestURI())) + "</H1><BR><H3>" + webGroupVHostNotFoundException.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    byte[] byArray = string2.getBytes();
                    iResponse.getOutputStream().write(byArray, 0, byArray.length);
                    Tr.error((TraceComponent)tc, (String)"Web.Group.VHost.Not.Found", (Object)new Object[]{this.truncateURI(iRequest.getRequestURI())});
                    Object var12_15 = null;
                    try {
                        this.securityCollaborator.postInvoke(object);
                    }
                    catch (Exception object3) {
                        FFDCFilter.processException((Throwable)object3, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        Object[] objectArray = new Object[]{object3};
                        Tr.error((TraceComponent)tc, (String)"postInvoke.Security.Exception.", (Object)objectArray);
                    }
                    if (isZOS) {
                        try {
                            intervalManager.flush();
                        }
                        catch (Throwable object3) {
                            Tr.error((TraceComponent)tc, (String)"intervalManager.flush() failed \n{0}", (Object)object3);
                        }
                        if (bl2) {
                            try {
                                Smf.webContainerDispatchEnds();
                            }
                            catch (Throwable object3) {
                                Tr.error((TraceComponent)tc, (String)"Smf.webContainerDispatchEnds() failed \n{0}", (Object)object3);
                            }
                        }
                    }
                    object3 = this;
                    synchronized (object3) {
                        --this.numRequests;
                    }
                }
                catch (WebSecurityException webSecurityException) {
                    FFDCFilter.processException((Throwable)webSecurityException, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"148", (Object)this);
                    iResponse.addHeader("Content-Type", "text/html");
                    iResponse.setStatusCode(403);
                    String string3 = "<H1>" + nls.getString("Forbidden.Web.Security.Exception", "Forbidden: Web Security Exception") + "</H1><BR><H3>" + webSecurityException.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    byte[] byArray = string3.getBytes();
                    iResponse.getOutputStream().write(byArray, 0, byArray.length);
                    Object[] objectArray = new Object[]{webSecurityException};
                    Tr.error((TraceComponent)tc, (String)"preInvoke.Security.Exception.", (Object)objectArray);
                    Object var12_16 = null;
                    try {
                        this.securityCollaborator.postInvoke(object);
                    }
                    catch (Exception object4) {
                        FFDCFilter.processException((Throwable)object4, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        Object[] objectArray2 = new Object[]{object4};
                        Tr.error((TraceComponent)tc, (String)"postInvoke.Security.Exception.", (Object)objectArray2);
                    }
                    if (isZOS) {
                        try {
                            intervalManager.flush();
                        }
                        catch (Throwable object4) {
                            Tr.error((TraceComponent)tc, (String)"intervalManager.flush() failed \n{0}", (Object)object4);
                        }
                        if (bl2) {
                            try {
                                Smf.webContainerDispatchEnds();
                            }
                            catch (Throwable object4) {
                                Tr.error((TraceComponent)tc, (String)"Smf.webContainerDispatchEnds() failed \n{0}", (Object)object4);
                            }
                        }
                    }
                    object4 = this;
                    synchronized (object4) {
                        --this.numRequests;
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"162", (Object)this);
                    iResponse.addHeader("Content-Type", "text/html");
                    iResponse.setStatusCode(500);
                    String string4 = "<H1>" + nls.getFormattedMessage("Engine.Exception.[{0}]", new Object[]{throwable.getMessage()}, "Engine Exception") + "</H1><BR><H3>" + throwable.getMessage() + "</H3><BR><I>IBM WebSphere Application Server</I>";
                    byte[] byArray = string4.getBytes();
                    iResponse.getOutputStream().write(byArray, 0, byArray.length);
                    Object[] objectArray = new Object[]{throwable};
                    Tr.error((TraceComponent)tc, (String)"Engine.Exception.[{0}]", (Object)objectArray);
                    Object var12_17 = null;
                    try {
                        this.securityCollaborator.postInvoke(object);
                    }
                    catch (Exception object5) {
                        FFDCFilter.processException((Throwable)object5, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                        Object[] objectArray3 = new Object[]{object5};
                        Tr.error((TraceComponent)tc, (String)"postInvoke.Security.Exception.", (Object)objectArray3);
                    }
                    if (isZOS) {
                        try {
                            intervalManager.flush();
                        }
                        catch (Throwable object5) {
                            Tr.error((TraceComponent)tc, (String)"intervalManager.flush() failed \n{0}", (Object)object5);
                        }
                        if (bl2) {
                            try {
                                Smf.webContainerDispatchEnds();
                            }
                            catch (Throwable object5) {
                                Tr.error((TraceComponent)tc, (String)"Smf.webContainerDispatchEnds() failed \n{0}", (Object)object5);
                            }
                        }
                    }
                    object5 = this;
                    synchronized (object5) {
                        --this.numRequests;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                try {
                    this.securityCollaborator.postInvoke(object);
                }
                catch (Exception object6) {
                    FFDCFilter.processException((Throwable)object6, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"183", (Object)this);
                    Object[] objectArray = new Object[]{object6};
                    Tr.error((TraceComponent)tc, (String)"postInvoke.Security.Exception.", (Object)objectArray);
                }
                if (isZOS) {
                    try {
                        intervalManager.flush();
                    }
                    catch (Throwable object6) {
                        Tr.error((TraceComponent)tc, (String)"intervalManager.flush() failed \n{0}", (Object)object6);
                    }
                    if (bl2) {
                        try {
                            Smf.webContainerDispatchEnds();
                        }
                        catch (Throwable object6) {
                            Tr.error((TraceComponent)tc, (String)"Smf.webContainerDispatchEnds() failed \n{0}", (Object)object6);
                        }
                    }
                }
                object6 = this;
                synchronized (object6) {
                    --this.numRequests;
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"service stopping ... , send sendUnavailableException ");
        }
        super.sendUnavailableException(iRequest, iResponse);
    }

    protected com.ibm.ws.webcontainer.srt.SRTConnectionContext getConnectionContext() {
        SRTConnectionContext sRTConnectionContext = null;
        if (this.srtConnectionObjectPool != null) {
            sRTConnectionContext = (SRTConnectionContext)this.srtConnectionObjectPool.getObject();
        }
        if (sRTConnectionContext == null) {
            sRTConnectionContext = new SRTConnectionContext();
        }
        return sRTConnectionContext;
    }

    public void reap() {
        long l = System.currentTimeMillis();
        try {
            Iterator iterator = this.requestMapper.targetMappings();
            Iterator iterator2 = null;
            Iterator iterator3 = null;
            Iterator iterator4 = null;
            VirtualHost virtualHost = null;
            WebGroup webGroup = null;
            WebApp webApp = null;
            ArrayList arrayList = null;
            RequestProcessor requestProcessor = null;
            IServletWrapper iServletWrapper = null;
            ServletWrapper servletWrapper = null;
            IServletConfig iServletConfig = null;
            List list = null;
            ServletMapping servletMapping = null;
            while (iterator.hasNext()) {
                virtualHost = (VirtualHost)iterator.next();
                iterator2 = virtualHost.getRequestMapper().targetMappings();
                while (iterator2.hasNext()) {
                    webGroup = (WebGroup)iterator2.next();
                    arrayList = webGroup.getWebApps();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        webApp = (WebApp)arrayList.get(i);
                        iterator3 = webApp.getRequestMapper().targetMappings();
                        while (iterator3.hasNext()) {
                            requestProcessor = (RequestProcessor)iterator3.next();
                            if (!(requestProcessor instanceof IServletWrapper) || l - this.reaperInactiveLimit <= (iServletWrapper = (IServletWrapper)requestProcessor).getLastAccessTime()) continue;
                            if (iServletWrapper instanceof ServletWrapper) {
                                servletWrapper = (ServletWrapper)iServletWrapper;
                                Tr.audit((TraceComponent)tc, (String)"reaper.unloading.servlet.[{0}]", (Object)iServletWrapper.getServletName());
                                servletWrapper.unload();
                                continue;
                            }
                            iServletConfig = (IServletConfig)iServletWrapper.getServletConfig();
                            list = iServletConfig.getMappings();
                            if (list != null) {
                                iterator4 = list.iterator();
                                while (iterator4.hasNext()) {
                                    servletMapping = (ServletMapping)iterator4.next();
                                    Tr.audit((TraceComponent)tc, (String)"reaper.removing.mapping.[{0}].for.servlet.[{1}]", (Object)new Object[]{servletMapping.getUrlPattern(), iServletWrapper.getServletName()});
                                    webApp.getRequestMapper().removeMapping(servletMapping.getUrlPattern());
                                }
                            }
                            Tr.audit((TraceComponent)tc, (String)"reaper.destroying.servlet.[{0}]", (Object)iServletWrapper.getServletName());
                            iServletWrapper.destroy();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.WebContainer", (String)"1114", (Object)this);
            Tr.error((TraceComponent)tc, (String)"reaper.thread.error");
        }
        this.reaperAlarm = ReaperAlarmListener.startReaperAlarm(this, this.reaperInterval);
    }

    protected void releaseConnectionContext(com.ibm.ws.webcontainer.srt.SRTConnectionContext sRTConnectionContext) {
        if (this.srtConnectionObjectPool != null) {
            this.srtConnectionObjectPool.returnObject((Object)sRTConnectionContext);
        } else {
            sRTConnectionContext.destroy();
        }
    }

    public String getURIEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        if (isZOS) {
            this.decode = false;
        }
        return super.getURIEncoding();
    }

    public boolean isEnableSecurityAtWARBoundary() {
        return this.enableSecurityAtWARBoundary;
    }

    public boolean isEnableSecurityAtEARBoundary() {
        return this.enableSecurityAtEARBoundary;
    }

    public static String getTempDir() {
        return tempDir;
    }

    public static void setTempDir(String string) {
        tempDir = string;
    }

    public static boolean isDefaultTempDir() {
        return isDefaultTempDir;
    }

    public static void setIsDefaultTempDir(boolean bl) {
        isDefaultTempDir = bl;
    }

    public static void addServletContextFacadeRegistryItem(ServletContextFacadeRegistryItem servletContextFacadeRegistryItem) {
        servletContextFacadeRegistry.put(servletContextFacadeRegistryItem.getPriority(), servletContextFacadeRegistryItem);
    }

    public static Collection getServletContextFacadeRegistry() {
        return servletContextFacadeRegistry.values();
    }

    public Iterator getVirtualHosts() {
        ArrayList arrayList = new ArrayList(this.virtualHostMap.values());
        return arrayList.listIterator();
    }

    static {
        Smf = null;
        intervalManager = null;
        if (isZOS) {
            Smf = SmfWebContainerDataCollectorFactory.getInstance();
            intervalManager = SmfWebContainerDataCollectorIntervalManager.getInstance();
        }
        servletContextFacadeRegistry = new TreeMap();
    }
}

