/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.security.web.WebReply;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.ws.webcontainer.webapp.WebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.FileNotFoundException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityCollaboratorHelper {
    private static TraceComponent tc = Tr.register((Class)SecurityCollaboratorHelper.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public static Object processPreInvokeException(WebSecurityException webSecurityException, RequestProcessor requestProcessor, WebAppSecurityCollaborator webAppSecurityCollaborator, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebAppDispatcherContext webAppDispatcherContext, WebApp webApp, String string) throws ServletErrorReport {
        int n;
        Object object = null;
        WebReply webReply = webSecurityException.getWebReply();
        object = webSecurityException.getWebSecurityContext();
        if (webReply == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"webReply is null, default to 403 status code");
            }
            n = 403;
        } else {
            n = webReply.getStatusCode();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SecurityCollaboratorHelper.processPreInvokeException():  WebSecurityException thrown (" + webSecurityException.toString() + ").  HTTP status code: " + n + "resource : " + string));
        }
        if (n == 403) {
            if (webApp.isErrorPageDefined(n)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using user defined error page for HTTP status code " + n));
                }
                WebAppErrorReport webAppErrorReport = new WebAppErrorReport(webSecurityException);
                webAppErrorReport.setErrorCode(n);
                webApp.sendError(httpServletRequest, httpServletResponse, webAppErrorReport);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using default security error page for HTTP status code " + n));
                }
                try {
                    webAppSecurityCollaborator.handleException(httpServletRequest, httpServletResponse, webSecurityException);
                }
                catch (Exception exception) {
                    if (requestProcessor instanceof IServletWrapper) {
                        throw ((IServletWrapper)requestProcessor).constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
                    }
                    throw SecurityCollaboratorHelper.constructErrorReport(exception, string);
                }
            }
        } else if (n == 401) {
            try {
                webAppSecurityCollaborator.handleException(httpServletRequest, httpServletResponse, webSecurityException);
            }
            catch (Exception exception) {
                if (requestProcessor instanceof IServletWrapper) {
                    throw ((IServletWrapper)requestProcessor).constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
                }
                throw SecurityCollaboratorHelper.constructErrorReport(exception, string);
            }
            if (webApp.isErrorPageDefined(n)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Using user defined error page for HTTP status code " + n));
                }
                WebAppErrorReport webAppErrorReport = new WebAppErrorReport(webSecurityException);
                webAppErrorReport.setErrorCode(n);
                webApp.sendError(httpServletRequest, httpServletResponse, webAppErrorReport);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using default security error page for HTTP status code " + n));
            }
        } else {
            if (tc.isDebugEnabled() && webReply != null) {
                Tr.debug((TraceComponent)tc, (String)("HTTP status code: " + n + "  Type of WebReply: " + webReply.getClass().getName()));
            }
            try {
                webAppSecurityCollaborator.handleException(httpServletRequest, httpServletResponse, webSecurityException);
            }
            catch (Exception exception) {
                if (requestProcessor instanceof IServletWrapper) {
                    throw ((IServletWrapper)requestProcessor).constructErrorReport(exception, webAppDispatcherContext.getCurrentServletReference());
                }
                throw SecurityCollaboratorHelper.constructErrorReport(exception, string);
            }
        }
        return object;
    }

    private static ServletErrorReport constructErrorReport(Throwable throwable, String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("constructing error report for path -->" + string + " Throwable -->" + throwable));
        }
        WebAppErrorReport webAppErrorReport = new WebAppErrorReport(throwable);
        webAppErrorReport.setTargetServletName(string);
        Throwable throwable2 = throwable;
        while (throwable2.getCause() != null) {
            throwable2 = throwable2.getCause();
        }
        if (throwable2 instanceof FileNotFoundException) {
            webAppErrorReport.setErrorCode(404);
        } else if (throwable2 instanceof UnavailableException) {
            UnavailableException unavailableException = (UnavailableException)throwable2;
            if (unavailableException.isPermanent()) {
                webAppErrorReport.setErrorCode(404);
            } else {
                webAppErrorReport.setErrorCode(503);
            }
        } else {
            webAppErrorReport.setErrorCode(500);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"returning new servlet error report");
        }
        return webAppErrorReport;
    }
}

