/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer.servlet;

import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.ws.wswebcontainer.servlet.ServletConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebType;

public class ServletConfigHelper {
    public static ServletConfig createServletConfig(Servlet servlet) {
        ServletConfig servletConfig = new ServletConfig(servlet.getServletName());
        servletConfig.setServletName(servlet.getServletName());
        servletConfig.setName(servlet.getServletName());
        WebType webType = servlet.getWebType();
        if (webType.isJspType()) {
            servletConfig.setIsJsp(true);
            servletConfig.setFileName(((JSPType)webType).getJspFile());
            servletConfig.setClassName(null);
        } else {
            servletConfig.setIsJsp(false);
            servletConfig.setClassName(((ServletType)webType).getClassName());
            servletConfig.setFileName(null);
        }
        servletConfig.setDisplayName(servlet.getDisplayName());
        servletConfig.setLargeIcon(servlet.getLargeIcon());
        servletConfig.setSmallIcon(servlet.getSmallIcon());
        if (servlet.isSetLoadOnStartup()) {
            servletConfig.setStartUpWeight(servlet.getLoadOnStartup());
        }
        servletConfig.setInitParams(ServletConfigHelper.constructInitParams((List)servlet.getParams(), (List)servlet.getInitParams()));
        return servletConfig;
    }

    private static HashMap constructInitParams(List list, List list2) {
        InitParam initParam;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            initParam = (InitParam)iterator.next();
            hashMap.put(initParam.getParamName(), initParam.getParamValue());
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            initParam = (ParamValue)iterator.next();
            hashMap.put(initParam.getName(), initParam.getValue());
        }
        return hashMap;
    }

    private static List constructMappings(List list, ServletConfig servletConfig) {
        ArrayList<ServletMapping> arrayList = new ArrayList<ServletMapping>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            org.eclipse.jst.j2ee.webapplication.ServletMapping servletMapping = (org.eclipse.jst.j2ee.webapplication.ServletMapping)iterator.next();
            ServletMapping servletMapping2 = new ServletMapping(servletConfig, servletMapping.getUrlPattern());
            arrayList.add(servletMapping2);
        }
        return arrayList;
    }
}

