/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer.stats;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.ws.pmi.server.PmiCollaborator;
import com.ibm.ws.pmi.server.PmiCollaboratorFactory;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.wswebcontainer.stats.UrlPmiModule;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

class ServletPmiModule
implements StatisticActionListener,
PmiConstants {
    private static TraceComponent tc = Tr.register((Class)ServletPmiModule.class, (String)"Webcontainer", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    private static final long serialVersionUID = 3692271975902012581L;
    CountStatisticImpl numErrors = null;
    CountStatisticImpl totalRequests = null;
    RangeStatisticImpl currentRequests = null;
    TimeStatisticImpl responseTime = null;
    private static final String uriTemplate = "/com/ibm/ws/wswebcontainer/stats/urlStats.xml";
    String subinstanceName = "";
    private StatsGroup uriStatsGroup = null;
    private StatsInstance servletStatsInstance = null;
    private HashMap uriData = null;
    private String webAppFullName = null;
    private String servletName = null;
    private static final String URL_MODULE = "webAppModule.servlets.urls";
    private static final boolean alwaysCreateURLObjects = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.runtimeuristatenablement"));
    private static final PmiCollaborator pmiCollab = PmiCollaboratorFactory.getPmiCollaborator();
    private StatDescriptor urlStatDesc = null;

    public ServletPmiModule(String string, String string2, StatsInstance statsInstance, StatsGroup statsGroup) {
        this.webAppFullName = string;
        this.servletName = string2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("new ServletPmiModule, servlet=" + string2 + ", AlwaysCreateUrlObjects=" + alwaysCreateURLObjects));
        }
        try {
            this.servletStatsInstance = StatsFactory.createStatsInstance((String)string2, (StatsGroup)statsGroup, null, (StatisticActionListener)this);
            this.createUriStatsGroup();
            if (!alwaysCreateURLObjects) {
                this.urlStatDesc = new StatDescriptor(new String[]{"webAppModule", this.webAppFullName, "webAppModule.servlets", this.servletName, URL_MODULE});
            }
        }
        catch (StatsFactoryException statsFactoryException) {
            Tr.error((TraceComponent)tc, (String)"error creating stats instance \n{0}", (Object)((Object)statsFactoryException));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("Servlet Statisics enabled : totalRequests=" + (this.totalRequests != null) + " , currentRequests=" + (this.currentRequests != null) + ", responseTime=" + (this.responseTime != null) + ", numErrors=" + (this.numErrors != null)));
        }
    }

    private void createUriStatsGroup() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("creating UriStatsGroup for the servlet:" + this.servletName));
        }
        if (this.uriStatsGroup == null) {
            try {
                this.uriStatsGroup = StatsFactory.createStatsGroup((String)URL_MODULE, (String)uriTemplate, (StatsInstance)this.servletStatsInstance, null);
            }
            catch (StatsFactoryException statsFactoryException) {
                Tr.error((TraceComponent)tc, (String)("Failed to create uri stats group for webapp: " + this.webAppFullName + ", servlet:" + this.servletName), (Object)((Object)statsFactoryException));
            }
        }
    }

    public final void decRequests(long l, String string) {
        UrlPmiModule urlPmiModule;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (string != null) {
                Tr.debug((TraceComponent)tc, (String)("decrementing requests for the servlet:" + this.servletName + ", url:" + string + ", execTime=" + l));
            } else {
                Tr.debug((TraceComponent)tc, (String)("decrementing requests for the servlet:" + this.servletName + ", execTime=" + l));
            }
        }
        long l2 = 0L;
        if (this.responseTime != null && l >= 0L) {
            l2 = System.currentTimeMillis();
            this.responseTime.add(l2, l);
        }
        if (this.currentRequests != null) {
            if (l2 <= 0L) {
                l2 = System.currentTimeMillis();
            }
            this.currentRequests.decrement(l2, 1L);
        }
        if (this.collectUrlStats() && (urlPmiModule = this.getUrlMod(string, false)) != null) {
            if (l2 <= 0L) {
                l2 = System.currentTimeMillis();
            }
            urlPmiModule.decRequests(l, l2);
        }
    }

    public final void incRequests(String string) {
        UrlPmiModule urlPmiModule;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (string != null) {
                Tr.debug((TraceComponent)tc, (String)("incrementing requests for the servlet:" + this.servletName + ", url:" + string));
            } else {
                Tr.debug((TraceComponent)tc, (String)("incrementing requests for the servlet:" + this.servletName));
            }
        }
        long l = 0L;
        if (this.totalRequests != null) {
            l = System.currentTimeMillis();
            this.totalRequests.increment(l, 1L);
        }
        if (this.currentRequests != null) {
            if (l <= 0L) {
                l = System.currentTimeMillis();
            }
            this.currentRequests.increment(l, 1L);
        }
        if (this.collectUrlStats() && (urlPmiModule = this.getUrlMod(string, true)) != null) {
            if (l <= 0L) {
                l = System.currentTimeMillis();
            }
            urlPmiModule.incRequests(l);
        }
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroy()" + this.servletStatsInstance.getName()));
        }
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.servletStatsInstance);
            if (this.uriStatsGroup != null) {
                StatsFactory.removeStatsGroup((StatsGroup)this.uriStatsGroup);
            }
        }
        catch (StatsFactoryException statsFactoryException) {
            Tr.error((TraceComponent)tc, (String)("destroy() failed" + this.servletStatsInstance.getName()), (Object)((Object)statsFactoryException));
        }
        if (this.uriData != null) {
            Set set = this.uriData.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ((UrlPmiModule)iterator.next().getValue()).destroy();
            }
        }
        this.uriData = null;
    }

    public void incNumErrors() {
        if (this.numErrors != null) {
            this.numErrors.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UrlPmiModule getUrlMod(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        UrlPmiModule urlPmiModule = null;
        if (this.servletStatsInstance != null) {
            if (this.uriData != null) {
                urlPmiModule = (UrlPmiModule)this.uriData.get(string);
            }
            if (urlPmiModule == null) {
                ServletPmiModule servletPmiModule = this;
                synchronized (servletPmiModule) {
                    if (this.uriData == null) {
                        this.uriData = new HashMap();
                    }
                    if ((urlPmiModule = (UrlPmiModule)this.uriData.get(string)) == null && bl) {
                        urlPmiModule = new UrlPmiModule(this, string, this.uriStatsGroup);
                        this.uriData.put(string, urlPmiModule);
                    }
                }
            }
        }
        return urlPmiModule;
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Servlet statistic created with id=" + sPIStatistic.getId()));
        }
        switch (sPIStatistic.getId()) {
            case 11: {
                this.totalRequests = (CountStatisticImpl)sPIStatistic;
                break;
            }
            case 14: {
                this.numErrors = (CountStatisticImpl)sPIStatistic;
                break;
            }
            case 13: {
                this.responseTime = (TimeStatisticImpl)sPIStatistic;
                break;
            }
            case 12: {
                this.currentRequests = (RangeStatisticImpl)sPIStatistic;
            }
        }
    }

    public void updateStatisticOnRequest(int n) {
    }

    public String getWebAppFullName() {
        return this.webAppFullName;
    }

    public String getServletName() {
        return this.servletName;
    }

    private boolean collectUrlStats() {
        if (alwaysCreateURLObjects || pmiCollab == null || this.urlStatDesc == null) {
            return true;
        }
        StatLevelSpec[] statLevelSpecArray = pmiCollab.getInstrumentationLevel(this.urlStatDesc, Boolean.valueOf(false));
        if (statLevelSpecArray != null) {
            int[] nArray = statLevelSpecArray[0].getEnabled();
            for (int i = 0; i < nArray.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Stat " + nArray[i] + " enabled."));
                }
                if (nArray[i] != 16 && nArray[i] != 17 && nArray[i] != 15) continue;
                return true;
            }
        }
        return false;
    }
}

