/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer.stats;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.ws.wswebcontainer.stats.ServletPmiModule;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

class UrlPmiModule
implements StatisticActionListener {
    private static TraceComponent tc = Tr.register((Class)UrlPmiModule.class, (String)"Webcontainer", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    CountStatisticImpl totalRequests = null;
    RangeStatisticImpl currentRequests = null;
    TimeStatisticImpl responseTime = null;
    private StatsInstance uriStatsInstance = null;
    private ServletPmiModule servletPMIModule = null;
    public static final int TOTAL_REQUESTS = 15;
    public static final int CONCURRENT_REQUESTS = 16;
    public static final int RESPONSE_TIME = 17;

    public UrlPmiModule(ServletPmiModule servletPmiModule, String string, StatsGroup statsGroup) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("new UrlPmiModule, webApp:" + servletPmiModule.getWebAppFullName() + ", servlet:" + servletPmiModule.getServletName() + ", url:" + string));
        }
        try {
            this.uriStatsInstance = StatsFactory.createStatsInstance((String)string, (StatsGroup)statsGroup, null, (StatisticActionListener)this);
        }
        catch (StatsFactoryException statsFactoryException) {
            Tr.error((TraceComponent)tc, (String)("failed to create UrlPmiModule, webApp:" + servletPmiModule.getWebAppFullName() + ", servlet:" + servletPmiModule.getServletName() + ", url:" + string));
        }
        this.servletPMIModule = servletPmiModule;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("URL Statisics enabled : totalRequests=" + (this.totalRequests != null) + " , currentRequests=" + (this.currentRequests != null) + ", responseTime=" + (this.responseTime != null)));
        }
    }

    public final void decRequests(long l, long l2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("decrementing requests for the urlStatsInstance=" + (this.uriStatsInstance == null ? "null" : this.uriStatsInstance.getName())));
        }
        if (this.responseTime != null && l >= 0L) {
            this.responseTime.add(l2, l);
        }
        if (this.currentRequests != null) {
            this.currentRequests.decrement(l2, 1L);
        }
    }

    public final void incRequests(long l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("incrementing requests for urlStatsInstance=" + (this.uriStatsInstance == null ? "null" : this.uriStatsInstance.getName())));
        }
        if (this.totalRequests != null) {
            this.totalRequests.increment(l, 1L);
        }
        if (this.currentRequests != null) {
            this.currentRequests.increment(l, 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("destroy()" + (this.uriStatsInstance == null ? "null" : this.uriStatsInstance.getName())));
        }
        try {
            if (this.uriStatsInstance != null) {
                StatsFactory.removeStatsInstance((StatsInstance)this.uriStatsInstance);
            }
        }
        catch (StatsFactoryException statsFactoryException) {
            Tr.error((TraceComponent)tc, (String)("failed to destroy UrlPmiModule, webApp:" + this.servletPMIModule.getWebAppFullName() + ", servlet:" + this.servletPMIModule.getServletName() + ", uriStatsInstance:" + this.uriStatsInstance.getName()));
        }
        finally {
            this.servletPMIModule = null;
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("URL statistics created with id=" + sPIStatistic.getId()));
        }
        switch (sPIStatistic.getId()) {
            case 15: {
                this.totalRequests = (CountStatisticImpl)sPIStatistic;
                break;
            }
            case 17: {
                this.responseTime = (TimeStatisticImpl)sPIStatistic;
                break;
            }
            case 16: {
                this.currentRequests = (RangeStatisticImpl)sPIStatistic;
            }
        }
    }

    public void updateStatisticOnRequest(int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("URL statistics updated with id=" + n));
        }
    }
}

