/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer.stats;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.wswebcontainer.stats.ServletPmiModule;
import com.ibm.ws.wswebcontainer.stats.WebAppPerf;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.HashMap;

public class WebAppModule
implements WebAppPerf,
StatisticActionListener,
PmiConstants {
    private static final String template = "/com/ibm/ws/wswebcontainer/stats/webAppModuleStats.xml";
    private static final String servletTemplate = "/com/ibm/ws/wswebcontainer/stats/servletStats.xml";
    private static StatsGroup webStatsGroup;
    StatsGroup servletStatsGroup = null;
    private StatsInstance webStatsInstance;
    private static final long serialVersionUID = -8923368384399206317L;
    private static TraceComponent tc;
    public static final String WEBAPP_MODULE = "webAppModule";
    public static final String SERVLET_MODULE = "webAppModule.servlets";
    private SPICountStatistic sgLoadedServlets = null;
    private SPICountStatistic sgNumReloads = null;
    private HashMap servletData = null;
    private String appPmiName = null;
    public static final int LOADED_SERVLETS = 1;
    public static final int NUM_RELOADS = 2;
    public static final int SERVLETS = 10;
    public static final int TOTAL_REQUESTS = 11;
    public static final int CONCURRENT_REQUESTS = 12;
    public static final int RESPONSE_TIME = 13;
    public static final int NUM_ERRORS = 14;
    public static final int LOADED_SINCE = 15;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppModule(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("new WebAppModule, webapp=" + string));
        }
        this.appPmiName = string;
        this.servletData = new HashMap();
        try {
            String string2 = template;
            synchronized (template) {
                if (webStatsGroup == null) {
                    webStatsGroup = StatsFactory.createStatsGroup((String)WEBAPP_MODULE, (String)template, null);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.webStatsInstance = StatsFactory.createStatsInstance((String)string, (StatsGroup)webStatsGroup, null, (StatisticActionListener)this);
                this.createServletStatsGroup();
            }
        }
        catch (StatsFactoryException statsFactoryException) {
            Tr.error((TraceComponent)tc, (String)("Failed to init PMI WebAppModule for " + string + "\n{0}"), (Object)((Object)statsFactoryException));
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Servlet statistic created with id=" + sPIStatistic.getId()));
        }
        if (sPIStatistic.getId() == 1) {
            this.sgLoadedServlets = (SPICountStatistic)sPIStatistic;
        } else if (sPIStatistic.getId() == 2) {
            this.sgNumReloads = (SPICountStatistic)sPIStatistic;
        }
    }

    public void onApplicationAvailableForService() {
    }

    public void onApplicationUnavailableForService() {
    }

    public void onApplicationStart() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"pmi WebAppModule received onApplicationStart");
        }
        if (this.sgNumReloads != null) {
            this.sgNumReloads.increment();
        }
    }

    public void onApplicationEnd() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"pmi WebAppModule received onApplicationEnd");
        }
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.webStatsInstance);
            StatsFactory.removeStatsGroup((StatsGroup)this.servletStatsGroup);
        }
        catch (StatsFactoryException statsFactoryException) {
            Tr.error((TraceComponent)tc, (String)("Failed to remove PMI WebAppModule for" + this.appPmiName), (Object)((Object)statsFactoryException));
        }
    }

    public final void onServletStartService(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pmi WebAppModule received onServletStartService for servlet:" + string + ", url:" + string2));
        }
        if (PMIServiceState.iStatisticSet < 1) {
            return;
        }
        ServletPmiModule servletPmiModule = (ServletPmiModule)this.servletData.get(string);
        if (servletPmiModule == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could not find a servlet pmi module, returning");
            }
            return;
        }
        servletPmiModule.incRequests(string2);
    }

    public final void onServletFinishService(String string, long l, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pmi WebAppModule received onServletFinishService for servlet:" + string + ", url:" + string2));
        }
        if (PMIServiceState.iStatisticSet < 1) {
            return;
        }
        ServletPmiModule servletPmiModule = (ServletPmiModule)this.servletData.get(string);
        if (servletPmiModule == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could not find a servlet pmi module, returning");
            }
            return;
        }
        servletPmiModule.decRequests(l, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServletStartInit(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pmi WebAppModule received onServletStartInit for servlet:" + string2));
        }
        ServletPmiModule servletPmiModule = new ServletPmiModule(this.appPmiName, string2, this.webStatsInstance, this.servletStatsGroup);
        HashMap hashMap = this.servletData;
        synchronized (hashMap) {
            this.servletData.put(string2, servletPmiModule);
        }
        if (this.sgLoadedServlets != null) {
            this.sgLoadedServlets.increment();
        }
    }

    private void createServletStatsGroup() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pmi WebAppModule: " + this.appPmiName + " creating servletStatsGroup"));
        }
        if (this.servletStatsGroup == null) {
            try {
                this.servletStatsGroup = StatsFactory.createStatsGroup((String)SERVLET_MODULE, (String)servletTemplate, (StatsInstance)this.webStatsInstance, null);
            }
            catch (StatsFactoryException statsFactoryException) {
                Tr.error((TraceComponent)tc, (String)"Error creating stats group \n{0}", (Object)((Object)statsFactoryException));
            }
        }
    }

    public void onServletFinishInit(String string) {
    }

    public void onServletStartDestroy(String string) {
    }

    public void onServletFinishDestroy(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServletUnloaded(String string) {
        ServletPmiModule servletPmiModule;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pmi WebAppModule unloading servlet:" + string));
        }
        if ((servletPmiModule = (ServletPmiModule)this.servletData.get(string)) != null) {
            HashMap hashMap = this.servletData;
            synchronized (hashMap) {
                this.servletData.remove(string);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could not find a servlet pmi module, returning");
            }
            return;
        }
        servletPmiModule.destroy();
        if (this.sgLoadedServlets != null) {
            this.sgLoadedServlets.increment(-1L);
        }
    }

    public void onServletAvailableForService(String string) {
    }

    public void onServletUnavailableForService(String string) {
    }

    public void onServletInitError(String string) {
        this.onServletError(string);
    }

    public void onServletServiceError(String string) {
        this.onServletError(string);
    }

    public void onServletError(String string) {
        ServletPmiModule servletPmiModule;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pmi WebAppModule received error for servlet:" + string));
        }
        if (PMIServiceState.iStatisticSet < 1) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("onServletError(), servletName=" + string));
        }
        if ((servletPmiModule = (ServletPmiModule)this.servletData.get(string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could not find a servlet pmi module, returning");
            }
            return;
        }
        servletPmiModule.incNumErrors();
    }

    public void onServletServiceDenied(String string) {
    }

    public void onServletDestroyError(String string) {
        this.onServletError(string);
    }

    public void updateStatisticOnRequest(int n) {
    }

    static {
        block2: {
            tc = Tr.register((Class)WebAppModule.class, (String)"Webcontainer", (String)"com.ibm.ws.pmi.properties.PMIMessages");
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.pmi.preprocess.webcontainer_StatsTemplateLookup");
                StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((StatsTemplateLookup)clazz.newInstance()));
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"PMI StatsTemplateLookup class not found.");
            }
        }
    }
}

