/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wswebcontainer.webapp;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.FileServingAttribute;
import com.ibm.ejs.models.base.extensions.webappext.InvokerAttribute;
import com.ibm.ejs.models.base.extensions.webappext.JSPAttribute;
import com.ibm.ejs.models.base.extensions.webappext.MimeFilter;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.ws.container.ErrorPage;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.filter.FilterConfig;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.wswebcontainer.WebContainer;
import com.ibm.ws.wswebcontainer.servlet.ServletConfig;
import com.ibm.ws.wswebcontainer.servlet.ServletConfigHelper;
import com.ibm.ws.wswebcontainer.webapp.WebAppConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.DispatcherType;
import org.eclipse.jst.j2ee.webapplication.ErrorCodeErrorPage;
import org.eclipse.jst.j2ee.webapplication.ExceptionTypeErrorPage;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.LocalEncodingMapping;
import org.eclipse.jst.j2ee.webapplication.MimeMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WelcomeFile;
import org.eclipse.jst.j2ee.webapplication.WelcomeFileList;

public class WebAppConfigurationHelper {
    protected static TraceComponent tc = Tr.register((String)WebAppConfigurationHelper.class.getName(), (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public static WebAppConfiguration createConfiguration(DeployedModule deployedModule) throws RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConfiguration");
        }
        WebApp webApp = (WebApp)deployedModule.getDeploymentDescriptor();
        WebAppExtension webAppExtension = (WebAppExtension)deployedModule.getExtension();
        WebAppBinding webAppBinding = (WebAppBinding)deployedModule.getBinding();
        WebApp webApp2 = (WebApp)deployedModule.getDeploymentDescriptor();
        WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)deployedModule.getMetaData();
        ModuleDeployment moduleDeployment = deployedModule.getModuleDeployment();
        WebModule webModule = (WebModule)((EARFile)deployedModule.getDeployedApplication().getModuleFile()).getModule(moduleDeployment.getUri(), moduleDeployment.getAltDD());
        String string = webModule.getContextRoot();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/") && !string.equals("/")) {
            string = string.substring(0, string.length() - 1);
        }
        WebAppConfiguration webAppConfiguration = new WebAppConfiguration(deployedModule.getName());
        webAppConfiguration.setContextRoot(string);
        webAppConfiguration.setAppStartupWeight(deployedModule.getDeployedApplication().getApplicationDeployment().getStartingWeight());
        webAppConfiguration.setModuleStartupWeight(moduleDeployment.getStartingWeight());
        webAppConfiguration.setVersion(webApp2.getVersionID());
        webAppConfiguration.setModuleName(deployedModule.getName());
        webAppConfiguration.setDescription(webApp2.getDescription());
        webAppConfiguration.setDistributable(webApp2.isDistributable());
        String string2 = webApp2.getDisplayName();
        if (string2 == null) {
            Iterator iterator = webApp2.getDisplayNames().iterator();
            if (iterator.hasNext()) {
                webAppConfiguration.setDisplayName(((DisplayName)iterator.next()).getValue());
            } else {
                webAppConfiguration.setDisplayName(deployedModule.getName());
            }
        } else {
            webAppConfiguration.setDisplayName(string2);
        }
        webAppConfiguration.setContextParams(WebAppConfigurationHelper.constructContextParams((List)webApp2.getContexts(), (List)webApp2.getContextParams()));
        webAppConfiguration.setCodeErrorPages(WebAppConfigurationHelper.constructErrorCodeErrorPages(webApp2.getErrorPages()));
        webAppConfiguration.setExceptionErrorPages(WebAppConfigurationHelper.constructExceptionTypeErrorPages(webApp2.getErrorPages()));
        webAppConfiguration.setWelcomeFileList(WebAppConfigurationHelper.constructWelcomeFileList(webApp2.getFileList()));
        webAppConfiguration.setTagLibs(WebAppConfigurationHelper.constructTagLibsList(webApp2.getTagLibs()));
        webAppConfiguration.setMimeMappings(WebAppConfigurationHelper.constructMimeMappings(webApp2.getMimeMappings()));
        if (webApp2.getSessionConfig() != null) {
            webAppConfiguration.setSessionTimeout(webApp2.getSessionConfig().getSessionTimeout());
        } else {
            webAppConfiguration.setSessionTimeout(-1);
        }
        webAppConfiguration.setServletInfos(WebAppConfigurationHelper.constructServletInfos(webApp2.getServlets()));
        WebAppConfigurationHelper.constructServletMappings(webApp2.getServletMappings(), webAppConfiguration);
        webAppConfiguration.setFilterInfos(WebAppConfigurationHelper.constructFilterInfos(webApp2.getFilters(), webAppConfiguration));
        webAppConfiguration.setFilterMappings(WebAppConfigurationHelper.constructFilterMappings(webApp2.getFilterMappings(), webAppConfiguration));
        webAppConfiguration.setListeners(WebAppConfigurationHelper.constructListeners(webApp2.getListeners()));
        webAppConfiguration.setVirtualHostName(webAppBinding.getVirtualHostName());
        webAppConfiguration.setReloadingEnabled(webAppExtension.isReloadingEnabled());
        webAppConfiguration.setReloadInterval(webAppExtension.getReloadInterval());
        webAppConfiguration.setDefaultErrorPage(webAppExtension.getDefaultErrorPage());
        webAppConfiguration.setAdditionalClassPath(webAppExtension.getAdditionalClassPath());
        if (webAppExtension.isSetFileServingEnabled()) {
            webAppConfiguration.setFileServingEnabled(new Boolean(webAppExtension.isFileServingEnabled()));
        }
        if (webAppExtension.isSetDirectoryBrowsingEnabled()) {
            webAppConfiguration.setDirectoryBrowsingEnabled(new Boolean(webAppExtension.isDirectoryBrowsingEnabled()));
        }
        if (webAppExtension.isSetServeServletsByClassnameEnabled()) {
            webAppConfiguration.setServeServletsByClassnameEnabled(new Boolean(webAppExtension.isServeServletsByClassnameEnabled()));
        }
        webAppConfiguration.setSyncToThreadEnabled(WebAppConfigurationHelper.getApplicationSyncToOSThread(webApp2));
        webAppConfiguration.setPrecompileJSPs(webAppExtension.isPreCompileJSPs());
        webAppConfiguration.setAutoRequestEncoding(webAppExtension.isAutoRequestEncoding());
        webAppConfiguration.setAutoResponseEncoding(webAppExtension.isAutoResponseEncoding());
        webAppConfiguration.setAutoLoadFilters(webAppExtension.isAutoLoadFilters());
        webAppConfiguration.setMimeFilters(WebAppConfigurationHelper.constructMimeFilters(webAppExtension.getMimeFilters()));
        webAppConfiguration.setJspAttributes(WebAppConfigurationHelper.constructAttributeMap(webAppExtension.getJspAttributes()));
        webAppConfiguration.setFileServingAttributes(WebAppConfigurationHelper.constructAttributeMap(webAppExtension.getFileServingAttributes()));
        webAppConfiguration.setInvokerAttributes(WebAppConfigurationHelper.constructAttributeMap(webAppExtension.getInvokerAttributes()));
        if (webApp2.getLocalEncodingMappingList() != null) {
            WebAppConfigurationHelper.constructLocaleToEncodingMap(webApp2.getLocalEncodingMappingList().getLocalEncodingMappings(), webAppConfiguration);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConfiguration");
        }
        return webAppConfiguration;
    }

    private static HashMap constructAttributeMap(EList eList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            InvokerAttribute invokerAttribute;
            Object e = iterator.next();
            if (e instanceof InvokerAttribute) {
                invokerAttribute = (InvokerAttribute)e;
                hashMap.put(invokerAttribute.getName(), invokerAttribute.getValue());
            }
            if (e instanceof FileServingAttribute) {
                invokerAttribute = (FileServingAttribute)e;
                hashMap.put(invokerAttribute.getName(), invokerAttribute.getValue());
            }
            if (!(e instanceof JSPAttribute)) continue;
            invokerAttribute = (JSPAttribute)e;
            hashMap.put(invokerAttribute.getName(), invokerAttribute.getValue());
        }
        return hashMap;
    }

    private static HashMap constructMimeFilters(EList eList) {
        HashMap<String, com.ibm.ws.container.MimeFilter> hashMap = new HashMap<String, com.ibm.ws.container.MimeFilter>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            MimeFilter mimeFilter = (MimeFilter)iterator.next();
            com.ibm.ws.container.MimeFilter mimeFilter2 = new com.ibm.ws.container.MimeFilter(mimeFilter.getType(), mimeFilter.getTarget());
            hashMap.put(mimeFilter.getType(), mimeFilter2);
        }
        return hashMap;
    }

    private static ArrayList constructListeners(EList eList) {
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Listener)iterator.next()).getListenerClass());
        }
        return arrayList;
    }

    private static List constructFilterMappings(EList eList, WebAppConfiguration webAppConfiguration) {
        ArrayList<com.ibm.ws.webcontainer.filter.FilterMapping> arrayList = new ArrayList<com.ibm.ws.webcontainer.filter.FilterMapping>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            FilterMapping filterMapping = (FilterMapping)iterator.next();
            if (filterMapping.getFilter() == null) continue;
            com.ibm.ws.webcontainer.filter.FilterMapping filterMapping2 = new com.ibm.ws.webcontainer.filter.FilterMapping(WebAppConfigurationHelper.resolveURI(filterMapping.getUrlPattern()), webAppConfiguration.getFilterInfo(filterMapping.getFilter().getName()), webAppConfiguration.getServletInfo(filterMapping.getServletName()));
            if (filterMapping.getDispatcherType().size() != 0) {
                int[] nArray = new int[filterMapping.getDispatcherType().size()];
                Iterator iterator2 = filterMapping.getDispatcherType().iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    DispatcherType dispatcherType = (DispatcherType)iterator2.next();
                    String string = dispatcherType.getName();
                    if (string.equalsIgnoreCase("include")) {
                        nArray[n++] = 2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("forward")) {
                        nArray[n++] = 1;
                        continue;
                    }
                    if (string.equalsIgnoreCase("error")) {
                        nArray[n++] = 3;
                        continue;
                    }
                    if (!string.equalsIgnoreCase("request")) continue;
                    nArray[n++] = 0;
                }
                filterMapping2.setDispatchMode(nArray);
            }
            arrayList.add(filterMapping2);
        }
        return arrayList;
    }

    private static HashMap constructFilterInfos(EList eList, WebAppConfiguration webAppConfiguration) {
        HashMap<String, FilterConfig> hashMap = new HashMap<String, FilterConfig>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Filter filter = (Filter)iterator.next();
            FilterConfig filterConfig = new FilterConfig(filter.getDisplayName());
            filterConfig.setDisplayName(filter.getDisplayName());
            filterConfig.setDescription(filter.getDescription());
            filterConfig.setFilterClassName(filter.getFilterClassName());
            filterConfig.setName(filter.getName());
            filterConfig.setLargeIcon(filter.getLargeIcon());
            filterConfig.setSmallIcon(filter.getSmallIcon());
            WebApp webApp = (WebApp)filter.eContainer();
            switch (webApp.getJ2EEVersionID()) {
                case 12: 
                case 13: {
                    EList eList2 = filter.getInitParams();
                    for (int i = 0; i < eList2.size(); ++i) {
                        InitParam initParam = (InitParam)eList2.get(i);
                        filterConfig.addInitParameter(initParam.getParamName(), initParam.getParamValue());
                    }
                    break;
                }
                default: {
                    EList eList3 = filter.getInitParamValues();
                    for (int i = 0; i < eList3.size(); ++i) {
                        ParamValue paramValue = (ParamValue)eList3.get(i);
                        filterConfig.addInitParameter(paramValue.getName(), paramValue.getValue());
                    }
                }
            }
            hashMap.put(filterConfig.getName(), filterConfig);
        }
        return hashMap;
    }

    private static HashMap constructServletInfos(EList eList) {
        HashMap<String, ServletConfig> hashMap = new HashMap<String, ServletConfig>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Servlet servlet = (Servlet)iterator.next();
            ServletConfig servletConfig = ServletConfigHelper.createServletConfig(servlet);
            hashMap.put(servletConfig.getServletName(), servletConfig);
        }
        return hashMap;
    }

    private static void constructLocaleToEncodingMap(EList eList, WebAppConfiguration webAppConfiguration) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            LocalEncodingMapping localEncodingMapping = (LocalEncodingMapping)iterator.next();
            webAppConfiguration.addLocaleEncodingMap(localEncodingMapping.getLocale(), localEncodingMapping.getEncoding());
        }
    }

    private static void constructServletMappings(EList eList, WebAppConfiguration webAppConfiguration) throws RuntimeWarning {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string;
            ServletMapping servletMapping = (ServletMapping)iterator.next();
            Servlet servlet = servletMapping.getServlet();
            String string2 = servletMapping.getUrlPattern();
            if (servlet == null) {
                string = nls.getFormattedMessage("servlet.name.for.servlet.mapping.not.found", new Object[]{string2}, "Servlet name for the servlet mapping [" + string2 + "] could not be found");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("constructServletMappings : --> " + string));
                }
                throw new RuntimeWarning(string);
            }
            string = servlet.getServletName();
            if (string2 != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"constructServletMappings", (Object)(" urlPattern --> " + string2 + " and servletName --> " + string));
                }
                webAppConfiguration.addServletMapping(servlet.getServletName(), WebAppConfigurationHelper.resolveURI(string2));
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"constructServletMappings", (Object)("unable to insert mapping for " + string + ". urlPattern is " + string2));
        }
    }

    private static HashMap constructMimeMappings(EList eList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            MimeMapping mimeMapping = (MimeMapping)iterator.next();
            hashMap.put(mimeMapping.getExtension(), mimeMapping.getMimeType());
        }
        return hashMap;
    }

    private static List constructTagLibsList(EList eList) {
        ArrayList<com.ibm.ws.container.TagLibRef> arrayList = new ArrayList<com.ibm.ws.container.TagLibRef>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TagLibRef tagLibRef = (TagLibRef)iterator.next();
            com.ibm.ws.container.TagLibRef tagLibRef2 = new com.ibm.ws.container.TagLibRef(WebAppConfigurationHelper.resolveURI(tagLibRef.getTaglibURI()), WebAppConfigurationHelper.resolveURI(tagLibRef.getTaglibLocation()));
            arrayList.add(tagLibRef2);
        }
        return arrayList;
    }

    private static ArrayList constructWelcomeFileList(WelcomeFileList welcomeFileList) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (welcomeFileList == null) {
            return arrayList;
        }
        if (welcomeFileList.getFile() == null) {
            return arrayList;
        }
        Iterator iterator = welcomeFileList.getFile().iterator();
        while (iterator.hasNext()) {
            WelcomeFile welcomeFile = (WelcomeFile)iterator.next();
            arrayList.add(WebAppConfigurationHelper.resolveURI(welcomeFile.getWelcomeFile()));
        }
        return arrayList;
    }

    private static HashMap constructErrorCodeErrorPages(EList eList) {
        HashMap<Integer, ErrorPage> hashMap = new HashMap<Integer, ErrorPage>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ErrorCodeErrorPage)) continue;
            ErrorCodeErrorPage errorCodeErrorPage = (ErrorCodeErrorPage)e;
            ErrorPage errorPage = new ErrorPage(WebAppConfigurationHelper.resolveURI(errorCodeErrorPage.getLocation()), errorCodeErrorPage.getErrorCode());
            try {
                Integer n = new Integer(errorCodeErrorPage.getErrorCode());
                hashMap.put(n, errorPage);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"WebGroupConfigurationHelper", (String)"73");
            }
        }
        return hashMap;
    }

    private static HashMap constructExceptionTypeErrorPages(EList eList) {
        HashMap<String, ErrorPage> hashMap = new HashMap<String, ErrorPage>();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ExceptionTypeErrorPage)) continue;
            try {
                ExceptionTypeErrorPage exceptionTypeErrorPage = (ExceptionTypeErrorPage)e;
                ErrorPage errorPage = new ErrorPage(WebAppConfigurationHelper.resolveURI(exceptionTypeErrorPage.getLocation()), exceptionTypeErrorPage.getExceptionTypeName());
                hashMap.put(exceptionTypeErrorPage.getExceptionTypeName(), errorPage);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    private static HashMap constructContextParams(List list, List list2) {
        ContextParam contextParam;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            contextParam = (ContextParam)iterator.next();
            hashMap.put(contextParam.getParamName(), contextParam.getParamValue());
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            contextParam = (ParamValue)iterator.next();
            hashMap.put(contextParam.getName(), contextParam.getValue());
        }
        return hashMap;
    }

    private static boolean getApplicationSyncToOSThread(WebApp webApp) {
        WSLoginLocalOSExtension wSLoginLocalOSExtension;
        if (!WebContainer.isZOS) {
            return false;
        }
        boolean bl = false;
        EList eList = webApp.getEnvEntries();
        EnvEntry[] envEntryArray = eList.toArray(new EnvEntry[eList.size()]);
        if (envEntryArray != null) {
            for (int i = 0; i < envEntryArray.length; ++i) {
                if (!envEntryArray[i].getName().equals("com.ibm.websphere.security.SyncToOSThread")) continue;
                Boolean bl2 = Boolean.valueOf(envEntryArray[i].getValue());
                bl = bl2;
            }
        }
        if (bl && !(wSLoginLocalOSExtension = WSLoginLocalOSExtensionFactory.getInstance()).isApplicationSyncToOSThreadEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"sync.tothread.not.set.for.server.[{0}]", (Object)webApp.getDisplayName());
            bl = false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getApplicationSyncToOSThread() returning " + bl));
        }
        return bl;
    }

    private static String resolveURI(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        string2 = new String(string);
        try {
            return WSUtil.resolveURI((String)string);
        }
        catch (Exception exception) {
            return string2;
        }
    }
}

