/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.extension;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.metadata.WebMetaDataFactory;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.wscontainer.DeployedModule;
import com.ibm.ws.wswebcontainer.servlet.ServletConfig;
import com.ibm.ws.wswebcontainer.servlet.ServletWrapper;
import com.ibm.ws.wswebcontainer.webapp.WebApp;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import com.ibm.wsspi.webcontainer.servlet.ServletConfigParmMap;
import com.ibm.wsspi.wswebcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.wswebcontainer.metadata.WebModuleMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public abstract class WebExtensionProcessor
extends com.ibm.ws.webcontainer.extension.WebExtensionProcessor {
    private static J2EENameFactory j2eeNameFactory = WebApp.getJ2eeNameFactory();
    private static TraceComponent tc = Tr.register((Class)WebExtensionProcessor.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");

    public WebExtensionProcessor(IServletContext iServletContext) {
        super(iServletContext);
        this.extensionContext = iServletContext;
    }

    public abstract void handleRequest(ServletRequest var1, ServletResponse var2) throws Exception;

    public IServletWrapper createServletWrapper(IServletConfig iServletConfig) throws Exception {
        ServletWrapper servletWrapper = new ServletWrapper(this.extensionContext);
        if (iServletConfig == null) {
            return servletWrapper;
        }
        try {
            servletWrapper.initialize(iServletConfig);
        }
        catch (UnavailableException unavailableException) {
            Tr.warning((TraceComponent)tc, (String)("Servlet " + iServletConfig.getServletName() + " is currently unavailable: " + unavailableException.getMessage()));
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"Error occured while preparing the servlet for initialization. \n{0}", (Object)throwable);
        }
        return servletWrapper;
    }

    public List getPatternList() {
        return new ArrayList();
    }

    public IServletConfig createConfig(String string) throws ServletException {
        ServletConfig servletConfig = new ServletConfig(string);
        WebComponentMetaDataImpl webComponentMetaDataImpl = null;
        try {
            WebAppConfiguration webAppConfiguration = ((WebApp)this.extensionContext).getConfiguration();
            WebModuleMetaData webModuleMetaData = (WebModuleMetaData)((com.ibm.ws.wswebcontainer.webapp.WebAppConfiguration)webAppConfiguration).getMetaData();
            J2EEName j2EEName = j2eeNameFactory.create(webModuleMetaData.getApplicationMetaData().getName(), webModuleMetaData.getName(), string);
            webComponentMetaDataImpl = WebMetaDataFactory.createWebComponentMetaData(j2EEName, (ModuleMetaData)webModuleMetaData);
            webComponentMetaDataImpl.setWebComponentType(1);
            webComponentMetaDataImpl.setWebComponentVersion("" + (double)webAppConfiguration.getVersion() / 10.0);
        }
        catch (RuntimeWarning runtimeWarning) {
            FFDCFilter.processException((Throwable)runtimeWarning, (String)"com.ibm.ws.webcontainer.extension.WebExtensionProcessor.createConfig", (String)"687", (Object)this);
        }
        catch (RuntimeError runtimeError) {
            FFDCFilter.processException((Throwable)runtimeError, (String)"com.ibm.ws.webcontainer.extension.WebExtensionProcessor.createConfig", (String)"691", (Object)this);
            throw new ServletException((Throwable)runtimeError);
        }
        servletConfig.setMetaData(webComponentMetaDataImpl);
        webComponentMetaDataImpl.setServletConfig(servletConfig);
        return servletConfig;
    }

    public IServletConfig createConfig(String string, ServletConfigParmMap servletConfigParmMap) throws ServletException {
        DeployedModule deployedModule;
        IServletConfig iServletConfig = this.createConfig(string);
        String string2 = (String)servletConfigParmMap.get(ServletConfigParmMap.CLASSNAME);
        String string3 = (String)servletConfigParmMap.get(ServletConfigParmMap.DISPLAYNAME);
        String string4 = (String)servletConfigParmMap.get(ServletConfigParmMap.FILENAME);
        Map map = (Map)servletConfigParmMap.get(ServletConfigParmMap.INITPARAMS);
        Boolean bl = (Boolean)servletConfigParmMap.get(ServletConfigParmMap.CACHINGENABLED);
        Boolean bl2 = (Boolean)servletConfigParmMap.get(ServletConfigParmMap.ISJSP);
        ServletContext servletContext = (ServletContext)servletConfigParmMap.get(ServletConfigParmMap.SERVLETCONTEXT);
        String string5 = (String)servletConfigParmMap.get(ServletConfigParmMap.SERVLETNAME);
        Integer n = (Integer)servletConfigParmMap.get(ServletConfigParmMap.STARTUPWEIGHT);
        Map map2 = (Map)servletConfigParmMap.get(ServletConfigParmMap.ATTRIBUTE);
        Boolean bl3 = (Boolean)servletConfigParmMap.get(ServletConfigParmMap.STATISTICSENABLED);
        if (string2 != null) {
            iServletConfig.setClassName(string2);
        }
        if (string3 != null) {
            iServletConfig.setDisplayName(string3);
        }
        if (string4 != null) {
            iServletConfig.setFileName(string4);
        }
        if (map != null) {
            iServletConfig.setInitParams(map);
        }
        if (bl != null) {
            iServletConfig.setIsCachingEnabled(bl);
        }
        if (bl3 != null) {
            iServletConfig.setStatisticsEnabled(bl3);
        }
        if (bl2 != null) {
            iServletConfig.setIsJsp(bl2);
        }
        if (servletContext != null) {
            iServletConfig.setServletContext(servletContext);
        }
        if (string5 != null) {
            iServletConfig.setServletName(string5);
        }
        if (n != null) {
            iServletConfig.setStartUpWeight(n);
        }
        if (map2 != null) {
            iServletConfig.setAttributes(map2);
        }
        if ((deployedModule = ((WebApp)this.extensionContext).getDeployedModule()) != null) {
            try {
                WebMetaDataFactory.fireMetaDataCreatedEvent((WebComponentMetaData)iServletConfig.getMetaData(), deployedModule.getDeployedModule());
            }
            catch (RuntimeError runtimeError) {
                FFDCFilter.processException((Throwable)runtimeError, (String)"com.ibm.ws.webcontainer.extension.WebExtensionProcessor.createConfig", (String)"163", (Object)this);
                throw new ServletException((Throwable)runtimeError);
            }
            catch (RuntimeWarning runtimeWarning) {
                FFDCFilter.processException((Throwable)runtimeWarning, (String)"com.ibm.ws.webcontainer.extension.WebExtensionProcessor.createConfig", (String)"166", (Object)this);
                throw new ServletException((Throwable)runtimeWarning);
            }
        }
        return iServletConfig;
    }
}

