/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.WriteBeyondContentLengthException;
import com.ibm.wsspi.webcontainer.IResponse;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedServletOutputStream
extends WSServletOutputStream {
    protected OutputStream out;
    protected byte[] buf = new byte[0];
    protected int count;
    protected int total;
    protected int limit;
    protected IResponse response;
    protected int length = -1;
    protected IOutputStreamObserver obs;
    protected boolean _hasWritten;
    protected boolean _hasFlushed;
    protected IOException except;
    protected boolean committed;
    private int bufferSize;
    private static TraceComponent tc = Tr.register((Class)BufferedServletOutputStream.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private boolean closeOnClose = false;
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");

    public BufferedServletOutputStream(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Constructor --> " + n));
        }
        this.buf = new byte[n];
        this.bufferSize = n;
        this._hasWritten = false;
        this._hasFlushed = false;
    }

    public BufferedServletOutputStream() {
        this(1024);
    }

    public void init(OutputStream outputStream, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init", (Object)outputStream);
        }
        this.initNewBuffer(outputStream, n);
    }

    void initNewBuffer(OutputStream outputStream, int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initNewBuffer --> " + n));
        }
        this.out = outputStream;
        if (n != this.buf.length) {
            this.bufferSize = n;
            this.buf = new byte[this.bufferSize];
        }
    }

    public void finish() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"finish");
        }
        if (this.length == -1 && this.total != 0) {
            this.length = this.total;
        }
        this.flush();
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reset");
        }
        this.out = null;
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.committed = false;
        this._hasWritten = false;
        this._hasFlushed = false;
        this.except = null;
        this.response = null;
    }

    public int getTotal() {
        return this.total;
    }

    public void setObserver(IOutputStreamObserver iOutputStreamObserver) {
        this.obs = iOutputStreamObserver;
        this.limit = -1;
    }

    public boolean isCommitted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCommitted: " + this.committed));
        }
        return this.committed;
    }

    protected void check() throws IOException {
        if (this.except != null) {
            this.flush();
            throw this.except;
        }
    }

    public void write(int n) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write --> " + n));
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total >= this.limit) {
            throw new WriteBeyondContentLengthException();
        }
        if (this.count == this.buf.length) {
            this.response.setFlushMode(false);
            this.flushBytes();
            this.response.setFlushMode(true);
        }
        this.buf[this.count++] = (byte)n;
        ++this.total;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("write len --> " + n2));
        }
        if (n2 < 0) {
            Tr.error((TraceComponent)tc, (String)"Illegal.Argument.Trying.to.write.chars");
            throw new IllegalArgumentException();
        }
        if (!this._hasWritten && this.obs != null) {
            this._hasWritten = true;
            this.obs.alertFirstWrite();
        }
        if (this.limit > -1 && this.total + n2 > this.limit) {
            n2 = this.limit - this.total;
            this.except = new WriteBeyondContentLengthException();
        }
        if (n2 >= this.buf.length) {
            this.response.setFlushMode(false);
            this.flushBytes();
            this.total += n2;
            this.writeOut(byArray, n, n2);
            this.response.setFlushMode(true);
            this.check();
            return;
        }
        int n3 = this.buf.length - this.count;
        if (n2 > n3) {
            this.response.setFlushMode(false);
            this.flushBytes();
            this.response.setFlushMode(true);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
        this.total += n2;
        this.check();
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flush");
        }
        this.flushBytes();
    }

    protected void flushBytes() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flushBytes");
        }
        if (!this.committed && !this._hasFlushed && this.obs != null) {
            this._hasFlushed = true;
            this.obs.alertFirstFlush();
        }
        this.committed = true;
        if (this.count > 0) {
            this.writeOut(this.buf, 0, this.count);
            this.count = 0;
        } else if (this.count == 0) {
            if (this.response != null && this.response.getFlushMode()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" Count 0 still flush mode is true , forceful flush");
                }
                this.response.flushBufferedContent();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" flush mode is false");
            }
        }
    }

    public void print(String string) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("print --> " + string));
        }
        if (string != null) {
            if (!this._hasWritten && this.obs != null) {
                this._hasWritten = true;
                this.obs.alertFirstWrite();
            }
            int n = string.length();
            if (this.limit > -1 && this.total + n > this.limit) {
                n = this.limit - this.total;
                this.except = new WriteBeyondContentLengthException();
            }
            int n2 = 0;
            while (n > 0) {
                int n3 = this.buf.length - this.count;
                if (n3 == 0) {
                    this.response.setFlushMode(false);
                    this.flushBytes();
                    this.response.setFlushMode(true);
                    n3 = this.buf.length - this.count;
                }
                if (n3 > n) {
                    n3 = n;
                }
                string.getBytes(n2, n2 + n3, this.buf, this.count);
                this.count += n3;
                this.total += n3;
                n2 += n3;
                n -= n3;
            }
            this.check();
        }
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close");
        }
        this.finish();
        try {
            this.out.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.srt.BufferedServletOutputStream.close", (String)"415", (Object)this);
        }
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    public void setResponse(IResponse iResponse) {
        this.response = iResponse;
    }

    protected void writeOut(byte[] byArray, int n, int n2) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeOut len --> " + n2));
        }
        this.out.write(byArray, n, n2);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBufferSize --> " + n));
        }
        if (this.total > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBufferSize(): illegal state--> already wrote " + this.total + " bytes"));
            }
            throw new IllegalStateException(nls.getString("Cannot.set.buffer.size.after.data", "Can't set buffer size after data has been written to stream"));
        }
        this.initNewBuffer(this.out, n);
    }

    public void clearBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearBuffer");
        }
        if (this.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clearBuffer(): illegal state--> stream is committed ");
            }
            throw new IllegalStateException("clearBuffer(): illegal state--> stream is committed ");
        }
        this.total = 0;
        this.count = 0;
        this._hasWritten = false;
    }

    public void flushBuffer() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"flushBuffer");
        }
        this.flush();
    }
}

