/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.WebContainerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class EncodingUtils {
    private static TraceComponent tc = Tr.register((Class)EncodingUtils.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static Object lock = new Object();
    private static Properties _localeProps = null;
    private static Properties _converterProps = null;
    private static HashMap _localeMap = new HashMap();
    private static HashMap _converterMap = new HashMap();
    private static boolean inited = false;
    private static Hashtable supportedEncodingsCache = new Hashtable();
    private static final byte[] TEST_CHAR = new byte[]{97};
    private static final Hashtable localesCache = new Hashtable();
    private static Locale cachedLocale = null;
    private static String cachedEncoding = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (inited) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initing EncodingUtils");
        }
        Object object = lock;
        synchronized (object) {
            if (inited) {
                return;
            }
            WebContainer webContainer = WebContainer.getWebContainer();
            WebContainerConfig webContainerConfig = webContainer.getWebContainerConfig();
            if (webContainerConfig != null) {
                _localeProps = webContainerConfig.getLocaleProps();
                _converterProps = webContainerConfig.getConverterProps();
            }
            if (_localeProps == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"locale properties using default location");
                }
                _localeProps = new Properties();
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Enumeration<URL> enumeration = (class$com$ibm$wsspi$webcontainer$util$EncodingUtils == null ? (class$com$ibm$wsspi$webcontainer$util$EncodingUtils = EncodingUtils.class$("com.ibm.wsspi.webcontainer.util.EncodingUtils")) : class$com$ibm$wsspi$webcontainer$util$EncodingUtils).getClassLoader().getResources("encoding.properties");
                            while (enumeration.hasMoreElements()) {
                                URL uRL = enumeration.nextElement();
                                InputStream inputStream = uRL.openStream();
                                _localeProps.load(inputStream);
                                inputStream.close();
                            }
                            return null;
                        }
                    });
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTRequestUtils", (String)"56");
                    Tr.error((TraceComponent)tc, (String)"failed.to.load.encoding.properties", (Object)throwable);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"locale properties specified by webcontainer shell");
            }
            if (_converterProps == null) {
                _converterProps = new Properties();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"converter properties using default location");
                }
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            Enumeration<URL> enumeration = (class$com$ibm$wsspi$webcontainer$util$EncodingUtils == null ? (class$com$ibm$wsspi$webcontainer$util$EncodingUtils = EncodingUtils.class$("com.ibm.wsspi.webcontainer.util.EncodingUtils")) : class$com$ibm$wsspi$webcontainer$util$EncodingUtils).getClassLoader().getResources("converter.properties");
                            while (enumeration.hasMoreElements()) {
                                URL uRL = enumeration.nextElement();
                                InputStream inputStream = uRL.openStream();
                                _converterProps.load(inputStream);
                                inputStream.close();
                            }
                            return null;
                        }
                    });
                    Properties properties = new Properties();
                    Enumeration<?> enumeration = _converterProps.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = (String)_converterProps.get(string);
                        properties.put(string.toLowerCase(), string2);
                    }
                    _converterProps = properties;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.srt.SRTRequestUtils", (String)"74");
                    Tr.error((TraceComponent)tc, (String)"failed.to.load.converter.properties", (Object)throwable);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"converter properties specified by webcontainer shell");
            }
            _localeMap.putAll(_localeProps);
            _converterMap.putAll(_converterProps);
            inited = true;
        }
    }

    public static String getCharsetFromContentType(String string) {
        EncodingUtils.init();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        int n2 = string2.indexOf("charset=");
        if (n2 == -1) {
            return null;
        }
        return string2.substring(n2 + 8).trim();
    }

    public static Vector getLocales(HttpServletRequest httpServletRequest) {
        EncodingUtils.init();
        String string = httpServletRequest.getHeader("Accept-Language");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Accept-Language --> " + string));
        }
        if (string == null) {
            Vector<Locale> vector = new Vector<Locale>();
            vector.addElement(Locale.getDefault());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processed Locales --> ", vector);
            }
            return vector;
        }
        Vector vector = null;
        vector = (Vector)localesCache.get(string);
        if (vector == null) {
            vector = EncodingUtils.processAcceptLanguage(string);
            vector = EncodingUtils.extractLocales(vector);
            localesCache.put(string, vector);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processed Locales --> " + vector));
        }
        return vector;
    }

    public static Vector processAcceptLanguage(String string) {
        Object object;
        EncodingUtils.init();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (object == null || ((String)object).length() == 0) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Encountered zero length language token without quality index.. skipping token");
                Tr.debug((TraceComponent)tc, (String)("acceptLanguage param = [" + string + "]"));
                continue;
            }
            int n = ((String)object).indexOf(59);
            Double d = new Double(1.0);
            if (n > -1) {
                int n2 = ((String)object).indexOf("q=");
                String string2 = ((String)object).substring(n2 + 2);
                try {
                    d = new Double(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webcontainer.srt.SRTRequestUtils.processAcceptLanguage", (String)"215");
                }
                object = ((String)object).substring(0, n);
            }
            if (((String)object).length() > 0) {
                if (!(d > 0.0) || ((String)object).charAt(0) == '*') continue;
                Vector vector = new Vector();
                if (treeMap.containsKey(d)) {
                    vector = (Vector)treeMap.get(d);
                }
                vector.addElement(object);
                treeMap.put(d, vector);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"Encountered zero length language token with quality index.. skipping token");
            Tr.debug((TraceComponent)tc, (String)("acceptLanguage param = [" + string + "]"));
        }
        if (treeMap.isEmpty()) {
            object = new Vector();
            ((Vector)object).addElement(Locale.getDefault().toString());
            treeMap.put("1", object);
        }
        return new Vector(treeMap.values());
    }

    public static Vector extractLocales(Vector vector) {
        EncodingUtils.init();
        Enumeration enumeration = vector.elements();
        Vector<Locale> vector2 = new Vector<Locale>();
        while (enumeration.hasMoreElements()) {
            Vector vector3 = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                String string2 = "";
                String string3 = "";
                int n = string.indexOf("-");
                if (n > -1) {
                    string2 = string.substring(n + 1).trim();
                    string = string.substring(0, n).trim();
                    int n2 = string2.indexOf("-");
                    if (n2 > -1) {
                        string3 = string2.substring(n2 + 1).trim();
                        string2 = string2.substring(0, n2).trim();
                    }
                }
                vector2.addElement(new Locale(string, string2, string3));
            }
        }
        return vector2;
    }

    public static String getEncodingFromLocale(Locale locale) {
        EncodingUtils.init();
        if (locale == cachedLocale) {
            return cachedEncoding;
        }
        String string = (String)_localeMap.get(locale.toString());
        if (string == null && (string = (String)_localeMap.get(locale.getLanguage() + "_" + locale.getCountry())) == null) {
            string = (String)_localeMap.get(locale.getLanguage());
        }
        cachedEncoding = string;
        cachedLocale = locale;
        return string;
    }

    public static String getJvmConverter(String string) {
        EncodingUtils.init();
        String string2 = (String)_converterMap.get(string.toLowerCase());
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static boolean isCharsetSupported(String string) {
        Boolean bl = (Boolean)supportedEncodingsCache.get(string);
        if (bl != null) {
            return bl;
        }
        try {
            new String(TEST_CHAR, string);
            supportedEncodingsCache.put(string, Boolean.TRUE);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encountered UnsupportedEncoding charset [" + string + "]"));
            }
            supportedEncodingsCache.put(string, Boolean.FALSE);
            return false;
        }
        return true;
    }
}

