/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.WebContainer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileSystem {
    private static TraceComponent tc = Tr.register((Class)FileSystem.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static boolean tolerateSymLinks = Boolean.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.toleratesymboliclinks"));
    private static int symLinkCacheSize;
    private static Map foundMatches;
    private static final String MAP_VALUE = "";

    public static boolean uriCaseCheck(File file, String string) throws IOException {
        return FileSystem.uriCaseCheck(file, string, true);
    }

    public static boolean uriCaseCheck(File file, String string, boolean bl) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("uriCaseCheck : file canpath=" + file.getCanonicalPath() + ", matchString=" + string + ", checkWEBINF=" + bl));
        }
        boolean bl2 = false;
        string = WSUtil.resolveURI((String)string);
        String string2 = new String(string.toUpperCase());
        if (bl && (string2.startsWith("/WEB-INF/") || string2.equals("/WEB-INF"))) {
            bl2 = false;
        } else if (string2.startsWith("/META-INF/") || string2.equals("/META-INF")) {
            bl2 = false;
        } else {
            string = string.replace('/', File.separatorChar);
            String string3 = file.getCanonicalPath();
            int n = string.length();
            if (string3.regionMatches(string3.length() - n, string, 0, n)) {
                bl2 = true;
            } else if (tolerateSymLinks) {
                if (foundMatches != null && foundMatches.get(string) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"uriCaseCheck : found in Cache");
                    }
                    bl2 = true;
                } else {
                    File file2;
                    String string4 = file.getAbsolutePath();
                    String string5 = string4.substring(0, string4.length() - n);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("uriCaseCheck : appRoot dir=" + string5));
                    }
                    if (FileSystem.walkPath(file2 = new File(string5), string)) {
                        if (foundMatches != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("uriCaseCheck : add to Cache :" + string + ", Cache size: current = " + foundMatches.size() + ", max = " + symLinkCacheSize));
                            }
                            foundMatches.put(string, MAP_VALUE);
                        }
                        bl2 = true;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("uriCaseCheck : result=" + bl2));
        }
        return bl2;
    }

    public static boolean walkPath(File file, String string) throws IOException {
        String[] stringArray = string.replace(File.separatorChar, '/').split("/");
        File file2 = new File(file.getCanonicalPath());
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(MAP_VALUE)) continue;
            String[] stringArray2 = file2.list(new StrictFileNameFilter(stringArray[i]));
            if (stringArray2 == null || stringArray2.length != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(stringArray[i] + " not found."));
                }
                return false;
            }
            file2 = new File(file2, stringArray[i]);
        }
        return true;
    }

    static {
        if (tolerateSymLinks) {
            symLinkCacheSize = Integer.valueOf(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.symboliclinkscachesize", "1000"));
            foundMatches = symLinkCacheSize > 0 ? Collections.synchronizedMap(new LRUCache(symLinkCacheSize)) : null;
        }
    }

    public static final class LRUCache
    extends LinkedHashMap {
        private int _maxEntries;

        public LRUCache(int n) {
            super(n, 0.75f, true);
            this._maxEntries = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this._maxEntries;
        }
    }

    public static final class StrictFileNameFilter
    implements FilenameFilter {
        String fileName;

        StrictFileNameFilter(String string) {
            this.fileName = string;
        }

        public boolean accept(File file, String string) {
            return string.equals(this.fileName);
        }
    }
}

