/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.ibm.ws.jsf.configuration.FacesConfigParser;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class NavigationHandlerImpl
extends NavigationHandler {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.application.NavigationHandlerImpl";
    private Map caseListMap;
    private Set wildCardSet;
    boolean associateSet;
    private ApplicationAssociate associate = null;

    public NavigationHandlerImpl() {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "NavigationHandlerImpl", "Created NavigationHandler instance ");
        }
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        applicationFactory.getApplication();
        this.associate = ApplicationAssociate.getInstance(FacesConfigParser.getExternalContextDuringInitialize());
        if (this.associate != null) {
            this.caseListMap = this.associate.getNavigationCaseListMappings();
            this.wildCardSet = this.associate.getNavigationWildCardList();
            this.associateSet = true;
        }
    }

    public void handleNavigation(FacesContext facesContext, String string, String string2) {
        if (facesContext == null) {
            String string3 = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            string3 = string3 + " context " + facesContext;
            throw new NullPointerException(string3);
        }
        if (string2 == null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "No navigation rule found for outcome " + string2 + "and viewId " + facesContext.getViewRoot().getViewId() + " Explicitly remain on the current view ");
            }
            return;
        }
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (caseStruct != null) {
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            if (caseStruct.navCase.hasRedirect()) {
                String string4 = viewHandler.getActionURL(facesContext, caseStruct.viewId);
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "Redirecting to path " + string4 + " for outcome " + string2 + "and viewId " + caseStruct.viewId);
                    }
                    externalContext.redirect(string4);
                }
                catch (IOException iOException) {
                    String string5 = "Redirect to " + string4 + " failed.";
                    if (log.isLoggable(Level.SEVERE)) {
                        log.logp(Level.SEVERE, CLASS_NAME, "handleNavigation", string5);
                    }
                    throw new FacesException(string5, iOException);
                }
                facesContext.responseComplete();
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot uIViewRoot = viewHandler.createView(facesContext, caseStruct.viewId);
                facesContext.setViewRoot(uIViewRoot);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "handleNavigation", "Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private CaseStruct getViewId(FacesContext facesContext, String string, String string2) {
        String string3 = facesContext.getViewRoot().getViewId();
        CaseStruct caseStruct = this.findExactMatch(string3, string, string2);
        if (caseStruct == null) {
            caseStruct = this.findWildCardMatch(string3, string, string2);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(string, string2);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(String string, String string2, String string3) {
        if (!this.associateSet) {
            return null;
        }
        List list = (List)this.caseListMap.get(string);
        if (list == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(list, string2, string3);
    }

    private CaseStruct findWildCardMatch(String string, String string2, String string3) {
        CaseStruct caseStruct = null;
        if (!this.associateSet) {
            return null;
        }
        Iterator iterator = this.wildCardSet.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (string.indexOf(string4, 0) == -1) continue;
            String string5 = string4 + "*";
            List list = (List)this.caseListMap.get(string5);
            if (list == null) {
                return null;
            }
            caseStruct = this.determineViewFromActionOutcome(list, string2, string3);
            if (caseStruct == null) continue;
            break;
        }
        return caseStruct;
    }

    private CaseStruct findDefaultMatch(String string, String string2) {
        if (!this.associateSet) {
            return null;
        }
        List list = (List)this.caseListMap.get("*");
        if (list == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(list, string, string2);
    }

    private CaseStruct determineViewFromActionOutcome(List list, String string, String string2) {
        CaseStruct caseStruct = new CaseStruct();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ConfigNavigationCase configNavigationCase = (ConfigNavigationCase)list.get(i);
            String string3 = configNavigationCase.getFromAction();
            String string4 = configNavigationCase.getFromOutcome();
            String string5 = configNavigationCase.getToViewId();
            if (string3 != null && string4 != null && string3.equals(string) && string4.equals(string2)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = configNavigationCase;
                return caseStruct;
            }
            if ((string3 == null || "*".equals(string3)) && string4 != null && string4.equals(string2)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = configNavigationCase;
                return caseStruct;
            }
            if (string3 != null && (string4 == null || "*".equals(string4)) && string3.equals(string)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = configNavigationCase;
                return caseStruct;
            }
            if (string3 != null && !"*".equals(string3) || string4 != null && !"*".equals(string4)) continue;
            caseStruct.viewId = string5;
            caseStruct.navCase = configNavigationCase;
            return caseStruct;
        }
        return null;
    }

    private static class CaseStruct {
        String viewId;
        ConfigNavigationCase navCase;

        private CaseStruct() {
        }
    }
}

