/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class StateManagerImpl
extends StateManager {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.application.StateManagerImpl";
    private static final String NUMBER_OF_VIEWS_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 15;
    private static final String FACES_VIEW_LIST = "com.sun.faces.VIEW_LIST";
    private static final String ENABLE_HA_PARAM = "enableHighAvailability";
    private static final String JSF_ENABLE_HA_PARAM = "com.sun.faces.enableHighAvailability";
    private static final String APPSERVER_ENABLE_HA_PARAM = "com.sun.appserver.enableHighAvailability";
    int noOfViews = 0;
    private Boolean haStateSavingSet = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) throws IllegalStateException {
        StateManager.SerializedView serializedView = null;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot.isTransient()) {
            return serializedView;
        }
        this.removeTransientChildrenAndFacets(facesContext, uIViewRoot, new HashSet());
        if (!this.isSavingStateInClient(facesContext)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "Saving view in session for viewId " + uIViewRoot.getViewId());
            }
            Map map = Util.getSessionMap(facesContext);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                ArrayList<String> arrayList = (ArrayList<String>)map.get(FACES_VIEW_LIST);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                } else {
                    this.removeViewFromSession(facesContext, uIViewRoot);
                }
                if (arrayList.contains(uIViewRoot.getViewId())) {
                    arrayList.remove(uIViewRoot.getViewId());
                }
                arrayList.add(uIViewRoot.getViewId());
                map.put(FACES_VIEW_LIST, arrayList);
                if (this.isHAStateSavingSet(facesContext)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "Highly Available state saving option enabled ");
                        log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "Highly Available state saving option enabledBegin creating serialized view for " + uIViewRoot.getViewId());
                    }
                    serializedView = new StateManager.SerializedView(this, this.getTreeStructureToSave(facesContext), this.getComponentStateToSave(facesContext));
                    Object[] objectArray = new Object[]{this.getTreeStructureToSave(facesContext), this.getComponentStateToSave(facesContext)};
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "End creating serialized view " + uIViewRoot.getViewId());
                        log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "StateArray is = [" + objectArray + "]");
                        log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "StateArray[0] is = [" + objectArray[0] + "]");
                        log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "StateArray[1] is = [" + objectArray[1] + "]");
                    }
                    map.put(uIViewRoot.getViewId(), objectArray);
                } else {
                    map.put(uIViewRoot.getViewId(), uIViewRoot);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "End saving view in session for viewId " + uIViewRoot.getViewId());
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "Begin creating serialized view for " + uIViewRoot.getViewId());
            }
            serializedView = new StateManager.SerializedView(this, this.getTreeStructureToSave(facesContext), this.getComponentStateToSave(facesContext));
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "End creating serialized view " + uIViewRoot.getViewId());
            }
        }
        return serializedView;
    }

    protected void removeTransientChildrenAndFacets(FacesContext facesContext, UIComponent uIComponent, Set set) throws IllegalStateException {
        String string;
        UIComponent uIComponent2;
        Iterator<Object> iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            uIComponent2 = (UIComponent)iterator.next();
            string = uIComponent2.getClientId(facesContext);
            if (string != null && !set.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (uIComponent2.isTransient()) {
                iterator.remove();
                continue;
            }
            this.removeTransientChildrenAndFacets(facesContext, uIComponent2, set);
        }
        iterator = uIComponent.getFacets().values().iterator();
        while (iterator.hasNext()) {
            uIComponent2 = (UIComponent)iterator.next();
            string = uIComponent2.getClientId(facesContext);
            if (string != null && !set.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (uIComponent2.isTransient()) {
                iterator.remove();
                continue;
            }
            this.removeTransientChildrenAndFacets(facesContext, uIComponent2, set);
        }
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        return uIViewRoot.processSaveState(facesContext);
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        TreeStructure treeStructure = null;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (!uIViewRoot.isTransient()) {
            treeStructure = new TreeStructure(uIViewRoot);
            this.buildTreeStructureToSave(facesContext, uIViewRoot, treeStructure, null);
        }
        return treeStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        if (null == string2) {
            String string3 = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            string3 = string3 + " renderKitId " + string2;
            throw new IllegalArgumentException(string3);
        }
        UIViewRoot uIViewRoot = null;
        if (this.isSavingStateInClient(facesContext)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "Begin restoring view from response " + string);
            }
            if ((uIViewRoot = this.restoreTreeStructure(facesContext, string, string2)) != null) {
                this.restoreComponentState(facesContext, uIViewRoot, string2);
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "Possibly a new request. Tree structure could not be restored for " + string);
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "End restoring view from response " + string);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "Begin restoring view in session for viewId " + string);
            }
            Map map = Util.getSessionMap(facesContext);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                if (this.isHAStateSavingSet(facesContext)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "restoreView", "High available state saving option enabled");
                        log.logp(Level.FINE, CLASS_NAME, "restoreView", "Begin restoring serialized view for " + string);
                    }
                    Object[] objectArray = (Object[])map.get(string);
                    StateManager.SerializedView serializedView = null;
                    if (objectArray != null) {
                        serializedView = new StateManager.SerializedView(this, objectArray[0], objectArray[1]);
                    }
                    uIViewRoot = this.restoreSerializedView(facesContext, serializedView, string);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "restoreView", "End restoring serialized view " + string);
                    }
                } else {
                    uIViewRoot = (UIViewRoot)map.get(string);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "restoreView", "Restoring view from session for viewId " + string);
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "End restoring view in session for viewId " + string);
            }
        }
        return uIViewRoot;
    }

    private void removeViewFromSession(FacesContext facesContext, UIViewRoot uIViewRoot) {
        String string;
        ArrayList arrayList;
        Map map;
        block7: {
            map = Util.getSessionMap(facesContext);
            arrayList = (ArrayList)map.get(FACES_VIEW_LIST);
            if (arrayList == null) {
                return;
            }
            if (this.noOfViews == 0) {
                this.noOfViews = 15;
                string = facesContext.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_SESSION);
                if (string != null) {
                    try {
                        this.noOfViews = Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.noOfViews = 15;
                        if (!log.isLoggable(Level.FINE)) break block7;
                        log.logp(Level.FINE, CLASS_NAME, "removeViewFromSession", "Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION. Using the default " + this.noOfViews);
                    }
                }
            }
        }
        if (arrayList.size() > this.noOfViews) {
            string = (String)arrayList.remove(0);
            map.remove(string);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "removeViewFromSession", "Number of views in session exceeded specified number " + this.noOfViews + ".Removing view " + string);
            }
        }
    }

    protected void restoreComponentState(FacesContext facesContext, UIViewRoot uIViewRoot, String string) {
        if (null == string) {
            String string2 = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            string2 = string2 + " renderKitId " + string;
            throw new IllegalArgumentException(string2);
        }
        Object object = Util.getResponseStateManager(facesContext, string).getComponentStateToRestore(facesContext);
        uIViewRoot.processRestoreState(facesContext, object);
    }

    protected UIViewRoot restoreTreeStructure(FacesContext facesContext, String string, String string2) {
        if (null == string2) {
            String string3 = Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR");
            string3 = string3 + " renderKitId " + string2;
            throw new IllegalArgumentException(string3);
        }
        UIComponent uIComponent = null;
        TreeStructure treeStructure = null;
        treeStructure = (TreeStructure)Util.getResponseStateManager(facesContext, string2).getTreeStructureToRestore(facesContext, string);
        if (treeStructure == null) {
            return null;
        }
        uIComponent = treeStructure.createComponent();
        this.restoreComponentTreeStructure(treeStructure, uIComponent);
        return (UIViewRoot)uIComponent;
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (this.isSavingStateInClient(facesContext)) {
            Util.getResponseStateManager(facesContext, facesContext.getViewRoot().getRenderKitId()).writeState(facesContext, serializedView);
        }
    }

    public void buildTreeStructureToSave(FacesContext facesContext, UIComponent uIComponent, TreeStructure treeStructure, Set hashSet) {
        Object object;
        String string;
        Object object2;
        if (null == hashSet) {
            hashSet = new HashSet<String>();
        }
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            object2 = (UIComponent)iterator.next();
            string = ((UIComponent)object2).getClientId(facesContext);
            if (string != null && !hashSet.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (object2.isTransient()) continue;
            object = new TreeStructure((UIComponent)object2);
            treeStructure.addChild((TreeStructure)object);
            this.buildTreeStructureToSave(facesContext, (UIComponent)object2, (TreeStructure)object, hashSet);
        }
        object2 = uIComponent.getFacets().keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            UIComponent uIComponent2 = (UIComponent)uIComponent.getFacets().get(object);
            string = uIComponent2.getClientId(facesContext);
            if (string != null && !hashSet.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (uIComponent2.isTransient()) continue;
            TreeStructure treeStructure2 = new TreeStructure(uIComponent2);
            treeStructure.addFacet((String)object, treeStructure2);
            this.buildTreeStructureToSave(facesContext, uIComponent2, treeStructure2, hashSet);
        }
    }

    public void restoreComponentTreeStructure(TreeStructure treeStructure, UIComponent uIComponent) {
        Object object;
        Object object2;
        Iterator iterator = treeStructure.getChildren();
        while (iterator.hasNext()) {
            object2 = (TreeStructure)iterator.next();
            object = ((TreeStructure)object2).createComponent();
            uIComponent.getChildren().add(object);
            this.restoreComponentTreeStructure((TreeStructure)object2, (UIComponent)object);
        }
        object2 = treeStructure.getFacetNames();
        while (object2.hasNext()) {
            object = (String)object2.next();
            TreeStructure treeStructure2 = treeStructure.getTreeStructureForFacet((String)object);
            UIComponent uIComponent2 = treeStructure2.createComponent();
            uIComponent.getFacets().put(object, uIComponent2);
            this.restoreComponentTreeStructure(treeStructure2, uIComponent2);
        }
    }

    protected boolean isHAStateSavingSet(FacesContext facesContext) {
        if (null != this.haStateSavingSet) {
            return this.haStateSavingSet;
        }
        this.haStateSavingSet = Boolean.FALSE;
        String string = facesContext.getExternalContext().getInitParameter(JSF_ENABLE_HA_PARAM);
        if (string != null) {
            this.haStateSavingSet = Boolean.valueOf(string);
        } else {
            string = facesContext.getExternalContext().getInitParameter(APPSERVER_ENABLE_HA_PARAM);
            if (string != null) {
                this.haStateSavingSet = Boolean.valueOf(string);
            }
        }
        return this.haStateSavingSet;
    }

    protected UIViewRoot restoreSerializedView(FacesContext facesContext, StateManager.SerializedView serializedView, String string) {
        if (serializedView == null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreSerializedView", "Possibly a new request. Tree structure could not  be restored for " + string);
            }
            return null;
        }
        TreeStructure treeStructure = (TreeStructure)serializedView.getStructure();
        if (treeStructure == null) {
            return null;
        }
        UIComponent uIComponent = treeStructure.createComponent();
        if (uIComponent != null) {
            this.restoreComponentTreeStructure(treeStructure, uIComponent);
            Object object = serializedView.getState();
            uIComponent.processRestoreState(facesContext, object);
        }
        return (UIViewRoot)uIComponent;
    }
}

