/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.RIConstants;
import com.sun.faces.context.ApplicationMap;
import com.sun.faces.context.InitParameterMap;
import com.sun.faces.context.MyHttpServletRequestWrapper;
import com.sun.faces.context.MyServletRequestWrapper;
import com.sun.faces.context.RequestCookieMap;
import com.sun.faces.context.RequestHeaderMap;
import com.sun.faces.context.RequestHeaderValuesMap;
import com.sun.faces.context.RequestMap;
import com.sun.faces.context.RequestParameterMap;
import com.sun.faces.context.RequestParameterValuesMap;
import com.sun.faces.context.SessionMap;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExternalContextImpl
extends ExternalContext {
    private ServletContext servletContext = null;
    private ServletRequest request = null;
    private ServletResponse response = null;
    private ApplicationMap applicationMap = null;
    private SessionMap sessionMap = null;
    private RequestMap requestMap = null;
    private RequestParameterMap requestParameterMap = null;
    private RequestParameterValuesMap requestParameterValuesMap = null;
    private RequestHeaderMap requestHeaderMap = null;
    private RequestHeaderValuesMap requestHeaderValuesMap = null;
    private RequestCookieMap cookieMap = null;
    private InitParameterMap initParameterMap = null;

    public ExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        try {
            Util.parameterNonNull(servletContext);
            Util.parameterNonNull(servletRequest);
            Util.parameterNonNull(servletResponse);
        }
        catch (Exception exception) {
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.FACES_CONTEXT_CONSTRUCTION_ERROR"));
        }
        this.servletContext = servletContext;
        this.request = RIConstants.IS_UNIT_TEST_MODE ? servletRequest : (servletRequest instanceof HttpServletRequest ? new MyHttpServletRequestWrapper((HttpServletRequest)servletRequest) : new MyServletRequestWrapper(servletRequest));
        this.response = servletResponse;
    }

    public Object getSession(boolean bl) {
        return ((HttpServletRequest)this.request).getSession(bl);
    }

    public Object getContext() {
        return this.servletContext;
    }

    public Object getRequest() {
        return this.request;
    }

    public Object getResponse() {
        return this.response;
    }

    public Map getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.servletContext);
        }
        return this.applicationMap;
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap((HttpServletRequest)this.request);
        }
        return this.sessionMap;
    }

    public Map getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map getRequestHeaderMap() {
        if (null == this.requestHeaderMap) {
            this.requestHeaderMap = new RequestHeaderMap((HttpServletRequest)this.request);
        }
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (null == this.requestHeaderValuesMap) {
            this.requestHeaderValuesMap = new RequestHeaderValuesMap((HttpServletRequest)this.request);
        }
        return this.requestHeaderValuesMap;
    }

    public Map getRequestCookieMap() {
        if (null == this.cookieMap) {
            this.cookieMap = new RequestCookieMap((HttpServletRequest)this.request);
        }
        return this.cookieMap;
    }

    public Map getInitParameterMap() {
        if (null == this.initParameterMap) {
            this.initParameterMap = new InitParameterMap(this.servletContext);
        }
        return this.initParameterMap;
    }

    public Map getRequestParameterMap() {
        if (null == this.requestParameterMap) {
            this.requestParameterMap = new RequestParameterMap(this.request);
        }
        return this.requestParameterMap;
    }

    public Map getRequestParameterValuesMap() {
        if (null == this.requestParameterValuesMap) {
            this.requestParameterValuesMap = new RequestParameterValuesMap(this.request);
        }
        return this.requestParameterValuesMap;
    }

    public Iterator getRequestParameterNames() {
        final Enumeration enumeration = this.request.getParameterNames();
        Iterator iterator = new Iterator(){

            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return enumeration.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return iterator;
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator getRequestLocales() {
        return new LocalesIterator(this.request.getLocales());
    }

    public String getRequestPathInfo() {
        return ((HttpServletRequest)this.request).getPathInfo();
    }

    public Cookie[] getRequestCookies() {
        return ((HttpServletRequest)this.request).getCookies();
    }

    public String getRequestContextPath() {
        return ((HttpServletRequest)this.request).getContextPath();
    }

    public String getRequestServletPath() {
        return ((HttpServletRequest)this.request).getServletPath();
    }

    public String getInitParameter(String string) {
        return this.servletContext.getInitParameter(string);
    }

    public Set getResourcePaths(String string) {
        return this.servletContext.getResourcePaths(string);
    }

    public InputStream getResourceAsStream(String string) {
        return this.servletContext.getResourceAsStream(string);
    }

    public URL getResource(String string) {
        URL uRL = null;
        try {
            uRL = this.servletContext.getResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return uRL;
    }

    public String encodeActionURL(String string) {
        return ((HttpServletResponse)this.response).encodeURL(string);
    }

    public String encodeResourceURL(String string) {
        return ((HttpServletResponse)this.response).encodeURL(string);
    }

    public String encodeNamespace(String string) {
        return string;
    }

    public String encodeURL(String string) {
        return ((HttpServletResponse)this.response).encodeURL(string);
    }

    public void dispatch(String string) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(string);
        try {
            requestDispatcher.forward(this.request, this.response);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            throw new FacesException(servletException);
        }
    }

    public void redirect(String string) throws IOException {
        ((HttpServletResponse)this.response).sendRedirect(string);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public void log(String string) {
        this.servletContext.log(string);
    }

    public void log(String string, Throwable throwable) {
        this.servletContext.log(string, throwable);
    }

    public String getAuthType() {
        return ((HttpServletRequest)this.request).getAuthType();
    }

    public String getRemoteUser() {
        return ((HttpServletRequest)this.request).getRemoteUser();
    }

    public Principal getUserPrincipal() {
        return ((HttpServletRequest)this.request).getUserPrincipal();
    }

    public boolean isUserInRole(String string) {
        return ((HttpServletRequest)this.request).isUserInRole(string);
    }

    private class LocalesIterator
    implements Iterator {
        private Enumeration locales;

        public LocalesIterator(Enumeration enumeration) {
            this.locales = enumeration;
        }

        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        public Object next() {
            return this.locales.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

