/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;

public class MixedELValueParser {
    private boolean inExpr = false;
    private boolean inLiteral = false;
    private char literalDelimiter = (char)34;
    private StringBuffer sb = new StringBuffer();
    private int currentPosition = 0;
    private String exprString;

    public MixedELValueParser() {
    }

    public MixedELValueParser(String string) {
        this.exprString = string;
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("#{foo}");
        arrayList.add("foo#{foo}bar");
        arrayList.add("foo\\#{foo}");
        arrayList.add("foo#{foo = '#{foo}'}");
        arrayList.add("foo#{foo = '\\'#{foo}'}");
        arrayList.add("foo#{foo = \"\\\"#{foo}\"}");
        arrayList.add("foo's#{bar}");
        arrayList.add("foo#{bar");
        arrayList.add("foo#{bar}#{baz}");
        arrayList.add("foo#{bar}{baz}");
        arrayList.add("foo#{'}'}");
        arrayList.add("foo#{'}'");
        Iterator iterator = arrayList.iterator();
        block2: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println("Parsing " + string);
            MixedELValueParser mixedELValueParser = new MixedELValueParser(string);
            boolean bl = false;
            System.out.println("Result:");
            while (!bl) {
                Token token = null;
                try {
                    token = mixedELValueParser.getNextToken();
                }
                catch (ElException elException) {
                    System.out.println("  Exception: " + elException);
                    continue block2;
                }
                if (token == null) {
                    bl = true;
                    continue;
                }
                if (token instanceof ExprToken) {
                    System.out.println("  Expression: " + token.getValue());
                    continue;
                }
                System.out.println("  Literal: " + token.getValue());
            }
        }
    }

    public List parse(FacesContext facesContext, String string) throws ElException {
        this.exprString = string;
        this.inExpr = false;
        this.inLiteral = false;
        this.sb = new StringBuffer();
        this.currentPosition = 0;
        boolean bl = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!bl) {
            Token token = this.getNextToken();
            if (token == null) {
                bl = true;
                continue;
            }
            if (token instanceof ExprToken) {
                arrayList.add(MixedELValueParser.toExpression(facesContext, token.getValue()));
                continue;
            }
            arrayList.add(token.getValue());
        }
        return arrayList;
    }

    private Token getNextToken() throws ElException {
        int n;
        Token token = null;
        for (n = this.currentPosition; n < this.exprString.length(); ++n) {
            char c = this.exprString.charAt(n);
            if (!(this.inLiteral || c != '#' || n != 0 && this.exprString.charAt(n - 1) == '\\' || n + 1 >= this.exprString.length() || this.exprString.charAt(n + 1) != '{')) {
                this.inExpr = true;
                ++n;
                if (this.sb.length() <= 0) continue;
                token = new Token(this.sb.toString());
                this.sb = new StringBuffer();
                this.currentPosition = n + 1;
                return token;
            }
            if (!this.inLiteral && this.inExpr && c == '}') {
                this.inExpr = false;
                token = new ExprToken(this.sb.toString());
                this.sb = new StringBuffer();
                this.currentPosition = n + 1;
                return token;
            }
            if (this.inExpr && (c == '\'' || c == '\"') && n > 0 && this.exprString.charAt(n - 1) != '\\') {
                if (this.inLiteral && c == this.literalDelimiter) {
                    this.inLiteral = false;
                } else if (!this.inLiteral) {
                    this.inLiteral = true;
                    this.literalDelimiter = c;
                }
                this.sb.append(c);
                continue;
            }
            this.sb.append(c);
        }
        if (this.sb.length() > 0) {
            if (this.inExpr) {
                throw new ElException("Missing closing delimiter: " + this.exprString);
            }
            token = new Token(this.sb.toString());
            this.sb = new StringBuffer();
            this.currentPosition = n + 1;
            return token;
        }
        return null;
    }

    private static Expression toExpression(FacesContext facesContext, String string) throws ElException {
        Application application = facesContext.getApplication();
        ExpressionInfo expressionInfo = new ExpressionInfo();
        expressionInfo.setExpressionString(string);
        expressionInfo.setFacesContext(facesContext);
        expressionInfo.setVariableResolver(application.getVariableResolver());
        expressionInfo.setPropertyResolver(application.getPropertyResolver());
        return Util.getExpressionEvaluator().parseExpression(expressionInfo);
    }

    private static class ExprToken
    extends Token {
        public ExprToken(String string) {
            super(string);
        }
    }

    private static class Token {
        String value;

        public Token(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

