/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.util.Util;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;

public class ValueBindingImpl
extends ValueBinding
implements StateHolder {
    private static final String[] FACES_IMPLICIT_OBJECTS = new String[]{"applicationScope", "sessionScope", "requestScope", "facesContext", "cookies", "header", "headerValues", "initParam", "param", "paramValues", "view"};
    private static final Logger log;
    private static final String CLASS_NAME = "com.sun.faces.el.ValueBindingImpl";
    protected String ref;
    protected String exprString;
    protected ExpressionInfo exprInfo = new ExpressionInfo();
    private boolean isTransient = false;

    public ValueBindingImpl() {
    }

    public ValueBindingImpl(Application application) {
        Util.parameterNonNull(application);
        this.exprInfo.setVariableResolver(application.getVariableResolver());
        this.exprInfo.setPropertyResolver(application.getPropertyResolver());
    }

    public void setRef(String string) {
        Util.parameterNonEmpty(string);
        this.ref = string;
        this.exprString = ValueBindingImpl.getExprString(string);
    }

    public Object getValue(FacesContext facesContext) throws EvaluationException, PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue(ref=" + this.ref + ")");
        }
        Object object = this.getValue(facesContext, this.ref);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "getValue", "-->Returning " + object);
        }
        return object;
    }

    protected Object getValue(FacesContext facesContext, String string) throws EvaluationException, PropertyNotFoundException {
        Object object;
        try {
            this.exprInfo.setExpressionString(string);
            this.exprInfo.setExpectedType(Object.class);
            this.exprInfo.setFacesContext(facesContext);
            object = Util.getExpressionEvaluator().evaluate(this.exprInfo);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Result:" + object);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getValue", "getValue Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
        return object;
    }

    public void setValue(FacesContext facesContext, Object object) throws EvaluationException, PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        if (this.isReservedIdentifier(this.ref)) {
            throw new ReferenceSyntaxException(Util.getExceptionMessageString("com.sun.faces.ILLEGAL_IDENTIFIER_LVALUE_MODE", new Object[]{this.ref}));
        }
        try {
            this.exprInfo.setExpressionString(this.ref);
            this.exprInfo.setFacesContext(facesContext);
            Expression expression = Util.getExpressionEvaluator().parseExpression(this.exprInfo);
            expression.setValue(this.exprInfo, object);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (throwable instanceof EvaluationException) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable);
                }
                throw (EvaluationException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "setValue", "setValue Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
    }

    public boolean isReadOnly(FacesContext facesContext) throws PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        try {
            this.exprInfo.setExpressionString(this.ref);
            this.exprInfo.setFacesContext(facesContext);
            Expression expression = Util.getExpressionEvaluator().parseExpression(this.exprInfo);
            return expression.isReadOnly(this.exprInfo);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "isReadOnly", "isReadOnly Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "isReadOnly", "isReadOnly Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "isReadOnly", "isReadOnly Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
    }

    public Class getType(FacesContext facesContext) throws PropertyNotFoundException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        try {
            this.exprInfo.setExpressionString(this.ref);
            this.exprInfo.setFacesContext(facesContext);
            Expression expression = Util.getExpressionEvaluator().parseExpression(this.exprInfo);
            return expression.getType(this.exprInfo);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ElException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable2 = throwable;
                    Throwable throwable3 = ((ElException)throwable).getCause();
                    if (throwable3 != null) {
                        throwable2 = throwable3;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getType", "getType Evaluation threw exception:", throwable2);
                }
                throw new EvaluationException(throwable);
            }
            if (throwable instanceof PropertyNotFoundException) {
                if (log.isLoggable(Level.FINE)) {
                    Throwable throwable4 = throwable;
                    Throwable throwable5 = ((PropertyNotFoundException)throwable).getCause();
                    if (throwable5 != null) {
                        throwable4 = throwable5;
                    }
                    log.logp(Level.FINE, CLASS_NAME, "getType", "getType Evaluation threw exception:", throwable4);
                }
                throw (PropertyNotFoundException)throwable;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getType", "getType Evaluation threw exception:", throwable);
            }
            throw new EvaluationException(throwable);
        }
    }

    public String getExpressionString() {
        return this.exprString;
    }

    private boolean isReservedIdentifier(String string) {
        return Arrays.binarySearch(FACES_IMPLICIT_OBJECTS, string) >= 0;
    }

    public Object saveState(FacesContext facesContext) {
        return this.ref;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.ref = object.toString();
        this.exprString = ValueBindingImpl.getExprString(this.ref);
        Application application = facesContext.getApplication();
        this.exprInfo.setPropertyResolver(application.getPropertyResolver());
        this.exprInfo.setVariableResolver(application.getVariableResolver());
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    private static String getExprString(String string) {
        return "#{" + string + "}";
    }

    static {
        Arrays.sort(FACES_IMPLICIT_OBJECTS);
        log = Logger.getLogger("com.ibm.ws.jsf");
    }
}

