/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.ValueSuffix;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;

public class ArraySuffix
extends ValueSuffix {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.ArraySuffix";
    static Object[] sNoArgs = new Object[0];
    Expression mIndex;

    public Expression getIndex() {
        return this.mIndex;
    }

    public void setIndex(Expression expression) {
        this.mIndex = expression;
    }

    public ArraySuffix(Expression expression) {
        this.mIndex = expression;
    }

    protected Object evaluateIndex(ExpressionInfo expressionInfo) throws ElException {
        return this.mIndex.evaluate(expressionInfo);
    }

    protected String getOperatorSymbol() {
        return "[]";
    }

    public String getExpressionString() {
        return "[" + this.mIndex.getExpressionString() + "]";
    }

    public Object evaluate(Object object, ExpressionInfo expressionInfo) throws ElException {
        PropertyResolver propertyResolver = expressionInfo.getPropertyResolver();
        Object object2 = this.evaluateIndex(expressionInfo);
        if (object != null && object2 != null && (object instanceof List || object.getClass().isArray())) {
            Integer n = Coercions.coerceToInteger(object2);
            if (n == null) {
                String string = MessageUtil.getMessageWithArgs(Constants.BAD_INDEX_VALUE, this.getOperatorSymbol(), object2.getClass().getName());
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "evaluate", string);
                }
                throw new ReferenceSyntaxException(string);
            }
            return propertyResolver.getValue(object, n);
        }
        return propertyResolver.getValue(object, object2);
    }

    public void setValue(Object object, Object object2, ExpressionInfo expressionInfo) throws ElException {
        PropertyResolver propertyResolver = expressionInfo.getPropertyResolver();
        Object object3 = this.evaluateIndex(expressionInfo);
        if (object != null && object3 != null && (object instanceof List || object.getClass().isArray())) {
            Integer n = Coercions.coerceToInteger(object3);
            if (n == null) {
                String string = MessageUtil.getMessageWithArgs(Constants.BAD_INDEX_VALUE, this.getOperatorSymbol(), object3.getClass().getName());
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "setValue", string);
                }
                throw new ReferenceSyntaxException(string);
            }
            propertyResolver.setValue(object, n, object2);
        } else {
            propertyResolver.setValue(object, object3, object2);
        }
    }

    public boolean isReadOnly(Object object, ExpressionInfo expressionInfo) throws ElException {
        PropertyResolver propertyResolver = expressionInfo.getPropertyResolver();
        Object object2 = this.evaluateIndex(expressionInfo);
        if (object != null && object2 != null && (object instanceof List || object.getClass().isArray())) {
            Integer n = Coercions.coerceToInteger(object2);
            if (n == null) {
                String string = MessageUtil.getMessageWithArgs(Constants.BAD_INDEX_VALUE, this.getOperatorSymbol(), object2.getClass().getName());
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "isReadOnly", string);
                }
                throw new ReferenceSyntaxException(string);
            }
            return propertyResolver.isReadOnly(object, n);
        }
        return propertyResolver.isReadOnly(object, object2);
    }

    public Class getType(Object object, ExpressionInfo expressionInfo) throws ElException {
        PropertyResolver propertyResolver = expressionInfo.getPropertyResolver();
        Object object2 = this.evaluateIndex(expressionInfo);
        if (object != null && object2 != null && (object instanceof List || object.getClass().isArray())) {
            Integer n = Coercions.coerceToInteger(object2);
            if (n == null) {
                String string = MessageUtil.getMessageWithArgs(Constants.BAD_INDEX_VALUE, this.getOperatorSymbol(), object2.getClass().getName());
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "getType", string);
                }
                throw new ReferenceSyntaxException(string);
            }
            return propertyResolver.getType(object, n);
        }
        return propertyResolver.getType(object, object2);
    }
}

