/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BeanInfoIndexedProperty;
import com.sun.faces.el.impl.BeanInfoProperty;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanInfoManager {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.BeanInfoManager";
    Class mBeanClass;
    BeanInfo mBeanInfo;
    Map mPropertyByName;
    Map mIndexedPropertyByName;
    Map mEventSetByName;
    boolean mInitialized;
    static Map mBeanInfoManagerByClass = new HashMap();

    public Class getBeanClass() {
        return this.mBeanClass;
    }

    BeanInfoManager(Class clazz) {
        this.mBeanClass = clazz;
    }

    public static BeanInfoManager getBeanInfoManager(Class clazz) {
        BeanInfoManager beanInfoManager = (BeanInfoManager)mBeanInfoManagerByClass.get(clazz);
        if (beanInfoManager == null) {
            beanInfoManager = BeanInfoManager.createBeanInfoManager(clazz);
        }
        return beanInfoManager;
    }

    static synchronized BeanInfoManager createBeanInfoManager(Class clazz) {
        BeanInfoManager beanInfoManager = (BeanInfoManager)mBeanInfoManagerByClass.get(clazz);
        if (beanInfoManager == null) {
            beanInfoManager = new BeanInfoManager(clazz);
            mBeanInfoManagerByClass.put(clazz, beanInfoManager);
        }
        return beanInfoManager;
    }

    public static BeanInfoProperty getBeanInfoProperty(Class clazz, String string) throws ElException {
        return BeanInfoManager.getBeanInfoManager(clazz).getProperty(string);
    }

    public static BeanInfoIndexedProperty getBeanInfoIndexedProperty(Class clazz, String string) throws ElException {
        return BeanInfoManager.getBeanInfoManager(clazz).getIndexedProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialized() throws ElException {
        if (!this.mInitialized) {
            BeanInfoManager beanInfoManager = this;
            synchronized (beanInfoManager) {
                if (!this.mInitialized) {
                    this.initialize();
                    this.mInitialized = true;
                }
            }
        }
    }

    void initialize() throws ElException {
        block5: {
            try {
                Object object;
                this.mBeanInfo = Introspector.getBeanInfo(this.mBeanClass);
                this.mPropertyByName = new HashMap();
                this.mIndexedPropertyByName = new HashMap();
                PropertyDescriptor[] propertyDescriptorArray = this.mBeanInfo.getPropertyDescriptors();
                for (int i = 0; propertyDescriptorArray != null && i < propertyDescriptorArray.length; ++i) {
                    Object object2;
                    Method method;
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                    if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
                        object = (IndexedPropertyDescriptor)propertyDescriptor;
                        method = BeanInfoManager.getPublicMethod(((IndexedPropertyDescriptor)object).getIndexedReadMethod());
                        object2 = BeanInfoManager.getPublicMethod(((IndexedPropertyDescriptor)object).getIndexedWriteMethod());
                        BeanInfoIndexedProperty beanInfoIndexedProperty = new BeanInfoIndexedProperty(method, (Method)object2, (IndexedPropertyDescriptor)object);
                        this.mIndexedPropertyByName.put(((FeatureDescriptor)object).getName(), beanInfoIndexedProperty);
                    }
                    object = BeanInfoManager.getPublicMethod(propertyDescriptor.getReadMethod());
                    method = BeanInfoManager.getPublicMethod(propertyDescriptor.getWriteMethod());
                    object2 = new BeanInfoProperty((Method)object, method, propertyDescriptor);
                    this.mPropertyByName.put(propertyDescriptor.getName(), object2);
                }
                this.mEventSetByName = new HashMap();
                EventSetDescriptor[] eventSetDescriptorArray = this.mBeanInfo.getEventSetDescriptors();
                for (int i = 0; eventSetDescriptorArray != null && i < eventSetDescriptorArray.length; ++i) {
                    object = eventSetDescriptorArray[i];
                    this.mEventSetByName.put(((FeatureDescriptor)object).getName(), object);
                }
            }
            catch (IntrospectionException introspectionException) {
                if (!log.isLoggable(Level.WARNING)) break block5;
                log.logp(Level.WARNING, CLASS_NAME, "initialize", MessageUtil.getMessageWithArgs(Constants.EXCEPTION_GETTING_BEANINFO, this.mBeanClass.getName()), introspectionException);
            }
        }
    }

    BeanInfo getBeanInfo() throws ElException {
        this.checkInitialized();
        return this.mBeanInfo;
    }

    public BeanInfoProperty getProperty(String string) throws ElException {
        this.checkInitialized();
        return (BeanInfoProperty)this.mPropertyByName.get(string);
    }

    public BeanInfoIndexedProperty getIndexedProperty(String string) throws ElException {
        this.checkInitialized();
        return (BeanInfoIndexedProperty)this.mIndexedPropertyByName.get(string);
    }

    public EventSetDescriptor getEventSet(String string) throws ElException {
        this.checkInitialized();
        return (EventSetDescriptor)this.mEventSetByName.get(string);
    }

    static Method getPublicMethod(Method method) {
        if (method == null) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        Method method2 = BeanInfoManager.getPublicMethod(clazz, method);
        if (method2 != null) {
            return method2;
        }
        return method;
    }

    static Method getPublicMethod(Class clazz, Method method) {
        Method method2;
        Object object;
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                try {
                    object = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                }
                catch (AccessControlException accessControlException) {
                    object = clazz.getMethod(method.getName(), method.getParameterTypes());
                }
                if (Modifier.isPublic(object.getModifiers())) {
                    return object;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if ((object = clazz.getInterfaces()) != null) {
            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                Method method3 = BeanInfoManager.getPublicMethod(object[i], method);
                if (method3 == null) continue;
                return method3;
            }
        }
        if ((object = clazz.getSuperclass()) != null && (method2 = BeanInfoManager.getPublicMethod(object, method)) != null) {
            return method2;
        }
        return null;
    }

    public static synchronized void clearCacheByClassloader(ClassLoader classLoader) {
        Set set = mBeanInfoManagerByClass.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (clazz.getClassLoader() != classLoader) continue;
            iterator.remove();
        }
    }
}

