/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ArithmeticOperator;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.EqualityOperator;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.PrimitiveObjects;
import com.sun.faces.el.impl.RelationalOperator;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Coercions {
    private static final Number ZERO = new Integer(0);
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.Coercions";

    private Coercions() {
        throw new IllegalArgumentException("Instantiation of this class is not permitted");
    }

    public static Object coerce(Object object, Class clazz) throws ElException {
        if (clazz == String.class) {
            return Coercions.coerceToString(object);
        }
        if (Coercions.isNumberClass(clazz)) {
            return Coercions.coerceToPrimitiveNumber(object, clazz);
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return Coercions.coerceToCharacter(object);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Coercions.coerceToBoolean(object);
        }
        return Coercions.coerceToObject(object, clazz);
    }

    static boolean isNumberClass(Class clazz) {
        return clazz == Byte.class || clazz == Byte.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    public static String coerceToString(Object object) throws ElException {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.TOSTRING_EXCEPTION, object.getClass().getName());
                log.logp(Level.SEVERE, CLASS_NAME, "coerceToString", string, exception);
                throw new ElException(exception);
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object object, Class clazz) throws ElException {
        if (object == null || "".equals(object)) {
            return Coercions.coerceToPrimitiveNumber(ZERO, clazz);
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            return Coercions.coerceToPrimitiveNumber(new Short((short)c), clazz);
        }
        if (object instanceof Boolean) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.BOOLEAN_TO_NUMBER, object, clazz.getName());
                log.logp(Level.SEVERE, CLASS_NAME, "coerceToPrimitiveNumber", string);
                throw new ElException(string);
            }
            return Coercions.coerceToPrimitiveNumber(ZERO, clazz);
        }
        if (object.getClass() == clazz) {
            return (Number)object;
        }
        if (object instanceof Number) {
            return Coercions.coerceToPrimitiveNumber((Number)object, clazz);
        }
        if (object instanceof String) {
            try {
                return Coercions.coerceToPrimitiveNumber((String)object, clazz);
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string = MessageUtil.getMessageWithArgs(Constants.STRING_TO_NUMBER_EXCEPTION, (String)object, clazz.getName());
                    log.logp(Level.SEVERE, CLASS_NAME, "coerceToPrimitiveNumber", string);
                    throw new ElException(string);
                }
                return Coercions.coerceToPrimitiveNumber(ZERO, clazz);
            }
        }
        if (log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_NUMBER, object.getClass().getName(), clazz.getName());
            log.logp(Level.SEVERE, CLASS_NAME, "coerceToPrimitiveNumber", string);
            throw new ElException(string);
        }
        return Coercions.coerceToPrimitiveNumber(0L, clazz);
    }

    public static Integer coerceToInteger(Object object) throws ElException {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return PrimitiveObjects.getInteger(((Character)object).charValue());
        }
        if (object instanceof Boolean) {
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "coerceToInteger", MessageUtil.getMessageWithArgs(Constants.BOOLEAN_TO_NUMBER, object, Integer.class.getName()));
            }
            return PrimitiveObjects.getInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return PrimitiveObjects.getInteger(((Number)object).intValue());
        }
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "coerceToInteger", MessageUtil.getMessageWithArgs(Constants.STRING_TO_NUMBER_EXCEPTION, (String)object, Integer.class.getName()));
                }
                return null;
            }
        }
        if (log.isLoggable(Level.WARNING)) {
            log.logp(Level.WARNING, CLASS_NAME, "coerceToInteger", MessageUtil.getMessageWithArgs(Constants.COERCE_TO_NUMBER, object.getClass().getName(), Integer.class.getName()));
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long l, Class clazz) throws ElException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)l);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort((short)l);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)l);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong(l);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat(l);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(l);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double d, Class clazz) throws ElException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte((byte)d);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort((short)d);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger((int)d);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong((long)d);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat((float)d);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(d);
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number number, Class clazz) throws ElException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return PrimitiveObjects.getByte(number.byteValue());
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return PrimitiveObjects.getShort(number.shortValue());
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return PrimitiveObjects.getInteger(number.intValue());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return PrimitiveObjects.getLong(number.longValue());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return PrimitiveObjects.getFloat(number.floatValue());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return PrimitiveObjects.getDouble(number.doubleValue());
        }
        if (clazz == BigInteger.class) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (clazz == BigDecimal.class) {
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        return PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String string, Class clazz) throws ElException {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return Byte.valueOf(string);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return Short.valueOf(string);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.valueOf(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.valueOf(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(string);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.valueOf(string);
        }
        if (clazz == BigInteger.class) {
            return new BigInteger(string);
        }
        if (clazz == BigDecimal.class) {
            return new BigDecimal(string);
        }
        return PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object object) throws ElException {
        if (object == null || "".equals(object)) {
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Boolean) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.BOOLEAN_TO_CHARACTER, object);
                log.logp(Level.SEVERE, CLASS_NAME, "coerceToCharacter", string);
                throw new ElException(string);
            }
            return PrimitiveObjects.getCharacter('\u0000');
        }
        if (object instanceof Number) {
            return PrimitiveObjects.getCharacter((char)((Number)object).shortValue());
        }
        if (object instanceof String) {
            String string = (String)object;
            return PrimitiveObjects.getCharacter(string.charAt(0));
        }
        if (log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_CHARACTER, object.getClass().getName());
            log.logp(Level.SEVERE, CLASS_NAME, "coerceToCharacter", string);
            throw new ElException(string);
        }
        return PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object object) throws ElException {
        if (object == null || "".equals(object)) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Boolean.valueOf(string);
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string2 = MessageUtil.getMessageWithArgs(Constants.STRING_TO_BOOLEAN, (String)object);
                    log.logp(Level.SEVERE, CLASS_NAME, "coerceToBoolean", string2, exception);
                    throw new ElException(string2, exception);
                }
                return Boolean.FALSE;
            }
        }
        if (log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_BOOLEAN, object.getClass().getName());
            log.logp(Level.SEVERE, CLASS_NAME, "coerceToBoolean", string);
            throw new ElException(string);
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object object, Class clazz) throws ElException {
        if (object == null) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (object instanceof String) {
            String string = (String)object;
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
            if (propertyEditor == null) {
                if ("".equals(string)) {
                    return null;
                }
                if (log.isLoggable(Level.SEVERE)) {
                    String string2 = MessageUtil.getMessageWithArgs(Constants.NO_PROPERTY_EDITOR, string, clazz.getName());
                    log.logp(Level.SEVERE, CLASS_NAME, "coerceToObject", string2);
                    throw new ElException(string2);
                }
                return null;
            }
            try {
                propertyEditor.setAsText(string);
                return propertyEditor.getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("".equals(string)) {
                    return null;
                }
                if (log.isLoggable(Level.SEVERE)) {
                    String string3 = MessageUtil.getMessageWithArgs(Constants.PROPERTY_EDITOR_ERROR, object, clazz.getName());
                    log.logp(Level.SEVERE, CLASS_NAME, "coerceToObject", string3, illegalArgumentException);
                    throw new ElException(string3, illegalArgumentException);
                }
                return null;
            }
        }
        if (log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.COERCE_TO_OBJECT, object.getClass().getName(), clazz.getName());
            log.logp(Level.SEVERE, CLASS_NAME, "coerceToObject", string);
            throw new ElException(string);
        }
        return null;
    }

    public static Object applyArithmeticOperator(Object object, Object object2, ArithmeticOperator arithmeticOperator) throws ElException {
        if (object == null && object2 == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "applyArithmeticOperator", MessageUtil.getMessageWithArgs(Constants.ARITH_OP_NULL, arithmeticOperator.getOperatorSymbol()));
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(object) || Coercions.isBigDecimal(object2)) {
            BigDecimal bigDecimal = (BigDecimal)Coercions.coerceToPrimitiveNumber(object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)Coercions.coerceToPrimitiveNumber(object2, BigDecimal.class);
            return arithmeticOperator.apply(bigDecimal, bigDecimal2);
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2) || Coercions.isFloatingPointString(object) || Coercions.isFloatingPointString(object2)) {
            if (Coercions.isBigInteger(object) || Coercions.isBigInteger(object2)) {
                BigDecimal bigDecimal = (BigDecimal)Coercions.coerceToPrimitiveNumber(object, BigDecimal.class);
                BigDecimal bigDecimal3 = (BigDecimal)Coercions.coerceToPrimitiveNumber(object2, BigDecimal.class);
                return arithmeticOperator.apply(bigDecimal, bigDecimal3);
            }
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class).doubleValue();
            return PrimitiveObjects.getDouble(arithmeticOperator.apply(d, d2));
        }
        if (Coercions.isBigInteger(object) || Coercions.isBigInteger(object2)) {
            BigInteger bigInteger = (BigInteger)Coercions.coerceToPrimitiveNumber(object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)Coercions.coerceToPrimitiveNumber(object2, BigInteger.class);
            return arithmeticOperator.apply(bigInteger, bigInteger2);
        }
        long l = Coercions.coerceToPrimitiveNumber(object, Long.class).longValue();
        long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class).longValue();
        return PrimitiveObjects.getLong(arithmeticOperator.apply(l, l2));
    }

    public static Object applyRelationalOperator(Object object, Object object2, RelationalOperator relationalOperator) throws ElException {
        if (Coercions.isBigDecimal(object) || Coercions.isBigDecimal(object2)) {
            BigDecimal bigDecimal = (BigDecimal)Coercions.coerceToPrimitiveNumber(object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)Coercions.coerceToPrimitiveNumber(object2, BigDecimal.class);
            return PrimitiveObjects.getBoolean(relationalOperator.apply(bigDecimal, bigDecimal2));
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class).doubleValue();
            return PrimitiveObjects.getBoolean(relationalOperator.apply(d, d2));
        }
        if (Coercions.isBigInteger(object) || Coercions.isBigInteger(object2)) {
            BigInteger bigInteger = (BigInteger)Coercions.coerceToPrimitiveNumber(object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)Coercions.coerceToPrimitiveNumber(object2, BigInteger.class);
            return PrimitiveObjects.getBoolean(relationalOperator.apply(bigInteger, bigInteger2));
        }
        if (Coercions.isIntegerType(object) || Coercions.isIntegerType(object2)) {
            long l = Coercions.coerceToPrimitiveNumber(object, Long.class).longValue();
            long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class).longValue();
            return PrimitiveObjects.getBoolean(relationalOperator.apply(l, l2));
        }
        if (object instanceof String || object2 instanceof String) {
            String string = Coercions.coerceToString(object);
            String string2 = Coercions.coerceToString(object2);
            return PrimitiveObjects.getBoolean(relationalOperator.apply(string, string2));
        }
        if (object instanceof Comparable) {
            try {
                int n = ((Comparable)object).compareTo(object2);
                return PrimitiveObjects.getBoolean(relationalOperator.apply(n, -n));
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string = MessageUtil.getMessageWithArgs(Constants.COMPARABLE_ERROR, object.getClass().getName(), object2 == null ? "null" : object2.getClass().getName(), relationalOperator.getOperatorSymbol());
                    log.logp(Level.SEVERE, CLASS_NAME, "applyRelationalOperator", string, exception);
                    throw new ElException(string, exception);
                }
                return Boolean.FALSE;
            }
        }
        if (object2 instanceof Comparable) {
            try {
                int n = ((Comparable)object2).compareTo(object);
                return PrimitiveObjects.getBoolean(relationalOperator.apply(-n, n));
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string = MessageUtil.getMessageWithArgs(Constants.COMPARABLE_ERROR, object2.getClass().getName(), object == null ? "null" : object.getClass().getName(), relationalOperator.getOperatorSymbol());
                    log.logp(Level.SEVERE, CLASS_NAME, "applyRelationalOperator", string, exception);
                    throw new ElException(string, exception);
                }
                return Boolean.FALSE;
            }
        }
        if (log.isLoggable(Level.SEVERE)) {
            String string = MessageUtil.getMessageWithArgs(Constants.ARITH_OP_BAD_TYPE, relationalOperator.getOperatorSymbol(), object.getClass().getName(), object2.getClass().getName());
            log.logp(Level.SEVERE, CLASS_NAME, "applyRelationalOperator", string);
            throw new ElException(string);
        }
        return Boolean.FALSE;
    }

    public static Object applyEqualityOperator(Object object, Object object2, EqualityOperator equalityOperator) throws ElException {
        if (object == object2) {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(true));
        }
        if (object == null || object2 == null) {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(false));
        }
        if (Coercions.isBigDecimal(object) || Coercions.isBigDecimal(object2)) {
            BigDecimal bigDecimal = (BigDecimal)Coercions.coerceToPrimitiveNumber(object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)Coercions.coerceToPrimitiveNumber(object2, BigDecimal.class);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(bigDecimal.equals(bigDecimal2)));
        }
        if (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointType(object2)) {
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class).doubleValue();
            return PrimitiveObjects.getBoolean(equalityOperator.apply(d == d2));
        }
        if (Coercions.isBigInteger(object) || Coercions.isBigInteger(object2)) {
            BigInteger bigInteger = (BigInteger)Coercions.coerceToPrimitiveNumber(object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)Coercions.coerceToPrimitiveNumber(object2, BigInteger.class);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(bigInteger.equals(bigInteger2)));
        }
        if (Coercions.isIntegerType(object) || Coercions.isIntegerType(object2)) {
            long l = Coercions.coerceToPrimitiveNumber(object, Long.class).longValue();
            long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class).longValue();
            return PrimitiveObjects.getBoolean(equalityOperator.apply(l == l2));
        }
        if (object instanceof Boolean || object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = Coercions.coerceToBoolean(object);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(bl2 == (bl = Coercions.coerceToBoolean(object2).booleanValue())));
        }
        if (object instanceof String || object2 instanceof String) {
            String string = Coercions.coerceToString(object);
            String string2 = Coercions.coerceToString(object2);
            return PrimitiveObjects.getBoolean(equalityOperator.apply(string.equals(string2)));
        }
        try {
            return PrimitiveObjects.getBoolean(equalityOperator.apply(object.equals(object2)));
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.ERROR_IN_EQUALS, object.getClass().getName(), object2.getClass().getName(), equalityOperator.getOperatorSymbol());
                log.logp(Level.SEVERE, CLASS_NAME, "applyEqualityOperator", string, exception);
                throw new ElException(string, exception);
            }
            return Boolean.FALSE;
        }
    }

    public static boolean isFloatingPointType(Object object) {
        return object != null && Coercions.isFloatingPointType(object.getClass());
    }

    public static boolean isFloatingPointType(Class clazz) {
        return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c != '.' && c != 'e' && c != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object object) {
        return object != null && Coercions.isIntegerType(object.getClass());
    }

    public static boolean isIntegerType(Class clazz) {
        return clazz == Byte.class || clazz == Byte.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Character.class || clazz == Character.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE;
    }

    public static boolean isBigInteger(Object object) {
        return object != null && object instanceof BigInteger;
    }

    public static boolean isBigDecimal(Object object) {
        return object != null && object instanceof BigDecimal;
    }
}

