/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionEvaluator;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.ExpressionString;
import com.sun.faces.el.impl.parser.ELParser;
import com.sun.faces.el.impl.parser.ElParseException;
import com.sun.faces.el.impl.parser.ParseException;
import com.sun.faces.el.impl.parser.Token;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final String DEFAULT_EL_PARSER = "com.sun.faces.el.impl.parser.ELParserImpl";
    private static boolean securityManager = System.getSecurityManager() != null;
    Map cachedExpressionStrings = null;
    static Map sCachedExpectedTypes;
    boolean mBypassCache;
    private String parserImplClass = "com.sun.faces.el.impl.parser.ELParserImpl";
    private Class parserClass;

    public ExpressionEvaluatorImpl(String string) {
        this(string, false);
    }

    public ExpressionEvaluatorImpl(String string, boolean bl) {
        this.mBypassCache = bl;
        if (!this.mBypassCache) {
            this.cachedExpressionStrings = Collections.synchronizedMap(new HashMap());
            sCachedExpectedTypes = new HashMap();
        }
        this.parserImplClass = string;
    }

    public void setParserImplementation(String string) {
        this.parserImplClass = string;
    }

    public Expression parseExpression(ExpressionInfo expressionInfo) throws ElException {
        Object object = this.parseExpressionString(expressionInfo.jspExpressionString.toString());
        if (object instanceof String || object instanceof ExpressionString) {
            return new ELExpression(this);
        }
        return (Expression)object;
    }

    public Object evaluate(ExpressionInfo expressionInfo) throws ElException {
        Class clazz = expressionInfo.getExpectedType();
        if (0 == expressionInfo.jspExpressionString.bufLen) {
            throw new ElException(Constants.NULL_EXPRESSION_STRING);
        }
        Object object = this.parseExpressionString(expressionInfo.jspExpressionString.toString());
        if (object instanceof String) {
            String string = (String)object;
            return this.convertStaticValueToExpectedType(string, clazz);
        }
        if (object instanceof Expression) {
            Object object2 = ((Expression)object).evaluate(expressionInfo);
            return this.convertToExpectedType(object2, clazz);
        }
        if (object instanceof ExpressionString) {
            String string = ((ExpressionString)object).evaluate(expressionInfo);
            return this.convertToExpectedType(string, clazz);
        }
        return null;
    }

    public Object parseExpressionString(String string) throws ElException {
        Object object;
        if (string.length() == 0) {
            return "";
        }
        Object object2 = object = this.mBypassCache ? null : (Object)this.cachedExpressionStrings.get(string);
        if (object == null) {
            ELParser eLParser = this.createParser(this.parserImplClass);
            eLParser.initParser(new StringReader(string));
            try {
                object = eLParser.ExpressionString();
                if (!this.mBypassCache) {
                    this.cachedExpressionStrings.put(string, object);
                }
            }
            catch (ElParseException elParseException) {
                if (elParseException instanceof ParseException) {
                    String string2 = ExpressionEvaluatorImpl.formatParseException(string, (ParseException)elParseException);
                    throw new ElException(string2, elParseException);
                }
                throw new ElException(elParseException.getMessage(), elParseException);
            }
        }
        return object;
    }

    protected Object convertToExpectedType(Object object, Class clazz) throws ElException {
        return Coercions.coerce(object, clazz);
    }

    protected Object convertStaticValueToExpectedType(String string, Class clazz) throws ElException {
        if (clazz == String.class || clazz == Object.class) {
            return string;
        }
        if (!this.mBypassCache) {
            Map map = ExpressionEvaluatorImpl.getOrCreateExpectedTypeMap(clazz);
            if (map.containsKey(string)) {
                return map.get(string);
            }
            Object object = Coercions.coerce(string, clazz);
            map.put(string, object);
            return object;
        }
        return Coercions.coerce(string, clazz);
    }

    private ELParser createParser(String string) {
        ELParser eLParser;
        try {
            if (this.parserClass == null) {
                if (securityManager) {
                    Object t = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    this.parserClass = ((ClassLoader)t).loadClass(string);
                } else {
                    this.parserClass = Thread.currentThread().getContextClassLoader().loadClass(string);
                }
            }
            eLParser = (ELParser)this.parserClass.newInstance();
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to create parser: " + throwable.toString());
        }
        return eLParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class clazz) {
        Map map = sCachedExpectedTypes;
        synchronized (map) {
            Map map2 = (Map)sCachedExpectedTypes.get(clazz);
            if (map2 == null) {
                map2 = Collections.synchronizedMap(new HashMap());
                sCachedExpectedTypes.put(clazz, map2);
            }
            return map2;
        }
    }

    static String formatParseException(String string, ParseException parseException) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        if (parseException.expectedTokenSequences == null) {
            return parseException.toString();
        }
        for (int i = 0; i < parseException.expectedTokenSequences.length; ++i) {
            if (n < parseException.expectedTokenSequences[i].length) {
                n = parseException.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < parseException.expectedTokenSequences[i].length; ++j) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(parseException.tokenImage[parseException.expectedTokenSequences[i][j]]);
                bl = true;
            }
        }
        String string2 = stringBuffer.toString();
        StringBuffer stringBuffer2 = new StringBuffer();
        Token token = parseException.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer2.append(" ");
            }
            if (token.kind == 0) {
                stringBuffer2.append(parseException.tokenImage[0]);
                break;
            }
            stringBuffer2.append(ExpressionEvaluatorImpl.addEscapes(token.image));
            token = token.next;
        }
        String string3 = stringBuffer2.toString();
        return MessageFormat.format(Constants.PARSE_EXCEPTION, string2, string3);
    }

    static String addEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block8;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String parseAndRender(String string) throws ElException {
        Object object = this.parseExpressionString(string);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Expression) {
            return "${" + ((Expression)object).getExpressionString() + "}";
        }
        if (object instanceof ExpressionString) {
            return ((ExpressionString)object).getExpressionString();
        }
        return "";
    }

    private class ELExpression
    extends Expression {
        private ExpressionEvaluator evaluator;
        private ExpressionInfo exprInfo;

        public ELExpression(ExpressionEvaluator expressionEvaluator) {
            this.evaluator = expressionEvaluator;
        }

        public Object evaluate(ExpressionInfo expressionInfo) throws ElException {
            this.exprInfo = expressionInfo;
            return this.evaluator.evaluate(expressionInfo);
        }

        public String getExpressionString() {
            return this.exprInfo != null ? this.exprInfo.jspExpressionString.toString() : "";
        }
    }
}

