/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BinaryOperator;
import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.PrimitiveObjects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntegerDivideOperator
extends BinaryOperator {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.IntegerDivideOperator";
    public static final IntegerDivideOperator SINGLETON = new IntegerDivideOperator();

    public String getOperatorSymbol() {
        return "idiv";
    }

    public Object apply(Object object, Object object2) throws ElException {
        if (object == null && object2 == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "apply", MessageUtil.getMessageWithArgs(Constants.ARITH_OP_NULL, this.getOperatorSymbol()));
            }
            return PrimitiveObjects.getInteger(0);
        }
        long l = Coercions.coerceToPrimitiveNumber(object, Long.class).longValue();
        long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class).longValue();
        try {
            return PrimitiveObjects.getLong(l / l2);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.ARITH_ERROR, this.getOperatorSymbol(), "" + l, "" + l2);
                log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

