/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.ibm.ws.jsf.util.WSFacesUtil;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;

public class RestoreViewPhase
extends Phase {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.lifecycle.RestoreViewPhase";
    private ActionListener actionListener = null;

    public RestoreViewPhase() {
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        if (applicationFactory != null) {
            this.actionListener = applicationFactory.getApplication().getActionListener();
        }
    }

    public PhaseId getId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void execute(FacesContext facesContext) throws FacesException {
        Object object;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "execute", "Entering RestoreViewPhase");
        }
        if (null == facesContext) {
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.NULL_CONTEXT_ERROR"));
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        Locale locale = null;
        if (uIViewRoot != null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "execute", "Found a pre created view in FacesContext");
            }
            locale = facesContext.getExternalContext().getRequestLocale();
            facesContext.getViewRoot().setLocale(locale);
            this.doPerComponentActions(facesContext, uIViewRoot);
            return;
        }
        Map map = facesContext.getExternalContext().getRequestMap();
        String string = WSFacesUtil.removeExtraPathInfo((String)map.get("javax.servlet.include.path_info"));
        if (string == null) {
            string = WSFacesUtil.removeExtraPathInfo(facesContext.getExternalContext().getRequestPathInfo());
        }
        if (string == null) {
            string = (String)map.get("javax.servlet.include.servlet_path");
        }
        if (string == null && (object = facesContext.getExternalContext().getRequest()) instanceof HttpServletRequest) {
            string = ((HttpServletRequest)object).getServletPath();
        }
        if (string == null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "execute", "viewId is null");
            }
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.NULL_REQUEST_VIEW_ERROR"));
        }
        uIViewRoot = Util.getViewHandler(facesContext).restoreView(facesContext, string);
        if (null == uIViewRoot) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "execute", "New request: creating a view for " + string);
            }
            uIViewRoot = Util.getViewHandler(facesContext).createView(facesContext, string);
            facesContext.renderResponse();
        } else if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "execute", "Postback: Restored view for " + string);
        }
        Util.doAssert(null != uIViewRoot);
        facesContext.setViewRoot(uIViewRoot);
        this.doPerComponentActions(facesContext, uIViewRoot);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "execute", "Exiting RestoreViewPhase");
        }
    }

    protected void doPerComponentActions(FacesContext facesContext, UIComponent uIComponent) {
        Iterator iterator = uIComponent.getFacetsAndChildren();
        while (iterator.hasNext()) {
            this.doPerComponentActions(facesContext, (UIComponent)iterator.next());
        }
        ValueBinding valueBinding = null;
        valueBinding = uIComponent.getValueBinding("binding");
        if (null != valueBinding) {
            valueBinding.setValue(facesContext, uIComponent);
        }
    }
}

