/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.RIConstants;
import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class MenuRenderer
extends HtmlBasicInputRenderer {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.renderkit.html_basic.MenuRenderer";

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "decode", "Begin decoding component " + uIComponent.getId());
        }
        boolean bl = false;
        if (uIComponent instanceof HtmlSelectOneMenu) {
            bl = ((HtmlSelectOneMenu)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectOneMenu)uIComponent).isReadonly();
            }
        } else if (uIComponent instanceof HtmlSelectOneListbox) {
            bl = ((HtmlSelectOneListbox)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectOneListbox)uIComponent).isReadonly();
            }
        } else if (uIComponent instanceof HtmlSelectManyMenu) {
            bl = ((HtmlSelectManyMenu)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectManyMenu)uIComponent).isReadonly();
            }
        } else if (uIComponent instanceof HtmlSelectManyListbox) {
            bl = ((HtmlSelectManyListbox)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectManyListbox)uIComponent).isReadonly();
            }
        } else {
            bl = Util.componentIsDisabledOnReadonly(uIComponent);
        }
        if (bl) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "decode", "No decoding necessary since the component " + uIComponent.getId() + " is disabled");
            }
            return;
        }
        String string = uIComponent.getClientId(facesContext);
        Util.doAssert(string != null);
        if (uIComponent instanceof UISelectMany) {
            Map map = facesContext.getExternalContext().getRequestParameterValuesMap();
            if (map.containsKey(string)) {
                String[] stringArray = (String[])map.get(string);
                this.setSubmittedValue(uIComponent, stringArray);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "submitted values for UISelectMany component " + uIComponent.getId() + " after decoding " + stringArray);
                }
            } else {
                this.setSubmittedValue(uIComponent, new String[0]);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "Set empty array for UISelectMany component " + uIComponent.getId() + " after decoding ");
                }
            }
        } else {
            Map map = facesContext.getExternalContext().getRequestParameterMap();
            if (map.containsKey(string)) {
                String string2;
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "found clientId in request parameter map");
                }
                if ((string2 = (String)map.get(string)) != null) {
                    this.setSubmittedValue(uIComponent, string2);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "decode", "submitted value for UISelectOne component " + uIComponent.getId() + " after decoding " + string2);
                    }
                } else if (((UIInput)uIComponent).isRequired()) {
                    this.setSubmittedValue(uIComponent, "");
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "decode", "submitted required value for UISelectOne component " + uIComponent.getId() + " after decoding to empty string");
                    }
                }
            } else if (((UIInput)uIComponent).isRequired()) {
                this.setSubmittedValue(uIComponent, "");
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "submitted required value for UISelectOne component " + uIComponent.getId() + " after decoding to empty string");
                }
            }
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uIComponent, Object object) throws ConverterException {
        if (uIComponent instanceof UISelectMany) {
            return this.convertSelectManyValue(facesContext, (UISelectMany)uIComponent, (String[])object);
        }
        return this.convertSelectOneValue(facesContext, (UISelectOne)uIComponent, (String)object);
    }

    public Object convertSelectOneValue(FacesContext facesContext, UISelectOne uISelectOne, String string) throws ConverterException {
        Object object = null;
        if (string == RIConstants.NO_VALUE) {
            return null;
        }
        if (string == null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "convertSelectOneValue", "No conversion necessary for SelectOne Component  " + uISelectOne.getId() + " since the new value is null ");
            }
            return null;
        }
        object = super.getConvertedValue(facesContext, uISelectOne, string);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "convertSelectOneValue", "SelectOne Component  " + uISelectOne.getId() + " convertedValue " + object);
        }
        return object;
    }

    public Object convertSelectManyValue(FacesContext facesContext, UISelectMany uISelectMany, String[] stringArray) throws ConverterException {
        Object object;
        ValueBinding valueBinding = uISelectMany.getValueBinding("value");
        Object object2 = stringArray;
        Class clazz = null;
        boolean bl = false;
        if (null != valueBinding) {
            clazz = valueBinding.getType(facesContext);
            if (null != clazz) {
                if (clazz.isArray()) {
                    object2 = this.handleArrayCase(facesContext, uISelectMany, clazz, stringArray);
                } else if (List.class.isAssignableFrom(clazz)) {
                    object2 = this.handleListCase(facesContext, stringArray);
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        } else {
            object = new Object[1];
            object2 = this.handleArrayCase(facesContext, uISelectMany, object.getClass(), stringArray);
        }
        if (bl) {
            object = "";
            if (null != stringArray) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object = (String)object + " " + stringArray[i];
                }
            }
            Object[] objectArray = new Object[]{object, valueBinding.getExpressionString()};
            throw new ConverterException(Util.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", objectArray));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "convertSelectManyValue", "SelectMany Component  " + uISelectMany.getId() + " convertedValues " + object2);
        }
        return object2;
    }

    protected Object handleArrayCase(FacesContext facesContext, UISelectMany uISelectMany, Class clazz, String[] stringArray) throws ConverterException {
        Object object = null;
        Class<?> clazz2 = null;
        Converter converter = null;
        int n = 0;
        int n2 = null != stringArray ? stringArray.length : 0;
        clazz2 = clazz.getComponentType();
        if (clazz2.equals(String.class)) {
            return stringArray;
        }
        try {
            object = Array.newInstance(clazz2, n2);
        }
        catch (Exception exception) {
            throw new ConverterException(exception);
        }
        if (null == stringArray) {
            return object;
        }
        converter = uISelectMany.getConverter();
        if (null == converter && null == (converter = Util.getConverterForClass(clazz2))) {
            if (clazz2.equals(Object.class)) {
                return stringArray;
            }
            String string = "";
            for (n = 0; n < stringArray.length; ++n) {
                string = string + " " + stringArray[n];
            }
            Object[] objectArray = new Object[]{string, "null Converter"};
            throw new ConverterException(Util.getExceptionMessage("com.sun.faces.TYPECONVERSION_ERROR", objectArray));
        }
        Util.doAssert(null != object);
        if (clazz2.isPrimitive()) {
            for (n = 0; n < n2; ++n) {
                if (clazz2.equals(Boolean.TYPE)) {
                    Array.setBoolean(object, n, (Boolean)converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Byte.TYPE)) {
                    Array.setByte(object, n, (Byte)converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Double.TYPE)) {
                    Array.setDouble(object, n, (Double)converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Float.TYPE)) {
                    Array.setFloat(object, n, ((Float)converter.getAsObject(facesContext, uISelectMany, stringArray[n])).floatValue());
                    continue;
                }
                if (clazz2.equals(Integer.TYPE)) {
                    Array.setInt(object, n, (Integer)converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Character.TYPE)) {
                    Array.setChar(object, n, ((Character)converter.getAsObject(facesContext, uISelectMany, stringArray[n])).charValue());
                    continue;
                }
                if (clazz2.equals(Short.TYPE)) {
                    Array.setShort(object, n, (Short)converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
                    continue;
                }
                if (!clazz2.equals(Long.TYPE)) continue;
                Array.setLong(object, n, (Long)converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (log.isLoggable(Level.FINE)) {
                    Object object2 = converter.getAsObject(facesContext, uISelectMany, stringArray[n]);
                    log.logp(Level.FINE, CLASS_NAME, "handleArrayCase", "String value: " + stringArray[n] + " converts to : " + object2.toString());
                }
                Array.set(object, n, converter.getAsObject(facesContext, uISelectMany, stringArray[n]));
            }
        }
        return object;
    }

    protected Object handleListCase(FacesContext facesContext, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(stringArray[n]);
        }
        return arrayList;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "Begin encoding component " + uIComponent.getId());
        }
        if (!uIComponent.isRendered()) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "End encoding component " + uIComponent.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        this.renderSelect(facesContext, uIComponent);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "End encoding component " + uIComponent.getId());
        }
    }

    void renderSelect(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        Object v;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "renderSelect", "Rendering 'select'");
        }
        responseWriter.startElement("select", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        responseWriter.writeAttribute("name", uIComponent.getClientId(facesContext), "clientId");
        String string = null;
        if (!this.getMultipleText(uIComponent).equals("")) {
            responseWriter.writeAttribute("multiple", Boolean.TRUE, null);
        }
        if (null != (string = uIComponent instanceof HtmlSelectOneMenu ? ((HtmlSelectOneMenu)uIComponent).getStyleClass() : (uIComponent instanceof HtmlSelectOneListbox ? ((HtmlSelectOneListbox)uIComponent).getStyleClass() : (uIComponent instanceof HtmlSelectManyMenu ? ((HtmlSelectManyMenu)uIComponent).getStyleClass() : (uIComponent instanceof HtmlSelectManyListbox ? ((HtmlSelectManyListbox)uIComponent).getStyleClass() : (String)uIComponent.getAttributes().get("styleClass")))))) {
            responseWriter.writeAttribute("class", string, "styleClass");
        }
        int n = this.getOptionNumber(facesContext, uIComponent);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "renderSelect", "Rendering " + n + " options");
        }
        if (null == (v = uIComponent.getAttributes().get("size")) || v instanceof Integer && (Integer)v == Integer.MIN_VALUE) {
            this.writeDefaultSize(responseWriter, n);
        }
        if (uIComponent instanceof HtmlSelectOneMenu) {
            this.renderPassthrusForSelectOneMenu(facesContext, uIComponent);
        } else if (uIComponent instanceof HtmlSelectOneListbox) {
            this.renderPassthrusForSelectOneListBox(facesContext, uIComponent);
        } else if (uIComponent instanceof HtmlSelectManyMenu) {
            this.renderPassthrusForSelectManyMenu(facesContext, uIComponent);
        } else if (uIComponent instanceof HtmlSelectManyListbox) {
            this.renderPassthrusForSelectManyListBox(facesContext, uIComponent);
        } else {
            Util.renderPassThruAttributes(responseWriter, uIComponent);
            Util.renderBooleanPassThruAttributes(responseWriter, uIComponent);
        }
        this.renderOptions(facesContext, uIComponent);
        responseWriter.endElement("select");
    }

    int getOptionNumber(FacesContext facesContext, UIComponent uIComponent) {
        Iterator iterator = Util.getSelectItems(facesContext, uIComponent);
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            SelectItem selectItem = (SelectItem)iterator.next();
            if (!(selectItem instanceof SelectItemGroup)) continue;
            int n2 = ((SelectItemGroup)selectItem).getSelectItems().length;
            n += n2;
        }
        return n;
    }

    void renderOptions(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        Iterator iterator = Util.getSelectItems(facesContext, uIComponent);
        SelectItem selectItem = null;
        while (iterator.hasNext()) {
            selectItem = (SelectItem)iterator.next();
            if (selectItem instanceof SelectItemGroup) {
                responseWriter.startElement("optgroup", uIComponent);
                responseWriter.writeAttribute("label", selectItem.getLabel(), "label");
                SelectItem[] selectItemArray = ((SelectItemGroup)selectItem).getSelectItems();
                for (int i = 0; i < selectItemArray.length; ++i) {
                    this.renderOption(facesContext, uIComponent, selectItemArray[i]);
                }
                responseWriter.endElement("optgroup");
                continue;
            }
            this.renderOption(facesContext, uIComponent, selectItem);
        }
    }

    protected void renderOption(FacesContext facesContext, UIComponent uIComponent, SelectItem selectItem) throws IOException {
        Object object;
        boolean bl;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        responseWriter.writeText("\t", null);
        responseWriter.startElement("option", uIComponent);
        String string = this.getFormattedValue(facesContext, uIComponent, selectItem.getValue());
        responseWriter.writeAttribute("value", string, "value");
        Object[] objectArray = this.getSubmittedSelectedValues(facesContext, uIComponent);
        if (objectArray != null) {
            bl = this.isSelected((Object)string, objectArray);
        } else {
            object = this.getCurrentSelectedValues(facesContext, uIComponent);
            bl = this.isSelected(selectItem.getValue(), object);
        }
        if (bl) {
            responseWriter.writeAttribute(this.getSelectedTextString(), Boolean.TRUE, null);
        }
        if (selectItem.isDisabled()) {
            responseWriter.writeAttribute("disabled", "disabled", "disabled");
        }
        object = null;
        Boolean bl2 = (Boolean)uIComponent.getAttributes().get("disabled");
        boolean bl3 = false;
        if (bl2 != null && bl2.equals(Boolean.TRUE)) {
            bl3 = true;
        }
        if ((object = bl3 || selectItem.isDisabled() ? (String)uIComponent.getAttributes().get("disabledClass") : (String)uIComponent.getAttributes().get("enabledClass")) != null) {
            responseWriter.writeAttribute("class", object, "labelClass");
        }
        responseWriter.writeText(selectItem.getLabel(), "label");
        responseWriter.endElement("option");
        responseWriter.writeText("\n", null);
    }

    boolean isSelected(Object object, Object object2) {
        if (null != object2) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object2, i);
                if (!(object3 == null ? object == null : object3.equals(object))) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSelected(Object object, Object[] objectArray) {
        if (null != objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!objectArray[i].equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    protected void writeDefaultSize(ResponseWriter responseWriter, int n) throws IOException {
        responseWriter.writeAttribute("size", "1", "size");
    }

    String getSelectedTextString() {
        return " selected";
    }

    String getMultipleText(UIComponent uIComponent) {
        if (uIComponent instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    Object[] getSubmittedSelectedValues(FacesContext facesContext, UIComponent uIComponent) {
        if (uIComponent instanceof UISelectMany) {
            UISelectMany uISelectMany = (UISelectMany)uIComponent;
            return (Object[])uISelectMany.getSubmittedValue();
        }
        UISelectOne uISelectOne = (UISelectOne)uIComponent;
        Object object = uISelectOne.getSubmittedValue();
        if (null != object) {
            return new Object[]{object};
        }
        return null;
    }

    Object getCurrentSelectedValues(FacesContext facesContext, UIComponent uIComponent) {
        if (uIComponent instanceof UISelectMany) {
            UISelectMany uISelectMany = (UISelectMany)uIComponent;
            Object object = uISelectMany.getValue();
            if (object instanceof List) {
                return ((List)object).toArray();
            }
            return object;
        }
        UISelectOne uISelectOne = (UISelectOne)uIComponent;
        Object object = uISelectOne.getValue();
        if (null != object) {
            return new Object[]{object};
        }
        return null;
    }

    void renderPassthrusForSelectOneMenu(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectOneMenu)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", ((HtmlSelectOneMenu)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", ((HtmlSelectOneMenu)uIComponent).getDir(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", "disabled", null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", ((HtmlSelectOneMenu)uIComponent).getLang(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", ((HtmlSelectOneMenu)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", ((HtmlSelectOneMenu)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", ((HtmlSelectOneMenu)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", ((HtmlSelectOneMenu)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", ((HtmlSelectOneMenu)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", ((HtmlSelectOneMenu)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", ((HtmlSelectOneMenu)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", ((HtmlSelectOneMenu)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", ((HtmlSelectOneMenu)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", ((HtmlSelectOneMenu)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", ((HtmlSelectOneMenu)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", ((HtmlSelectOneMenu)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", ((HtmlSelectOneMenu)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", ((HtmlSelectOneMenu)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", "readonly", null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", ((HtmlSelectOneMenu)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", ((HtmlSelectOneMenu)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", ((HtmlSelectOneMenu)uIComponent).getTitle(), null);
        }
    }

    void renderPassthrusForSelectOneListBox(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectOneListbox)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", ((HtmlSelectOneListbox)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", ((HtmlSelectOneListbox)uIComponent).getDir(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", "disabled", null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", ((HtmlSelectOneListbox)uIComponent).getLang(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", ((HtmlSelectOneListbox)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", ((HtmlSelectOneListbox)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", ((HtmlSelectOneListbox)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", ((HtmlSelectOneListbox)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", ((HtmlSelectOneListbox)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", ((HtmlSelectOneListbox)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", ((HtmlSelectOneListbox)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", ((HtmlSelectOneListbox)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", ((HtmlSelectOneListbox)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", ((HtmlSelectOneListbox)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", ((HtmlSelectOneListbox)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", ((HtmlSelectOneListbox)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", ((HtmlSelectOneListbox)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", ((HtmlSelectOneListbox)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", "readonly", null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getSize() > 0) {
            responseWriter.writeAttribute("size", new Integer(((HtmlSelectOneListbox)uIComponent).getSize()), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", ((HtmlSelectOneListbox)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", ((HtmlSelectOneListbox)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", ((HtmlSelectOneListbox)uIComponent).getTitle(), null);
        }
    }

    void renderPassthrusForSelectManyListBox(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectManyListbox)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", ((HtmlSelectManyListbox)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", ((HtmlSelectManyListbox)uIComponent).getDir(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", "disabled", null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", ((HtmlSelectManyListbox)uIComponent).getLang(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", ((HtmlSelectManyListbox)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", ((HtmlSelectManyListbox)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", ((HtmlSelectManyListbox)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", ((HtmlSelectManyListbox)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", ((HtmlSelectManyListbox)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", ((HtmlSelectManyListbox)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", ((HtmlSelectManyListbox)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", ((HtmlSelectManyListbox)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", ((HtmlSelectManyListbox)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", ((HtmlSelectManyListbox)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", ((HtmlSelectManyListbox)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", ((HtmlSelectManyListbox)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", ((HtmlSelectManyListbox)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", ((HtmlSelectManyListbox)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", "readonly", null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getSize() > 0) {
            responseWriter.writeAttribute("size", new Integer(((HtmlSelectManyListbox)uIComponent).getSize()), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", ((HtmlSelectManyListbox)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", ((HtmlSelectManyListbox)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", ((HtmlSelectManyListbox)uIComponent).getTitle(), null);
        }
    }

    void renderPassthrusForSelectManyMenu(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectManyMenu)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", ((HtmlSelectManyMenu)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", ((HtmlSelectManyMenu)uIComponent).getDir(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", "disabled", null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", ((HtmlSelectManyMenu)uIComponent).getLang(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", ((HtmlSelectManyMenu)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", ((HtmlSelectManyMenu)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", ((HtmlSelectManyMenu)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", ((HtmlSelectManyMenu)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", ((HtmlSelectManyMenu)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", ((HtmlSelectManyMenu)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", ((HtmlSelectManyMenu)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", ((HtmlSelectManyMenu)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", ((HtmlSelectManyMenu)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", ((HtmlSelectManyMenu)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", ((HtmlSelectManyMenu)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", ((HtmlSelectManyMenu)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", ((HtmlSelectManyMenu)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", ((HtmlSelectManyMenu)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", "readonly", null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", ((HtmlSelectManyMenu)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", ((HtmlSelectManyMenu)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", ((HtmlSelectManyMenu)uIComponent).getTitle(), null);
        }
    }
}

