/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

public class TreeStructure
implements Serializable {
    private static final long serialVersionUID = 3545518426031731251L;
    ArrayList children = null;
    HashMap facets = null;
    String className = null;
    String id = null;

    public TreeStructure() {
    }

    public TreeStructure(UIComponent uIComponent) {
        Util.parameterNonNull(uIComponent);
        this.id = uIComponent.getId();
        this.className = uIComponent.getClass().getName();
    }

    public String getClazzName() {
        return this.className;
    }

    public Iterator getChildren() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getFacetNames() {
        if (this.facets != null) {
            return this.facets.keySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void addChild(TreeStructure treeStructure) {
        Util.parameterNonNull(treeStructure);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(treeStructure);
    }

    public void addFacet(String string, TreeStructure treeStructure) {
        Util.parameterNonNull(string);
        Util.parameterNonNull(treeStructure);
        if (this.facets == null) {
            this.facets = new HashMap();
        }
        this.facets.put(string, treeStructure);
    }

    public TreeStructure getTreeStructureForFacet(String string) {
        Util.parameterNonNull(string);
        if (this.facets != null) {
            return (TreeStructure)this.facets.get(string);
        }
        return null;
    }

    public UIComponent createComponent() {
        UIComponent uIComponent = null;
        try {
            Class clazz = Util.loadClass(this.className, this);
            uIComponent = (UIComponent)clazz.newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{this.className};
            throw new FacesException(Util.getExceptionMessageString("com.sun.faces.MISSING_CLASS_ERROR", objectArray));
        }
        Util.doAssert(uIComponent != null);
        uIComponent.setId(this.id);
        return uIComponent;
    }
}

