/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.security.PrivilegedAction;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;

class StateHolderSaver
implements Serializable {
    private String className = null;
    private Object savedState = null;
    private static boolean securityManager = System.getSecurityManager() != null;

    public StateHolderSaver(FacesContext context, Object toSave) {
        this.className = toSave.getClass().getName();
        if (toSave instanceof StateHolder) {
            if (!((StateHolder)toSave).isTransient()) {
                this.savedState = ((StateHolder)toSave).saveState(context);
            } else {
                this.className = null;
            }
        } else if (toSave instanceof Serializable) {
            this.savedState = toSave;
            this.className = null;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Object result = null;
        Class toRestoreClass = null;
        if (null == this.className && null != this.savedState) {
            return this.savedState;
        }
        if (this.className == null) {
            return null;
        }
        try {
            toRestoreClass = StateHolderSaver.loadClass(this.className, this);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (null != toRestoreClass) {
            try {
                result = toRestoreClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException a) {
                throw new IllegalStateException(a.getMessage());
            }
        }
        if (null != result && null != this.savedState && result instanceof StateHolder) {
            ((StateHolder)result).restoreState(context, this.savedState);
        }
        return result;
    }

    private static Class loadClass(String name, final Object fallbackClass) throws ClassNotFoundException {
        if (securityManager) {
            Object cl = AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return fallbackClass.getClass().getClassLoader();
                    }
                });
            }
            return ((ClassLoader)cl).loadClass(name);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader.loadClass(name);
    }
}

