/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.ws.webcontainer.WebContainer;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.runtime.JspWriterImpl;

public class BodyContentImpl
extends BodyContent {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.BodyContentImpl";
    public static final int DEFAULT_TAG_BUFFER_SIZE = 512;
    private static final String LINE_SEPARATOR = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("line.separator");
        }
    });
    protected int bodyContentBuffSize = 512;
    private StringBuffer strBuffer;
    private int nextChar;
    private boolean closed;
    private Writer writer;
    private int bufferSizeSave;
    private static boolean limitBuffer = new Boolean(WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.jsp.limitbuffer", "false"));

    public BodyContentImpl(JspWriter jspWriter) {
        this(jspWriter, 512);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "BodyContentImpl", "BodyContentImpl ctor 1 buffsize=[512]  this=[" + (Object)((Object)this) + "]");
        }
    }

    public BodyContentImpl(JspWriter jspWriter, int n) {
        super(jspWriter);
        this.bodyContentBuffSize = n;
        this.bufferSizeSave = this.bufferSize = n;
        this.strBuffer = new StringBuffer(this.bufferSize);
        this.nextChar = 0;
        this.closed = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "BodyContentImpl", "BodyContentImpl ctor 2 buffsize=[" + this.bodyContentBuffSize + "]  this=[" + (Object)((Object)this) + "]");
        }
    }

    public void write(int n) throws IOException {
        if (this.writer != null) {
            this.writer.write(n);
        } else {
            this.ensureOpen();
            this.strBuffer.append((char)n);
            ++this.nextChar;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.writer != null) {
            this.writer.write(cArray, n, n2);
        } else {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            this.strBuffer.append(cArray, n, n2);
            this.nextChar += n2;
        }
    }

    public void write(char[] cArray) throws IOException {
        if (this.writer != null) {
            this.writer.write(cArray);
        } else {
            this.write(cArray, 0, cArray.length);
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.writer != null) {
            this.writer.write(string, n, n2);
        } else {
            this.ensureOpen();
            this.strBuffer.append(string.substring(n, n + n2));
            this.nextChar += n2;
        }
    }

    public void write(String string) throws IOException {
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            this.write(string, 0, string.length());
        }
    }

    public void newLine() throws IOException {
        if (this.writer != null) {
            this.writer.write(LINE_SEPARATOR);
        } else {
            this.write(LINE_SEPARATOR);
        }
    }

    public void print(boolean bl) throws IOException {
        if (this.writer != null) {
            this.writer.write(bl ? "true" : "false");
        } else {
            this.write(bl ? "true" : "false");
        }
    }

    public void print(char c) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(c));
        } else {
            this.write(String.valueOf(c));
        }
    }

    public void print(int n) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(n));
        } else {
            this.write(String.valueOf(n));
        }
    }

    public void print(long l) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(l));
        } else {
            this.write(String.valueOf(l));
        }
    }

    public void print(float f) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(f));
        } else {
            this.write(String.valueOf(f));
        }
    }

    public void print(double d) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(d));
        } else {
            this.write(String.valueOf(d));
        }
    }

    public void print(char[] cArray) throws IOException {
        if (this.writer != null) {
            this.writer.write(cArray);
        } else {
            this.write(cArray);
        }
    }

    public void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        if (this.writer != null) {
            this.writer.write(string);
        } else {
            this.write(string);
        }
    }

    public void print(Object object) throws IOException {
        if (this.writer != null) {
            this.writer.write(String.valueOf(object));
        } else {
            this.write(String.valueOf(object));
        }
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.println();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.println();
    }

    public void clear() throws IOException {
        if (this.writer != null) {
            throw new IOException();
        }
        this.nextChar = 0;
        if (limitBuffer && this.strBuffer.length() > this.bodyContentBuffSize) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "BodyContentImpl", "clear buffer, create new one with buffer size [" + this.bodyContentBuffSize + "]");
            }
            this.strBuffer = new StringBuffer(this.bodyContentBuffSize);
        } else {
            this.strBuffer.setLength(0);
        }
    }

    public void clearBuffer() throws IOException {
        if (this.writer == null) {
            this.clear();
        }
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.closed = true;
            this.strBuffer = null;
        }
    }

    public int getRemaining() {
        return this.writer == null ? this.strBuffer.capacity() - this.strBuffer.length() : 0;
    }

    public Reader getReader() {
        char[] cArray = new char[this.strBuffer.length()];
        this.strBuffer.getChars(0, this.strBuffer.length(), cArray, 0);
        return this.writer == null ? new CharArrayReader(cArray, 0, this.strBuffer.length()) : null;
    }

    public String getString() {
        return this.writer == null ? this.strBuffer.toString() : null;
    }

    public void writeOut(Writer writer) throws IOException {
        if (this.writer == null) {
            writer.write(this.strBuffer.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        char[] cArray = new char[]{'f', 'o', 'o', 'b', 'a', 'r', 'b', 'a', 'z', 'y'};
        BodyContentImpl bodyContentImpl = new BodyContentImpl(new JspWriterImpl(null, 100, false));
        bodyContentImpl.println(cArray);
        System.out.println(bodyContentImpl.getString());
        bodyContentImpl.writeOut(new PrintWriter(System.out));
    }

    void setWriter(Writer writer) {
        this.writer = writer;
        if (writer != null) {
            if (this.bufferSize != 0) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setWriter", "BodyContentImpl setWriter A. bufferSize=[" + this.bufferSize + "]  this=[" + (Object)((Object)this) + "]");
                }
                this.bufferSizeSave = this.bufferSize;
                this.bufferSize = 0;
            }
        } else {
            this.bufferSize = this.bufferSizeSave;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setWriter", "BodyContentImpl setWriter B. bufferSize=[" + this.bufferSize + "]  this=[" + (Object)((Object)this) + "]");
            }
            this.clearBody();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

