/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.ws.jsp.runtime.PageContextPool;
import com.ibm.ws.util.WSThreadLocal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.JspFactoryImpl";
    private static final String SPEC_VERSION = "2.0";
    private static WSThreadLocal _threadLocal = new WSThreadLocal();
    private int bodyContentBufferSize = 512;

    public JspFactoryImpl() {
        this(512);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JspFactoryImpl", "JspFactoryImpl ctor 1 buffsize=[512]  this=[" + (Object)((Object)this) + "]");
        }
    }

    public JspFactoryImpl(int n) {
        this.bodyContentBufferSize = n;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "JspFactoryImpl", "JspFactoryImpl ctor 2 buffsize=[" + this.bodyContentBufferSize + "]  this=[" + (Object)((Object)this) + "]");
        }
    }

    public PageContext getPageContext(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        if (System.getSecurityManager() != null) {
            PrivilegedGetPageContext privilegedGetPageContext = new PrivilegedGetPageContext(this, servlet, servletRequest, servletResponse, string, bl, n, bl2);
            return (PageContext)AccessController.doPrivileged(privilegedGetPageContext);
        }
        return this.internalGetPageContext(servlet, servletRequest, servletResponse, string, bl, n, bl2);
    }

    public void releasePageContext(PageContext pageContext) {
        if (pageContext == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            PrivilegedReleasePageContext privilegedReleasePageContext = new PrivilegedReleasePageContext(this, pageContext);
            AccessController.doPrivileged(privilegedReleasePageContext);
        } else {
            this.internalReleasePageContext(pageContext);
        }
    }

    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            public String getSpecificationVersion() {
                return JspFactoryImpl.SPEC_VERSION;
            }
        };
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        try {
            PageContext pageContext = this.getPool().remove();
            pageContext.initialize(servlet, servletRequest, servletResponse, string, bl, n, bl2);
            return pageContext;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            return null;
        }
    }

    private void internalReleasePageContext(PageContext pageContext) {
        pageContext.release();
    }

    void returnFreePageContext(PageContextImpl pageContextImpl) {
        this.getPool().add(pageContextImpl);
    }

    protected PageContextPool getPool() {
        PageContextPool pageContextPool = null;
        pageContextPool = (PageContextPool)_threadLocal.get();
        if (pageContextPool == null) {
            pageContextPool = new PageContextPool(4){

                protected PageContext createPageContext() {
                    return new PageContextImpl(JspFactoryImpl.this, JspFactoryImpl.this.bodyContentBufferSize);
                }
            };
            _threadLocal.set((Object)pageContextPool);
        }
        return pageContextPool;
    }

    private class PrivilegedReleasePageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl jspFactoryImpl2, PageContext pageContext) {
            this.factory = jspFactoryImpl2;
            this.pageContext = pageContext;
        }

        public Object run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private class PrivilegedGetPageContext
    implements PrivilegedAction {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl jspFactoryImpl2, Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
            this.factory = jspFactoryImpl2;
            this.servlet = servlet;
            this.request = servletRequest;
            this.response = servletResponse;
            this.errorPageURL = string;
            this.needsSession = bl;
            this.bufferSize = n;
            this.autoflush = bl2;
        }

        public Object run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

