/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext
implements VariableResolver {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "org.apache.jasper.runtime.PageContextImpl";
    private VariableResolver variableResolver;
    private BodyContentImpl[] outs;
    private int depth;
    private Servlet servlet;
    private ServletConfig config;
    private ServletContext context;
    private JspFactory factory;
    private boolean needsSession;
    private String errorPageURL;
    private boolean autoFlush;
    private int bufferSize;
    private int bodyContentBufferSize;
    private transient HashMap attributes;
    private transient ServletRequest request;
    private transient ServletResponse response;
    private transient Object page;
    private transient HttpSession session;
    private boolean isIncluded;
    private transient JspWriter out;
    private transient JspWriterImpl baseOut;

    PageContextImpl(JspFactory jspFactory) {
        this(jspFactory, 512);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "PageContextImpl ctor 1 buffsize=[512]  this=[" + (Object)((Object)this) + "]");
        }
    }

    PageContextImpl(JspFactory jspFactory, int n) {
        this.factory = jspFactory;
        this.outs = new BodyContentImpl[0];
        this.attributes = new HashMap(16);
        this.depth = -1;
        this.bodyContentBufferSize = n;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "PageContextImpl", "PageContextImpl ctor 2 buffsize=[" + this.bodyContentBufferSize + "]  this=[" + (Object)((Object)this) + "]");
        }
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException {
        this._initialize(servlet, servletRequest, servletResponse, string, bl, n, bl2);
    }

    private void _initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = bl;
        this.errorPageURL = string;
        this.bufferSize = n;
        this.autoFlush = bl2;
        this.request = servletRequest;
        this.response = servletResponse;
        if (servletRequest instanceof HttpServletRequest && bl) {
            this.session = ((HttpServletRequest)servletRequest).getSession();
        }
        if (bl && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        this.depth = -1;
        if (this.baseOut == null) {
            this.baseOut = this._createOut(n, bl2);
        } else {
            this.baseOut.init(servletResponse, n, bl2);
        }
        this.out = this.baseOut;
        if (this.out == null) {
            throw new IllegalStateException("failed initialize JspWriter");
        }
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", servletRequest);
        this.setAttribute("javax.servlet.jsp.jspResponse", servletResponse);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.isIncluded = servletRequest.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public void release() {
        block2: {
            this.out = this.baseOut;
            try {
                ((JspWriterImpl)this.out).flushBuffer();
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.logp(Level.WARNING, CLASS_NAME, "release", "failed to flush response buffer during PageContext.release().", iOException);
            }
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.depth = -1;
        this.baseOut.recycle();
        this.session = null;
        this.attributes.clear();
        ((JspFactoryImpl)this.factory).returnFreePageContext(this);
    }

    public Object getAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("Null name");
        }
        return this.attributes.get(string);
    }

    public Object getAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Null name");
        }
        switch (n) {
            case 1: {
                return this.attributes.get(string);
            }
            case 2: {
                return this.request.getAttribute(string);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                return this.session.getAttribute(string);
            }
            case 4: {
                return this.context.getAttribute(string);
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("Null name");
        }
        if (object != null) {
            this.attributes.put(string, object);
        } else {
            this.removeAttribute(string, 1);
        }
    }

    public void setAttribute(String string, Object object, int n) {
        block9: {
            block8: {
                if (string == null) {
                    throw new NullPointerException("Null name");
                }
                if (object == null) break block8;
                switch (n) {
                    case 1: {
                        this.attributes.put(string, object);
                        break block9;
                    }
                    case 2: {
                        this.request.setAttribute(string, object);
                        break block9;
                    }
                    case 3: {
                        if (this.session == null) {
                            throw new IllegalStateException("jsp.error.page.noSession");
                        }
                        this.session.setAttribute(string, object);
                        break block9;
                    }
                    case 4: {
                        this.context.setAttribute(string, object);
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid scope");
                    }
                }
            }
            this.removeAttribute(string, n);
        }
    }

    public void removeAttribute(String string, int n) {
        if (string == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        switch (n) {
            case 1: {
                this.attributes.remove(string);
                break;
            }
            case 2: {
                this.request.removeAttribute(string);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                this.session.removeAttribute(string);
                break;
            }
            case 4: {
                this.context.removeAttribute(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope");
            }
        }
    }

    public int getAttributesScope(String string) {
        if (string == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        if (this.attributes.get(string) != null) {
            return 1;
        }
        if (this.request.getAttribute(string) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(string) != null) {
            return 3;
        }
        if (this.context.getAttribute(string) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        Object object = this.attributes.get(string);
        if (object != null) {
            return object;
        }
        object = this.request.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.session != null && (object = this.session.getAttribute(string)) != null) {
            return object;
        }
        return this.context.getAttribute(string);
    }

    public Enumeration getAttributeNamesInScope(int n) {
        switch (n) {
            case 1: {
                return Collections.enumeration(this.attributes.keySet());
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalStateException("jsp.error.page.noSession");
                }
                return this.session.getAttributeNames();
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        throw new IllegalArgumentException("Invalid scope");
    }

    public void removeAttribute(String string) {
        if (string == null) {
            throw new NullPointerException("jsp.error.attribute.null_name");
        }
        try {
            this.removeAttribute(string, 1);
            this.removeAttribute(string, 2);
            if (this.session != null) {
                this.removeAttribute(string, 3);
            }
            this.removeAttribute(string, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String string) {
        String string2 = string;
        if (!string2.startsWith("/")) {
            String string3 = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (string3 == null) {
                string3 = ((HttpServletRequest)this.request).getServletPath();
            }
            String string4 = string3.substring(0, string3.lastIndexOf(47));
            string2 = string4 + '/' + string2;
        }
        return string2;
    }

    public void include(String string) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, string, (Writer)this.out, true);
    }

    public void include(String string, boolean bl) throws ServletException, IOException {
        JspRuntimeLibrary.include(this.request, this.response, string, (Writer)this.out, bl);
    }

    public VariableResolver getVariableResolver() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forward(String string) throws ServletException, IOException {
        block7: {
            try {
                this.out.clear();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("jsp.error.attempt_to_clear_flushed_buffer");
            }
            while (this.response instanceof ServletResponseWrapperInclude) {
                this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
            }
            String string2 = this.getAbsolutePathRelativeToContext(string);
            String string3 = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            ServletResponse servletResponse = this.response;
            ServletRequest servletRequest = this.request;
            if (string3 != null) {
                this.request.removeAttribute("javax.servlet.include.servlet_path");
            }
            try {
                this.context.getRequestDispatcher(string2).forward(this.request, this.response);
                Object var7_7 = null;
                if (string3 == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (string3 != null) {
                    this.request.setAttribute("javax.servlet.include.servlet_path", (Object)string3);
                }
                this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
                throw throwable;
            }
            this.request.setAttribute("javax.servlet.include.servlet_path", (Object)string3);
        }
        this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
    }

    public BodyContent pushBody() {
        return (BodyContent)this.pushBody(null);
    }

    public JspWriter pushBody(Writer writer) {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            BodyContentImpl[] bodyContentImplArray = new BodyContentImpl[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                bodyContentImplArray[i] = this.outs[i];
            }
            bodyContentImplArray[this.depth] = new BodyContentImpl(this.out, this.bodyContentBufferSize);
            this.outs = bodyContentImplArray;
        }
        this.outs[this.depth].setWriter(writer);
        this.out = this.outs[this.depth];
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.outs[this.depth];
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.depth >= 0 ? this.outs[this.depth] : this.baseOut;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        return this.out;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)this.context.getAttribute("com.ibm.ws.jsp.expreval");
        if (expressionEvaluator == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.commons.el.ExpressionEvaluatorImpl");
                Constructor<?> constructor = clazz.getConstructor(Boolean.TYPE);
                expressionEvaluator = (ExpressionEvaluator)constructor.newInstance(Boolean.FALSE);
                this.context.setAttribute("com.ibm.ws.jsp.expreval", (Object)expressionEvaluator);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return expressionEvaluator;
    }

    public void handlePageException(Exception exception) throws IOException, ServletException {
        this.handlePageException((Throwable)exception);
    }

    public void handlePageException(Throwable throwable) throws IOException, ServletException {
        if (throwable == null) {
            throw new NullPointerException("null Throwable");
        }
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            this.request.setAttribute("javax.servlet.jsp.jspException", (Object)throwable);
            this.request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
            this.request.setAttribute("javax.servlet.error.request_uri", (Object)((HttpServletRequest)this.request).getRequestURI());
            this.request.setAttribute("javax.servlet.error.servlet_name", (Object)this.config.getServletName());
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException illegalStateException) {
                this.include(this.errorPageURL);
            }
            Object object = this.request.getAttribute("javax.servlet.error.exception");
            if (object != null && object == throwable) {
                this.request.removeAttribute("javax.servlet.error.exception");
            }
        } else {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            Throwable throwable2 = null;
            if (throwable instanceof JspException) {
                throwable2 = ((JspException)throwable).getRootCause();
            } else if (throwable instanceof ELException) {
                throwable2 = ((ELException)throwable).getRootCause();
            }
            if (throwable2 != null) {
                throw new ServletException(throwable.getMessage(), throwable2);
            }
            throw new ServletException(throwable);
        }
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.error.request_uri");
        this.request.removeAttribute("javax.servlet.error.status_code");
        this.request.removeAttribute("javax.servlet.jsp.jspException");
    }

    public Object resolveVariable(String string) throws ELException {
        if (this.variableResolver == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.commons.el.VariableResolverImpl");
                Constructor<?> constructor = clazz.getConstructor(PageContext.class);
                this.variableResolver = (VariableResolver)constructor.newInstance(new Object[]{this});
            }
            catch (Exception exception) {
                throw new ELException("EL is not supported in this runtime");
            }
        }
        return this.variableResolver.resolveVariable(string);
    }

    private static String XmlEscape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&#039;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&#034;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static Object proprietaryEvaluate(final String string, final Class clazz, final PageContext pageContext, final ProtectedFunctionMapper protectedFunctionMapper, boolean bl) throws ELException {
        Object object;
        final ExpressionEvaluator expressionEvaluator = pageContext.getExpressionEvaluator();
        if (expressionEvaluator == null) {
            throw new ELException("EL is not supported in this runtime");
        }
        if (System.getSecurityManager() != null) {
            try {
                object = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return expressionEvaluator.evaluate(string, clazz, pageContext.getVariableResolver(), (FunctionMapper)protectedFunctionMapper);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof ELException) {
                    throw (ELException)((Object)exception);
                }
                throw new ELException((Throwable)exception);
            }
        } else {
            object = expressionEvaluator.evaluate(string, clazz, pageContext.getVariableResolver(), (FunctionMapper)protectedFunctionMapper);
        }
        if (bl) {
            object = PageContextImpl.XmlEscape(object.toString());
        }
        return object;
    }

    private JspWriterImpl _createOut(int n, boolean bl) throws IOException {
        try {
            return new JspWriterImpl(this.response, n, bl);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

