/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.runtime.TagHandlerPool;

public class PerThreadTagHandlerPool
extends TagHandlerPool {
    public static int MAX_SIZE = 100;
    private int maxSize = MAX_SIZE;
    private int initialSize = 5;
    private ThreadLocal perThread = new ThreadLocal();
    private Hashtable threadData = new Hashtable();

    public PerThreadTagHandlerPool() {
    }

    protected void init(Servlet servlet) {
        String string = TagHandlerPool.getOption(servlet.getServletConfig(), OPTION_MAXSIZE, null);
        this.maxSize = Integer.parseInt(string);
        if (this.maxSize < 0) {
            this.maxSize = MAX_SIZE;
        }
    }

    public PerThreadTagHandlerPool(int n) {
        this.maxSize = n;
    }

    public Tag get(Class clazz) throws JspException {
        PerThreadData perThreadData = (PerThreadData)this.perThread.get();
        if (perThreadData != null && perThreadData.current >= 0) {
            return perThreadData.handlers[perThreadData.current--];
        }
        try {
            return (Tag)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JspException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void reuse(Tag tag) {
        PerThreadData perThreadData = (PerThreadData)this.perThread.get();
        if (perThreadData == null) {
            perThreadData = new PerThreadData();
            perThreadData.handlers = new Tag[this.initialSize];
            perThreadData.current = 0;
            this.threadData.put(perThreadData, perThreadData);
        }
        if (perThreadData.current < perThreadData.handlers.length - 1) {
            perThreadData.handlers[++perThreadData.current] = tag;
            return;
        }
        if (perThreadData.handlers.length < this.maxSize) {
            Tag[] tagArray = new Tag[perThreadData.handlers.length + this.initialSize];
            System.arraycopy(perThreadData.handlers, 0, tagArray, 0, perThreadData.handlers.length);
            perThreadData.handlers = tagArray;
            perThreadData.handlers[++perThreadData.current] = tag;
            return;
        }
        tag.release();
    }

    public synchronized void release() {
        Enumeration enumeration = this.threadData.keys();
        while (enumeration.hasMoreElements()) {
            PerThreadData perThreadData = (PerThreadData)enumeration.nextElement();
            for (int i = perThreadData.current; i >= 0; --i) {
                if (perThreadData.handlers == null || perThreadData.handlers[i] == null) continue;
                perThreadData.handlers[i].release();
            }
        }
    }

    private static class PerThreadData {
        Tag[] handlers;
        int current;

        private PerThreadData() {
        }
    }
}

