/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.servlet.jsp.el.FunctionMapper;

public final class ProtectedFunctionMapper
implements FunctionMapper {
    private HashMap fnmap = new HashMap();

    private ProtectedFunctionMapper() {
    }

    public static ProtectedFunctionMapper getInstance() {
        if (System.getSecurityManager() != null) {
            return (ProtectedFunctionMapper)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ProtectedFunctionMapper();
                }
            });
        }
        return new ProtectedFunctionMapper();
    }

    public void mapFunction(String string, String string2, final Class clazz, final String string3, final Class[] classArray) {
        Method method;
        if (System.getSecurityManager() != null) {
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return clazz.getDeclaredMethod(string3, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException("Invalid function mapping - no such method: " + privilegedActionException.getException().getMessage());
            }
        }
        try {
            method = clazz.getDeclaredMethod(string3, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Invalid function mapping - no such method: " + noSuchMethodException.getMessage());
        }
        this.fnmap.put(string + ":" + string2, method);
    }

    public Method resolveFunction(String string, String string2) {
        return (Method)this.fnmap.get(string + ":" + string2);
    }
}

