/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class TagHandlerPool {
    private static final int MAX_POOL_SIZE = 5;
    private Tag[] handlers;
    public static String OPTION_TAGPOOL = "jasper.tagpoolClassName";
    public static String OPTION_MAXSIZE = "jasper.tagpoolMaxSize";
    private int current;

    public static TagHandlerPool getTagHandlerPool(ServletConfig servletConfig) {
        TagHandlerPool tagHandlerPool = null;
        String string = TagHandlerPool.getOption(servletConfig, OPTION_TAGPOOL, null);
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                tagHandlerPool = (TagHandlerPool)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                tagHandlerPool = null;
            }
        }
        if (tagHandlerPool == null) {
            tagHandlerPool = new TagHandlerPool();
        }
        tagHandlerPool.init(servletConfig);
        return tagHandlerPool;
    }

    protected void init(ServletConfig servletConfig) {
        int n = -1;
        String string = TagHandlerPool.getOption(servletConfig, OPTION_MAXSIZE, null);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        if (n < 0) {
            n = 5;
        }
        this.handlers = new Tag[n];
        this.current = -1;
    }

    public TagHandlerPool() {
    }

    public TagHandlerPool(int n) {
        this.handlers = new Tag[n];
        this.current = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag get(Class clazz) throws JspException {
        Tag tag = null;
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                tag = this.handlers[this.current--];
                return tag;
            }
        }
        try {
            return (Tag)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JspException(exception.getMessage(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(Tag tag) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = tag;
                return;
            }
        }
        tag.release();
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            this.handlers[i].release();
        }
    }

    protected static String getOption(ServletConfig servletConfig, String string, String string2) {
        if (servletConfig == null) {
            return string2;
        }
        String string3 = servletConfig.getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        if (servletConfig.getServletContext() == null) {
            return string2;
        }
        string3 = servletConfig.getServletContext().getInitParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }
}

