/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.NullAttributeException;
import org.apache.taglibs.standard.tag.common.core.ParamParent;
import org.apache.taglibs.standard.tag.common.core.ParamSupport;
import org.apache.taglibs.standard.tag.common.core.Util;

public abstract class ImportSupport
extends BodyTagSupport
implements TryCatchFinally,
ParamParent {
    public static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String url;
    protected String context;
    protected String charEncoding;
    private String var;
    private int scope;
    private String varReader;
    private Reader r;
    private boolean isAbsoluteUrl;
    private ParamSupport.ParamManager params;
    private String urlWithParams;

    public ImportSupport() {
        this.init();
    }

    private void init() {
        this.urlWithParams = null;
        this.charEncoding = null;
        this.context = null;
        this.varReader = null;
        this.var = null;
        this.url = null;
        this.params = null;
        this.scope = 1;
    }

    public int doStartTag() throws JspException {
        if (!(this.context == null || this.context.startsWith("/") && this.url.startsWith("/"))) {
            throw new JspTagException(Resources.getMessage("IMPORT_BAD_RELATIVE"));
        }
        this.urlWithParams = null;
        this.params = new ParamSupport.ParamManager();
        if (this.url == null || this.url.equals("")) {
            throw new NullAttributeException("import", "url");
        }
        this.isAbsoluteUrl = this.isAbsoluteUrl();
        try {
            if (this.varReader != null) {
                this.r = this.acquireReader();
                this.pageContext.setAttribute(this.varReader, (Object)this.r);
            }
        }
        catch (IOException iOException) {
            throw new JspTagException(iOException.toString(), (Throwable)iOException);
        }
        if (this.var != null) {
            this.pageContext.setAttribute("discardJSPContent", (Object)Boolean.TRUE, 2);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.varReader == null) {
                if (this.var != null) {
                    this.pageContext.setAttribute(this.var, (Object)this.acquireString(), this.scope);
                    this.pageContext.setAttribute("discardJSPContent", (Object)Boolean.FALSE, 2);
                } else {
                    this.pageContext.getOut().print(this.acquireString());
                }
            }
            return 6;
        }
        catch (IOException iOException) {
            throw new JspTagException(iOException.toString(), (Throwable)iOException);
        }
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        try {
            if (this.varReader != null) {
                if (this.r != null) {
                    this.r.close();
                }
                this.pageContext.removeAttribute(this.varReader, 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void release() {
        this.init();
        super.release();
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setVarReader(String string) {
        this.varReader = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public void addParameter(String string, String string2) {
        this.params.addParameter(string, string2);
    }

    private String acquireString() throws IOException, JspException {
        String string;
        if (this.isAbsoluteUrl) {
            int n;
            BufferedReader bufferedReader = new BufferedReader(this.acquireReader());
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            return stringBuffer.toString();
        }
        if (!(this.pageContext.getRequest() instanceof HttpServletRequest) || !(this.pageContext.getResponse() instanceof HttpServletResponse)) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_HTTP"));
        }
        ServletContext servletContext = null;
        String string2 = this.targetUrl();
        if (this.context != null) {
            servletContext = this.pageContext.getServletContext().getContext(this.context);
        } else {
            servletContext = this.pageContext.getServletContext();
            if (!string2.startsWith("/")) {
                string = ((HttpServletRequest)this.pageContext.getRequest()).getServletPath();
                string2 = string.substring(0, string.lastIndexOf(47)) + '/' + string2;
            }
        }
        if (servletContext == null) {
            throw new JspTagException(Resources.getMessage("IMPORT_REL_WITHOUT_DISPATCHER", this.context, string2));
        }
        string = servletContext.getRequestDispatcher(ImportSupport.stripSession(string2));
        if (string == null) {
            throw new JspTagException(ImportSupport.stripSession(string2));
        }
        ImportResponseWrapper importResponseWrapper = new ImportResponseWrapper((HttpServletResponse)this.pageContext.getResponse());
        try {
            string.include(this.pageContext.getRequest(), (ServletResponse)importResponseWrapper);
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new JspException((Throwable)runtimeException);
        }
        catch (ServletException servletException) {
            Throwable throwable = servletException.getRootCause();
            if (throwable == null) {
                throw new JspException((Throwable)servletException);
            }
            throw new JspException(throwable);
        }
        if (importResponseWrapper.getStatus() < 200 || importResponseWrapper.getStatus() > 299) {
            throw new JspTagException(importResponseWrapper.getStatus() + " " + ImportSupport.stripSession(string2));
        }
        return importResponseWrapper.getString();
    }

    private Reader acquireReader() throws IOException, JspException {
        if (!this.isAbsoluteUrl) {
            return new StringReader(this.acquireString());
        }
        String string = this.targetUrl();
        try {
            int n;
            String string2;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = null;
            if (this.charEncoding != null && !this.charEncoding.equals("")) {
                string2 = this.charEncoding;
            } else {
                String string3 = uRLConnection.getContentType();
                if (string3 != null) {
                    string2 = Util.getContentTypeAttribute(string3, "charset");
                    if (string2 == null) {
                        string2 = DEFAULT_ENCODING;
                    }
                } else {
                    string2 = DEFAULT_ENCODING;
                }
            }
            try {
                inputStreamReader = new InputStreamReader(inputStream, string2);
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream, DEFAULT_ENCODING);
            }
            if (uRLConnection instanceof HttpURLConnection && ((n = ((HttpURLConnection)uRLConnection).getResponseCode()) < 200 || n > 299)) {
                throw new JspTagException(n + " " + string);
            }
            return inputStreamReader;
        }
        catch (IOException iOException) {
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", string, iOException), (Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new JspException(Resources.getMessage("IMPORT_ABS_ERROR", string, runtimeException), (Throwable)runtimeException);
        }
    }

    private String targetUrl() {
        if (this.urlWithParams == null) {
            this.urlWithParams = this.params.aggregateParams(this.url);
        }
        return this.urlWithParams;
    }

    private boolean isAbsoluteUrl() throws JspTagException {
        return ImportSupport.isAbsoluteUrl(this.url);
    }

    public static boolean isAbsoluteUrl(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSession(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = stringBuffer.toString().indexOf(";jsessionid=")) != -1) {
            int n2 = stringBuffer.toString().indexOf(";", n + 1);
            if (n2 == -1) {
                n2 = stringBuffer.toString().indexOf("?", n + 1);
            }
            if (n2 == -1) {
                n2 = stringBuffer.length();
            }
            stringBuffer.delete(n, n2);
        }
        return stringBuffer.toString();
    }

    private class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw = new StringWriter();
        private ByteArrayOutputStream bos = new ByteArrayOutputStream();
        private ServletOutputStream sos = new ServletOutputStream(this){
            private final /* synthetic */ ImportResponseWrapper this$1;
            {
                this.this$1 = importResponseWrapper;
            }

            public void write(int n) throws IOException {
                ImportResponseWrapper.access$000(this.this$1).write(n);
            }
        };
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status = 200;

        public ImportResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public PrintWriter getWriter() {
            if (this.isStreamUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_STREAM"));
            }
            this.isWriterUsed = true;
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException(Resources.getMessage("IMPORT_ILLEGAL_WRITER"));
            }
            this.isStreamUsed = true;
            return this.sos;
        }

        public void setContentType(String string) {
        }

        public void setLocale(Locale locale) {
        }

        public void setStatus(int n) {
            this.status = n;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                if (ImportSupport.this.charEncoding != null && !ImportSupport.this.charEncoding.equals("")) {
                    return this.bos.toString(ImportSupport.this.charEncoding);
                }
                return this.bos.toString(ImportSupport.DEFAULT_ENCODING);
            }
            return "";
        }

        static /* synthetic */ ByteArrayOutputStream access$000(ImportResponseWrapper importResponseWrapper) {
            return importResponseWrapper.bos;
        }
    }
}

