/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cimom.logs.svc.collectLogs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CollectLogs {
    private static final String ZIPNAME = "/collectedLogs.zip";
    private static Vector adjusted = new Vector();
    private static String separator = File.separator;

    public static void main(String[] args) {
        Properties props = new Properties();
        FileInputStream fis = null;
        Vector logFiles = new Vector();
        Vector adjustedPathNames = new Vector();
        String destDir = null;
        String value = null;
        Vector<String> cimomFiletypes = new Vector<String>();
        Vector<String> uiFiletypes = new Vector<String>();
        Vector<String> installFiletypes = new Vector<String>();
        Vector<String> vpdFiletypes = new Vector<String>();
        String propsFile = "./raspd.properties";
        String cimagentLogDir = "CIMAgentLogDir";
        String uiLogDir = "UILogDir";
        String installLogDir = "InstallLogDir";
        String defaultZipfileDest = "DefaultZipFileDest";
        String vpdLogDir = "VPDLogInfo";
        try {
            File vpdDir;
            Vector vpdFiles;
            File installDir;
            Vector installFiles;
            File uiDir;
            Vector uiFiles;
            if (propsFile != null) {
                fis = new FileInputStream(new File(propsFile));
                props.load(fis);
                fis.close();
            }
            Enumeration<?> properties = props.propertyNames();
            while (properties.hasMoreElements()) {
                String token;
                StringTokenizer st;
                String propertyname = (String)properties.nextElement();
                if (propertyname.equals(defaultZipfileDest)) {
                    defaultZipfileDest = new String(props.getProperty(propertyname));
                }
                if (propertyname.equals(cimagentLogDir)) {
                    value = new String(props.getProperty(propertyname));
                    if (value.indexOf(44) < 0) {
                        cimagentLogDir = value;
                        cimomFiletypes.add("log");
                    } else {
                        cimagentLogDir = value.substring(0, value.indexOf(44)).trim();
                        st = new StringTokenizer(value, ",");
                        st.nextToken();
                        while (st.hasMoreTokens()) {
                            token = st.nextToken().trim();
                            cimomFiletypes.addElement(token);
                        }
                    }
                }
                if (propertyname.equals(uiLogDir)) {
                    value = new String(props.getProperty(propertyname));
                    if (value.indexOf(44) < 0) {
                        uiLogDir = value;
                        uiFiletypes.add("log");
                    } else {
                        uiLogDir = value.substring(0, value.indexOf(44)).trim();
                        st = new StringTokenizer(value, ",");
                        st.nextToken();
                        while (st.hasMoreTokens()) {
                            token = st.nextToken().trim();
                            uiFiletypes.addElement(token);
                        }
                    }
                }
                if (propertyname.equals(installLogDir)) {
                    value = new String(props.getProperty(propertyname));
                    if (value.indexOf(44) < 0) {
                        installLogDir = value;
                        installFiletypes.add("log");
                    } else {
                        installLogDir = value.substring(0, value.indexOf(44)).trim();
                        st = new StringTokenizer(value, ",");
                        st.nextToken();
                        while (st.hasMoreTokens()) {
                            token = st.nextToken().trim();
                            installFiletypes.addElement(token);
                        }
                    }
                }
                if (!propertyname.equals(vpdLogDir)) continue;
                value = new String(props.getProperty(propertyname));
                if (value.indexOf(44) < 0) {
                    vpdLogDir = value;
                    vpdFiletypes.add("txt");
                    continue;
                }
                vpdLogDir = value.substring(0, value.indexOf(44)).trim();
                st = new StringTokenizer(value, ",");
                st.nextToken();
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    vpdFiletypes.addElement(token);
                }
            }
            File cimagentDir = new File(cimagentLogDir);
            Vector cimagentFiles = CollectLogs.findAllLogFilesAndDirs(cimagentDir, cimomFiletypes);
            if (cimagentFiles.isEmpty()) {
                System.out.println("\nNo CIM Agent logfiles found in the directory " + cimagentDir + "\n");
            }
            if ((uiFiles = CollectLogs.findAllLogFilesAndDirs(uiDir = new File(uiLogDir), uiFiletypes)).isEmpty()) {
                System.out.println("\nNo UI logfiles found in the directory " + uiDir + "\n");
            }
            if ((installFiles = CollectLogs.findAllLogFilesAndDirs(installDir = new File(installLogDir), installFiletypes)).isEmpty()) {
                System.out.println("\nNo Installation logfiles found in the directory " + installDir + "\n");
            }
            if ((vpdFiles = CollectLogs.findAllLogFilesAndDirs(vpdDir = new File(vpdLogDir), vpdFiletypes)).isEmpty()) {
                System.out.println("\nNo VPD files found in the directory " + vpdDir + "\n");
            }
            logFiles.addAll(cimagentFiles);
            logFiles.addAll(uiFiles);
            logFiles.addAll(installFiles);
            logFiles.addAll(vpdFiles);
            Vector cimagtAdjustedPathNames = CollectLogs.adjustPath(cimagentFiles, cimagentLogDir, 1);
            Vector uiAdjustedPathNames = CollectLogs.adjustPath(uiFiles, uiLogDir, 2);
            Vector installAdjustedPathNames = CollectLogs.adjustPath(installFiles, installLogDir, 3);
            Vector vpdAdjustedPathNames = CollectLogs.adjustPath(vpdFiles, vpdLogDir, 4);
            adjustedPathNames.addAll(cimagtAdjustedPathNames);
            adjustedPathNames.addAll(uiAdjustedPathNames);
            adjustedPathNames.addAll(installAdjustedPathNames);
            adjustedPathNames.addAll(vpdAdjustedPathNames);
            File dir = null;
            File destination = new File(defaultZipfileDest);
            if (args == null || args.length == 0) {
                dir = new File(destination + ZIPNAME);
                destDir = dir.toString();
            } else if (new File(args[0]).exists()) {
                dir = new File(String.valueOf(args[0]) + ZIPNAME);
                destDir = dir.toString();
            } else {
                boolean created = new File(args[0]).mkdir();
                if (!created) {
                    System.out.println("Failed to create the directory " + args[0]);
                } else {
                    dir = new File(String.valueOf(args[0]) + ZIPNAME);
                    destDir = dir.toString();
                }
            }
            int success = CollectLogs.zipFiles(logFiles, adjustedPathNames, destDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Vector findAllLogFilesAndDirs(File dir, Vector filetypes) throws IOException {
        Vector<File> filenames;
        block14: {
            filenames = new Vector<File>();
            try {
                File[] fileList = dir.listFiles();
                if (fileList != null) {
                    int i = 0;
                    while (i < fileList.length) {
                        File parent = fileList[i];
                        if (parent.isDirectory()) {
                            File[] children = parent.listFiles();
                            String[] childrenS = parent.list();
                            int j = 0;
                            while (j < children.length) {
                                File child = children[j];
                                if (child.isDirectory()) {
                                    File nextDir = new File(parent, childrenS[j]);
                                    File[] check = nextDir.listFiles();
                                    if (check != null) {
                                        CollectLogs.findAllLogFilesAndDirs(nextDir, filetypes);
                                    }
                                } else {
                                    int a = 0;
                                    while (a < filetypes.size()) {
                                        String extension = filetypes.elementAt(a).toString();
                                        String currFile = children[j].toString();
                                        if (currFile.substring(currFile.indexOf(".") + 1, currFile.length()).equalsIgnoreCase(extension)) {
                                            filenames.add(children[j]);
                                        }
                                        ++a;
                                    }
                                }
                                ++j;
                            }
                        } else {
                            int b = 0;
                            while (b < filetypes.size()) {
                                String extension = filetypes.elementAt(b).toString();
                                String currFile = fileList[i].toString();
                                if (currFile.substring(currFile.indexOf(".") + 1, currFile.length()).equalsIgnoreCase(extension)) {
                                    filenames.add(fileList[i]);
                                }
                                ++b;
                            }
                        }
                        ++i;
                    }
                    break block14;
                }
                return filenames;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return filenames;
    }

    private static Vector findAllFiles(File db2Dir, Vector filetypes) throws IOException {
        Vector<File> db2Files = new Vector<File>();
        File[] fileList = db2Dir.listFiles();
        if (fileList != null) {
            int i = 0;
            while (i < fileList.length) {
                File file = fileList[i];
                if (!file.isDirectory()) {
                    int c = 0;
                    while (c < filetypes.size()) {
                        String extension = filetypes.elementAt(c).toString();
                        String currFile = file.toString();
                        if (currFile.substring(currFile.indexOf(".") + 1, currFile.length()).equalsIgnoreCase(extension)) {
                            db2Files.add(fileList[i]);
                        }
                        ++c;
                    }
                }
                ++i;
            }
        } else {
            return db2Files;
        }
        return db2Files;
    }

    private static int zipFiles(Vector fileList, Vector zipFilenameList, String zipFileName) {
        int BUFFER = 2048;
        int returnVal = 0;
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(zipFileName);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            int i = 0;
            while (i < fileList.size()) {
                if (fileList.elementAt(i).toString().indexOf(".zip") < 0) {
                    int count;
                    System.out.println("Adding file: " + fileList.elementAt(i));
                    FileInputStream fi = new FileInputStream(fileList.elementAt(i).toString());
                    origin = new BufferedInputStream(fi, 2048);
                    ZipEntry entry = new ZipEntry(zipFilenameList.elementAt(i).toString());
                    out.putNextEntry(entry);
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        out.write(data, 0, count);
                    }
                    origin.close();
                }
                ++i;
            }
            out.close();
            System.out.println("\n--------------------------------------------------------------------------------------------------");
            System.out.println("Zipfile has been created and can be found in: " + zipFileName);
            System.out.println("--------------------------------------------------------------------------------------------------\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return returnVal;
    }

    private static Vector adjustPath(Vector filenames, String installDir, int type) {
        switch (type) {
            case 1: {
                int i = 0;
                while (i < filenames.size()) {
                    String entry = filenames.elementAt(i).toString();
                    String s = entry.substring(installDir.length() + 1, entry.length());
                    File dir1 = new File("collectedLogs/CIMAgent/" + s);
                    String newDir = dir1.toString();
                    adjusted.addElement(newDir);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < filenames.size()) {
                    String entry = filenames.elementAt(i).toString();
                    String s = entry.substring(installDir.length() + 1, entry.length());
                    File dir2 = new File("collectedLogs/UI/" + s);
                    String newDir = dir2.toString();
                    adjusted.addElement(newDir);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < filenames.size()) {
                    String entry = filenames.elementAt(i).toString();
                    String s = entry.substring(entry.lastIndexOf(separator) + 1, entry.length());
                    File dir3 = new File("collectedLogs/Installation/" + s);
                    String newDir = dir3.toString();
                    adjusted.addElement(newDir);
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < filenames.size()) {
                    String entry = filenames.elementAt(i).toString();
                    String s = entry.substring(entry.lastIndexOf(separator) + 1, entry.length());
                    File dir4 = new File("collectedLogs/VPD/" + s);
                    String newDir = dir4.toString();
                    adjusted.addElement(newDir);
                    ++i;
                }
                break;
            }
        }
        return adjusted;
    }

    private static String execDBCmd(String logDir) {
        String line = null;
        String variable = null;
        String diagPath = null;
        String db2inst = null;
        Object retString = null;
        String dirString = null;
        Process p = null;
        Process p1 = null;
        try {
            if (System.getProperty("os.name").indexOf("Windows") >= 0) {
                dirString = logDir.substring(0, logDir.indexOf("SQLLIB") + 6);
                p = Runtime.getRuntime().exec(String.valueOf(dirString) + "/bin/db2cmd -c -w -i db2 GET DBM CFG");
            } else {
                String[] echoParams = new String[]{"env"};
                p1 = Runtime.getRuntime().exec(echoParams);
                BufferedReader br1 = new BufferedReader(new InputStreamReader(p1.getInputStream()));
                while ((variable = br1.readLine()) != null) {
                    if (variable.indexOf("DB2INSTANCE") < 0) continue;
                    db2inst = variable.substring(variable.indexOf("=") + 1, variable.length()).trim();
                    if (db2inst != null && db2inst.length() > 0) {
                        p = Runtime.getRuntime().exec("db2 GET DBM CFG");
                        break;
                    }
                    System.out.println("\n--------------------------------------------------------------------------------------------------");
                    System.out.println("NOTE: Cannot read out the DIAGPATH variable. The user must be configured to use db2.");
                    System.out.println("--------------------------------------------------------------------------------------------------");
                    return logDir;
                }
                br1.close();
            }
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (line.indexOf("DIAGPATH") <= 0) continue;
                diagPath = line.substring(line.indexOf("=") + 1, line.length()).trim();
                break;
            }
            isr.close();
            br.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        if (diagPath != null && diagPath.length() > 0) {
            System.out.println("\n--------------------------------------------------------------------------------------------------");
            System.out.println("INFO: The DIAGPATH variable is set to: " + diagPath);
            System.out.println("--------------------------------------------------------------------------------------------------");
            return diagPath;
        }
        System.out.println("\n--------------------------------------------------------------------------------------------------");
        System.out.println("INFO: The DIAGPATH variable is set to: NULL. Will use the MDM.db2LogsDir variable from MDM.properties");
        System.out.println("--------------------------------------------------------------------------------------------------");
        return logDir;
    }
}

