/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import java.io.IOException;
import java.math.BigInteger;

public final class TCPMsgPollRep {
    private BigInteger pollingRef;
    private BigInteger timeToCheckBack;

    public TCPMsgPollRep(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("TCPMsgPollRep error : polling reference not specified");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("TCPMsgPollRep error : time-to-check-back not specified");
        }
        this.pollingRef = bigInteger;
        this.timeToCheckBack = bigInteger2;
    }

    public TCPMsgPollRep(byte[] byArray) throws IOException {
        this.parse(byArray);
    }

    public TCPMsgPollRep(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new IllegalArgumentException("TCPMsgPollRep error : polling reference not specified");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("TCPMsgPollRep error : time-to-check-back not specified");
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("TCPMsgPollRep error : invalid polling reference length");
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("TCPMsgPollRep error : invalid check back value");
        }
        this.pollingRef = new BigInteger(1, byArray);
        this.timeToCheckBack = new BigInteger(1, byArray2);
    }

    public byte[] getEncoded() throws IOException {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = 0;
            ++n;
        }
        byte[] byArray2 = this.pollingRef.toByteArray();
        if (byArray2.length < 4) {
            System.arraycopy(byArray2, 0, byArray, 4 - byArray2.length, byArray2.length);
        } else {
            System.arraycopy(byArray2, byArray2.length - 4, byArray, 0, 4);
        }
        byArray2 = this.timeToCheckBack.toByteArray();
        if (byArray2.length < 4) {
            System.arraycopy(byArray2, 0, byArray, 8 - byArray2.length, byArray2.length);
        } else {
            System.arraycopy(byArray2, byArray2.length - 4, byArray, 4, 4);
        }
        return byArray;
    }

    public BigInteger getPollingReference() {
        return this.pollingRef;
    }

    public BigInteger getTimeToCheckBack() {
        return this.timeToCheckBack;
    }

    private void parse(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("TCPMsgPollRep error : data not specified");
        }
        if (byArray.length != 8) {
            throw new IOException("TCPMsgPollRep error : invalid input");
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        this.pollingRef = new BigInteger(1, byArray2);
        System.arraycopy(byArray, 4, byArray2, 0, 4);
        this.timeToCheckBack = new BigInteger(1, byArray2);
    }

    public String toString() {
        String string = "\r\nPolling Reference : ";
        if (this.pollingRef != null) {
            string = String.valueOf(string) + this.pollingRef.toString();
        }
        string = String.valueOf(string) + "\r\nTime to check back : ";
        if (this.timeToCheckBack != null) {
            string = String.valueOf(string) + this.timeToCheckBack.toString();
        }
        return string;
    }
}

